/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.NetworkGroupCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class NetworkGroupConfigManager
implements ConfigurationChangeListener<NetworkGroupCfg>,
ConfigurationAddListener<NetworkGroupCfg>,
ConfigurationDeleteListener<NetworkGroupCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final ConcurrentHashMap<DN, NetworkGroup> networkGroups = new ConcurrentHashMap();

    @Override
    public ConfigChangeResult applyConfigurationAdd(NetworkGroupCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            try {
                NetworkGroup networkGroup = NetworkGroup.createUserNetworkGroup(configuration);
                this.networkGroups.put(configuration.dn(), networkGroup);
            }
            catch (InitializationException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            catch (ConfigException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(NetworkGroupCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        NetworkGroup networkGroup = this.networkGroups.get(configuration.dn());
        if (networkGroup != null && !configuration.isEnabled()) {
            this.networkGroups.remove(configuration.dn());
            networkGroup.finalizeNetworkGroup();
        } else if (networkGroup == null && configuration.isEnabled()) {
            try {
                networkGroup = NetworkGroup.createUserNetworkGroup(configuration);
                this.networkGroups.put(configuration.dn(), networkGroup);
            }
            catch (InitializationException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            catch (ConfigException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(NetworkGroupCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        NetworkGroup networkGroup = this.networkGroups.remove(configuration.dn());
        if (networkGroup != null) {
            networkGroup.finalizeNetworkGroup();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    public void finalizeNetworkGroups() {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.removeNetworkGroupAddListener(this);
        rootConfiguration.removeNetworkGroupDeleteListener(this);
        for (NetworkGroup networkGroup : this.networkGroups.values()) {
            networkGroup.finalizeNetworkGroup();
        }
        this.networkGroups.clear();
    }

    public void initializeNetworkGroups() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addNetworkGroupAddListener(this);
        rootConfiguration.addNetworkGroupDeleteListener(this);
        for (String networkGroupName : rootConfiguration.listNetworkGroups()) {
            NetworkGroupCfg configuration = rootConfiguration.getNetworkGroup(networkGroupName);
            configuration.addChangeListener(this);
            ArrayList<Message> unacceptableReasons = new ArrayList<Message>();
            if (!NetworkGroup.isConfigurationAcceptable(configuration, unacceptableReasons)) {
                Message message = ConfigMessages.ERR_CONFIG_NETWORK_GROUP_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), StaticUtils.listToString(unacceptableReasons, ". "));
                throw new InitializationException(message);
            }
            if (!configuration.isEnabled()) continue;
            NetworkGroup networkGroup = NetworkGroup.createUserNetworkGroup(configuration);
            this.networkGroups.put(configuration.dn(), networkGroup);
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
        return NetworkGroup.isConfigurationAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
        return NetworkGroup.isConfigurationAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }
}

