/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.authorization.dseecompat.PatternDN;
import org.opends.server.core.networkgroups.ConnectionCriteria;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;

final class BindDNConnectionCriteria
implements ConnectionCriteria {
    private final List<PatternDN> patterns;

    public static BindDNConnectionCriteria create(Collection<PatternDN> patterns) {
        return new BindDNConnectionCriteria(new ArrayList<PatternDN>(patterns));
    }

    public static BindDNConnectionCriteria decode(Collection<String> patternStrings) throws DirectoryException {
        ArrayList<PatternDN> patterns = new ArrayList<PatternDN>(patternStrings.size());
        for (String s : patternStrings) {
            patterns.add(PatternDN.decode(s));
        }
        return new BindDNConnectionCriteria(patterns);
    }

    private BindDNConnectionCriteria(List<PatternDN> patterns) {
        this.patterns = patterns;
    }

    @Override
    public boolean matches(ClientConnection connection) {
        DN dn = connection.getAuthenticationInfo().getAuthenticationDN();
        return this.willMatchAfterBind(connection, dn, null, false);
    }

    @Override
    public boolean willMatchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        if (bindDN == null) {
            return false;
        }
        for (PatternDN pattern : this.patterns) {
            if (!pattern.matchesDN(bindDN)) continue;
            return true;
        }
        return false;
    }
}

