/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.opends.server.admin.std.meta.NetworkGroupCfgDefn;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.networkgroups.ConnectionCriteria;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;

final class AuthMethodConnectionCriteria
implements ConnectionCriteria {
    private final Set<NetworkGroupCfgDefn.AllowedAuthMethod> authMethods;

    public AuthMethodConnectionCriteria(Collection<NetworkGroupCfgDefn.AllowedAuthMethod> authMethods) {
        this.authMethods = EnumSet.copyOf(authMethods);
    }

    @Override
    public boolean matches(ClientConnection connection) {
        AuthenticationInfo authInfo = connection.getAuthenticationInfo();
        for (NetworkGroupCfgDefn.AllowedAuthMethod method : this.authMethods) {
            switch (method) {
                case ANONYMOUS: {
                    if (authInfo.isAuthenticated()) break;
                    return true;
                }
                case SIMPLE: {
                    if (!authInfo.hasAuthenticationType(AuthenticationType.SIMPLE)) break;
                    return true;
                }
                case SASL: {
                    if (!authInfo.hasAuthenticationType(AuthenticationType.SASL)) break;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean willMatchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        for (NetworkGroupCfgDefn.AllowedAuthMethod method : this.authMethods) {
            switch (method) {
                case ANONYMOUS: {
                    if (bindDN.toNormalizedString().length() != 0) break;
                    return true;
                }
                case SIMPLE: {
                    if (authType != AuthenticationType.SIMPLE || bindDN.toNormalizedString().length() <= 0) break;
                    return true;
                }
                case SASL: {
                    if (authType != AuthenticationType.SASL) break;
                    return true;
                }
            }
        }
        return false;
    }
}

