/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.SASLMechanismHandlerCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class SASLConfigManager
implements ConfigurationChangeListener<SASLMechanismHandlerCfg>,
ConfigurationAddListener<SASLMechanismHandlerCfg>,
ConfigurationDeleteListener<SASLMechanismHandlerCfg> {
    private ConcurrentHashMap<DN, SASLMechanismHandler> handlers = new ConcurrentHashMap();

    public void initializeSASLMechanismHandlers() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addSASLMechanismHandlerAddListener(this);
        rootConfiguration.addSASLMechanismHandlerDeleteListener(this);
        for (String handlerName : rootConfiguration.listSASLMechanismHandlers()) {
            SASLMechanismHandlerCfg handlerConfiguration = rootConfiguration.getSASLMechanismHandler(handlerName);
            handlerConfiguration.addChangeListener(this);
            if (!handlerConfiguration.isEnabled()) continue;
            String className = handlerConfiguration.getJavaClass();
            try {
                SASLMechanismHandler handler = this.loadHandler(className, handlerConfiguration, true);
                this.handlers.put(handlerConfiguration.dn(), handler);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadHandler(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        SASLMechanismHandler handler = null;
        String className = configuration.getJavaClass();
        try {
            handler = this.loadHandler(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.handlers.put(configuration.dn(), handler);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        SASLMechanismHandler handler = this.handlers.remove(configuration.dn());
        if (handler != null) {
            handler.finalizeSASLMechanismHandler();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadHandler(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        SASLMechanismHandler existingHandler = this.handlers.get(configuration.dn());
        if (!configuration.isEnabled()) {
            SASLMechanismHandler handler;
            if (existingHandler != null && (handler = this.handlers.remove(configuration.dn())) != null) {
                handler.finalizeSASLMechanismHandler();
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingHandler != null) {
            if (!className.equals(existingHandler.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        SASLMechanismHandler handler = null;
        try {
            handler = this.loadHandler(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.handlers.put(configuration.dn(), handler);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private SASLMechanismHandler loadHandler(String className, SASLMechanismHandlerCfg configuration, boolean initialize) throws InitializationException {
        try {
            SASLMechanismHandlerCfgDefn definition = SASLMechanismHandlerCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<SASLMechanismHandler> handlerClass = propertyDefinition.loadClass(className, SASLMechanismHandler.class);
            SASLMechanismHandler handler = handlerClass.newInstance();
            if (initialize) {
                Method method = handler.getClass().getMethod("initializeSASLMechanismHandler", configuration.configurationClass());
                method.invoke((Object)handler, configuration);
            } else {
                Method method = handler.getClass().getMethod("isConfigurationAcceptable", SASLMechanismHandlerCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)handler, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_SASL_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return handler;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_SASL_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

