/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.AccessLogPublisherCfg;
import org.opends.server.admin.std.server.DebugLogPublisherCfg;
import org.opends.server.admin.std.server.ErrorLogPublisherCfg;
import org.opends.server.admin.std.server.HTTPAccessLogPublisherCfg;
import org.opends.server.admin.std.server.LogPublisherCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.AbstractLogger;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.HTTPAccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class LoggerConfigManager
implements ConfigurationAddListener<LogPublisherCfg>,
ConfigurationDeleteListener<LogPublisherCfg> {
    public void initializeLoggerConfig() throws ConfigException, InitializationException {
        ServerManagementContext context = ServerManagementContext.getInstance();
        RootCfg root = context.getRootConfiguration();
        root.addLogPublisherAddListener(this);
        root.addLogPublisherDeleteListener(this);
        ArrayList<DebugLogPublisherCfg> debugPublisherCfgs = new ArrayList<DebugLogPublisherCfg>();
        ArrayList<AccessLogPublisherCfg> accessPublisherCfgs = new ArrayList<AccessLogPublisherCfg>();
        ArrayList<HTTPAccessLogPublisherCfg> httpAccessPublisherCfgs = new ArrayList<HTTPAccessLogPublisherCfg>();
        ArrayList<ErrorLogPublisherCfg> errorPublisherCfgs = new ArrayList<ErrorLogPublisherCfg>();
        for (String name : root.listLogPublishers()) {
            LogPublisherCfg config = root.getLogPublisher(name);
            if (config instanceof DebugLogPublisherCfg) {
                debugPublisherCfgs.add((DebugLogPublisherCfg)config);
                continue;
            }
            if (config instanceof AccessLogPublisherCfg) {
                accessPublisherCfgs.add((AccessLogPublisherCfg)config);
                continue;
            }
            if (config instanceof HTTPAccessLogPublisherCfg) {
                httpAccessPublisherCfgs.add((HTTPAccessLogPublisherCfg)config);
                continue;
            }
            if (config instanceof ErrorLogPublisherCfg) {
                errorPublisherCfgs.add((ErrorLogPublisherCfg)config);
                continue;
            }
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_OBJECTCLASS.get(String.valueOf(config.dn()));
            throw new ConfigException(message);
        }
        if (accessPublisherCfgs.isEmpty()) {
            ErrorLogger.logError(ConfigMessages.WARN_CONFIG_LOGGER_NO_ACTIVE_ACCESS_LOGGERS.get());
        }
        if (errorPublisherCfgs.isEmpty()) {
            ErrorLogger.logError(ConfigMessages.WARN_CONFIG_LOGGER_NO_ACTIVE_ERROR_LOGGERS.get());
        }
        DebugLogger.getInstance().initializeLogger(debugPublisherCfgs);
        AccessLogger.getInstance().initializeLogger(accessPublisherCfgs);
        HTTPAccessLogger.getInstance().initializeLogger(httpAccessPublisherCfgs);
        ErrorLogger.getInstance().initializeLogger(errorPublisherCfgs);
    }

    private AbstractLogger getLoggerInstance(LogPublisherCfg config, List<Message> messages) {
        if (config instanceof DebugLogPublisherCfg) {
            return DebugLogger.getInstance();
        }
        if (config instanceof AccessLogPublisherCfg) {
            return AccessLogger.getInstance();
        }
        if (config instanceof HTTPAccessLogPublisherCfg) {
            return HTTPAccessLogger.getInstance();
        }
        if (config instanceof ErrorLogPublisherCfg) {
            return ErrorLogger.getInstance();
        }
        messages.add(ConfigMessages.ERR_CONFIG_LOGGER_INVALID_OBJECTCLASS.get(String.valueOf(config.dn())));
        return null;
    }

    @Override
    public boolean isConfigurationAddAcceptable(LogPublisherCfg config, List<Message> unacceptableReasons) {
        AbstractLogger instance = this.getLoggerInstance(config, unacceptableReasons);
        if (instance != null) {
            return instance.isConfigurationAddAcceptable(config, unacceptableReasons);
        }
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(LogPublisherCfg config) {
        ArrayList<Message> messages = new ArrayList<Message>(1);
        AbstractLogger instance = this.getLoggerInstance(config, messages);
        if (instance != null) {
            return instance.applyConfigurationAdd(config);
        }
        boolean adminActionRequired = false;
        ResultCode resultCode = ResultCode.UNWILLING_TO_PERFORM;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(LogPublisherCfg config, List<Message> unacceptableReasons) {
        AbstractLogger instance = this.getLoggerInstance(config, unacceptableReasons);
        if (instance != null) {
            return instance.isConfigurationDeleteAcceptable(config, unacceptableReasons);
        }
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(LogPublisherCfg config) {
        ArrayList<Message> messages = new ArrayList<Message>(1);
        AbstractLogger instance = this.getLoggerInstance(config, messages);
        if (instance != null) {
            return instance.applyConfigurationDelete(config);
        }
        boolean adminActionRequired = false;
        ResultCode resultCode = ResultCode.UNWILLING_TO_PERFORM;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

