/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import org.opends.messages.CoreMessages;
import org.opends.server.api.Backend;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

public class LockFileManager {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static HashMap<String, FileLock> exclusiveLocks = new HashMap();
    private static HashMap<String, FileLock> sharedLocks = new HashMap();
    private static HashMap<String, Integer> sharedLockReferences = new HashMap();
    private static Object mapLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean acquireSharedLock(String lockFile, StringBuilder failureReason) {
        Object object = mapLock;
        synchronized (object) {
            FileLock fileLock;
            if (exclusiveLocks.containsKey(lockFile)) {
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_SHARED_REJECTED_BY_EXCLUSIVE.get(lockFile));
                return false;
            }
            FileLock sharedLock = sharedLocks.get(lockFile);
            if (sharedLock != null) {
                int numReferences = sharedLockReferences.get(lockFile);
                sharedLockReferences.put(lockFile, ++numReferences);
                return true;
            }
            File f = StaticUtils.getFileForPath(lockFile);
            try {
                if (!f.exists()) {
                    f.createNewFile();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_SHARED_FAILED_CREATE.get(lockFile, StaticUtils.getExceptionMessage(e)));
                return false;
            }
            FileChannel channel = null;
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(lockFile, "r");
                channel = raf.getChannel();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_SHARED_FAILED_OPEN.get(lockFile, StaticUtils.getExceptionMessage(e)));
                StaticUtils.close(raf);
                return false;
            }
            try {
                fileLock = channel.tryLock(0L, Long.MAX_VALUE, true);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_SHARED_FAILED_LOCK.get(lockFile, StaticUtils.getExceptionMessage(e)));
                StaticUtils.close(channel, raf);
                return false;
            }
            if (fileLock == null) {
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_SHARED_NOT_GRANTED.get(lockFile));
                StaticUtils.close(channel, raf);
                return false;
            }
            sharedLocks.put(lockFile, fileLock);
            sharedLockReferences.put(lockFile, 1);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean acquireExclusiveLock(String lockFile, StringBuilder failureReason) {
        Object object = mapLock;
        synchronized (object) {
            FileLock fileLock;
            if (exclusiveLocks.containsKey(lockFile)) {
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_REJECTED_BY_EXCLUSIVE.get(lockFile));
                return false;
            }
            if (sharedLocks.containsKey(lockFile)) {
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_REJECTED_BY_SHARED.get(lockFile));
                return false;
            }
            File f = StaticUtils.getFileForPath(lockFile);
            try {
                if (!f.exists()) {
                    f.createNewFile();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_FAILED_CREATE.get(lockFile, StaticUtils.getExceptionMessage(e)));
                return false;
            }
            FileChannel channel = null;
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(lockFile, "rw");
                channel = raf.getChannel();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_FAILED_OPEN.get(lockFile, StaticUtils.getExceptionMessage(e)));
                StaticUtils.close(raf);
                return false;
            }
            try {
                fileLock = channel.tryLock(0L, Long.MAX_VALUE, false);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_FAILED_LOCK.get(lockFile, StaticUtils.getExceptionMessage(e)));
                StaticUtils.close(channel, raf);
                return false;
            }
            if (fileLock == null) {
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_NOT_GRANTED.get(lockFile));
                StaticUtils.close(channel, raf);
                return false;
            }
            exclusiveLocks.put(lockFile, fileLock);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean releaseLock(String lockFile, StringBuilder failureReason) {
        Object object = mapLock;
        synchronized (object) {
            FileLock lock = exclusiveLocks.remove(lockFile);
            if (lock != null) {
                block17: {
                    try {
                        lock.release();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        failureReason.append(CoreMessages.ERR_FILELOCKER_UNLOCK_EXCLUSIVE_FAILED_RELEASE.get(lockFile, StaticUtils.getExceptionMessage(e)));
                        return false;
                    }
                    try {
                        lock.channel().close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block17;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                return true;
            }
            lock = sharedLocks.get(lockFile);
            if (lock != null) {
                block18: {
                    int refCount = sharedLockReferences.get(lockFile);
                    if (--refCount <= 0) {
                        sharedLocks.remove(lockFile);
                        sharedLockReferences.remove(lockFile);
                        try {
                            lock.release();
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            failureReason.append(CoreMessages.ERR_FILELOCKER_UNLOCK_SHARED_FAILED_RELEASE.get(lockFile, StaticUtils.getExceptionMessage(e)));
                            return false;
                        }
                        try {
                            lock.channel().close();
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            break block18;
                        }
                    }
                    sharedLockReferences.put(lockFile, refCount);
                }
                return true;
            }
            failureReason.append(CoreMessages.ERR_FILELOCKER_UNLOCK_UNKNOWN_FILE.get(lockFile));
            return false;
        }
    }

    public static String getLockDirectoryPath() {
        File lockDirectory = DirectoryServer.getEnvironmentConfig().getLockDirectory();
        return lockDirectory.getAbsolutePath();
    }

    public static String getServerLockFileName() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(LockFileManager.getLockDirectoryPath());
        buffer.append(File.separator);
        buffer.append("server");
        buffer.append(".lock");
        return buffer.toString();
    }

    public static String getBackendLockFileName(Backend backend) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(LockFileManager.getLockDirectoryPath());
        buffer.append(File.separator);
        buffer.append("backend-");
        buffer.append(backend.getBackendID());
        buffer.append(".lock");
        return buffer.toString();
    }
}

