/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.util.StaticUtils;

public class IdleTimeLimitThread
extends DirectoryThread
implements ServerShutdownListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private volatile boolean shutdownRequested;
    private final Object shutdownLock = new Object();

    public IdleTimeLimitThread() {
        super("Idle Time Limit Thread");
        this.setDaemon(true);
        this.shutdownRequested = false;
        DirectoryServer.registerShutdownListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Message disconnectMessage = CoreMessages.INFO_IDLETIME_LIMIT_EXCEEDED.get();
        long sleepTime = 5000L;
        while (!this.shutdownRequested) {
            try {
                Object object = this.shutdownLock;
                synchronized (object) {
                    if (!this.shutdownRequested) {
                        try {
                            this.shutdownLock.wait(sleepTime);
                        }
                        catch (InterruptedException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            this.shutdownRequested = true;
                            break;
                        }
                    }
                }
                sleepTime = 5000L;
                for (ConnectionHandler ch : DirectoryServer.getConnectionHandlers()) {
                    for (ClientConnection c : ch.getClientConnections()) {
                        long idleTimeLimit;
                        long idleTime = c.getIdleTime();
                        if (idleTime <= 0L || (idleTimeLimit = c.getIdleTimeLimit()) <= 0L) continue;
                        if (idleTime > idleTimeLimit) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("Terminating client connection " + c.getConnectionID() + " due to the idle time limit");
                            }
                            try {
                                c.disconnect(DisconnectReason.IDLE_TIME_LIMIT_EXCEEDED, true, disconnectMessage);
                            }
                            catch (Exception e) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                                Message message = CoreMessages.ERR_IDLETIME_DISCONNECT_ERROR.get(c.getConnectionID(), StaticUtils.stackTraceToSingleLineString(e));
                                ErrorLogger.logError(message);
                            }
                            continue;
                        }
                        long shouldSleepTime = idleTimeLimit - idleTime;
                        if (shouldSleepTime >= sleepTime) continue;
                        sleepTime = shouldSleepTime;
                    }
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = CoreMessages.ERR_IDLETIME_UNEXPECTED_ERROR.get(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
    }

    @Override
    public String getShutdownListenerName() {
        return "Idle Time Limit Thread";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processServerShutdown(Message reason) {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdownRequested = true;
            this.shutdownLock.notifyAll();
        }
    }
}

