/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.CertificateMapperCfgDefn;
import org.opends.server.admin.std.server.CertificateMapperCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.CertificateMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class CertificateMapperConfigManager
implements ConfigurationChangeListener<CertificateMapperCfg>,
ConfigurationAddListener<CertificateMapperCfg>,
ConfigurationDeleteListener<CertificateMapperCfg> {
    private ConcurrentHashMap<DN, CertificateMapper> certificateMappers = new ConcurrentHashMap();

    public void initializeCertificateMappers() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addCertificateMapperAddListener(this);
        rootConfiguration.addCertificateMapperDeleteListener(this);
        for (String mapperName : rootConfiguration.listCertificateMappers()) {
            CertificateMapperCfg mapperConfiguration = rootConfiguration.getCertificateMapper(mapperName);
            mapperConfiguration.addChangeListener(this);
            if (!mapperConfiguration.isEnabled()) continue;
            String className = mapperConfiguration.getJavaClass();
            try {
                CertificateMapper mapper = this.loadMapper(className, mapperConfiguration, true);
                this.certificateMappers.put(mapperConfiguration.dn(), mapper);
                DirectoryServer.registerCertificateMapper(mapperConfiguration.dn(), mapper);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(CertificateMapperCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadMapper(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(CertificateMapperCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        CertificateMapper certificateMapper = null;
        String className = configuration.getJavaClass();
        try {
            certificateMapper = this.loadMapper(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.certificateMappers.put(configuration.dn(), certificateMapper);
            DirectoryServer.registerCertificateMapper(configuration.dn(), certificateMapper);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(CertificateMapperCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(CertificateMapperCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DirectoryServer.deregisterCertificateMapper(configuration.dn());
        CertificateMapper certificateMapper = this.certificateMappers.remove(configuration.dn());
        if (certificateMapper != null) {
            certificateMapper.finalizeCertificateMapper();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(CertificateMapperCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadMapper(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(CertificateMapperCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        CertificateMapper existingMapper = this.certificateMappers.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingMapper != null) {
                DirectoryServer.deregisterCertificateMapper(configuration.dn());
                CertificateMapper certificateMapper = this.certificateMappers.remove(configuration.dn());
                if (certificateMapper != null) {
                    certificateMapper.finalizeCertificateMapper();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingMapper != null) {
            if (!className.equals(existingMapper.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        CertificateMapper certificateMapper = null;
        try {
            certificateMapper = this.loadMapper(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.certificateMappers.put(configuration.dn(), certificateMapper);
            DirectoryServer.registerCertificateMapper(configuration.dn(), certificateMapper);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private CertificateMapper loadMapper(String className, CertificateMapperCfg configuration, boolean initialize) throws InitializationException {
        try {
            CertificateMapperCfgDefn definition = CertificateMapperCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<CertificateMapper> mapperClass = propertyDefinition.loadClass(className, CertificateMapper.class);
            CertificateMapper mapper = mapperClass.newInstance();
            if (initialize) {
                Method method = mapper.getClass().getMethod("initializeCertificateMapper", configuration.configurationClass());
                method.invoke((Object)mapper, configuration);
            } else {
                Method method = mapper.getClass().getMethod("isConfigurationAcceptable", CertificateMapperCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)mapper, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_CERTMAPPER_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return mapper;
        }
        catch (InitializationException e) {
            throw e;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_CERTMAPPER_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

