/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AbandonOperationWrapper;
import org.opends.server.core.AddOperation;
import org.opends.server.core.AddOperationWrapper;
import org.opends.server.core.BindOperation;
import org.opends.server.core.BindOperationWrapper;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.CompareOperationWrapper;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DeleteOperationWrapper;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ExtendedOperationWrapper;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyDNOperationWrapper;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.ModifyOperationWrapper;
import org.opends.server.core.QueueingStrategy;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.SearchOperationWrapper;
import org.opends.server.core.UnbindOperation;
import org.opends.server.core.UnbindOperationWrapper;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Operation;

public class BoundedWorkQueueStrategy
implements QueueingStrategy {
    private final AtomicInteger nbRunningOperations = new AtomicInteger(0);
    private final int maxNbConcurrentOperations;

    public BoundedWorkQueueStrategy(Integer maxNbConcurrentOperations) {
        if (maxNbConcurrentOperations != null) {
            this.maxNbConcurrentOperations = maxNbConcurrentOperations;
        } else {
            int cpus = Runtime.getRuntime().availableProcessors();
            int numWorkerThreads = DirectoryServer.getWorkQueue().getNumWorkerThreads();
            this.maxNbConcurrentOperations = Math.max(cpus, numWorkerThreads * 25 / 100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueRequest(Operation operation) throws DirectoryException {
        if (!operation.getClientConnection().isConnectionValid()) {
            return;
        }
        if (this.maxNbConcurrentOperations == 0) {
            if (!DirectoryServer.tryEnqueueRequest(operation)) {
                operation.run();
            }
        } else if (this.nbRunningOperations.getAndIncrement() > this.maxNbConcurrentOperations || !DirectoryServer.tryEnqueueRequest(this.wrap(operation))) {
            try {
                operation.run();
            }
            finally {
                this.nbRunningOperations.decrementAndGet();
            }
        }
    }

    private Operation wrap(final Operation operation) {
        if (operation instanceof AbandonOperation) {
            return new AbandonOperationWrapper((AbandonOperation)operation){

                @Override
                public void run() {
                    BoundedWorkQueueStrategy.this.runWrapped(operation);
                }
            };
        }
        if (operation instanceof AddOperation) {
            return new AddOperationWrapper((AddOperation)operation){

                @Override
                public void run() {
                    BoundedWorkQueueStrategy.this.runWrapped(operation);
                }
            };
        }
        if (operation instanceof BindOperation) {
            return new BindOperationWrapper((BindOperation)operation){

                @Override
                public void run() {
                    BoundedWorkQueueStrategy.this.runWrapped(operation);
                }
            };
        }
        if (operation instanceof CompareOperation) {
            return new CompareOperationWrapper((CompareOperation)operation){

                @Override
                public void run() {
                    BoundedWorkQueueStrategy.this.runWrapped(operation);
                }
            };
        }
        if (operation instanceof DeleteOperation) {
            return new DeleteOperationWrapper((DeleteOperation)operation){

                @Override
                public void run() {
                    BoundedWorkQueueStrategy.this.runWrapped(operation);
                }
            };
        }
        if (operation instanceof ExtendedOperation) {
            return new ExtendedOperationWrapper((ExtendedOperation)operation){

                @Override
                public void run() {
                    BoundedWorkQueueStrategy.this.runWrapped(operation);
                }
            };
        }
        if (operation instanceof ModifyDNOperation) {
            return new ModifyDNOperationWrapper((ModifyDNOperation)operation){

                @Override
                public void run() {
                    BoundedWorkQueueStrategy.this.runWrapped(operation);
                }
            };
        }
        if (operation instanceof ModifyOperation) {
            return new ModifyOperationWrapper((ModifyOperation)operation){

                @Override
                public void run() {
                    BoundedWorkQueueStrategy.this.runWrapped(operation);
                }
            };
        }
        if (operation instanceof SearchOperation) {
            return new SearchOperationWrapper((SearchOperation)operation){

                @Override
                public void run() {
                    BoundedWorkQueueStrategy.this.runWrapped(operation);
                }
            };
        }
        if (operation instanceof UnbindOperation) {
            return new UnbindOperationWrapper((UnbindOperation)operation){

                @Override
                public void run() {
                    BoundedWorkQueueStrategy.this.runWrapped(operation);
                }
            };
        }
        throw new RuntimeException("Not implemented for " + operation == null ? null : operation.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWrapped(Operation operation) {
        try {
            operation.run();
        }
        finally {
            this.nbRunningOperations.decrementAndGet();
        }
    }
}

