/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.AttributeSyntaxCfgDefn;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class AttributeSyntaxConfigManager
implements ConfigurationChangeListener<AttributeSyntaxCfg>,
ConfigurationAddListener<AttributeSyntaxCfg>,
ConfigurationDeleteListener<AttributeSyntaxCfg> {
    private ConcurrentHashMap<DN, AttributeSyntax> syntaxes = new ConcurrentHashMap();

    public void initializeAttributeSyntaxes() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addAttributeSyntaxAddListener(this);
        rootConfiguration.addAttributeSyntaxDeleteListener(this);
        for (String name : rootConfiguration.listAttributeSyntaxes()) {
            AttributeSyntaxCfg syntaxConfiguration = rootConfiguration.getAttributeSyntax(name);
            syntaxConfiguration.addChangeListener(this);
            if (!syntaxConfiguration.isEnabled()) continue;
            String className = syntaxConfiguration.getJavaClass();
            try {
                AttributeSyntax syntax = this.loadSyntax(className, syntaxConfiguration, true);
                try {
                    DirectoryServer.registerAttributeSyntax(syntax, false);
                    this.syntaxes.put(syntaxConfiguration.dn(), syntax);
                }
                catch (DirectoryException de) {
                    Message message = ConfigMessages.WARN_CONFIG_SCHEMA_SYNTAX_CONFLICTING_SYNTAX.get(String.valueOf(syntaxConfiguration.dn()), de.getMessageObject());
                    ErrorLogger.logError(message);
                }
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(AttributeSyntaxCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadSyntax(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(AttributeSyntaxCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        AttributeSyntax syntax = null;
        String className = configuration.getJavaClass();
        try {
            syntax = this.loadSyntax(className, configuration, true);
            try {
                DirectoryServer.registerAttributeSyntax(syntax, false);
                this.syntaxes.put(configuration.dn(), syntax);
            }
            catch (DirectoryException de) {
                Message message = ConfigMessages.WARN_CONFIG_SCHEMA_SYNTAX_CONFLICTING_SYNTAX.get(String.valueOf(configuration.dn()), de.getMessageObject());
                messages.add(message);
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(AttributeSyntaxCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        AttributeSyntax syntax = this.syntaxes.get(configuration.dn());
        if (syntax != null) {
            String oid = syntax.getOID();
            for (AttributeType at : DirectoryServer.getAttributeTypes().values()) {
                if (!oid.equals(at.getSyntaxOID())) continue;
                Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DELETE_SYNTAX_IN_USE.get(syntax.getSyntaxName(), at.getNameOrOID());
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(AttributeSyntaxCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        AttributeSyntax syntax = this.syntaxes.remove(configuration.dn());
        if (syntax != null) {
            DirectoryServer.deregisterAttributeSyntax(syntax);
            syntax.finalizeSyntax();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AttributeSyntaxCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadSyntax(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        } else {
            AttributeSyntax syntax = this.syntaxes.get(configuration.dn());
            if (syntax != null) {
                String oid = syntax.getOID();
                for (AttributeType at : DirectoryServer.getAttributeTypes().values()) {
                    if (!oid.equals(at.getSyntaxOID())) continue;
                    Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DISABLE_SYNTAX_IN_USE.get(syntax.getSyntaxName(), at.getNameOrOID());
                    unacceptableReasons.add(message);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AttributeSyntaxCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        AttributeSyntax existingSyntax = this.syntaxes.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingSyntax != null) {
                DirectoryServer.deregisterAttributeSyntax(existingSyntax);
                AttributeSyntax syntax = this.syntaxes.remove(configuration.dn());
                if (syntax != null) {
                    syntax.finalizeSyntax();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingSyntax != null) {
            if (!className.equals(existingSyntax.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        AttributeSyntax syntax = null;
        try {
            syntax = this.loadSyntax(className, configuration, true);
            try {
                DirectoryServer.registerAttributeSyntax(syntax, false);
                this.syntaxes.put(configuration.dn(), syntax);
            }
            catch (DirectoryException de) {
                Message message = ConfigMessages.WARN_CONFIG_SCHEMA_SYNTAX_CONFLICTING_SYNTAX.get(String.valueOf(configuration.dn()), de.getMessageObject());
                messages.add(message);
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private AttributeSyntax loadSyntax(String className, AttributeSyntaxCfg configuration, boolean initialize) throws InitializationException {
        try {
            AttributeSyntaxCfgDefn definition = AttributeSyntaxCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<AttributeSyntax> syntaxClass = propertyDefinition.loadClass(className, AttributeSyntax.class);
            AttributeSyntax syntax = syntaxClass.newInstance();
            if (initialize) {
                Method method = syntax.getClass().getMethod("initializeSyntax", configuration.configurationClass());
                method.invoke((Object)syntax, configuration);
            } else {
                Method method = syntax.getClass().getMethod("isConfigurationAcceptable", AttributeSyntaxCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)syntax, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_SCHEMA_SYNTAX_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return syntax;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_SCHEMA_SYNTAX_CANNOT_INITIALIZE.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

