/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class VLVRequestControl
extends Control {
    public static final ControlDecoder<VLVRequestControl> DECODER = new Decoder();
    public static final byte TYPE_TARGET_BYOFFSET = -96;
    public static final byte TYPE_TARGET_GREATERTHANOREQUAL = -127;
    private byte targetType;
    private ByteString contextID;
    private ByteString greaterThanOrEqual;
    private int afterCount;
    private int beforeCount;
    private int contentCount;
    private int offset;

    public VLVRequestControl(int beforeCount, int afterCount, int offset, int contentCount) {
        this(false, beforeCount, afterCount, offset, contentCount, null);
    }

    public VLVRequestControl(boolean isCritical, int beforeCount, int afterCount, int offset, int contentCount, ByteString contextID) {
        super("2.16.840.1.113730.3.4.9", isCritical);
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.offset = offset;
        this.contentCount = contentCount;
        this.contextID = contextID;
        this.targetType = (byte)-96;
    }

    public VLVRequestControl(int beforeCount, int afterCount, ByteString greaterThanOrEqual) {
        this(false, beforeCount, afterCount, greaterThanOrEqual, null);
    }

    public VLVRequestControl(boolean isCritical, int beforeCount, int afterCount, ByteString greaterThanOrEqual, ByteString contextID) {
        super("2.16.840.1.113730.3.4.9", isCritical);
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.greaterThanOrEqual = greaterThanOrEqual;
        this.contextID = contextID;
        this.targetType = (byte)-127;
    }

    public int getBeforeCount() {
        return this.beforeCount;
    }

    public int getAfterCount() {
        return this.afterCount;
    }

    public byte getTargetType() {
        return this.targetType;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public ByteString getGreaterThanOrEqualAssertion() {
        return this.greaterThanOrEqual;
    }

    public ByteString getContextID() {
        return this.contextID;
    }

    @Override
    protected void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        writer.writeInteger(this.beforeCount);
        writer.writeInteger(this.afterCount);
        if (this.targetType == -96) {
            writer.writeStartSequence((byte)-96);
            writer.writeInteger(this.offset);
            writer.writeInteger(this.contentCount);
            writer.writeEndSequence();
        } else {
            writer.writeOctetString((byte)-127, this.greaterThanOrEqual);
        }
        if (this.contextID != null) {
            writer.writeOctetString(this.contextID);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("VLVRequestControl(beforeCount=");
        buffer.append(this.beforeCount);
        buffer.append(", afterCount=");
        buffer.append(this.afterCount);
        if (this.targetType == -96) {
            buffer.append(", offset=");
            buffer.append(this.offset);
            buffer.append(", contentCount=");
            buffer.append(this.contentCount);
        } else {
            buffer.append(", greaterThanOrEqual=");
            buffer.append(this.greaterThanOrEqual);
        }
        if (this.contextID != null) {
            buffer.append(", contextID=");
            buffer.append(this.contextID);
        }
        buffer.append(")");
    }

    private static final class Decoder
    implements ControlDecoder<VLVRequestControl> {
        private Decoder() {
        }

        @Override
        public VLVRequestControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value == null) {
                Message message = ProtocolMessages.INFO_VLVREQ_CONTROL_NO_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                reader.readStartSequence();
                int beforeCount = (int)reader.readInteger();
                int afterCount = (int)reader.readInteger();
                int offset = 0;
                int contentCount = 0;
                ByteString greaterThanOrEqual = null;
                byte targetType = reader.peekType();
                switch (targetType) {
                    case -96: {
                        reader.readStartSequence();
                        offset = (int)reader.readInteger();
                        contentCount = (int)reader.readInteger();
                        reader.readEndSequence();
                        break;
                    }
                    case -127: {
                        greaterThanOrEqual = reader.readOctetString();
                        break;
                    }
                    default: {
                        Message message = ProtocolMessages.INFO_VLVREQ_CONTROL_INVALID_TARGET_TYPE.get(StaticUtils.byteToHex(targetType));
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                    }
                }
                ByteString contextID = null;
                if (reader.hasNextElement()) {
                    contextID = reader.readOctetString();
                }
                if (targetType == -96) {
                    return new VLVRequestControl(isCritical, beforeCount, afterCount, offset, contentCount, contextID);
                }
                return new VLVRequestControl(isCritical, beforeCount, afterCount, greaterThanOrEqual, contextID);
            }
            catch (DirectoryException de) {
                throw de;
            }
            catch (Exception e) {
                Message message = ProtocolMessages.INFO_VLVREQ_CONTROL_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
        }

        @Override
        public String getOID() {
            return "2.16.840.1.113730.3.4.9";
        }
    }
}

