/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class ServerSideSortResponseControl
extends Control {
    public static final ControlDecoder<ServerSideSortResponseControl> DECODER = new Decoder();
    private static final byte TYPE_ATTRIBUTE_TYPE = -128;
    private int resultCode;
    private String attributeType;

    public ServerSideSortResponseControl(int resultCode, String attributeType) {
        this(false, resultCode, attributeType);
    }

    public ServerSideSortResponseControl(boolean isCritical, int resultCode, String attributeType) {
        super("1.2.840.113556.1.4.474", isCritical);
        this.resultCode = resultCode;
        this.attributeType = attributeType;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    @Override
    protected void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        writer.writeEnumerated(this.resultCode);
        if (this.attributeType != null) {
            writer.writeOctetString((byte)-128, this.attributeType);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ServerSideSortResponseControl(resultCode=");
        buffer.append(this.resultCode);
        if (this.attributeType != null) {
            buffer.append(", attributeType=");
            buffer.append(this.attributeType);
        }
        buffer.append(")");
    }

    private static final class Decoder
    implements ControlDecoder<ServerSideSortResponseControl> {
        private Decoder() {
        }

        @Override
        public ServerSideSortResponseControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value == null) {
                Message message = ProtocolMessages.INFO_SORTRES_CONTROL_NO_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                reader.readStartSequence();
                int resultCode = (int)reader.readInteger();
                String attributeType = null;
                if (reader.hasNextElement()) {
                    attributeType = reader.readOctetStringAsString();
                }
                return new ServerSideSortResponseControl(isCritical, resultCode, attributeType);
            }
            catch (Exception e) {
                Message message = ProtocolMessages.INFO_SORTRES_CONTROL_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
        }

        @Override
        public String getOID() {
            return "1.2.840.113556.1.4.474";
        }
    }
}

