/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.AuthenticationPolicyState;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class ProxiedAuthV1Control
extends Control {
    public static final ControlDecoder<ProxiedAuthV1Control> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString rawAuthorizationDN;
    private DN authorizationDN;

    public ProxiedAuthV1Control(ByteString rawAuthorizationDN) {
        this(true, rawAuthorizationDN);
    }

    public ProxiedAuthV1Control(DN authorizationDN) {
        this(true, authorizationDN);
    }

    public ProxiedAuthV1Control(boolean isCritical, ByteString rawAuthorizationDN) {
        super("2.16.840.1.113730.3.4.12", isCritical);
        this.rawAuthorizationDN = rawAuthorizationDN;
        this.authorizationDN = null;
    }

    public ProxiedAuthV1Control(boolean isCritical, DN authorizationDN) {
        super("2.16.840.1.113730.3.4.12", isCritical);
        this.authorizationDN = authorizationDN;
        this.rawAuthorizationDN = ByteString.valueOf(authorizationDN.toString());
    }

    @Override
    protected void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        writer.writeOctetString(this.rawAuthorizationDN);
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public ByteString getRawAuthorizationDN() {
        return this.rawAuthorizationDN;
    }

    public DN getAuthorizationDN() throws DirectoryException {
        if (this.authorizationDN == null) {
            this.authorizationDN = DN.decode(this.rawAuthorizationDN);
        }
        return this.authorizationDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getAuthorizationEntry() throws DirectoryException {
        Lock entryLock;
        DN authzDN = this.getAuthorizationDN();
        if (authzDN.isNullDN()) {
            return null;
        }
        DN actualDN = DirectoryServer.getActualRootBindDN(authzDN);
        if (actualDN != null) {
            authzDN = actualDN;
        }
        if ((entryLock = LockManager.lockRead(authzDN)) == null) {
            throw new DirectoryException(ResultCode.BUSY, ProtocolMessages.ERR_PROXYAUTH1_CANNOT_LOCK_USER.get(String.valueOf(authzDN)));
        }
        try {
            PasswordPolicyState pwpState;
            Entry userEntry = DirectoryServer.getEntry(authzDN);
            if (userEntry == null) {
                Message message = ProtocolMessages.ERR_PROXYAUTH1_NO_SUCH_USER.get(String.valueOf(authzDN));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            AuthenticationPolicyState state = AuthenticationPolicyState.forUser(userEntry, false);
            if (state.isDisabled()) {
                Message message = ProtocolMessages.ERR_PROXYAUTH1_UNUSABLE_ACCOUNT.get(String.valueOf(userEntry.getDN()));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            if (state.isPasswordPolicy() && ((pwpState = (PasswordPolicyState)state).isAccountExpired() || pwpState.lockedDueToFailures() || pwpState.lockedDueToIdleInterval() || pwpState.lockedDueToMaximumResetAge() || pwpState.isPasswordExpired())) {
                Message message = ProtocolMessages.ERR_PROXYAUTH1_UNUSABLE_ACCOUNT.get(String.valueOf(authzDN));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            Entry entry = userEntry;
            return entry;
        }
        finally {
            LockManager.unlock(authzDN, entryLock);
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ProxiedAuthorizationV1Control(authorizationDN=\"");
        buffer.append(this.rawAuthorizationDN);
        buffer.append("\")");
    }

    private static final class Decoder
    implements ControlDecoder<ProxiedAuthV1Control> {
        private Decoder() {
        }

        @Override
        public ProxiedAuthV1Control decode(boolean isCritical, ByteString value) throws DirectoryException {
            DN authorizationDN;
            if (!isCritical) {
                Message message = ProtocolMessages.ERR_PROXYAUTH1_CONTROL_NOT_CRITICAL.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            if (value == null) {
                Message message = ProtocolMessages.ERR_PROXYAUTH1_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                reader.readStartSequence();
                authorizationDN = DN.decode(reader.readOctetString());
                reader.readEndSequence();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_PROXYAUTH1_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
            return new ProxiedAuthV1Control(isCritical, authorizationDN);
        }

        @Override
        public String getOID() {
            return "2.16.840.1.113730.3.4.12";
        }
    }
}

