/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class PasswordPolicyResponseControl
extends Control {
    public static final ControlDecoder<PasswordPolicyResponseControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final byte TYPE_WARNING_ELEMENT = -96;
    public static final byte TYPE_ERROR_ELEMENT = -127;
    private int warningValue;
    private PasswordPolicyErrorType errorType;
    private PasswordPolicyWarningType warningType;

    public PasswordPolicyResponseControl() {
        this(false, null, -1, null);
    }

    public PasswordPolicyResponseControl(PasswordPolicyWarningType warningType, int warningValue, PasswordPolicyErrorType errorType) {
        this(false, warningType, warningValue, errorType);
    }

    public PasswordPolicyResponseControl(boolean isCritical, PasswordPolicyWarningType warningType, int warningValue, PasswordPolicyErrorType errorType) {
        super("1.3.6.1.4.1.42.2.27.8.5.1", isCritical);
        this.warningType = warningType;
        this.warningValue = warningValue;
        this.errorType = errorType;
    }

    @Override
    protected void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        if (this.warningType != null) {
            writer.writeStartSequence((byte)-96);
            writer.writeInteger(this.warningType.getType(), this.warningValue);
            writer.writeEndSequence();
        }
        if (this.errorType != null) {
            writer.writeInteger((byte)-127, this.errorType.intValue());
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public PasswordPolicyWarningType getWarningType() {
        return this.warningType;
    }

    public int getWarningValue() {
        return this.warningValue;
    }

    public PasswordPolicyErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("PasswordPolicyResponseControl(");
        if (this.warningType != null) {
            buffer.append(this.warningType.toString());
            buffer.append("=");
            buffer.append(this.warningValue);
            if (this.errorType != null) {
                buffer.append(", ");
            }
        }
        if (this.errorType != null) {
            buffer.append(this.errorType.toString());
        }
        buffer.append(")");
    }

    private static final class Decoder
    implements ControlDecoder<PasswordPolicyResponseControl> {
        private Decoder() {
        }

        @Override
        public PasswordPolicyResponseControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value == null) {
                Message message = ProtocolMessages.ERR_PWPOLICYRES_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                int errorValue;
                PasswordPolicyWarningType warningType = null;
                PasswordPolicyErrorType errorType = null;
                int warningValue = -1;
                reader.readStartSequence();
                if (reader.hasNextElement() && reader.peekType() == -96) {
                    reader.readStartSequence();
                    warningType = PasswordPolicyWarningType.valueOf(reader.peekType());
                    warningValue = (int)reader.readInteger();
                    if (warningType == null) {
                        Message message = ProtocolMessages.ERR_PWPOLICYRES_INVALID_WARNING_TYPE.get(StaticUtils.byteToHex(reader.peekType()));
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                    }
                    reader.readEndSequence();
                }
                if (reader.hasNextElement() && reader.peekType() == -127 && (errorType = PasswordPolicyErrorType.valueOf(errorValue = (int)reader.readInteger())) == null) {
                    Message message = ProtocolMessages.ERR_PWPOLICYRES_INVALID_ERROR_TYPE.get(errorValue);
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                }
                reader.readEndSequence();
                return new PasswordPolicyResponseControl(isCritical, warningType, warningValue, errorType);
            }
            catch (DirectoryException de) {
                throw de;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_PWPOLICYRES_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.42.2.27.9.5.8";
        }
    }
}

