/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.HashMap;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;

public enum PasswordPolicyErrorType {
    PASSWORD_EXPIRED(0, ProtocolMessages.INFO_PWPERRTYPE_DESCRIPTION_PASSWORD_EXPIRED.get()),
    ACCOUNT_LOCKED(1, ProtocolMessages.INFO_PWPERRTYPE_DESCRIPTION_ACCOUNT_LOCKED.get()),
    CHANGE_AFTER_RESET(2, ProtocolMessages.INFO_PWPERRTYPE_DESCRIPTION_CHANGE_AFTER_RESET.get()),
    PASSWORD_MOD_NOT_ALLOWED(3, ProtocolMessages.INFO_PWPERRTYPE_DESCRIPTION_PASSWORD_MOD_NOT_ALLOWED.get()),
    MUST_SUPPLY_OLD_PASSWORD(4, ProtocolMessages.INFO_PWPERRTYPE_DESCRIPTION_MUST_SUPPLY_OLD_PASSWORD.get()),
    INSUFFICIENT_PASSWORD_QUALITY(5, ProtocolMessages.INFO_PWPERRTYPE_DESCRIPTION_INSUFFICIENT_PASSWORD_QUALITY.get()),
    PASSWORD_TOO_SHORT(6, ProtocolMessages.INFO_PWPERRTYPE_DESCRIPTION_PASSWORD_TOO_SHORT.get()),
    PASSWORD_TOO_YOUNG(7, ProtocolMessages.INFO_PWPERRTYPE_DESCRIPTION_PASSWORD_TOO_YOUNG.get()),
    PASSWORD_IN_HISTORY(8, ProtocolMessages.INFO_PWPERRTYPE_DESCRIPTION_PASSWORD_IN_HISTORY.get());

    private static final Map<Integer, PasswordPolicyErrorType> TABLE;
    private int value;
    private Message description;

    private PasswordPolicyErrorType(int value, Message description) {
        this.value = value;
        this.description = description;
    }

    public int intValue() {
        return this.value;
    }

    public static PasswordPolicyErrorType valueOf(int value) {
        return TABLE.get(value);
    }

    public String toString() {
        return this.description.toString();
    }

    static {
        TABLE = new HashMap<Integer, PasswordPolicyErrorType>();
        for (PasswordPolicyErrorType type : PasswordPolicyErrorType.values()) {
            TABLE.put(type.value, type);
            TABLE.put(type.value, type);
        }
    }
}

