/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.RawFilter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public class MatchedValuesFilter {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final byte EQUALITY_MATCH_TYPE = -93;
    public static final byte SUBSTRINGS_TYPE = -92;
    public static final byte GREATER_OR_EQUAL_TYPE = -91;
    public static final byte LESS_OR_EQUAL_TYPE = -90;
    public static final byte PRESENT_TYPE = -121;
    public static final byte APPROXIMATE_MATCH_TYPE = -88;
    public static final byte EXTENSIBLE_MATCH_TYPE = -87;
    private ApproximateMatchingRule approximateMatchingRule;
    private ByteString normalizedSubFinal;
    private ByteString normalizedSubInitial;
    private final ByteString rawAssertionValue;
    private final ByteString subFinal;
    private final ByteString subInitial;
    private AttributeType attributeType;
    private AttributeValue assertionValue;
    private boolean decoded;
    private final byte matchType;
    private EqualityMatchingRule equalityMatchingRule;
    private List<ByteString> normalizedSubAny;
    private final List<ByteString> subAny;
    private MatchingRule matchingRule;
    private OrderingMatchingRule orderingMatchingRule;
    private final String matchingRuleID;
    private final String rawAttributeType;
    private SubstringMatchingRule substringMatchingRule;

    private MatchedValuesFilter(byte matchType, String rawAttributeType, ByteString rawAssertionValue, ByteString subInitial, List<ByteString> subAny, ByteString subFinal, String matchingRuleID) {
        this.matchType = matchType;
        this.rawAttributeType = rawAttributeType;
        this.rawAssertionValue = rawAssertionValue;
        this.subInitial = subInitial;
        this.subAny = subAny;
        this.subFinal = subFinal;
        this.matchingRuleID = matchingRuleID;
        this.decoded = false;
        this.attributeType = null;
        this.assertionValue = null;
        this.matchingRule = null;
        this.normalizedSubInitial = null;
        this.normalizedSubAny = null;
        this.normalizedSubFinal = null;
        this.approximateMatchingRule = null;
        this.equalityMatchingRule = null;
        this.orderingMatchingRule = null;
        this.substringMatchingRule = null;
    }

    public static MatchedValuesFilter createEqualityFilter(String rawAttributeType, ByteString rawAssertionValue) {
        Validator.ensureNotNull(rawAttributeType, rawAssertionValue);
        return new MatchedValuesFilter(-93, rawAttributeType, rawAssertionValue, null, null, null, null);
    }

    public static MatchedValuesFilter createEqualityFilter(AttributeType attributeType, AttributeValue assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        String rawAttributeType = attributeType.getNameOrOID();
        ByteString rawAssertionValue = assertionValue.getValue();
        MatchedValuesFilter filter = new MatchedValuesFilter(-93, rawAttributeType, rawAssertionValue, null, null, null, null);
        filter.attributeType = attributeType;
        filter.assertionValue = assertionValue;
        return filter;
    }

    public static MatchedValuesFilter createSubstringsFilter(String rawAttributeType, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        Validator.ensureNotNull(rawAttributeType);
        return new MatchedValuesFilter(-92, rawAttributeType, null, subInitial, subAny, subFinal, null);
    }

    public static MatchedValuesFilter createSubstringsFilter(AttributeType attributeType, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        Validator.ensureNotNull(attributeType);
        String rawAttributeType = attributeType.getNameOrOID();
        MatchedValuesFilter filter = new MatchedValuesFilter(-92, rawAttributeType, null, subInitial, subAny, subFinal, null);
        filter.attributeType = attributeType;
        return filter;
    }

    public static MatchedValuesFilter createGreaterOrEqualFilter(String rawAttributeType, ByteString rawAssertionValue) {
        Validator.ensureNotNull(rawAttributeType, rawAssertionValue);
        return new MatchedValuesFilter(-91, rawAttributeType, rawAssertionValue, null, null, null, null);
    }

    public static MatchedValuesFilter createGreaterOrEqualFilter(AttributeType attributeType, AttributeValue assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        String rawAttributeType = attributeType.getNameOrOID();
        ByteString rawAssertionValue = assertionValue.getValue();
        MatchedValuesFilter filter = new MatchedValuesFilter(-91, rawAttributeType, rawAssertionValue, null, null, null, null);
        filter.attributeType = attributeType;
        filter.assertionValue = assertionValue;
        return filter;
    }

    public static MatchedValuesFilter createLessOrEqualFilter(String rawAttributeType, ByteString rawAssertionValue) {
        Validator.ensureNotNull(rawAttributeType, rawAssertionValue);
        return new MatchedValuesFilter(-90, rawAttributeType, rawAssertionValue, null, null, null, null);
    }

    public static MatchedValuesFilter createLessOrEqualFilter(AttributeType attributeType, AttributeValue assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        String rawAttributeType = attributeType.getNameOrOID();
        ByteString rawAssertionValue = assertionValue.getValue();
        MatchedValuesFilter filter = new MatchedValuesFilter(-90, rawAttributeType, rawAssertionValue, null, null, null, null);
        filter.attributeType = attributeType;
        filter.assertionValue = assertionValue;
        return filter;
    }

    public static MatchedValuesFilter createPresentFilter(String rawAttributeType) {
        Validator.ensureNotNull(rawAttributeType);
        return new MatchedValuesFilter(-121, rawAttributeType, null, null, null, null, null);
    }

    public static MatchedValuesFilter createPresentFilter(AttributeType attributeType) {
        Validator.ensureNotNull(attributeType);
        String rawAttributeType = attributeType.getNameOrOID();
        MatchedValuesFilter filter = new MatchedValuesFilter(-121, rawAttributeType, null, null, null, null, null);
        filter.attributeType = attributeType;
        return filter;
    }

    public static MatchedValuesFilter createApproximateFilter(String rawAttributeType, ByteString rawAssertionValue) {
        Validator.ensureNotNull(rawAttributeType, rawAssertionValue);
        return new MatchedValuesFilter(-88, rawAttributeType, rawAssertionValue, null, null, null, null);
    }

    public static MatchedValuesFilter createApproximateFilter(AttributeType attributeType, AttributeValue assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        String rawAttributeType = attributeType.getNameOrOID();
        ByteString rawAssertionValue = assertionValue.getValue();
        MatchedValuesFilter filter = new MatchedValuesFilter(-88, rawAttributeType, rawAssertionValue, null, null, null, null);
        filter.attributeType = attributeType;
        filter.assertionValue = assertionValue;
        return filter;
    }

    public static MatchedValuesFilter createExtensibleMatchFilter(String rawAttributeType, String matchingRuleID, ByteString rawAssertionValue) {
        Validator.ensureNotNull(rawAttributeType, matchingRuleID, rawAssertionValue);
        return new MatchedValuesFilter(-87, rawAttributeType, rawAssertionValue, null, null, null, matchingRuleID);
    }

    public static MatchedValuesFilter createExtensibleMatchFilter(AttributeType attributeType, MatchingRule matchingRule, AttributeValue assertionValue) {
        Validator.ensureNotNull(attributeType, matchingRule, assertionValue);
        String rawAttributeType = attributeType.getNameOrOID();
        String matchingRuleID = matchingRule.getOID();
        ByteString rawAssertionValue = assertionValue.getValue();
        MatchedValuesFilter filter = new MatchedValuesFilter(-87, rawAttributeType, rawAssertionValue, null, null, null, matchingRuleID);
        filter.attributeType = attributeType;
        filter.assertionValue = assertionValue;
        filter.matchingRule = matchingRule;
        return filter;
    }

    public static MatchedValuesFilter createFromLDAPFilter(RawFilter filter) throws LDAPException {
        switch (filter.getFilterType()) {
            case AND: 
            case OR: 
            case NOT: {
                Message message = ProtocolMessages.ERR_MVFILTER_INVALID_LDAP_FILTER_TYPE.get(String.valueOf(filter), String.valueOf((Object)filter.getFilterType()));
                throw new LDAPException(2, message);
            }
            case EQUALITY: {
                return new MatchedValuesFilter(-93, filter.getAttributeType(), filter.getAssertionValue(), null, null, null, null);
            }
            case SUBSTRING: {
                return new MatchedValuesFilter(-92, filter.getAttributeType(), null, filter.getSubInitialElement(), filter.getSubAnyElements(), filter.getSubFinalElement(), null);
            }
            case GREATER_OR_EQUAL: {
                return new MatchedValuesFilter(-91, filter.getAttributeType(), filter.getAssertionValue(), null, null, null, null);
            }
            case LESS_OR_EQUAL: {
                return new MatchedValuesFilter(-90, filter.getAttributeType(), filter.getAssertionValue(), null, null, null, null);
            }
            case PRESENT: {
                return new MatchedValuesFilter(-121, filter.getAttributeType(), null, null, null, null, null);
            }
            case APPROXIMATE_MATCH: {
                return new MatchedValuesFilter(-88, filter.getAttributeType(), filter.getAssertionValue(), null, null, null, null);
            }
            case EXTENSIBLE_MATCH: {
                if (filter.getDNAttributes()) {
                    Message message = ProtocolMessages.ERR_MVFILTER_INVALID_DN_ATTRIBUTES_FLAG.get(String.valueOf(filter));
                    throw new LDAPException(2, message);
                }
                return new MatchedValuesFilter(-87, filter.getAttributeType(), filter.getAssertionValue(), null, null, null, filter.getMatchingRuleID());
            }
        }
        Message message = ProtocolMessages.ERR_MVFILTER_INVALID_LDAP_FILTER_TYPE.get(String.valueOf(filter), String.valueOf((Object)filter.getFilterType()));
        throw new LDAPException(2, message);
    }

    public void encode(ASN1Writer writer) throws IOException {
        switch (this.matchType) {
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                writer.writeStartSequence(this.matchType);
                writer.writeOctetString(this.rawAttributeType);
                writer.writeOctetString(this.rawAssertionValue);
                writer.writeEndSequence();
                return;
            }
            case -92: {
                writer.writeStartSequence(this.matchType);
                writer.writeOctetString(this.rawAttributeType);
                writer.writeStartSequence();
                if (this.subInitial != null) {
                    writer.writeOctetString((byte)-128, this.subInitial);
                }
                if (this.subAny != null) {
                    for (ByteString s : this.subAny) {
                        writer.writeOctetString((byte)-127, s);
                    }
                }
                if (this.subFinal != null) {
                    writer.writeOctetString((byte)-126, this.subFinal);
                }
                writer.writeEndSequence();
                writer.writeEndSequence();
                return;
            }
            case -121: {
                writer.writeOctetString(this.matchType, this.rawAttributeType);
                return;
            }
            case -87: {
                writer.writeStartSequence(this.matchType);
                if (this.matchingRuleID != null) {
                    writer.writeOctetString((byte)-127, this.matchingRuleID);
                }
                if (this.rawAttributeType != null) {
                    writer.writeOctetString((byte)-126, this.rawAttributeType);
                }
                writer.writeOctetString((byte)-125, this.rawAssertionValue);
                writer.writeEndSequence();
                return;
            }
        }
    }

    public static MatchedValuesFilter decode(ASN1Reader reader) throws LDAPException {
        byte type;
        try {
            type = reader.peekType();
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_MVFILTER_INVALID_ELEMENT_TYPE.get(e.toString());
            throw new LDAPException(2, message);
        }
        switch (type) {
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                try {
                    reader.readStartSequence();
                    String rawAttributeType = reader.readOctetStringAsString();
                    ByteString rawAssertionValue = reader.readOctetString();
                    reader.readEndSequence();
                    return new MatchedValuesFilter(type, rawAttributeType, rawAssertionValue, null, null, null, null);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_MVFILTER_CANNOT_DECODE_AVA.get(StaticUtils.getExceptionMessage(e));
                    throw new LDAPException(2, message, e);
                }
            }
            case -92: {
                try {
                    reader.readStartSequence();
                    String rawAttributeType = reader.readOctetStringAsString();
                    reader.readStartSequence();
                    if (!reader.hasNextElement()) {
                        Message message = ProtocolMessages.ERR_MVFILTER_NO_SUBSTRING_ELEMENTS.get();
                        throw new LDAPException(2, message);
                    }
                    ByteString subInitial = null;
                    ArrayList<ByteString> subAny = null;
                    ByteString subFinal = null;
                    if (reader.hasNextElement() && reader.peekType() == -128) {
                        subInitial = reader.readOctetString();
                    }
                    while (reader.hasNextElement() && reader.peekType() == -127) {
                        if (subAny == null) {
                            subAny = new ArrayList<ByteString>();
                        }
                        subAny.add(reader.readOctetString());
                    }
                    if (reader.hasNextElement() && reader.peekType() == -126) {
                        subFinal = reader.readOctetString();
                    }
                    reader.readEndSequence();
                    reader.readEndSequence();
                    return new MatchedValuesFilter(type, rawAttributeType, null, subInitial, subAny, subFinal, null);
                }
                catch (LDAPException le) {
                    throw le;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_MVFILTER_CANNOT_DECODE_SUBSTRINGS.get(StaticUtils.getExceptionMessage(e));
                    throw new LDAPException(2, message, e);
                }
            }
            case -121: {
                try {
                    String rawAttributeType = reader.readOctetStringAsString();
                    return new MatchedValuesFilter(type, rawAttributeType, null, null, null, null, null);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_MVFILTER_CANNOT_DECODE_PRESENT_TYPE.get(StaticUtils.getExceptionMessage(e));
                    throw new LDAPException(2, message, e);
                }
            }
            case -87: {
                try {
                    reader.readStartSequence();
                    String rawAttributeType = null;
                    String matchingRuleID = null;
                    if (reader.peekType() == -127) {
                        matchingRuleID = reader.readOctetStringAsString();
                    }
                    if (matchingRuleID == null || reader.peekType() == -126) {
                        rawAttributeType = reader.readOctetStringAsString();
                    }
                    ByteString rawAssertionValue = reader.readOctetString();
                    reader.readEndSequence();
                    return new MatchedValuesFilter(type, rawAttributeType, rawAssertionValue, null, null, null, matchingRuleID);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_MVFILTER_CANNOT_DECODE_EXTENSIBLE_MATCH.get(StaticUtils.getExceptionMessage(e));
                    throw new LDAPException(2, message, e);
                }
            }
        }
        Message message = ProtocolMessages.ERR_MVFILTER_INVALID_ELEMENT_TYPE.get(StaticUtils.byteToHex(type));
        throw new LDAPException(2, message);
    }

    public byte getMatchType() {
        return this.matchType;
    }

    public String getRawAttributeType() {
        return this.rawAttributeType;
    }

    public AttributeType getAttributeType() {
        if (this.attributeType == null && this.rawAttributeType != null) {
            this.attributeType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(this.rawAttributeType));
            if (this.attributeType == null) {
                this.attributeType = DirectoryServer.getDefaultAttributeType(this.rawAttributeType);
            }
        }
        return this.attributeType;
    }

    public ByteString getRawAssertionValue() {
        return this.rawAssertionValue;
    }

    public AttributeValue getAssertionValue() {
        if (this.assertionValue == null && this.rawAssertionValue != null) {
            this.assertionValue = AttributeValues.create(this.getAttributeType(), this.rawAssertionValue);
        }
        return this.assertionValue;
    }

    public ByteString getSubInitialElement() {
        return this.subInitial;
    }

    public ByteString getNormalizedSubInitialElement() {
        block3: {
            if (this.normalizedSubInitial == null && this.subInitial != null && this.getSubstringMatchingRule() != null) {
                try {
                    this.normalizedSubInitial = this.getSubstringMatchingRule().normalizeSubstring(this.subInitial);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return this.normalizedSubInitial;
    }

    public List<ByteString> getSubAnyElements() {
        return this.subAny;
    }

    public List<ByteString> getNormalizedSubAnyElements() {
        if (this.normalizedSubAny == null) {
            if (this.subAny == null || this.subAny.isEmpty()) {
                this.normalizedSubAny = new ArrayList<ByteString>(0);
            } else {
                if (this.getSubstringMatchingRule() == null) {
                    return null;
                }
                this.normalizedSubAny = new ArrayList<ByteString>();
                try {
                    for (ByteString s : this.subAny) {
                        this.normalizedSubAny.add(this.substringMatchingRule.normalizeSubstring(s));
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.normalizedSubAny = null;
                }
            }
        }
        return this.normalizedSubAny;
    }

    public ByteString getSubFinalElement() {
        return this.subFinal;
    }

    public ByteString getNormalizedSubFinalElement() {
        block3: {
            if (this.normalizedSubFinal == null && this.subFinal != null && this.getSubstringMatchingRule() != null) {
                try {
                    this.normalizedSubFinal = this.getSubstringMatchingRule().normalizeSubstring(this.subFinal);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return this.normalizedSubFinal;
    }

    public String getMatchingRuleID() {
        return this.matchingRuleID;
    }

    public MatchingRule getMatchingRule() {
        if (this.matchingRule == null && this.matchingRuleID != null) {
            this.matchingRule = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(this.matchingRuleID));
        }
        return this.matchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        AttributeType attrType;
        if (this.approximateMatchingRule == null && (attrType = this.getAttributeType()) != null) {
            this.approximateMatchingRule = attrType.getApproximateMatchingRule();
        }
        return this.approximateMatchingRule;
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        AttributeType attrType;
        if (this.equalityMatchingRule == null && (attrType = this.getAttributeType()) != null) {
            this.equalityMatchingRule = attrType.getEqualityMatchingRule();
        }
        return this.equalityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        AttributeType attrType;
        if (this.orderingMatchingRule == null && (attrType = this.getAttributeType()) != null) {
            this.orderingMatchingRule = attrType.getOrderingMatchingRule();
        }
        return this.orderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        AttributeType attrType;
        if (this.substringMatchingRule == null && (attrType = this.getAttributeType()) != null) {
            this.substringMatchingRule = attrType.getSubstringMatchingRule();
        }
        return this.substringMatchingRule;
    }

    private void fullyDecode() {
        if (!this.decoded) {
            this.getAttributeType();
            this.getAssertionValue();
            this.getNormalizedSubInitialElement();
            this.getNormalizedSubAnyElements();
            this.getNormalizedSubFinalElement();
            this.getMatchingRule();
            this.getApproximateMatchingRule();
            this.getEqualityMatchingRule();
            this.getOrderingMatchingRule();
            this.getSubstringMatchingRule();
            this.decoded = true;
        }
    }

    public boolean valueMatches(AttributeType type, AttributeValue value) {
        this.fullyDecode();
        switch (this.matchType) {
            case -93: {
                if (this.attributeType != null && type != null && this.attributeType.equals(type) && this.assertionValue != null && value != null && this.equalityMatchingRule != null) {
                    try {
                        return this.equalityMatchingRule.areEqual(this.assertionValue.getNormalizedValue(), value.getNormalizedValue());
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                return false;
            }
            case -92: {
                if (this.attributeType != null && type != null && this.attributeType.equals(type) && this.substringMatchingRule != null) {
                    try {
                        ArrayList<ByteSequence> normalizedSubAnyBS = new ArrayList<ByteSequence>(this.normalizedSubAny);
                        return this.substringMatchingRule.valueMatchesSubstring(this.substringMatchingRule.normalizeValue(value.getValue()), this.normalizedSubInitial, normalizedSubAnyBS, this.normalizedSubFinal);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                return false;
            }
            case -91: {
                if (this.attributeType != null && type != null && this.attributeType.equals(type) && this.assertionValue != null && value != null && this.orderingMatchingRule != null) {
                    try {
                        return this.orderingMatchingRule.compareValues(this.assertionValue.getNormalizedValue(), this.orderingMatchingRule.normalizeValue(value.getValue())) >= 0;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                return false;
            }
            case -90: {
                if (this.attributeType != null && type != null && this.attributeType.equals(type) && this.assertionValue != null && value != null && this.orderingMatchingRule != null) {
                    try {
                        return this.orderingMatchingRule.compareValues(this.assertionValue.getNormalizedValue(), this.orderingMatchingRule.normalizeValue(value.getValue())) <= 0;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                return false;
            }
            case -121: {
                return this.attributeType != null && type != null && this.attributeType.equals(type);
            }
            case -88: {
                if (this.attributeType != null && type != null && this.attributeType.equals(type) && this.assertionValue != null && value != null && this.approximateMatchingRule != null) {
                    try {
                        ByteString nv1 = this.approximateMatchingRule.normalizeValue(this.assertionValue.getNormalizedValue());
                        ByteString nv2 = this.approximateMatchingRule.normalizeValue(this.approximateMatchingRule.normalizeValue(value.getValue()));
                        return this.approximateMatchingRule.approximatelyMatch(nv1, nv2);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                return false;
            }
            case -87: {
                if (this.assertionValue == null || value == null) {
                    return false;
                }
                if (this.attributeType == null) {
                    if (this.matchingRule == null) {
                        return false;
                    }
                    try {
                        ByteString nv1 = this.matchingRule.normalizeValue(value.getValue());
                        ByteString nv2 = this.matchingRule.normalizeValue(this.assertionValue.getValue());
                        return this.matchingRule.valuesMatch(nv1, nv2) == ConditionResult.TRUE;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                if (!this.attributeType.equals(type) || this.equalityMatchingRule == null) {
                    return false;
                }
                try {
                    return this.equalityMatchingRule.areEqual(this.assertionValue.getNormalizedValue(), value.getNormalizedValue());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        switch (this.matchType) {
            case -93: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append("=");
                RawFilter.valueToFilterString(buffer, this.rawAssertionValue);
                buffer.append(")");
                break;
            }
            case -92: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append("=");
                if (this.subInitial != null) {
                    RawFilter.valueToFilterString(buffer, this.subInitial);
                }
                if (this.subAny != null) {
                    for (ByteString s : this.subAny) {
                        buffer.append("*");
                        RawFilter.valueToFilterString(buffer, s);
                    }
                }
                buffer.append("*");
                if (this.subFinal != null) {
                    RawFilter.valueToFilterString(buffer, this.subFinal);
                }
                buffer.append(")");
                break;
            }
            case -91: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append(">=");
                RawFilter.valueToFilterString(buffer, this.rawAssertionValue);
                buffer.append(")");
                break;
            }
            case -90: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append("<=");
                RawFilter.valueToFilterString(buffer, this.rawAssertionValue);
                buffer.append(")");
                break;
            }
            case -121: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append("=*)");
                break;
            }
            case -88: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append("~=");
                RawFilter.valueToFilterString(buffer, this.rawAssertionValue);
                buffer.append(")");
                break;
            }
            case -87: {
                buffer.append("(");
                if (this.rawAttributeType != null) {
                    buffer.append(this.rawAttributeType);
                }
                if (this.matchingRuleID != null) {
                    buffer.append(":");
                    buffer.append(this.matchingRuleID);
                }
                buffer.append(":=");
                RawFilter.valueToFilterString(buffer, this.rawAssertionValue);
                buffer.append(")");
            }
        }
    }
}

