/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.plugins.LDAPADListPlugin;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class LDAPPreReadRequestControl
extends Control {
    public static final ControlDecoder<LDAPPreReadRequestControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Set<String> rawAttributes;
    private Set<String> requestedAttributes;

    public LDAPPreReadRequestControl(boolean isCritical, Set<String> rawAttributes) {
        super("1.3.6.1.1.13.1", isCritical);
        this.rawAttributes = rawAttributes == null ? new LinkedHashSet<String>(0) : rawAttributes;
        this.requestedAttributes = null;
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        if (this.rawAttributes != null) {
            for (String attr : this.rawAttributes) {
                writer.writeOctetString(attr);
            }
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public Set<String> getRawAttributes() {
        return this.rawAttributes;
    }

    public Set<String> getRequestedAttributes() {
        if (this.requestedAttributes == null) {
            this.requestedAttributes = LDAPADListPlugin.normalizedObjectClasses(this.rawAttributes);
        }
        return this.requestedAttributes;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPPreReadRequestControl(criticality=");
        buffer.append(this.isCritical());
        buffer.append(",attrs=\"");
        if (!this.rawAttributes.isEmpty()) {
            Iterator<String> iterator = this.rawAttributes.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(",");
                buffer.append(iterator.next());
            }
        }
        buffer.append("\")");
    }

    private static final class Decoder
    implements ControlDecoder<LDAPPreReadRequestControl> {
        private Decoder() {
        }

        @Override
        public LDAPPreReadRequestControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value == null) {
                Message message = ProtocolMessages.ERR_PREREADREQ_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            LinkedHashSet<String> rawAttributes = new LinkedHashSet<String>();
            try {
                reader.readStartSequence();
                while (reader.hasNextElement()) {
                    rawAttributes.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
            }
            catch (Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                Message message = ProtocolMessages.ERR_PREREADREQ_CANNOT_DECODE_VALUE.get(ae.getMessage());
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, ae);
            }
            return new LDAPPreReadRequestControl(isCritical, rawAttributes);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.1.13.1";
        }
    }
}

