/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;

public class LDAPAssertionRequestControl
extends Control {
    public static final ControlDecoder<LDAPAssertionRequestControl> DECODER = new Decoder();
    private LDAPFilter rawFilter;
    private SearchFilter filter;

    public LDAPAssertionRequestControl(boolean isCritical, LDAPFilter rawFilter) {
        super("1.3.6.1.1.12", isCritical);
        this.rawFilter = rawFilter;
        this.filter = null;
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        this.rawFilter.write(writer);
        writer.writeEndSequence();
    }

    public LDAPFilter getRawFilter() {
        return this.rawFilter;
    }

    public SearchFilter getSearchFilter() throws DirectoryException {
        if (this.filter == null) {
            this.filter = this.rawFilter.toSearchFilter();
        }
        return this.filter;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPAssertionRequestControl(criticality=");
        buffer.append(this.isCritical());
        buffer.append(",filter=\"");
        this.rawFilter.toString(buffer);
        buffer.append("\")");
    }

    private static final class Decoder
    implements ControlDecoder<LDAPAssertionRequestControl> {
        private Decoder() {
        }

        @Override
        public LDAPAssertionRequestControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            LDAPFilter filter;
            if (value == null) {
                Message message = ProtocolMessages.ERR_LDAPASSERT_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                filter = LDAPFilter.decode(reader);
            }
            catch (LDAPException e) {
                throw new DirectoryException(ResultCode.valueOf(e.getResultCode()), e.getMessageObject(), e.getCause());
            }
            return new LDAPAssertionRequestControl(isCritical, filter);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.1.12";
        }
    }
}

