/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class GetEffectiveRightsRequestControl
extends Control {
    public static final ControlDecoder<GetEffectiveRightsRequestControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN authzDN = null;
    private String rawAuthzDN = null;
    private List<AttributeType> attrs = null;
    private List<String> rawAttrs = null;

    public GetEffectiveRightsRequestControl(DN authzDN, List<AttributeType> attrs) {
        this(true, authzDN, attrs);
    }

    public GetEffectiveRightsRequestControl(boolean isCritical, DN authzDN, List<AttributeType> attrs) {
        super("1.3.6.1.4.1.42.2.27.9.5.2", isCritical);
        this.authzDN = authzDN;
        this.attrs = attrs;
    }

    public GetEffectiveRightsRequestControl(boolean isCritical, String authzDN, List<String> attrs) {
        super("1.3.6.1.4.1.42.2.27.9.5.2", isCritical);
        this.rawAuthzDN = authzDN;
        this.rawAttrs = attrs;
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        if (this.authzDN != null) {
            writer.writeOctetString("dn:" + this.authzDN.toString());
        } else if (this.rawAuthzDN != null) {
            writer.writeOctetString("dn:" + this.rawAuthzDN);
        }
        if (this.attrs != null) {
            writer.writeStartSequence();
            for (AttributeType attr : this.attrs) {
                writer.writeOctetString(attr.getNameOrOID());
            }
            writer.writeEndSequence();
        } else if (this.rawAttrs != null) {
            writer.writeStartSequence();
            for (String attr : this.rawAttrs) {
                writer.writeOctetString(attr);
            }
            writer.writeEndSequence();
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public DN getAuthzDN() {
        return this.authzDN;
    }

    public List<AttributeType> getAttributes() {
        return this.attrs;
    }

    private static final class Decoder
    implements ControlDecoder<GetEffectiveRightsRequestControl> {
        private Decoder() {
        }

        @Override
        public GetEffectiveRightsRequestControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            DN authzDN;
            if (value == null) {
                return new GetEffectiveRightsRequestControl(isCritical, (DN)null, (List<AttributeType>)null);
            }
            ASN1Reader reader = ASN1.getReader(value);
            LinkedList<AttributeType> attrs = null;
            String authzIDString = "";
            try {
                reader.readStartSequence();
                authzIDString = reader.readOctetStringAsString();
                String lowerAuthzIDString = authzIDString.toLowerCase();
                if (!lowerAuthzIDString.startsWith("dn:")) {
                    Message message = ProtocolMessages.INFO_GETEFFECTIVERIGHTS_INVALID_AUTHZID.get(lowerAuthzIDString);
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                }
                authzDN = DN.decode(authzIDString.substring(3));
                if (reader.hasNextElement()) {
                    attrs = new LinkedList<AttributeType>();
                    reader.readStartSequence();
                    while (reader.hasNextElement()) {
                        String attrStr = reader.readOctetStringAsString();
                        AttributeType attributeType = DirectoryServer.getAttributeType(attrStr);
                        if (attributeType == null) {
                            attributeType = DirectoryServer.getDefaultAttributeType(attrStr);
                        }
                        attrs.add(attributeType);
                    }
                    reader.readEndSequence();
                }
                reader.readEndSequence();
            }
            catch (ASN1Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.INFO_GETEFFECTIVERIGHTS_DECODE_ERROR.get(e.getMessage());
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            return new GetEffectiveRightsRequestControl(isCritical, authzDN, attrs);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.42.2.27.9.5.2";
        }
    }
}

