/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class DNConfigAttribute
extends ConfigAttribute {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private List<DN> activeValues;
    private List<DN> pendingValues;

    public DNConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction);
        this.activeValues = new ArrayList<DN>();
        this.pendingValues = this.activeValues;
    }

    public DNConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, DN value) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, DNConfigAttribute.getValueSet(value));
        if (value == null) {
            this.activeValues = new ArrayList<DN>();
        } else {
            this.activeValues = new ArrayList<DN>(1);
            this.activeValues.add(value);
        }
        this.pendingValues = this.activeValues;
    }

    public DNConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, List<DN> values) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, DNConfigAttribute.getValueSet(values));
        if (values == null) {
            this.activeValues = new ArrayList<DN>();
            this.pendingValues = this.activeValues;
        } else {
            this.activeValues = values;
            this.pendingValues = this.activeValues;
        }
    }

    public DNConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, List<DN> activeValues, List<DN> pendingValues) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, DNConfigAttribute.getValueSet(activeValues), pendingValues != null, DNConfigAttribute.getValueSet(pendingValues));
        this.activeValues = activeValues == null ? new ArrayList<DN>() : activeValues;
        this.pendingValues = pendingValues == null ? this.activeValues : pendingValues;
    }

    @Override
    public String getDataType() {
        return "DN";
    }

    @Override
    public AttributeSyntax<?> getSyntax() {
        return DirectoryServer.getDefaultStringSyntax();
    }

    public DN activeValue() throws ConfigException {
        if (this.activeValues == null || this.activeValues.isEmpty()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_NO_STRING_VALUE.get(this.getName());
            throw new ConfigException(message);
        }
        if (this.activeValues.size() > 1) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_STRING_VALUES.get(this.getName());
            throw new ConfigException(message);
        }
        return this.activeValues.get(0);
    }

    public List<DN> activeValues() {
        return this.activeValues;
    }

    public DN pendingValue() throws ConfigException {
        if (!this.hasPendingValues()) {
            return this.activeValue();
        }
        if (this.pendingValues == null || this.pendingValues.isEmpty()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_NO_STRING_VALUE.get(this.getName());
            throw new ConfigException(message);
        }
        if (this.pendingValues.size() > 1) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_STRING_VALUES.get(this.getName());
            throw new ConfigException(message);
        }
        return this.pendingValues.get(0);
    }

    public List<DN> pendingValues() {
        if (!this.hasPendingValues()) {
            return this.activeValues;
        }
        return this.pendingValues;
    }

    public void setValue(DN value) throws ConfigException {
        if (value == null) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_DN_NULL.get(this.getName());
            throw new ConfigException(message);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = new ArrayList<DN>(1);
            this.pendingValues.add(value);
            this.setPendingValues(DNConfigAttribute.getValueSet(value));
        } else {
            this.activeValues.clear();
            this.activeValues.add(value);
            this.pendingValues = this.activeValues;
            this.setActiveValues(DNConfigAttribute.getValueSet(value));
        }
    }

    public void setValues(List<DN> values) throws ConfigException {
        if (values == null || values.isEmpty()) {
            if (this.isRequired()) {
                Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.getName());
                throw new ConfigException(message);
            }
            if (this.requiresAdminAction()) {
                this.setPendingValues(new LinkedHashSet<AttributeValue>(0));
                this.pendingValues = new ArrayList<DN>();
            } else {
                this.setActiveValues(new LinkedHashSet<AttributeValue>(0));
                this.activeValues.clear();
            }
        }
        int numValues = values.size();
        if (!this.isMultiValued() && numValues > 1) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(this.getName());
            throw new ConfigException(message);
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(numValues);
        for (DN value : values) {
            if (value == null) {
                Message message = ConfigMessages.ERR_CONFIG_ATTR_DN_NULL.get(this.getName());
                throw new ConfigException(message);
            }
            AttributeValue attrValue = AttributeValues.create(ByteString.valueOf(value.toString()), ByteString.valueOf(value.toNormalizedString()));
            if (valueSet.contains(attrValue)) {
                Message message = ConfigMessages.ERR_CONFIG_ATTR_ADD_VALUES_ALREADY_EXISTS.get(this.getName(), String.valueOf(value));
                throw new ConfigException(message);
            }
            valueSet.add(attrValue);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = values;
            this.setPendingValues(valueSet);
        } else {
            this.activeValues = values;
            this.pendingValues = this.activeValues;
            this.setActiveValues(valueSet);
        }
    }

    private static LinkedHashSet<AttributeValue> getValueSet(DN value) {
        LinkedHashSet<AttributeValue> valueSet;
        if (value == null) {
            valueSet = new LinkedHashSet<AttributeValue>(0);
        } else {
            valueSet = new LinkedHashSet(1);
            valueSet.add(AttributeValues.create(ByteString.valueOf(value.toString()), ByteString.valueOf(value.toNormalizedString())));
        }
        return valueSet;
    }

    private static LinkedHashSet<AttributeValue> getValueSet(List<DN> values) {
        if (values == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(values.size());
        for (DN value : values) {
            valueSet.add(AttributeValues.create(ByteString.valueOf(value.toString()), ByteString.valueOf(value.toNormalizedString())));
        }
        return valueSet;
    }

    @Override
    public void applyPendingValues() {
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeValues = this.pendingValues;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue value, StringBuilder rejectReason) {
        if (value == null) {
            rejectReason.append(ConfigMessages.ERR_CONFIG_ATTR_DN_NULL.get(this.getName()));
            return false;
        }
        try {
            DN.decode(value.getValue().toString());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            rejectReason.append(ConfigMessages.ERR_CONFIG_ATTR_DN_CANNOT_PARSE.get(value.getValue().toString(), this.getName(), String.valueOf(e)));
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> valueStrings, boolean allowFailures) throws ConfigException {
        if (valueStrings == null || valueStrings.isEmpty()) {
            if (this.isRequired()) {
                Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.getName());
                throw new ConfigException(message);
            }
            return new LinkedHashSet<AttributeValue>();
        }
        int numValues = valueStrings.size();
        if (!this.isMultiValued() && numValues > 1) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(this.getName());
            throw new ConfigException(message);
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(numValues);
        for (String valueString : valueStrings) {
            DN dn;
            if (valueString == null) {
                Message message = ConfigMessages.ERR_CONFIG_ATTR_DN_NULL.get(this.getName());
                if (allowFailures) {
                    ErrorLogger.logError(message);
                    continue;
                }
                throw new ConfigException(message);
            }
            try {
                dn = DN.decode(valueString);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ConfigMessages.ERR_CONFIG_ATTR_DN_CANNOT_PARSE.get(valueString, this.getName(), String.valueOf(e));
                if (allowFailures) {
                    ErrorLogger.logError(message);
                    continue;
                }
                throw new ConfigException(message);
            }
            valueSet.add(AttributeValues.create(ByteString.valueOf(dn.toString()), ByteString.valueOf(dn.toNormalizedString())));
        }
        if (this.isRequired() && valueSet.isEmpty()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.getName());
            throw new ConfigException(message);
        }
        return valueSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        ArrayList<String> valueStrings = new ArrayList<String>(this.activeValues.size());
        for (DN dn : this.activeValues) {
            valueStrings.add(dn.toString());
        }
        return valueStrings;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        if (this.hasPendingValues()) {
            ArrayList<String> valueStrings = new ArrayList<String>(this.pendingValues.size());
            for (DN dn : this.pendingValues) {
                valueStrings.add(dn.toString());
            }
            return valueStrings;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> attributeList) throws ConfigException {
        ArrayList<DN> activeValues = null;
        ArrayList<DN> pendingValues = null;
        for (Attribute a : attributeList) {
            DN dn;
            Message message;
            int numValues;
            if (a.hasOptions()) {
                if (a.hasOption("pending")) {
                    if (pendingValues != null) {
                        Message message2 = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_PENDING_VALUE_SETS.get(a.getName());
                        throw new ConfigException(message2);
                    }
                    if (a.isEmpty()) {
                        if (this.isRequired()) {
                            Message message3 = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(a.getName());
                            throw new ConfigException(message3);
                        }
                        pendingValues = new ArrayList(0);
                        continue;
                    }
                    numValues = a.size();
                    if (numValues > 1 && !this.isMultiValued()) {
                        message = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(a.getName());
                        throw new ConfigException(message);
                    }
                    pendingValues = new ArrayList(numValues);
                    for (AttributeValue v : a) {
                        try {
                            dn = DN.decode(v.getValue().toString());
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            Message message4 = ConfigMessages.ERR_CONFIG_ATTR_DN_CANNOT_PARSE.get(v.getValue().toString(), this.getName(), String.valueOf(e));
                            throw new ConfigException(message4, (Throwable)e);
                        }
                        pendingValues.add(dn);
                    }
                    continue;
                }
                Message message5 = ConfigMessages.ERR_CONFIG_ATTR_OPTIONS_NOT_ALLOWED.get(a.getName());
                throw new ConfigException(message5);
            }
            if (activeValues != null) {
                Message message6 = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_ACTIVE_VALUE_SETS.get(a.getName());
                throw new ConfigException(message6);
            }
            if (a.isEmpty()) {
                if (this.isRequired()) {
                    Message message7 = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(a.getName());
                    throw new ConfigException(message7);
                }
                activeValues = new ArrayList<DN>(0);
                continue;
            }
            numValues = a.size();
            if (numValues > 1 && !this.isMultiValued()) {
                message = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(a.getName());
                throw new ConfigException(message);
            }
            activeValues = new ArrayList(numValues);
            for (AttributeValue v : a) {
                try {
                    dn = DN.decode(v.getValue().toString());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message8 = ConfigMessages.ERR_CONFIG_ATTR_DN_CANNOT_PARSE.get(v.getValue().toString(), this.getName(), String.valueOf(e));
                    throw new ConfigException(message8, (Throwable)e);
                }
                activeValues.add(dn);
            }
        }
        if (activeValues == null) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_NO_ACTIVE_VALUE_SET.get(this.getName());
            throw new ConfigException(message);
        }
        if (pendingValues == null) {
            pendingValues = activeValues;
        }
        return new DNConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), activeValues, pendingValues);
    }

    private javax.management.Attribute _toJMXAttribute(boolean pending) {
        String name;
        List<DN> requestedValues;
        if (pending) {
            requestedValues = this.pendingValues;
            name = this.getName() + ";" + "pending";
        } else {
            requestedValues = this.activeValues;
            name = this.getName();
        }
        if (this.isMultiValued()) {
            String[] values = new String[requestedValues.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = requestedValues.get(i).toString();
            }
            return new javax.management.Attribute(name, values);
        }
        if (requestedValues.isEmpty()) {
            return null;
        }
        DN dn = requestedValues.get(0);
        return new javax.management.Attribute(name, dn.toString());
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        return this._toJMXAttribute(false);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        return this._toJMXAttribute(true);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        if (this.activeValues.size() > 0) {
            if (this.isMultiValued()) {
                String[] values = new String[this.activeValues.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.activeValues.get(i).toString();
                }
                attributeList.add(new javax.management.Attribute(this.getName(), values));
            } else {
                attributeList.add(new javax.management.Attribute(this.getName(), this.activeValues.get(0).toString()));
            }
        } else if (this.isMultiValued()) {
            attributeList.add(new javax.management.Attribute(this.getName(), new String[0]));
        } else {
            attributeList.add(new javax.management.Attribute(this.getName(), null));
        }
        if (this.requiresAdminAction() && this.pendingValues != null && this.pendingValues != this.activeValues) {
            String name = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                String[] values = new String[this.pendingValues.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.pendingValues.get(i).toString();
                }
                attributeList.add(new javax.management.Attribute(name, values));
            } else if (!this.pendingValues.isEmpty()) {
                attributeList.add(new javax.management.Attribute(name, this.pendingValues.get(0).toString()));
            }
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> attributeInfoList) {
        if (this.isMultiValued()) {
            attributeInfoList.add(new MBeanAttributeInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, String.valueOf(this.getDescription()), true, true, false));
        } else {
            attributeInfoList.add(new MBeanAttributeInfo(this.getName(), String.class.getName(), String.valueOf(this.getDescription()), true, true, false));
        }
        if (this.requiresAdminAction()) {
            String name = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                attributeInfoList.add(new MBeanAttributeInfo(name, ConfigConstants.JMX_TYPE_STRING_ARRAY, String.valueOf(this.getDescription()), true, false, false));
            } else {
                attributeInfoList.add(new MBeanAttributeInfo(name, String.class.getName(), String.valueOf(this.getDescription()), true, false, false));
            }
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        if (this.isMultiValued()) {
            return new MBeanParameterInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, String.valueOf(this.getDescription()));
        }
        return new MBeanParameterInfo(this.getName(), String.class.getName(), String.valueOf(this.getDescription()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(javax.management.Attribute jmxAttribute) throws ConfigException {
        Object value = jmxAttribute.getValue();
        if (value == null) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_DN_NULL.get(this.getName());
            throw new ConfigException(message);
        }
        if (value instanceof DN) {
            this.setValue((DN)value);
        }
        if (value instanceof String) {
            DN dn;
            try {
                dn = DN.decode((String)value);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ConfigMessages.ERR_CONFIG_ATTR_DN_CANNOT_PARSE.get((String)value, this.getName(), String.valueOf(e));
                throw new ConfigException(message, (Throwable)e);
            }
            this.setValue(dn);
            return;
        }
        if (value.getClass().isArray()) {
            String componentType = value.getClass().getComponentType().getName();
            int length = Array.getLength(value);
            if (componentType.equals(DN.class.getName())) {
                ArrayList<DN> dnList = new ArrayList<DN>(length);
                for (int i = 0; i < length; ++i) {
                    dnList.add((DN)Array.get(value, i));
                }
                this.setValues(dnList);
                return;
            }
            if (componentType.equals(String.class.getName())) {
                try {
                    ArrayList<DN> values = new ArrayList<DN>(length);
                    for (int i = 0; i < length; ++i) {
                        DN dn;
                        String valueStr = (String)Array.get(value, i);
                        try {
                            dn = DN.decode(valueStr);
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            Message message = ConfigMessages.ERR_CONFIG_ATTR_DN_CANNOT_PARSE.get(valueStr, this.getName(), String.valueOf(e));
                            throw new ConfigException(message, (Throwable)e);
                        }
                        values.add(dn);
                    }
                    this.setValues(values);
                    return;
                }
                catch (ConfigException ce) {
                    if (!DebugLogger.debugEnabled()) throw ce;
                    TRACER.debugCaught(DebugLogLevel.ERROR, ce);
                    throw ce;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ConfigMessages.ERR_CONFIG_ATTR_INVALID_DN_VALUE.get(this.getName(), String.valueOf(value), String.valueOf(e));
                    throw new ConfigException(message, (Throwable)e);
                }
            }
            Message message = ConfigMessages.ERR_CONFIG_ATTR_DN_INVALID_ARRAY_TYPE.get(String.valueOf(jmxAttribute), String.valueOf(componentType));
            throw new ConfigException(message);
        }
        Message message = ConfigMessages.ERR_CONFIG_ATTR_DN_INVALID_TYPE.get(String.valueOf(value), this.getName(), value.getClass().getName());
        throw new ConfigException(message);
    }

    @Override
    public ConfigAttribute duplicate() {
        return new DNConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.activeValues, this.pendingValues);
    }
}

