/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class BooleanConfigAttribute
extends ConfigAttribute {
    private boolean activeValue;
    private boolean pendingValue;

    public BooleanConfigAttribute(String name, Message description, boolean requiresAdminAction) {
        super(name, description, true, false, requiresAdminAction);
    }

    public BooleanConfigAttribute(String name, Message description, boolean requiresAdminAction, boolean value) {
        super(name, description, true, false, requiresAdminAction, BooleanConfigAttribute.getValueSet(value));
        this.activeValue = value;
        this.pendingValue = value;
    }

    public BooleanConfigAttribute(String name, Message description, boolean requiresAdminAction, boolean activeValue, boolean pendingValue) {
        super(name, description, true, false, requiresAdminAction, BooleanConfigAttribute.getValueSet(activeValue), true, BooleanConfigAttribute.getValueSet(pendingValue));
        this.activeValue = activeValue;
        this.pendingValue = pendingValue;
    }

    @Override
    public String getDataType() {
        return "Boolean";
    }

    @Override
    public AttributeSyntax<?> getSyntax() {
        return DirectoryServer.getDefaultBooleanSyntax();
    }

    public boolean activeValue() {
        return this.activeValue;
    }

    public boolean pendingValue() {
        if (this.hasPendingValues()) {
            return this.pendingValue;
        }
        return this.activeValue;
    }

    public void setValue(boolean booleanValue) {
        if (this.requiresAdminAction()) {
            this.pendingValue = booleanValue;
            this.setPendingValues(BooleanConfigAttribute.getValueSet(booleanValue));
        } else {
            this.activeValue = booleanValue;
            this.setActiveValues(BooleanConfigAttribute.getValueSet(booleanValue));
        }
    }

    private static LinkedHashSet<AttributeValue> getValueSet(boolean booleanValue) {
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
        if (booleanValue) {
            valueSet.add(AttributeValues.create(ByteString.valueOf("true"), ByteString.valueOf("true")));
        } else {
            valueSet.add(AttributeValues.create(ByteString.valueOf("false"), ByteString.valueOf("false")));
        }
        return valueSet;
    }

    @Override
    public void applyPendingValues() {
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeValue = this.pendingValue;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue value, StringBuilder rejectReason) {
        String stringValue = value.getValue().toString();
        if (stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("false")) {
            return true;
        }
        rejectReason.append(ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get(this.getName(), stringValue));
        return false;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> valueStrings, boolean allowFailures) throws ConfigException {
        if (valueStrings == null || valueStrings.isEmpty()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.getName());
            throw new ConfigException(message);
        }
        Iterator<String> iterator = valueStrings.iterator();
        String valueString = iterator.next().toLowerCase();
        if (iterator.hasNext()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.getName());
            throw new ConfigException(message);
        }
        if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
            return BooleanConfigAttribute.getValueSet(true);
        }
        if (valueString.equals("false") || valueString.equals("no") || valueString.equals("off") || valueString.equals("0")) {
            return BooleanConfigAttribute.getValueSet(false);
        }
        Message message = ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get(this.getName(), valueString);
        throw new ConfigException(message);
    }

    @Override
    public List<String> activeValuesToStrings() {
        ArrayList<String> valueStrings = new ArrayList<String>(1);
        valueStrings.add(String.valueOf(this.activeValue));
        return valueStrings;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        if (this.hasPendingValues()) {
            ArrayList<String> valueStrings = new ArrayList<String>(1);
            valueStrings.add(String.valueOf(this.pendingValue));
            return valueStrings;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> attributeList) throws ConfigException {
        boolean activeValue = false;
        boolean pendingValue = false;
        boolean activeValueSet = false;
        boolean pendingValueSet = false;
        for (Attribute a : attributeList) {
            String valueString;
            Iterator<AttributeValue> iterator;
            Message message;
            if (a.hasOptions()) {
                if (a.hasOption("pending")) {
                    if (pendingValueSet) {
                        message = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_PENDING_VALUE_SETS.get(a.getName());
                        throw new ConfigException(message);
                    }
                    if (a.isEmpty()) {
                        message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(a.getName());
                        throw new ConfigException(message);
                    }
                    iterator = a.iterator();
                    valueString = iterator.next().getValue().toString().toLowerCase();
                    if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
                        pendingValue = true;
                        pendingValueSet = true;
                    } else if (valueString.equals("false") || valueString.equals("no") || valueString.equals("off") || valueString.equals("0")) {
                        pendingValue = false;
                        pendingValueSet = true;
                    } else {
                        Message message2 = ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get(this.getName(), valueString);
                        throw new ConfigException(message2);
                    }
                    if (!iterator.hasNext()) continue;
                    Message message3 = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(a.getName());
                    throw new ConfigException(message3);
                }
                message = ConfigMessages.ERR_CONFIG_ATTR_OPTIONS_NOT_ALLOWED.get(a.getName());
                throw new ConfigException(message);
            }
            if (activeValueSet) {
                message = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_ACTIVE_VALUE_SETS.get(a.getName());
                throw new ConfigException(message);
            }
            if (a.isEmpty()) {
                message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(a.getName());
                throw new ConfigException(message);
            }
            iterator = a.iterator();
            valueString = iterator.next().getValue().toString().toLowerCase();
            if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
                activeValue = true;
                activeValueSet = true;
            } else if (valueString.equals("false") || valueString.equals("no") || valueString.equals("off") || valueString.equals("0")) {
                activeValue = false;
                activeValueSet = true;
            } else {
                Message message4 = ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get(this.getName(), valueString);
                throw new ConfigException(message4);
            }
            if (!iterator.hasNext()) continue;
            Message message5 = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(a.getName());
            throw new ConfigException(message5);
        }
        if (!activeValueSet) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_NO_ACTIVE_VALUE_SET.get(this.getName());
            throw new ConfigException(message);
        }
        if (pendingValueSet) {
            return new BooleanConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), activeValue, pendingValue);
        }
        return new BooleanConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), activeValue);
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        return new javax.management.Attribute(this.getName(), this.activeValue);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        return new javax.management.Attribute(this.getName() + ";" + "pending", this.pendingValue);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        attributeList.add(new javax.management.Attribute(this.getName(), this.activeValue));
        if (this.requiresAdminAction() && this.pendingValue != this.activeValue) {
            String name = this.getName() + ";" + "pending";
            attributeList.add(new javax.management.Attribute(name, this.pendingValue));
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> attributeInfoList) {
        attributeInfoList.add(new MBeanAttributeInfo(this.getName(), Boolean.class.getName(), String.valueOf(this.getDescription()), true, true, false));
        if (this.requiresAdminAction()) {
            String name = this.getName() + ";" + "pending";
            attributeInfoList.add(new MBeanAttributeInfo(name, Boolean.class.getName(), String.valueOf(this.getDescription()), true, false, false));
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        return new MBeanParameterInfo(this.getName(), Boolean.TYPE.getName(), String.valueOf(this.getDescription()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setValue(javax.management.Attribute jmxAttribute) throws ConfigException {
        Object value = jmxAttribute.getValue();
        if (value instanceof Boolean) {
            this.setValue((Boolean)value);
            return;
        }
        if (!(value instanceof String)) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get(this.getName(), value.getClass().getName() + ":" + String.valueOf(value));
            throw new ConfigException(message);
        }
        String stringValue = ((String)value).toLowerCase();
        if (stringValue.equals("true") || stringValue.equals("yes") || stringValue.equals("on") || stringValue.equals("1")) {
            this.setValue(true);
            return;
        }
        if (!(stringValue.equals("false") || stringValue.equals("no") || stringValue.equals("off") || stringValue.equals("0"))) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get(this.getName(), stringValue);
            throw new ConfigException(message);
        }
        this.setValue(false);
    }

    @Override
    public ConfigAttribute duplicate() {
        return new BooleanConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), this.activeValue, this.pendingValue);
    }
}

