/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.backends.task.RecurringTask;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskBackend;
import org.opends.server.backends.task.TaskState;
import org.opends.server.backends.task.TaskThread;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LockManager;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public class TaskScheduler
extends DirectoryThread
implements AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.backends.task.TaskScheduler";
    private static long MAX_SLEEP_TIME = 5000L;
    private boolean isRunning;
    private boolean stopRequested;
    private Entry recurringTaskParentEntry;
    private Entry scheduledTaskParentEntry;
    private Entry taskRootEntry;
    private HashMap<String, RecurringTask> recurringTasks;
    private HashMap<String, Task> tasks;
    private HashMap<String, TaskThread> activeThreads;
    private int nextThreadID;
    private LinkedList<TaskThread> idleThreads;
    private final ReentrantLock schedulerLock;
    private TaskBackend taskBackend;
    private Thread schedulerThread;
    private TreeSet<Task> completedTasks;
    private TreeSet<Task> pendingTasks;
    private TreeSet<Task> runningTasks;

    public TaskScheduler(TaskBackend taskBackend) throws InitializationException {
        super("Task Scheduler Thread");
        this.taskBackend = taskBackend;
        this.schedulerLock = new ReentrantLock();
        this.isRunning = false;
        this.stopRequested = false;
        this.schedulerThread = null;
        this.nextThreadID = 1;
        this.recurringTasks = new HashMap();
        this.tasks = new HashMap();
        this.activeThreads = new HashMap();
        this.idleThreads = new LinkedList();
        this.completedTasks = new TreeSet();
        this.pendingTasks = new TreeSet();
        this.runningTasks = new TreeSet();
        this.taskRootEntry = null;
        this.recurringTaskParentEntry = null;
        this.scheduledTaskParentEntry = null;
        DirectoryServer.registerAlertGenerator(this);
        this.initializeTasksFromBackingFile();
        for (RecurringTask recurringTask : this.recurringTasks.values()) {
            Task task = null;
            try {
                task = recurringTask.scheduleNextIteration(new GregorianCalendar());
            }
            catch (DirectoryException de) {
                ErrorLogger.logError(de.getMessageObject());
            }
            if (task == null) continue;
            try {
                this.scheduleTask(task, false);
            }
            catch (DirectoryException de) {
                if (de.getResultCode() == ResultCode.ENTRY_ALREADY_EXISTS) continue;
                ErrorLogger.logError(de.getMessageObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecurringTask(RecurringTask recurringTask, boolean scheduleIteration) throws DirectoryException {
        this.schedulerLock.lock();
        try {
            Task task;
            String id = recurringTask.getRecurringTaskID();
            if (this.recurringTasks.containsKey(id)) {
                Message message = BackendMessages.ERR_TASKSCHED_DUPLICATE_RECURRING_ID.get(String.valueOf(id));
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
            }
            Attribute attr = Attributes.create("ds-task-state", TaskState.RECURRING.toString());
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(attr);
            Entry recurringTaskEntry = recurringTask.getRecurringTaskEntry();
            recurringTaskEntry.putAttribute(attr.getAttributeType(), attrList);
            if (scheduleIteration && (task = recurringTask.scheduleNextIteration(new GregorianCalendar())) != null) {
                Task t = this.tasks.get(task.getTaskID());
                if (t != null && TaskState.isDone(t.getTaskState())) {
                    this.removeCompletedTask(t.getTaskID());
                }
                this.scheduleTask(task, false);
            }
            this.recurringTasks.put(id, recurringTask);
            this.writeState();
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecurringTask removeRecurringTask(String recurringTaskID) throws DirectoryException {
        this.schedulerLock.lock();
        try {
            RecurringTask recurringTask = this.recurringTasks.remove(recurringTaskID);
            HashMap<String, Task> iterationsMap = new HashMap<String, Task>();
            for (Task task : this.tasks.values()) {
                if (task.getRecurringTaskID() == null || !task.getRecurringTaskID().equals(recurringTaskID)) continue;
                TaskState state = task.getTaskState();
                if (!TaskState.isDone(state) && !TaskState.isCancelled(state)) {
                    this.cancelTask(task.getTaskID());
                }
                iterationsMap.put(task.getTaskID(), task);
            }
            for (Map.Entry entry : iterationsMap.entrySet()) {
                if (!TaskState.isDone(((Task)entry.getValue()).getTaskState())) continue;
                this.removeCompletedTask((String)entry.getKey());
            }
            this.writeState();
            RecurringTask recurringTask2 = recurringTask;
            return recurringTask2;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(Task task, boolean writeState) throws DirectoryException {
        this.schedulerLock.lock();
        try {
            String id = task.getTaskID();
            if (this.tasks.containsKey(id)) {
                Message message = BackendMessages.ERR_TASKSCHED_DUPLICATE_TASK_ID.get(String.valueOf(id));
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
            }
            for (String dependencyID : task.getDependencyIDs()) {
                Task t = this.tasks.get(dependencyID);
                if (t != null) continue;
                Message message = BackendMessages.ERR_TASKSCHED_DEPENDENCY_MISSING.get(String.valueOf(id), dependencyID);
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
            }
            this.tasks.put(id, task);
            TaskState state = this.shouldStart(task);
            task.setTaskState(state);
            if (state == TaskState.RUNNING) {
                TaskThread taskThread;
                if (this.idleThreads.isEmpty()) {
                    taskThread = new TaskThread(this, this.nextThreadID++);
                    taskThread.start();
                } else {
                    taskThread = this.idleThreads.removeFirst();
                }
                this.runningTasks.add(task);
                this.activeThreads.put(task.getTaskID(), taskThread);
                taskThread.setTask(task);
            } else if (TaskState.isDone(state)) {
                if (state == TaskState.CANCELED_BEFORE_STARTING && task.isRecurring()) {
                    this.pendingTasks.add(task);
                } else {
                    this.completedTasks.add(task);
                }
            } else {
                this.pendingTasks.add(task);
            }
            if (writeState) {
                this.writeState();
            }
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task cancelTask(String taskID) {
        this.schedulerLock.lock();
        try {
            Task t = this.tasks.get(taskID);
            if (t == null) {
                Task task = null;
                return task;
            }
            if (TaskState.isPending(t.getTaskState())) {
                this.pendingTasks.remove(t);
                t.setTaskState(TaskState.CANCELED_BEFORE_STARTING);
                this.addCompletedTask(t);
                this.writeState();
            }
            Task task = t;
            return task;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public Task removePendingTask(String taskID) throws DirectoryException {
        this.schedulerLock.lock();
        try {
            Task t = this.tasks.get(taskID);
            if (t == null) {
                Message message = BackendMessages.ERR_TASKSCHED_REMOVE_PENDING_NO_SUCH_TASK.get(String.valueOf(taskID));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
            }
            if (TaskState.isPending(t.getTaskState())) {
                this.tasks.remove(taskID);
                this.pendingTasks.remove(t);
                this.writeState();
                Task message = t;
                return message;
            }
            Message message = BackendMessages.ERR_TASKSCHED_REMOVE_PENDING_NOT_PENDING.get(String.valueOf(taskID));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public Task removeCompletedTask(String taskID) throws DirectoryException {
        this.schedulerLock.lock();
        try {
            Iterator<Task> iterator = this.completedTasks.iterator();
            while (iterator.hasNext()) {
                Task t = iterator.next();
                if (!t.getTaskID().equals(taskID)) continue;
                iterator.remove();
                this.tasks.remove(taskID);
                this.writeState();
                Task task = t;
                return task;
            }
            Message message = BackendMessages.ERR_TASKSCHED_REMOVE_COMPLETED_NO_SUCH_TASK.get(String.valueOf(taskID));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean threadDone(TaskThread taskThread, Task completedTask, TaskState taskState) {
        this.schedulerLock.lock();
        try {
            block9: {
                completedTask.setCompletionTime(TimeThread.getTime());
                completedTask.setTaskState(taskState);
                this.addCompletedTask(completedTask);
                try {
                    completedTask.sendNotificationEMailMessage();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block9;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            String taskID = completedTask.getTaskID();
            if (this.activeThreads.remove(taskID) == null) {
                boolean bl = false;
                return bl;
            }
            this.scheduleNextRecurringTaskIteration(completedTask, new GregorianCalendar());
            this.writeState();
            if (this.isRunning) {
                this.idleThreads.add(taskThread);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    protected void scheduleNextRecurringTaskIteration(Task completedTask, GregorianCalendar calendar) {
        block8: {
            RecurringTask recurringTask;
            String recurringTaskID = completedTask.getRecurringTaskID();
            if (recurringTaskID != null && (recurringTask = this.recurringTasks.get(recurringTaskID)) != null) {
                Task newIteration = null;
                try {
                    newIteration = recurringTask.scheduleNextIteration(calendar);
                }
                catch (DirectoryException de) {
                    ErrorLogger.logError(de.getMessageObject());
                }
                if (newIteration != null) {
                    try {
                        Task t = this.tasks.get(newIteration.getTaskID());
                        if (t != null && TaskState.isDone(t.getTaskState())) {
                            this.removeCompletedTask(t.getTaskID());
                        }
                        this.scheduleTask(newIteration, false);
                    }
                    catch (DirectoryException de) {
                        if (de.getResultCode() == ResultCode.ENTRY_ALREADY_EXISTS) break block8;
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        Message message = BackendMessages.ERR_TASKSCHED_ERROR_SCHEDULING_RECURRING_ITERATION.get(recurringTaskID, de.getMessageObject());
                        ErrorLogger.logError(message);
                        DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotScheduleRecurringIteration", message);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletedTask(Task completedTask) {
        this.schedulerLock.lock();
        try {
            this.completedTasks.add(completedTask);
            this.runningTasks.remove(completedTask);
            if (completedTask.getCompletionTime() == -1L) {
                completedTask.setCompletionTime(TimeThread.getTime());
            }
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public void stopScheduler() {
        block6: {
            block5: {
                this.stopRequested = true;
                try {
                    this.schedulerThread.interrupt();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            try {
                this.schedulerThread.join();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block6;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        this.pendingTasks.clear();
        this.runningTasks.clear();
        this.completedTasks.clear();
        this.tasks.clear();
        for (TaskThread thread : this.idleThreads) {
            Message message = BackendMessages.INFO_TASKBE_INTERRUPTED_BY_SHUTDOWN.get();
            thread.interruptTask(TaskState.STOPPED_BY_SHUTDOWN, message, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptRunningTasks(TaskState interruptState, Message interruptReason, boolean waitForStop) {
        LinkedList<TaskThread> threadList = new LinkedList<TaskThread>();
        this.schedulerLock.lock();
        try {
            threadList.addAll(this.activeThreads.values());
        }
        finally {
            this.schedulerLock.unlock();
        }
        for (TaskThread t : threadList) {
            try {
                t.interruptTask(interruptState, interruptReason, true);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        if (waitForStop) {
            for (TaskThread t : threadList) {
                try {
                    t.join();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block25: {
            this.isRunning = true;
            this.schedulerThread = TaskScheduler.currentThread();
            block8: while (true) {
                while (!this.stopRequested) {
                    this.schedulerLock.lock();
                    boolean writeState = false;
                    long sleepTime = MAX_SLEEP_TIME;
                    try {
                        Iterator<Task> iterator = this.pendingTasks.iterator();
                        while (iterator.hasNext()) {
                            Task t = iterator.next();
                            TaskState state = this.shouldStart(t);
                            if (state == TaskState.RUNNING) {
                                TaskThread taskThread;
                                if (this.idleThreads.isEmpty()) {
                                    taskThread = new TaskThread(this, this.nextThreadID++);
                                    taskThread.start();
                                } else {
                                    taskThread = this.idleThreads.removeFirst();
                                }
                                this.runningTasks.add(t);
                                this.activeThreads.put(t.getTaskID(), taskThread);
                                taskThread.setTask(t);
                                iterator.remove();
                                writeState = true;
                            } else if (state == TaskState.WAITING_ON_START_TIME) {
                                long waitTime = t.getScheduledStartTime() - TimeThread.getTime();
                                sleepTime = Math.min(sleepTime, waitTime);
                            } else if (state == TaskState.CANCELED_BEFORE_STARTING && t.isRecurring()) {
                                if (t.getScheduledStartTime() > TimeThread.getTime()) {
                                    long waitTime = t.getScheduledStartTime() - TimeThread.getTime();
                                    sleepTime = Math.min(sleepTime, waitTime);
                                } else {
                                    TaskThread taskThread;
                                    if (this.idleThreads.isEmpty()) {
                                        taskThread = new TaskThread(this, this.nextThreadID++);
                                        taskThread.start();
                                    } else {
                                        taskThread = this.idleThreads.removeFirst();
                                    }
                                    this.runningTasks.add(t);
                                    this.activeThreads.put(t.getTaskID(), taskThread);
                                    taskThread.setTask(t);
                                }
                            }
                            if (state == t.getTaskState()) continue;
                            t.setTaskState(state);
                            writeState = true;
                        }
                        long retentionTimeMillis = TimeUnit.SECONDS.toMillis(this.taskBackend.getRetentionTime());
                        long oldestRetainedCompletionTime = TimeThread.getTime() - retentionTimeMillis;
                        iterator = this.completedTasks.iterator();
                        while (iterator.hasNext()) {
                            Task t = iterator.next();
                            if (t.getCompletionTime() >= oldestRetainedCompletionTime) continue;
                            iterator.remove();
                            this.tasks.remove(t.getTaskID());
                            writeState = true;
                        }
                        if (writeState) {
                            this.writeState();
                        }
                    }
                    finally {
                        this.schedulerLock.unlock();
                    }
                    try {
                        if (sleepTime <= 0L) continue block8;
                        Thread.sleep(sleepTime);
                        continue block8;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                break block25;
                {
                    continue block8;
                    break;
                }
                break;
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    private TaskState shouldStart(Task task) {
        TaskState state = task.getTaskState();
        if (state == TaskState.RECURRING) {
            state = null;
        }
        if (state != null && TaskState.isDone(state)) {
            return state;
        }
        if (!this.isRunning) {
            return TaskState.UNSCHEDULED;
        }
        if (task.getScheduledStartTime() > TimeThread.getTime()) {
            return TaskState.WAITING_ON_START_TIME;
        }
        LinkedList<String> dependencyIDs = task.getDependencyIDs();
        if (dependencyIDs != null) {
            for (String dependencyID : dependencyIDs) {
                Task t = this.tasks.get(dependencyID);
                if (t == null) continue;
                TaskState tState = t.getTaskState();
                if (!TaskState.isDone(tState)) {
                    return TaskState.WAITING_ON_DEPENDENCY;
                }
                if (TaskState.isSuccessful(tState)) continue;
                FailedDependencyAction action = task.getFailedDependencyAction();
                switch (action) {
                    case CANCEL: {
                        this.cancelTask(task.getTaskID());
                        return task.getTaskState();
                    }
                    case DISABLE: {
                        task.setTaskState(TaskState.DISABLED);
                        return task.getTaskState();
                    }
                }
            }
        }
        return TaskState.RUNNING;
    }

    private void initializeTasksFromBackingFile() throws InitializationException {
        String backingFilePath = this.taskBackend.getTaskBackingFile();
        try {
            File backingFile = StaticUtils.getFileForPath(backingFilePath);
            if (!backingFile.exists()) {
                this.createNewTaskBackingFile();
                return;
            }
            LDIFImportConfig importConfig = new LDIFImportConfig(backingFilePath);
            LDIFReader ldifReader = new LDIFReader(importConfig);
            this.taskRootEntry = null;
            this.recurringTaskParentEntry = null;
            this.scheduledTaskParentEntry = null;
            while (true) {
                Message message;
                Message message2;
                Entry entry;
                try {
                    entry = ldifReader.readEntry();
                }
                catch (LDIFException le) {
                    Message message3;
                    block25: {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, le);
                        }
                        if (le.canContinueReading()) {
                            message3 = BackendMessages.ERR_TASKSCHED_CANNOT_PARSE_ENTRY_RECOVERABLE.get(backingFilePath, le.getLineNumber(), le.getMessage());
                            ErrorLogger.logError(message3);
                            continue;
                        }
                        try {
                            ldifReader.close();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block25;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    message3 = BackendMessages.ERR_TASKSCHED_CANNOT_PARSE_ENTRY_FATAL.get(backingFilePath, le.getLineNumber(), le.getMessage());
                    throw new InitializationException(message3);
                }
                if (entry == null) break;
                DN entryDN = entry.getDN();
                if (entryDN.equals(this.taskBackend.getTaskRootDN())) {
                    this.taskRootEntry = entry;
                    continue;
                }
                if (entryDN.equals(this.taskBackend.getRecurringTasksParentDN())) {
                    this.recurringTaskParentEntry = entry;
                    continue;
                }
                if (entryDN.equals(this.taskBackend.getScheduledTasksParentDN())) {
                    this.scheduledTaskParentEntry = entry;
                    continue;
                }
                DN parentDN = entryDN.getParentDNInSuffix();
                if (parentDN == null) {
                    message2 = BackendMessages.ERR_TASKSCHED_ENTRY_HAS_NO_PARENT.get(String.valueOf(entryDN), String.valueOf(this.taskBackend.getTaskRootDN()));
                    ErrorLogger.logError(message2);
                    continue;
                }
                if (parentDN.equals(this.taskBackend.getScheduledTasksParentDN())) {
                    try {
                        Task task = this.entryToScheduledTask(entry, null);
                        if (TaskState.isDone(task.getTaskState())) {
                            String id = task.getTaskID();
                            if (this.tasks.containsKey(id)) {
                                Message message4 = BackendMessages.WARN_TASKSCHED_DUPLICATE_TASK_ID.get(String.valueOf(id));
                                ErrorLogger.logError(message4);
                                continue;
                            }
                            this.completedTasks.add(task);
                            this.tasks.put(id, task);
                            continue;
                        }
                        this.scheduleTask(task, false);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = BackendMessages.ERR_TASKSCHED_CANNOT_SCHEDULE_TASK_FROM_ENTRY.get(String.valueOf(entryDN), de.getMessageObject());
                        ErrorLogger.logError(message);
                    }
                    continue;
                }
                if (parentDN.equals(this.taskBackend.getRecurringTasksParentDN())) {
                    try {
                        RecurringTask recurringTask = this.entryToRecurringTask(entry);
                        this.addRecurringTask(recurringTask, false);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = BackendMessages.ERR_TASKSCHED_CANNOT_SCHEDULE_RECURRING_TASK_FROM_ENTRY.get(String.valueOf(entryDN), de.getMessageObject());
                        ErrorLogger.logError(message);
                    }
                    continue;
                }
                message2 = BackendMessages.ERR_TASKSCHED_INVALID_TASK_ENTRY_DN.get(String.valueOf(entryDN), backingFilePath);
                ErrorLogger.logError(message2);
            }
            ldifReader.close();
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            Message message = BackendMessages.ERR_TASKSCHED_ERROR_READING_TASK_BACKING_FILE.get(String.valueOf(backingFilePath), StaticUtils.stackTraceToSingleLineString(ioe));
            throw new InitializationException(message, (Throwable)ioe);
        }
    }

    private void createNewTaskBackingFile() throws InitializationException {
        String backingFile = this.taskBackend.getTaskBackingFile();
        LDIFExportConfig exportConfig = new LDIFExportConfig(backingFile, ExistingFileBehavior.OVERWRITE);
        try {
            LDIFWriter writer = new LDIFWriter(exportConfig);
            writer.writeComment(BackendMessages.INFO_TASKBE_BACKING_FILE_HEADER.get(), 80);
            this.taskRootEntry = StaticUtils.createEntry(this.taskBackend.getTaskRootDN());
            writer.writeEntry(this.taskRootEntry);
            this.scheduledTaskParentEntry = StaticUtils.createEntry(this.taskBackend.getScheduledTasksParentDN());
            writer.writeEntry(this.scheduledTaskParentEntry);
            this.recurringTaskParentEntry = StaticUtils.createEntry(this.taskBackend.getRecurringTasksParentDN());
            writer.writeEntry(this.recurringTaskParentEntry);
            writer.close();
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            Message message = BackendMessages.ERR_TASKSCHED_CANNOT_CREATE_BACKING_FILE.get(backingFile, StaticUtils.stackTraceToSingleLineString(ioe));
            throw new InitializationException(message, (Throwable)ioe);
        }
        catch (LDIFException le) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            Message message = BackendMessages.ERR_TASKSCHED_CANNOT_CREATE_BACKING_FILE.get(backingFile, le.getMessage());
            throw new InitializationException(message, (Throwable)le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState() {
        String backingFilePath = this.taskBackend.getTaskBackingFile();
        String tmpFilePath = backingFilePath + ".tmp";
        LDIFExportConfig exportConfig = new LDIFExportConfig(tmpFilePath, ExistingFileBehavior.OVERWRITE);
        this.schedulerLock.lock();
        try {
            File saveFile;
            block24: {
                LDIFWriter writer = new LDIFWriter(exportConfig);
                writer.writeComment(BackendMessages.INFO_TASKBE_BACKING_FILE_HEADER.get(), 80);
                writer.writeEntry(this.taskRootEntry);
                writer.writeEntry(this.scheduledTaskParentEntry);
                writer.writeEntry(this.recurringTaskParentEntry);
                for (RecurringTask recurringTask : this.recurringTasks.values()) {
                    writer.writeEntry(recurringTask.getRecurringTaskEntry());
                }
                for (Task task : this.tasks.values()) {
                    writer.writeEntry(task.getTaskEntry());
                }
                writer.close();
                saveFile = StaticUtils.getFileForPath(backingFilePath + ".save");
                try {
                    if (saveFile.exists()) {
                        saveFile.delete();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block24;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            File backingFile = StaticUtils.getFileForPath(backingFilePath);
            try {
                if (backingFile.exists()) {
                    backingFile.renameTo(saveFile);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.WARN_TASKSCHED_CANNOT_RENAME_CURRENT_BACKING_FILE.get(String.valueOf(backingFilePath), String.valueOf(saveFile.getAbsolutePath()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotRenameCurrentTaskFile", message);
            }
            File tmpFile = StaticUtils.getFileForPath(tmpFilePath);
            try {
                tmpFile.renameTo(backingFile);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_TASKSCHED_CANNOT_RENAME_NEW_BACKING_FILE.get(String.valueOf(tmpFilePath), String.valueOf(backingFilePath), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotRenameNewTaskFile", message);
            }
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            Message message = BackendMessages.ERR_TASKSCHED_CANNOT_WRITE_BACKING_FILE.get(tmpFilePath, StaticUtils.stackTraceToSingleLineString(ioe));
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteTaskFile", message);
        }
        catch (LDIFException le) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            Message message = BackendMessages.ERR_TASKSCHED_CANNOT_WRITE_BACKING_FILE.get(tmpFilePath, le.getMessage());
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteTaskFile", message);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TASKSCHED_CANNOT_WRITE_BACKING_FILE.get(tmpFilePath, StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteTaskFile", message);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntryCount() {
        this.schedulerLock.lock();
        try {
            long l = this.tasks.size() + this.recurringTasks.size() + 3;
            return l;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getScheduledTaskCount() {
        this.schedulerLock.lock();
        try {
            long l = this.tasks.size();
            return l;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRecurringTaskCount() {
        this.schedulerLock.lock();
        try {
            long l = this.recurringTasks.size();
            return l;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public TaskBackend getTaskBackend() {
        return this.taskBackend;
    }

    public Entry getTaskRootEntry() {
        return this.taskRootEntry.duplicate(true);
    }

    public Entry getScheduledTaskParentEntry() {
        return this.scheduledTaskParentEntry.duplicate(true);
    }

    public Entry getRecurringTaskParentEntry() {
        return this.recurringTaskParentEntry.duplicate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getScheduledTask(String taskID) {
        this.schedulerLock.lock();
        try {
            Task task = this.tasks.get(taskID);
            return task;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getScheduledTask(DN taskEntryDN) {
        this.schedulerLock.lock();
        try {
            for (Task t : this.tasks.values()) {
                if (!taskEntryDN.equals(t.getTaskEntry().getDN())) continue;
                Task task = t;
                return task;
            }
            Task task = null;
            return task;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    boolean holdsSchedulerLock() {
        return this.schedulerLock.isHeldByCurrentThread();
    }

    Lock writeLockEntry(DN entryDN) {
        Lock lock = LockManager.lockWrite(entryDN);
        while (lock == null) {
            lock = LockManager.lockWrite(entryDN);
        }
        return lock;
    }

    Lock readLockEntry(DN entryDN) throws DirectoryException {
        Lock lock = LockManager.lockRead(entryDN);
        if (lock == null) {
            throw new DirectoryException(ResultCode.BUSY, BackendMessages.ERR_BACKEND_CANNOT_LOCK_ENTRY.get(String.valueOf(entryDN)));
        }
        return lock;
    }

    void unlockEntry(DN entryDN, Lock lock) {
        LockManager.unlock(entryDN, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getScheduledTaskEntry(DN scheduledTaskEntryDN) {
        this.schedulerLock.lock();
        try {
            for (Task task : this.tasks.values()) {
                Entry taskEntry = task.getTaskEntry();
                if (!scheduledTaskEntryDN.equals(taskEntry.getDN())) continue;
                Entry entry = taskEntry.duplicate(true);
                return entry;
            }
            Entry entry = null;
            return entry;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchScheduledTasks(SearchOperation searchOperation) throws DirectoryException {
        SearchFilter filter = searchOperation.getFilter();
        this.schedulerLock.lock();
        try {
            for (Task t : this.tasks.values()) {
                DN taskEntryDN = t.getTaskEntryDN();
                Lock lock = this.readLockEntry(taskEntryDN);
                try {
                    Entry e = t.getTaskEntry().duplicate(true);
                    if (!filter.matchesEntry(e) || searchOperation.returnEntry(e, null)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.unlockEntry(taskEntryDN, lock);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecurringTask getRecurringTask(String recurringTaskID) {
        this.schedulerLock.lock();
        try {
            RecurringTask recurringTask = this.recurringTasks.get(recurringTaskID);
            return recurringTask;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecurringTask getRecurringTask(DN recurringTaskEntryDN) {
        this.schedulerLock.lock();
        try {
            for (RecurringTask rt : this.recurringTasks.values()) {
                if (!recurringTaskEntryDN.equals(rt.getRecurringTaskEntry().getDN())) continue;
                RecurringTask recurringTask = rt;
                return recurringTask;
            }
            RecurringTask recurringTask = null;
            return recurringTask;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getRecurringTaskEntry(DN recurringTaskEntryDN) {
        this.schedulerLock.lock();
        try {
            for (RecurringTask recurringTask : this.recurringTasks.values()) {
                Entry recurringTaskEntry = recurringTask.getRecurringTaskEntry();
                if (!recurringTaskEntryDN.equals(recurringTaskEntry.getDN())) continue;
                Entry entry = recurringTaskEntry.duplicate(true);
                return entry;
            }
            Entry entry = null;
            return entry;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchRecurringTasks(SearchOperation searchOperation) throws DirectoryException {
        SearchFilter filter = searchOperation.getFilter();
        this.schedulerLock.lock();
        try {
            for (RecurringTask rt : this.recurringTasks.values()) {
                DN recurringTaskEntryDN = rt.getRecurringTaskEntryDN();
                Lock lock = this.readLockEntry(recurringTaskEntryDN);
                try {
                    Entry e = rt.getRecurringTaskEntry().duplicate(true);
                    if (!filter.matchesEntry(e) || searchOperation.returnEntry(e, null)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.unlockEntry(recurringTaskEntryDN, lock);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public Task entryToScheduledTask(Entry entry, Operation operation) throws DirectoryException {
        Task task;
        Class<?> taskClass;
        List<Attribute> attrList;
        AttributeType attrType = DirectoryServer.getAttributeType("ds-task-class-name".toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType("ds-task-class-name");
        }
        if ((attrList = entry.getAttribute(attrType)) == null || attrList.isEmpty()) {
            Message message = BackendMessages.ERR_TASKSCHED_NO_CLASS_ATTRIBUTE.get("ds-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (attrList.size() > 1) {
            Message message = BackendMessages.ERR_TASKSCHED_MULTIPLE_CLASS_TYPES.get("ds-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        Attribute attr = attrList.get(0);
        if (attr.isEmpty()) {
            Message message = BackendMessages.ERR_TASKSCHED_NO_CLASS_VALUES.get("ds-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        Iterator<AttributeValue> iterator = attr.iterator();
        AttributeValue value = iterator.next();
        if (iterator.hasNext()) {
            Message message = BackendMessages.ERR_TASKSCHED_MULTIPLE_CLASS_VALUES.get("ds-task-id");
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
        }
        String taskClassName = value.getValue().toString();
        try {
            taskClass = DirectoryServer.loadClass(taskClassName);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TASKSCHED_CANNOT_LOAD_CLASS.get(String.valueOf(taskClassName), "ds-task-class-name", StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        try {
            task = (Task)taskClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TASKSCHED_CANNOT_INSTANTIATE_CLASS_AS_TASK.get(String.valueOf(taskClassName), Task.class.getName());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        try {
            task.initializeTaskInternal(this, entry);
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            Message message = BackendMessages.ERR_TASKSCHED_CANNOT_INITIALIZE_INTERNAL.get(String.valueOf(taskClassName), ie.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        catch (Exception e) {
            Message message = BackendMessages.ERR_TASKSCHED_CANNOT_INITIALIZE_INTERNAL.get(String.valueOf(taskClassName), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (!TaskState.isDone(task.getTaskState()) && !DirectoryServer.getAllowedTasks().contains(taskClassName)) {
            Message message = BackendMessages.ERR_TASKSCHED_NOT_ALLOWED_TASK.get(taskClassName);
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        task.setOperation(operation);
        if (!TaskState.isDone(task.getTaskState())) {
            task.initializeTask();
        }
        task.setOperation(null);
        return task;
    }

    public RecurringTask entryToRecurringTask(Entry entry) throws DirectoryException {
        return new RecurringTask(this, entry);
    }

    @Override
    public DN getComponentEntryDN() {
        return this.taskBackend.getConfigEntryDN();
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.CannotScheduleRecurringIteration", "This alert type will be used to notify administrators if the Directory Server is unable to schedule an iteration of a recurring task.");
        alerts.put("org.opends.server.CannotRenameCurrentTaskFile", "This alert type will be used to notify administrators if the Directory Server is unable to rename the current tasks backing file in the process of trying to write an updated version.");
        alerts.put("org.opends.server.CannotRenameNewTaskFile", "This alert type will be used to notify administrators if the Directory Server is unable to rename the new tasks backing file into place.");
        alerts.put("org.opends.server.CannotWriteTaskFile", "This alert type will be used to notify administrators if the Directory Server is unable to write an updated tasks backing file for some reason.");
        return alerts;
    }
}

