/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Mac;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.TaskBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.backends.task.RecurringTask;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.crypto.CryptoManagerImpl;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.CryptoManagerException;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.LockManager;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public class TaskBackend
extends Backend
implements ConfigurationChangeListener<TaskBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private TaskBackendCfg currentConfig;
    private DN configEntryDN;
    private DN recurringTaskParentDN;
    private DN scheduledTaskParentDN;
    private DN taskRootDN;
    private DN[] baseDNs;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private long retentionTime;
    private String notificationSenderAddress;
    private String taskBackingFile;
    private TaskScheduler taskScheduler;

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        Validator.ensureNotNull(config);
        Validator.ensureTrue(config instanceof TaskBackendCfg);
        TaskBackendCfg cfg = (TaskBackendCfg)config;
        DN[] baseDNs = new DN[cfg.getBaseDN().size()];
        cfg.getBaseDN().toArray(baseDNs);
        ConfigEntry configEntry = DirectoryServer.getConfigEntry(cfg.dn());
        this.configEntryDN = configEntry.getDN();
        if (baseDNs == null || baseDNs.length == 0) {
            Message message = BackendMessages.ERR_TASKBE_NO_BASE_DNS.get();
            throw new ConfigException(message);
        }
        if (baseDNs.length > 1) {
            Message message = BackendMessages.ERR_TASKBE_MULTIPLE_BASE_DNS.get();
            throw new ConfigException(message);
        }
        this.baseDNs = baseDNs;
        this.taskRootDN = baseDNs[0];
        String recurringTaskBaseString = "cn=Recurring Tasks," + this.taskRootDN.toString();
        try {
            this.recurringTaskParentDN = DN.decode(recurringTaskBaseString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TASKBE_CANNOT_DECODE_RECURRING_TASK_BASE_DN.get(String.valueOf(recurringTaskBaseString), StaticUtils.getExceptionMessage(e));
            throw new ConfigException(message, (Throwable)e);
        }
        String scheduledTaskBaseString = "cn=Scheduled Tasks," + this.taskRootDN.toString();
        try {
            this.scheduledTaskParentDN = DN.decode(scheduledTaskBaseString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TASKBE_CANNOT_DECODE_SCHEDULED_TASK_BASE_DN.get(String.valueOf(scheduledTaskBaseString), StaticUtils.getExceptionMessage(e));
            throw new ConfigException(message, (Throwable)e);
        }
        this.retentionTime = cfg.getTaskRetentionTime();
        this.notificationSenderAddress = cfg.getNotificationSenderAddress();
        if (this.notificationSenderAddress == null) {
            try {
                this.notificationSenderAddress = "opendj-task-notification@" + InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                this.notificationSenderAddress = "opendj-task-notification@opendj.org";
            }
        }
        this.taskBackingFile = cfg.getTaskBackingFile();
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        this.currentConfig = cfg;
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        this.taskScheduler = new TaskScheduler(this);
        this.taskScheduler.start();
        this.currentConfig.addTaskChangeListener(this);
        try {
            DirectoryServer.registerBaseDN(this.taskRootDN, this, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(this.taskRootDN.toString(), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    @Override
    public void finalizeBackend() {
        block8: {
            block7: {
                block6: {
                    this.currentConfig.removeTaskChangeListener(this);
                    try {
                        this.taskScheduler.stopScheduler();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block6;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                try {
                    Message message = BackendMessages.INFO_TASKBE_INTERRUPTED_BY_SHUTDOWN.get();
                    this.taskScheduler.interruptRunningTasks(TaskState.STOPPED_BY_SHUTDOWN, message, true);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block7;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            try {
                DirectoryServer.deregisterBaseDN(this.taskRootDN);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        if (this.taskScheduler != null) {
            return this.taskScheduler.getEntryCount();
        }
        return -1L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isIndexed(AttributeType attributeType, IndexType indexType) {
        return true;
    }

    @Override
    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        long ret = this.numSubordinates(entryDN, false);
        if (ret < 0L) {
            return ConditionResult.UNDEFINED;
        }
        if (ret == 0L) {
            return ConditionResult.FALSE;
        }
        return ConditionResult.TRUE;
    }

    @Override
    public long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        if (entryDN == null) {
            return -1L;
        }
        if (entryDN.equals(this.taskRootDN)) {
            if (!subtree) {
                return 2L;
            }
            return this.taskScheduler.getScheduledTaskCount() + this.taskScheduler.getRecurringTaskCount() + 2L;
        }
        if (entryDN.equals(this.scheduledTaskParentDN)) {
            return this.taskScheduler.getScheduledTaskCount();
        }
        if (entryDN.equals(this.recurringTaskParentDN)) {
            return this.taskScheduler.getRecurringTaskCount();
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            return -1L;
        }
        if (parentDN.equals(this.scheduledTaskParentDN) && this.taskScheduler.getScheduledTask(entryDN) != null) {
            return 0L;
        }
        if (parentDN.equals(this.recurringTaskParentDN) && this.taskScheduler.getRecurringTask(entryDN) != null) {
            return 0L;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        if (entryDN == null) {
            return null;
        }
        Lock lock = this.taskScheduler.readLockEntry(entryDN);
        try {
            if (entryDN.equals(this.taskRootDN)) {
                Entry entry = this.taskScheduler.getTaskRootEntry();
                return entry;
            }
            if (entryDN.equals(this.scheduledTaskParentDN)) {
                Entry entry = this.taskScheduler.getScheduledTaskParentEntry();
                return entry;
            }
            if (entryDN.equals(this.recurringTaskParentDN)) {
                Entry entry = this.taskScheduler.getRecurringTaskParentEntry();
                return entry;
            }
            DN parentDN = entryDN.getParentDNInSuffix();
            if (parentDN == null) {
                Entry entry = null;
                return entry;
            }
            if (parentDN.equals(this.scheduledTaskParentDN)) {
                Entry entry = this.taskScheduler.getScheduledTaskEntry(entryDN);
                return entry;
            }
            if (parentDN.equals(this.recurringTaskParentDN)) {
                Entry entry = this.taskScheduler.getRecurringTaskEntry(entryDN);
                return entry;
            }
            Entry entry = null;
            return entry;
        }
        finally {
            this.taskScheduler.unlockEntry(entryDN, lock);
        }
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        Entry e = entry.duplicate(false);
        DN entryDN = e.getDN();
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            Message message = BackendMessages.ERR_TASKBE_ADD_DISALLOWED_DN.get(String.valueOf(this.scheduledTaskParentDN), String.valueOf(this.recurringTaskParentDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (parentDN.equals(this.scheduledTaskParentDN)) {
            Task task = this.taskScheduler.entryToScheduledTask(e, addOperation);
            this.taskScheduler.scheduleTask(task, true);
            return;
        }
        if (parentDN.equals(this.recurringTaskParentDN)) {
            RecurringTask recurringTask = this.taskScheduler.entryToRecurringTask(e);
            this.taskScheduler.addRecurringTask(recurringTask, true);
            return;
        }
        Message message = BackendMessages.ERR_TASKBE_ADD_DISALLOWED_DN.get(String.valueOf(this.scheduledTaskParentDN), String.valueOf(this.recurringTaskParentDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            Message message = BackendMessages.ERR_TASKBE_DELETE_INVALID_ENTRY.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (parentDN.equals(this.scheduledTaskParentDN)) {
            Task t = this.taskScheduler.getScheduledTask(entryDN);
            if (t == null) {
                Message message = BackendMessages.ERR_TASKBE_DELETE_NO_SUCH_TASK.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
            }
            TaskState state = t.getTaskState();
            if (TaskState.isPending(state)) {
                if (!t.isRecurring()) {
                    this.taskScheduler.removePendingTask(t.getTaskID());
                    return;
                }
                this.taskScheduler.removePendingTask(t.getTaskID());
                long scheduledStartTime = t.getScheduledStartTime();
                long currentSystemTime = System.currentTimeMillis();
                if (scheduledStartTime < currentSystemTime) {
                    scheduledStartTime = currentSystemTime;
                }
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTimeInMillis(scheduledStartTime);
                this.taskScheduler.scheduleNextRecurringTaskIteration(t, calendar);
                return;
            }
            if (TaskState.isDone(t.getTaskState())) {
                this.taskScheduler.removeCompletedTask(t.getTaskID());
                return;
            }
            Message message = BackendMessages.ERR_TASKBE_DELETE_RUNNING.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (!parentDN.equals(this.recurringTaskParentDN)) {
            Message message = BackendMessages.ERR_TASKBE_DELETE_INVALID_ENTRY.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        RecurringTask rt = this.taskScheduler.getRecurringTask(entryDN);
        if (rt == null) {
            Message message = BackendMessages.ERR_TASKBE_DELETE_NO_SUCH_RECURRING_TASK.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        this.taskScheduler.removeRecurringTask(rt.getRecurringTaskID());
    }

    @Override
    public void replaceEntry(Entry oldEntry, Entry newEntry, ModifyOperation modifyOperation) throws DirectoryException {
        DN entryDN = newEntry.getDN();
        Lock entryLock = null;
        if (!this.taskScheduler.holdsSchedulerLock() && (entryLock = LockManager.lockWrite(entryDN)) == null) {
            throw new DirectoryException(ResultCode.BUSY, BackendMessages.ERR_TASKBE_MODIFY_CANNOT_LOCK_ENTRY.get(String.valueOf(entryDN)));
        }
        try {
            DN parentDN = entryDN.getParentDNInSuffix();
            if (parentDN == null) {
                Message message = BackendMessages.ERR_TASKBE_MODIFY_INVALID_ENTRY.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (parentDN.equals(this.scheduledTaskParentDN)) {
                Task t = this.taskScheduler.getScheduledTask(entryDN);
                if (t == null) {
                    Message message = BackendMessages.ERR_TASKBE_MODIFY_NO_SUCH_TASK.get(String.valueOf(entryDN));
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
                }
                TaskState state = t.getTaskState();
                if (TaskState.isPending(state) && !t.isRecurring()) {
                    Task newTask = this.taskScheduler.entryToScheduledTask(newEntry, modifyOperation);
                    this.taskScheduler.removePendingTask(t.getTaskID());
                    this.taskScheduler.scheduleTask(newTask, true);
                    return;
                }
                if (TaskState.isRunning(state)) {
                    boolean acceptable = this.isReplaceEntryAcceptable(modifyOperation);
                    if (acceptable) {
                        Message message = BackendMessages.INFO_TASKBE_RUNNING_TASK_CANCELLED.get();
                        t.interruptTask(TaskState.STOPPED_BY_ADMINISTRATOR, message);
                        return;
                    }
                    Message message = BackendMessages.ERR_TASKBE_MODIFY_RUNNING.get(String.valueOf(entryDN));
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                if (TaskState.isPending(state) && t.isRecurring()) {
                    boolean acceptable = this.isReplaceEntryAcceptable(modifyOperation);
                    if (acceptable) {
                        Task newTask = this.taskScheduler.entryToScheduledTask(newEntry, modifyOperation);
                        if (newTask.getTaskState() == TaskState.CANCELED_BEFORE_STARTING) {
                            this.taskScheduler.removePendingTask(t.getTaskID());
                            long scheduledStartTime = t.getScheduledStartTime();
                            long currentSystemTime = System.currentTimeMillis();
                            if (scheduledStartTime < currentSystemTime) {
                                scheduledStartTime = currentSystemTime;
                            }
                            GregorianCalendar calendar = new GregorianCalendar();
                            calendar.setTimeInMillis(scheduledStartTime);
                            this.taskScheduler.scheduleNextRecurringTaskIteration(newTask, calendar);
                        } else if (newTask.getTaskState() == TaskState.STOPPED_BY_ADMINISTRATOR) {
                            Message message = BackendMessages.INFO_TASKBE_RUNNING_TASK_CANCELLED.get();
                            t.interruptTask(TaskState.STOPPED_BY_ADMINISTRATOR, message);
                        }
                        return;
                    }
                    Message message = BackendMessages.ERR_TASKBE_MODIFY_RECURRING.get(String.valueOf(entryDN));
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                Message message = BackendMessages.ERR_TASKBE_MODIFY_COMPLETED.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (parentDN.equals(this.recurringTaskParentDN)) {
                Message message = BackendMessages.ERR_TASKBE_MODIFY_RECURRING.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            Message message = BackendMessages.ERR_TASKBE_MODIFY_INVALID_ENTRY.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        finally {
            if (entryLock != null) {
                LockManager.unlock(entryDN, entryLock);
            }
        }
    }

    private boolean isReplaceEntryAcceptable(ModifyOperation modifyOperation) {
        boolean acceptable = true;
        for (Modification m : modifyOperation.getModifications()) {
            if (m.isInternal()) continue;
            if (m.getModificationType() != ModificationType.REPLACE) {
                acceptable = false;
                break;
            }
            Attribute a = m.getAttribute();
            AttributeType at = a.getAttributeType();
            if (!at.hasName("ds-task-state")) {
                acceptable = false;
                break;
            }
            Iterator<AttributeValue> iterator = a.iterator();
            if (!iterator.hasNext()) {
                acceptable = false;
                break;
            }
            AttributeValue v = iterator.next();
            String valueString = StaticUtils.toLowerCase(v.toString());
            if (!valueString.startsWith("cancel") && !valueString.startsWith("stop")) {
                acceptable = false;
                break;
            }
            if (!iterator.hasNext()) continue;
            acceptable = false;
            break;
        }
        return acceptable;
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_TASKBE_MODIFY_DN_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException, CanceledOperationException {
        Entry e;
        boolean searchRoot = false;
        boolean searchScheduledParent = false;
        boolean searchScheduledTasks = false;
        boolean searchRecurringParent = false;
        boolean searchRecurringTasks = false;
        DN baseDN = searchOperation.getBaseDN();
        SearchScope searchScope = searchOperation.getScope();
        SearchFilter searchFilter = searchOperation.getFilter();
        if (baseDN.equals(this.taskRootDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    searchRoot = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    searchScheduledParent = true;
                    searchRecurringParent = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    searchRoot = true;
                    searchScheduledParent = true;
                    searchRecurringParent = true;
                    searchScheduledTasks = true;
                    searchRecurringTasks = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    searchScheduledParent = true;
                    searchRecurringParent = true;
                    searchScheduledTasks = true;
                    searchRecurringTasks = true;
                }
            }
        } else if (baseDN.equals(this.scheduledTaskParentDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    searchScheduledParent = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    searchScheduledTasks = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    searchScheduledParent = true;
                    searchScheduledTasks = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    searchScheduledTasks = true;
                }
            }
        } else if (baseDN.equals(this.recurringTaskParentDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    searchRecurringParent = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    searchRecurringTasks = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    searchRecurringParent = true;
                    searchRecurringTasks = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    searchRecurringTasks = true;
                }
            }
        } else {
            DN parentDN = baseDN.getParentDNInSuffix();
            if (parentDN == null) {
                Message message = BackendMessages.ERR_TASKBE_SEARCH_INVALID_BASE.get(String.valueOf(baseDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
            }
            if (parentDN.equals(this.scheduledTaskParentDN)) {
                Lock lock = this.taskScheduler.readLockEntry(baseDN);
                try {
                    Entry e2 = this.taskScheduler.getScheduledTaskEntry(baseDN);
                    if (e2 == null) {
                        Message message = BackendMessages.ERR_TASKBE_SEARCH_NO_SUCH_TASK.get(String.valueOf(baseDN));
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, this.scheduledTaskParentDN, null);
                    }
                    if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(e2)) {
                        searchOperation.returnEntry(e2, null);
                    }
                    return;
                }
                finally {
                    this.taskScheduler.unlockEntry(baseDN, lock);
                }
            }
            if (parentDN.equals(this.recurringTaskParentDN)) {
                Lock lock = this.taskScheduler.readLockEntry(baseDN);
                try {
                    Entry e3 = this.taskScheduler.getRecurringTaskEntry(baseDN);
                    if (e3 == null) {
                        Message message = BackendMessages.ERR_TASKBE_SEARCH_NO_SUCH_RECURRING_TASK.get(String.valueOf(baseDN));
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, this.recurringTaskParentDN, null);
                    }
                    if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(e3)) {
                        searchOperation.returnEntry(e3, null);
                    }
                    return;
                }
                finally {
                    this.taskScheduler.unlockEntry(baseDN, lock);
                }
            }
            Message message = BackendMessages.ERR_TASKBE_SEARCH_INVALID_BASE.get(String.valueOf(baseDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        if (searchRoot && searchFilter.matchesEntry(e = this.taskScheduler.getTaskRootEntry()) && !searchOperation.returnEntry(e, null)) {
            return;
        }
        if (searchScheduledParent && searchFilter.matchesEntry(e = this.taskScheduler.getScheduledTaskParentEntry()) && !searchOperation.returnEntry(e, null)) {
            return;
        }
        if (searchScheduledTasks && !this.taskScheduler.searchScheduledTasks(searchOperation)) {
            return;
        }
        if (searchRecurringParent && searchFilter.matchesEntry(e = this.taskScheduler.getRecurringTaskParentEntry()) && !searchOperation.returnEntry(e, null)) {
            return;
        }
        if (searchRecurringTasks && !this.taskScheduler.searchRecurringTasks(searchOperation)) {
            return;
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        LDIFWriter ldifWriter;
        LDIFReader ldifReader;
        File taskFile = StaticUtils.getFileForPath(this.taskBackingFile);
        try {
            ldifReader = new LDIFReader(new LDIFImportConfig(taskFile.getPath()));
        }
        catch (Exception e) {
            Message message = BackendMessages.ERR_TASKS_CANNOT_EXPORT_TO_FILE.get(String.valueOf(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            ldifWriter = new LDIFWriter(exportConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TASKS_CANNOT_EXPORT_TO_FILE.get(StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        try {
            while (true) {
                Entry e;
                block26: {
                    e = null;
                    try {
                        e = ldifReader.readEntry();
                        if (e != null) break block26;
                        break;
                    }
                    catch (LDIFException le) {
                        if (le.canContinueReading()) continue;
                        Message message = BackendMessages.ERR_TASKS_CANNOT_EXPORT_TO_FILE.get(String.valueOf(e));
                        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, le);
                    }
                }
                ldifWriter.writeEntry(e);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            block29: {
                block28: {
                    try {
                        ldifWriter.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block28;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                try {
                    ldifReader.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block29;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_TASKBE_IMPORT_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsBackup() {
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return true;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        OutputStream outputStream;
        String backupID = backupConfig.getBackupID();
        BackupDirectory backupDirectory = backupConfig.getBackupDirectory();
        boolean compress = backupConfig.compressData();
        boolean encrypt = backupConfig.encryptData();
        boolean hash = backupConfig.hashData();
        boolean signHash = backupConfig.signHash();
        HashMap<String, String> backupProperties = new HashMap<String, String>();
        CryptoManagerImpl cryptoManager = DirectoryServer.getCryptoManager();
        Mac mac = null;
        MessageDigest digest = null;
        String digestAlgorithm = null;
        String macKeyID = null;
        if (hash) {
            if (signHash) {
                try {
                    macKeyID = cryptoManager.getMacEngineKeyEntryID();
                    backupProperties.put("mac_key_id", macKeyID);
                    mac = cryptoManager.getMacEngine(macKeyID);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = BackendMessages.ERR_TASKS_BACKUP_CANNOT_GET_MAC.get(macKeyID, StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
                }
            }
            digestAlgorithm = cryptoManager.getPreferredMessageDigestAlgorithm();
            backupProperties.put("digest_algorithm", digestAlgorithm);
            try {
                digest = cryptoManager.getPreferredMessageDigest();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_TASKS_BACKUP_CANNOT_GET_DIGEST.get(digestAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        String filename = null;
        try {
            filename = "tasks-backup-" + backupID;
            File archiveFile = new File(backupDirectory.getPath() + File.separator + filename);
            if (archiveFile.exists()) {
                int i = 1;
                while ((archiveFile = new File(backupDirectory.getPath() + File.separator + filename + "." + i)).exists()) {
                    ++i;
                }
                filename = filename + "." + i;
            }
            outputStream = new FileOutputStream(archiveFile, false);
            backupProperties.put("archive_file", filename);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TASKS_BACKUP_CANNOT_CREATE_ARCHIVE_FILE.get(String.valueOf(filename), backupDirectory.getPath(), StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        if (encrypt) {
            try {
                outputStream = cryptoManager.getCipherOutputStream(outputStream);
            }
            catch (CryptoManagerException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_TASKS_BACKUP_CANNOT_GET_CIPHER.get(StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        ZipOutputStream zipStream = new ZipOutputStream(outputStream);
        Message message = BackendMessages.ERR_TASKS_BACKUP_ZIP_COMMENT.get(DynamicConstants.PRODUCT_NAME, backupID);
        zipStream.setComment(String.valueOf(message));
        if (compress) {
            zipStream.setLevel(-1);
        } else {
            zipStream.setLevel(0);
        }
        byte[] buffer = new byte[8192];
        File tasksFile = StaticUtils.getFileForPath(this.taskBackingFile);
        String baseName = tasksFile.getName();
        if (hash) {
            if (signHash) {
                mac.update(StaticUtils.getBytes(baseName));
            } else {
                digest.update(StaticUtils.getBytes(baseName));
            }
        }
        InputStream inputStream = null;
        try {
            int bytesRead;
            ZipEntry zipEntry = new ZipEntry(baseName);
            zipStream.putNextEntry(zipEntry);
            inputStream = new FileInputStream(tasksFile);
            while ((bytesRead = inputStream.read(buffer)) >= 0 && !backupConfig.isCancelled()) {
                if (hash) {
                    if (signHash) {
                        mac.update(buffer, 0, bytesRead);
                    } else {
                        digest.update(buffer, 0, bytesRead);
                    }
                }
                zipStream.write(buffer, 0, bytesRead);
            }
            zipStream.closeEntry();
            inputStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            try {
                inputStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                zipStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            message = BackendMessages.ERR_TASKS_BACKUP_CANNOT_BACKUP_TASKS_FILE.get(baseName, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            zipStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = BackendMessages.ERR_TASKS_BACKUP_CANNOT_CLOSE_ZIP_STREAM.get(filename, backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        byte[] digestBytes = null;
        byte[] macBytes = null;
        if (hash) {
            if (signHash) {
                macBytes = mac.doFinal();
            } else {
                digestBytes = digest.digest();
            }
        }
        BackupInfo backupInfo = new BackupInfo(backupDirectory, backupID, new Date(), false, compress, encrypt, digestBytes, macBytes, null, backupProperties);
        try {
            backupDirectory.addBackup(backupInfo);
            backupDirectory.writeBackupDirectoryDescriptor();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = BackendMessages.ERR_TASKS_BACKUP_CANNOT_UPDATE_BACKUP_DESCRIPTOR.get(backupDirectory.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        BackupInfo backupInfo = backupDirectory.getBackupInfo(backupID);
        if (backupInfo == null) {
            Message message = BackendMessages.ERR_BACKUP_MISSING_BACKUPID.get(backupDirectory.getPath(), backupID);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        HashMap<String, String> backupProperties = backupInfo.getBackupProperties();
        String archiveFilename = backupProperties.get("archive_file");
        File archiveFile = new File(backupDirectory.getPath(), archiveFilename);
        try {
            backupDirectory.removeBackup(backupID);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        try {
            backupDirectory.writeBackupDirectoryDescriptor();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_BACKUP_CANNOT_UPDATE_BACKUP_DESCRIPTOR.get(backupDirectory.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        archiveFile.delete();
    }

    @Override
    public boolean supportsRestore() {
        return true;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        Message message;
        Message message2;
        InputStream inputStream;
        BackupDirectory backupDirectory = restoreConfig.getBackupDirectory();
        String backupPath = backupDirectory.getPath();
        String backupID = restoreConfig.getBackupID();
        BackupInfo backupInfo = backupDirectory.getBackupInfo(backupID);
        boolean verifyOnly = restoreConfig.verifyOnly();
        if (backupInfo == null) {
            Message message3 = BackendMessages.ERR_TASKS_RESTORE_NO_SUCH_BACKUP.get(backupID, backupPath);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message3);
        }
        String backupFilename = backupInfo.getBackupProperty("archive_file");
        if (backupFilename == null) {
            Message message4 = BackendMessages.ERR_TASKS_RESTORE_NO_BACKUP_FILE.get(backupID, backupPath);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message4);
        }
        File backupFile = new File(backupPath + File.separator + backupFilename);
        try {
            if (!backupFile.exists()) {
                Message message5 = BackendMessages.ERR_TASKS_RESTORE_NO_SUCH_FILE.get(backupID, backupFile.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message5);
            }
        }
        catch (DirectoryException de) {
            throw de;
        }
        catch (Exception e) {
            Message message6 = BackendMessages.ERR_TASKS_RESTORE_CANNOT_CHECK_FOR_ARCHIVE.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message6, e);
        }
        byte[] unsignedHash = backupInfo.getUnsignedHash();
        MessageDigest digest = null;
        if (unsignedHash != null) {
            String digestAlgorithm = backupInfo.getBackupProperty("digest_algorithm");
            if (digestAlgorithm == null) {
                Message message7 = BackendMessages.ERR_TASKS_RESTORE_UNKNOWN_DIGEST.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message7);
            }
            try {
                digest = DirectoryServer.getCryptoManager().getMessageDigest(digestAlgorithm);
            }
            catch (Exception e) {
                Message message8 = BackendMessages.ERR_TASKS_RESTORE_CANNOT_GET_DIGEST.get(backupID, digestAlgorithm);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message8, e);
            }
        }
        byte[] signedHash = backupInfo.getSignedHash();
        Mac mac = null;
        if (signedHash != null) {
            String macKeyID = backupInfo.getBackupProperty("mac_key_id");
            if (macKeyID == null) {
                Message message9 = BackendMessages.ERR_TASKS_RESTORE_UNKNOWN_MAC.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message9);
            }
            try {
                mac = DirectoryServer.getCryptoManager().getMacEngine(macKeyID);
            }
            catch (Exception e) {
                Message message10 = BackendMessages.ERR_TASKS_RESTORE_CANNOT_GET_MAC.get(backupID, macKeyID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message10, e);
            }
        }
        try {
            inputStream = new FileInputStream(backupFile);
        }
        catch (Exception e) {
            Message message11 = BackendMessages.ERR_TASKS_RESTORE_CANNOT_OPEN_BACKUP_FILE.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message11, e);
        }
        if (backupInfo.isEncrypted()) {
            try {
                inputStream = DirectoryServer.getCryptoManager().getCipherInputStream(inputStream);
            }
            catch (CryptoManagerException e) {
                Message message12 = BackendMessages.ERR_TASKS_RESTORE_CANNOT_GET_CIPHER.get(backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message12, e);
            }
        }
        ZipInputStream zipStream = new ZipInputStream(inputStream);
        byte[] buffer = new byte[8192];
        while (true) {
            ZipEntry zipEntry;
            try {
                zipEntry = zipStream.getNextEntry();
            }
            catch (Exception e) {
                Message message13 = BackendMessages.ERR_TASKS_RESTORE_CANNOT_GET_ZIP_ENTRY.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message13, e);
            }
            if (zipEntry == null) break;
            String fileName = zipEntry.getName();
            if (digest != null) {
                digest.update(StaticUtils.getBytes(fileName));
            }
            if (mac != null) {
                mac.update(StaticUtils.getBytes(fileName));
            }
            File tasksFile = StaticUtils.getFileForPath(this.taskBackingFile);
            String baseDirPath = tasksFile.getParent();
            OutputStream outputStream = null;
            if (!verifyOnly) {
                String filePath = baseDirPath + File.separator + fileName;
                try {
                    outputStream = new FileOutputStream(filePath);
                }
                catch (Exception e) {
                    Message message14 = BackendMessages.ERR_TASKS_RESTORE_CANNOT_CREATE_FILE.get(backupID, filePath, StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message14, e);
                }
            }
            try {
                int bytesRead;
                while ((bytesRead = zipStream.read(buffer)) >= 0) {
                    if (digest != null) {
                        digest.update(buffer, 0, bytesRead);
                    }
                    if (mac != null) {
                        mac.update(buffer, 0, bytesRead);
                    }
                    if (outputStream == null) continue;
                    outputStream.write(buffer, 0, bytesRead);
                }
                if (outputStream == null) continue;
                outputStream.close();
            }
            catch (Exception e) {
                Message message15 = BackendMessages.ERR_TASKS_RESTORE_CANNOT_PROCESS_ARCHIVE_FILE.get(backupID, fileName, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message15, e);
            }
        }
        try {
            zipStream.close();
        }
        catch (Exception e) {
            message2 = BackendMessages.ERR_TASKS_RESTORE_ERROR_ON_ZIP_STREAM_CLOSE.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message2, e);
        }
        if (digest != null) {
            byte[] calculatedHash = digest.digest();
            if (Arrays.equals(calculatedHash, unsignedHash)) {
                message2 = BackendMessages.NOTE_TASKS_RESTORE_UNSIGNED_HASH_VALID.get();
                ErrorLogger.logError(message2);
            } else {
                message2 = BackendMessages.ERR_TASKS_RESTORE_UNSIGNED_HASH_INVALID.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message2);
            }
        }
        if (mac != null) {
            byte[] calculatedSignature = mac.doFinal();
            if (Arrays.equals(calculatedSignature, signedHash)) {
                message2 = BackendMessages.NOTE_TASKS_RESTORE_SIGNED_HASH_VALID.get();
                ErrorLogger.logError(message2);
            } else {
                message2 = BackendMessages.ERR_TASKS_RESTORE_SIGNED_HASH_INVALID.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message2);
            }
        }
        if (verifyOnly) {
            message = BackendMessages.NOTE_TASKS_RESTORE_VERIFY_SUCCESSFUL.get(backupID, backupPath);
            ErrorLogger.logError(message);
            return;
        }
        message = BackendMessages.NOTE_TASKS_RESTORE_SUCCESSFUL.get(backupID, backupPath);
        ErrorLogger.logError(message);
    }

    @Override
    public boolean isConfigurationAcceptable(Configuration configuration, List<Message> unacceptableReasons) {
        TaskBackendCfg config = (TaskBackendCfg)configuration;
        return TaskBackend.isConfigAcceptable(config, unacceptableReasons, null);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(TaskBackendCfg configEntry, List<Message> unacceptableReasons) {
        return TaskBackend.isConfigAcceptable(configEntry, unacceptableReasons, this.taskBackingFile);
    }

    private static boolean isConfigAcceptable(TaskBackendCfg config, List<Message> unacceptableReasons, String taskBackingFile) {
        boolean configIsAcceptable = true;
        try {
            String tmpBackingFile = config.getTaskBackingFile();
            if (taskBackingFile == null || !taskBackingFile.equals(tmpBackingFile)) {
                File f = StaticUtils.getFileForPath(tmpBackingFile);
                if (f.exists()) {
                    if (taskBackingFile != null) {
                        unacceptableReasons.add(BackendMessages.ERR_TASKBE_BACKING_FILE_EXISTS.get(tmpBackingFile));
                        configIsAcceptable = false;
                    }
                } else {
                    File p = f.getParentFile();
                    if (p == null) {
                        unacceptableReasons.add(BackendMessages.ERR_TASKBE_INVALID_BACKING_FILE_PATH.get(tmpBackingFile));
                        configIsAcceptable = false;
                    } else if (!p.exists()) {
                        unacceptableReasons.add(BackendMessages.ERR_TASKBE_BACKING_FILE_MISSING_PARENT.get(p.getPath(), tmpBackingFile));
                        configIsAcceptable = false;
                    } else if (!p.isDirectory()) {
                        unacceptableReasons.add(BackendMessages.ERR_TASKBE_BACKING_FILE_PARENT_NOT_DIRECTORY.get(p.getPath(), tmpBackingFile));
                        configIsAcceptable = false;
                    }
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            unacceptableReasons.add(BackendMessages.ERR_TASKBE_ERROR_GETTING_BACKING_FILE.get(StaticUtils.getExceptionMessage(e)));
            configIsAcceptable = false;
        }
        return configIsAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(TaskBackendCfg configEntry) {
        String tmpNotificationAddress;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        String tmpBackingFile = this.taskBackingFile;
        try {
            tmpBackingFile = configEntry.getTaskBackingFile();
            if (!this.taskBackingFile.equals(tmpBackingFile)) {
                File f = StaticUtils.getFileForPath(tmpBackingFile);
                if (f.exists()) {
                    messages.add(BackendMessages.ERR_TASKBE_BACKING_FILE_EXISTS.get(tmpBackingFile));
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                } else {
                    File p = f.getParentFile();
                    if (p == null) {
                        messages.add(BackendMessages.ERR_TASKBE_INVALID_BACKING_FILE_PATH.get(tmpBackingFile));
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    } else if (!p.exists()) {
                        messages.add(BackendMessages.ERR_TASKBE_BACKING_FILE_MISSING_PARENT.get(String.valueOf(p), tmpBackingFile));
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    } else if (!p.isDirectory()) {
                        messages.add(BackendMessages.ERR_TASKBE_BACKING_FILE_PARENT_NOT_DIRECTORY.get(String.valueOf(p), tmpBackingFile));
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    }
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(BackendMessages.ERR_TASKBE_ERROR_GETTING_BACKING_FILE.get(StaticUtils.getExceptionMessage(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        long tmpRetentionTime = configEntry.getTaskRetentionTime();
        if (resultCode == ResultCode.SUCCESS) {
            if (this.retentionTime != tmpRetentionTime) {
                this.retentionTime = tmpRetentionTime;
                messages.add(BackendMessages.INFO_TASKBE_UPDATED_RETENTION_TIME.get(this.retentionTime));
            }
            if (!this.taskBackingFile.equals(tmpBackingFile)) {
                this.taskBackingFile = tmpBackingFile;
                this.taskScheduler.writeState();
                messages.add(BackendMessages.INFO_TASKBE_UPDATED_BACKING_FILE.get(this.taskBackingFile));
            }
        }
        if ((tmpNotificationAddress = configEntry.getNotificationSenderAddress()) == null) {
            try {
                tmpNotificationAddress = "opendj-task-notification@" + InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                tmpNotificationAddress = "opendj-task-notification@opendj.org";
            }
        }
        this.notificationSenderAddress = tmpNotificationAddress;
        this.currentConfig = configEntry;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    public DN getConfigEntryDN() {
        return this.configEntryDN;
    }

    public String getTaskBackingFile() {
        File f = StaticUtils.getFileForPath(this.taskBackingFile);
        return f.getPath();
    }

    public String getNotificationSenderAddress() {
        return this.notificationSenderAddress;
    }

    public long getRetentionTime() {
        return this.retentionTime;
    }

    public DN getTaskRootDN() {
        return this.taskRootDN;
    }

    public DN getRecurringTasksParentDN() {
        return this.recurringTaskParentDN;
    }

    public DN getScheduledTasksParentDN() {
        return this.scheduledTaskParentDN;
    }

    public Task getScheduledTask(DN taskEntryDN) {
        return this.taskScheduler.getScheduledTask(taskEntryDN);
    }

    public RecurringTask getRecurringTask(DN taskEntryDN) {
        return this.taskScheduler.getRecurringTask(taskEntryDN);
    }

    @Override
    public void preloadEntryCache() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported.");
    }
}

