/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DiskOrderedCursor;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.util.PackedInteger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.messages.Category;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.messages.Severity;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.admin.std.server.LocalDBIndexCfg;
import org.opends.server.api.DiskSpaceMonitorHandler;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EnvManager;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.RebuildConfig;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.backends.jeb.importLDIF.ImportIDSet;
import org.opends.server.backends.jeb.importLDIF.IndexInputBuffer;
import org.opends.server.backends.jeb.importLDIF.IndexOutputBuffer;
import org.opends.server.backends.jeb.importLDIF.Suffix;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.DiskSpaceMonitor;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ResultCode;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.Platform;
import org.opends.server.util.StaticUtils;

public final class Importer
implements DiskSpaceMonitorHandler {
    private static final int TIMER_INTERVAL = 10000;
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final String DEFAULT_TMP_DIR = "import-tmp";
    private static final String TMPENV_DIR = "tmp-env";
    private static final int MAX_DB_CACHE_SIZE = 0x800000;
    private static final int MAX_DB_LOG_SIZE = 0xA00000;
    private static final int MIN_DB_CACHE_SIZE = 0x400000;
    private static final int READER_WRITER_BUFFER_SIZE = 8192;
    private static final int MIN_DB_CACHE_MEMORY = 0x1200000;
    private static final int BYTE_BUFFER_CAPACITY = 128;
    private static final int MAX_BUFFER_SIZE = 0x200000;
    private static final int MIN_BUFFER_SIZE = 4096;
    private static final int MIN_READ_AHEAD_CACHE_SIZE = 2048;
    private static final int SMALL_HEAP_SIZE = 0x10000000;
    private static AttributeType dnType;
    static final IndexOutputBuffer.IndexComparator indexComparator;
    private final AtomicInteger bufferCount = new AtomicInteger(0);
    private final AtomicLong importCount = new AtomicLong(0L);
    private int bufferSize;
    private final File tempDir;
    private final int indexCount;
    private int threadCount;
    private final boolean skipDNValidation;
    private final TmpEnv tmpEnv;
    private RootContainer rootContainer;
    private final LDIFImportConfig importConfiguration;
    private final LocalDBBackendCfg backendConfiguration;
    private LDIFReader reader;
    private int migratedCount;
    private long tmpEnvCacheSize;
    private long availableMemory;
    private long dbCacheSize;
    private ExecutorService bufferSortService;
    private ExecutorService scratchFileWriterService;
    private final BlockingQueue<IndexOutputBuffer> freeBufferQueue = new LinkedBlockingQueue<IndexOutputBuffer>();
    private final Map<IndexKey, BlockingQueue<IndexOutputBuffer>> indexKeyQueMap = new ConcurrentHashMap<IndexKey, BlockingQueue<IndexOutputBuffer>>();
    private final List<IndexManager> indexMgrList = new LinkedList<IndexManager>();
    private final List<IndexManager> DNIndexMgrList = new LinkedList<IndexManager>();
    private final List<Future<?>> scratchFileWriterFutures;
    private final List<ScratchFileWriterTask> scratchFileWriterList;
    private final Map<DN, Suffix> dnSuffixMap = new LinkedHashMap<DN, Suffix>();
    private final ConcurrentHashMap<Integer, DatabaseContainer> idContainerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, EntryContainer> idECMap = new ConcurrentHashMap();
    private final Object synObj = new Object();
    private final RebuildIndexManager rebuildManager;
    private boolean clearedBackend = false;
    private volatile boolean isCanceled = false;
    private volatile boolean isPhaseOneDone = false;
    private int phaseOneBufferCount;

    public Importer(RebuildConfig rebuildConfig, LocalDBBackendCfg cfg, EnvironmentConfig envConfig) throws InitializationException, JebException, ConfigException {
        this.importConfiguration = null;
        this.backendConfiguration = cfg;
        this.tmpEnv = null;
        this.threadCount = 1;
        this.rebuildManager = new RebuildIndexManager(rebuildConfig, cfg);
        this.indexCount = this.rebuildManager.getIndexCount();
        this.scratchFileWriterList = new ArrayList<ScratchFileWriterTask>(this.indexCount);
        this.scratchFileWriterFutures = new CopyOnWriteArrayList();
        File parentDir = rebuildConfig.getTmpDirectory() == null ? StaticUtils.getFileForPath(DEFAULT_TMP_DIR) : StaticUtils.getFileForPath(rebuildConfig.getTmpDirectory());
        this.tempDir = new File(parentDir, cfg.getBackendId());
        this.recursiveDelete(this.tempDir);
        if (!this.tempDir.exists() && !this.tempDir.mkdirs()) {
            Message message = JebMessages.ERR_JEB_IMPORT_CREATE_TMPDIR_ERROR.get(String.valueOf(this.tempDir));
            throw new InitializationException(message);
        }
        this.skipDNValidation = true;
        this.initializeDBEnv(envConfig);
    }

    public Importer(LDIFImportConfig importConfiguration, LocalDBBackendCfg localDBBackendCfg, EnvironmentConfig envConfig) throws InitializationException, ConfigException, DatabaseException {
        this.rebuildManager = null;
        this.importConfiguration = importConfiguration;
        this.backendConfiguration = localDBBackendCfg;
        this.threadCount = importConfiguration.getThreadCount() == 0 ? Runtime.getRuntime().availableProcessors() * 2 : importConfiguration.getThreadCount();
        this.indexCount = this.getTotalIndexCount(localDBBackendCfg);
        if (!importConfiguration.appendToExistingData() && (importConfiguration.clearBackend() || localDBBackendCfg.getBaseDN().size() <= 1)) {
            this.clearedBackend = true;
        }
        this.scratchFileWriterList = new ArrayList<ScratchFileWriterTask>(this.indexCount);
        this.scratchFileWriterFutures = new CopyOnWriteArrayList();
        File parentDir = importConfiguration.getTmpDirectory() == null ? StaticUtils.getFileForPath(DEFAULT_TMP_DIR) : StaticUtils.getFileForPath(importConfiguration.getTmpDirectory());
        this.tempDir = new File(parentDir, localDBBackendCfg.getBackendId());
        this.recursiveDelete(this.tempDir);
        if (!this.tempDir.exists() && !this.tempDir.mkdirs()) {
            Message message = JebMessages.ERR_JEB_IMPORT_CREATE_TMPDIR_ERROR.get(String.valueOf(this.tempDir));
            throw new InitializationException(message);
        }
        this.skipDNValidation = importConfiguration.getSkipDNValidation();
        this.initializeDBEnv(envConfig);
        if (!this.skipDNValidation) {
            File envPath = new File(this.tempDir, TMPENV_DIR);
            envPath.mkdirs();
            this.tmpEnv = new TmpEnv(envPath);
        } else {
            this.tmpEnv = null;
        }
    }

    private int getTotalIndexCount(LocalDBBackendCfg localDBBackendCfg) throws ConfigException {
        int indexes = 2;
        for (String indexName : localDBBackendCfg.listLocalDBIndexes()) {
            LocalDBIndexCfg index = localDBBackendCfg.getLocalDBIndex(indexName);
            SortedSet<LocalDBIndexCfgDefn.IndexType> types = index.getIndexType();
            if (types.contains((Object)LocalDBIndexCfgDefn.IndexType.EXTENSIBLE)) {
                indexes += types.size() - 1 + index.getIndexExtensibleMatchingRule().size();
                continue;
            }
            indexes += types.size();
        }
        return indexes;
    }

    public static Suffix getMatchSuffix(DN dn, Map<DN, Suffix> map) {
        Suffix suffix = null;
        DN nodeDN = dn;
        while (suffix == null && nodeDN != null) {
            suffix = map.get(nodeDN);
            if (suffix != null) continue;
            nodeDN = nodeDN.getParentDNInSuffix();
        }
        return suffix;
    }

    private void initializeDBEnv(EnvironmentConfig envConfig) throws InitializationException {
        int oldThreadCount;
        block16: {
            this.calculateAvailableMemory();
            long usableMemory = this.availableMemory - (long)(this.indexCount * 8192);
            if (!this.skipDNValidation || this.rebuildManager != null) {
                if (System.getProperty("org.opends.server.RunningUnitTests") != null) {
                    this.dbCacheSize = 512000L;
                    this.tmpEnvCacheSize = 512000L;
                } else if (usableMemory < 0x1600000L) {
                    this.dbCacheSize = 0x400000L;
                    this.tmpEnvCacheSize = 0x400000L;
                } else if (!this.clearedBackend) {
                    this.dbCacheSize = usableMemory * 33L / 100L;
                    this.tmpEnvCacheSize = usableMemory * 33L / 100L;
                } else {
                    this.dbCacheSize = 0x800000L;
                    this.tmpEnvCacheSize = usableMemory * 66L / 100L;
                }
            } else {
                this.tmpEnvCacheSize = 0L;
                this.dbCacheSize = System.getProperty("org.opends.server.RunningUnitTests") != null ? 512000L : (usableMemory < 0x1200000L ? 0x400000L : 0x800000L);
            }
            long phaseOneBufferMemory = usableMemory - this.dbCacheSize - this.tmpEnvCacheSize;
            oldThreadCount = this.threadCount;
            if (this.indexCount != 0) {
                int totalPhaseOneBufferCount;
                while (true) {
                    this.phaseOneBufferCount = 2 * this.indexCount * this.threadCount;
                    totalPhaseOneBufferCount = this.phaseOneBufferCount + 4 * this.indexCount;
                    this.bufferSize = (int)(phaseOneBufferMemory / (long)totalPhaseOneBufferCount);
                    if (this.bufferSize > 0x200000) {
                        if (!this.skipDNValidation) {
                            this.bufferSize = 0x200000;
                            long extraMemory = phaseOneBufferMemory - (long)(totalPhaseOneBufferCount * this.bufferSize);
                            if (!this.clearedBackend) {
                                this.dbCacheSize += extraMemory / 2L;
                                this.tmpEnvCacheSize += extraMemory / 2L;
                            } else {
                                this.tmpEnvCacheSize += extraMemory;
                            }
                        }
                        break block16;
                    }
                    if (this.bufferSize > 4096) break block16;
                    if (this.threadCount <= 1) break;
                    --this.threadCount;
                }
                long minimumPhaseOneBufferMemory = totalPhaseOneBufferCount * 4096;
                Message message = JebMessages.ERR_IMPORT_LDIF_LACK_MEM.get(usableMemory, minimumPhaseOneBufferMemory + this.dbCacheSize + this.tmpEnvCacheSize);
                throw new InitializationException(message);
            }
        }
        if (oldThreadCount != this.threadCount) {
            Message message = JebMessages.NOTE_JEB_IMPORT_ADJUST_THREAD_COUNT.get(oldThreadCount, this.threadCount);
            ErrorLogger.logError(message);
        }
        Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_TOT_MEM_BUF.get(this.availableMemory, this.phaseOneBufferCount);
        ErrorLogger.logError(message);
        if (this.tmpEnvCacheSize > 0L) {
            message = JebMessages.NOTE_JEB_IMPORT_LDIF_TMP_ENV_MEM.get(this.tmpEnvCacheSize);
            ErrorLogger.logError(message);
        }
        envConfig.setConfigParam("je.maxMemory", Long.toString(this.dbCacheSize));
        message = JebMessages.NOTE_JEB_IMPORT_LDIF_DB_MEM_BUF_INFO.get(this.dbCacheSize, this.bufferSize);
        ErrorLogger.logError(message);
    }

    private void calculateAvailableMemory() {
        long totalAvailableMemory;
        if (DirectoryServer.isRunning()) {
            Runtime runTime = Runtime.getRuntime();
            runTime.gc();
            runTime.gc();
            long usedMemory = runTime.totalMemory() - runTime.freeMemory();
            long maxUsableMemory = Platform.getUsableMemoryForCaching();
            long usableMemory = maxUsableMemory - usedMemory;
            long configuredMemory = this.backendConfiguration.getDBCacheSize() > 0L ? this.backendConfiguration.getDBCacheSize() : (long)this.backendConfiguration.getDBCachePercent() * Runtime.getRuntime().maxMemory() / 100L;
            totalAvailableMemory = Math.max(Math.min(usableMemory, configuredMemory), 0x1000000L);
        } else {
            totalAvailableMemory = Platform.getUsableMemoryForCaching();
        }
        int importMemPct = 90;
        if (totalAvailableMemory <= 0x10000000L) {
            importMemPct -= 25;
        }
        if (this.rebuildManager != null) {
            importMemPct -= 15;
        }
        this.availableMemory = totalAvailableMemory * (long)importMemPct / 100L;
    }

    private void initializeIndexBuffers() {
        for (int i = 0; i < this.phaseOneBufferCount; ++i) {
            IndexOutputBuffer b = new IndexOutputBuffer(this.bufferSize);
            this.freeBufferQueue.add(b);
        }
    }

    private void initializeSuffixes() throws DatabaseException, ConfigException, InitializationException {
        for (EntryContainer ec : this.rootContainer.getEntryContainers()) {
            Suffix suffix = this.getSuffix(ec);
            if (suffix == null) continue;
            this.dnSuffixMap.put(ec.getBaseDN(), suffix);
            this.generateIndexID(suffix);
        }
    }

    private void generateIndexID(Suffix suffix) {
        for (Map.Entry<AttributeType, AttributeIndex> mapEntry : suffix.getAttrIndexMap().entrySet()) {
            Collection<Index> sharedIndexes;
            Map<String, Collection<Index>> extensibleMap;
            int id;
            AttributeIndex attributeIndex = mapEntry.getValue();
            Index container = attributeIndex.getEqualityIndex();
            if (container != null) {
                id = System.identityHashCode(container);
                this.idContainerMap.putIfAbsent(id, container);
            }
            if ((container = attributeIndex.getPresenceIndex()) != null) {
                id = System.identityHashCode(container);
                this.idContainerMap.putIfAbsent(id, container);
            }
            if ((container = attributeIndex.getSubstringIndex()) != null) {
                id = System.identityHashCode(container);
                this.idContainerMap.putIfAbsent(id, container);
            }
            if ((container = attributeIndex.getOrderingIndex()) != null) {
                id = System.identityHashCode(container);
                this.idContainerMap.putIfAbsent(id, container);
            }
            if ((container = attributeIndex.getApproximateIndex()) != null) {
                id = System.identityHashCode(container);
                this.idContainerMap.putIfAbsent(id, container);
            }
            if ((extensibleMap = attributeIndex.getExtensibleIndexes()).isEmpty()) continue;
            Collection<Index> subIndexes = attributeIndex.getExtensibleIndexes().get("substring");
            if (subIndexes != null) {
                for (DatabaseContainer databaseContainer : subIndexes) {
                    int n = System.identityHashCode(databaseContainer);
                    this.idContainerMap.putIfAbsent(n, databaseContainer);
                }
            }
            if ((sharedIndexes = attributeIndex.getExtensibleIndexes().get("shared")) == null) continue;
            for (DatabaseContainer databaseContainer : sharedIndexes) {
                int id3 = System.identityHashCode(databaseContainer);
                this.idContainerMap.putIfAbsent(id3, databaseContainer);
            }
        }
    }

    private Suffix getSuffix(EntryContainer entryContainer) throws ConfigException, InitializationException {
        DN baseDN = entryContainer.getBaseDN();
        EntryContainer sourceEntryContainer = null;
        ArrayList<DN> includeBranches = new ArrayList<DN>();
        ArrayList<DN> excludeBranches = new ArrayList<DN>();
        if (!this.importConfiguration.appendToExistingData() && !this.importConfiguration.clearBackend()) {
            for (DN dn : this.importConfiguration.getExcludeBranches()) {
                if (baseDN.equals(dn)) {
                    return null;
                }
                if (!baseDN.isAncestorOf(dn)) continue;
                excludeBranches.add(dn);
            }
            if (!this.importConfiguration.getIncludeBranches().isEmpty()) {
                for (DN dn : this.importConfiguration.getIncludeBranches()) {
                    if (!baseDN.isAncestorOf(dn)) continue;
                    includeBranches.add(dn);
                }
                if (includeBranches.isEmpty()) {
                    return null;
                }
                Iterator includeBranchIterator = includeBranches.iterator();
                while (includeBranchIterator.hasNext()) {
                    DN includeDN = (DN)includeBranchIterator.next();
                    boolean keep = true;
                    for (DN dn : includeBranches) {
                        if (dn.equals(includeDN) || !dn.isAncestorOf(includeDN)) continue;
                        keep = false;
                        break;
                    }
                    if (keep) continue;
                    includeBranchIterator.remove();
                }
                Iterator excludeBranchIterator = excludeBranches.iterator();
                while (excludeBranchIterator.hasNext()) {
                    DN excludeDN = (DN)excludeBranchIterator.next();
                    boolean keep = false;
                    for (DN includeDN : includeBranches) {
                        if (!includeDN.isAncestorOf(excludeDN)) continue;
                        keep = true;
                        break;
                    }
                    if (keep) continue;
                    excludeBranchIterator.remove();
                }
                if (includeBranches.size() == 1 && excludeBranches.isEmpty() && ((DN)includeBranches.get(0)).equals(baseDN)) {
                    entryContainer.lock();
                    entryContainer.clear();
                    entryContainer.unlock();
                } else {
                    sourceEntryContainer = entryContainer;
                    entryContainer = this.rootContainer.openEntryContainer(baseDN, baseDN.toNormalizedString() + "_importTmp");
                }
            }
        }
        return Suffix.createSuffixContext(entryContainer, sourceEntryContainer, includeBranches, excludeBranches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildIndexes(RootContainer rootContainer) throws ConfigException, InitializationException, JebException, InterruptedException, ExecutionException {
        this.rootContainer = rootContainer;
        long startTime = System.currentTimeMillis();
        DiskSpaceMonitor tmpMonitor = new DiskSpaceMonitor(this.backendConfiguration.getBackendId() + " backend index rebuild tmp directory", this.tempDir, this.backendConfiguration.getDiskLowThreshold(), this.backendConfiguration.getDiskFullThreshold(), 5, TimeUnit.SECONDS, this);
        tmpMonitor.initializeMonitorProvider(null);
        DirectoryServer.registerMonitorProvider(tmpMonitor);
        File parentDirectory = StaticUtils.getFileForPath(this.backendConfiguration.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.backendConfiguration.getBackendId());
        DiskSpaceMonitor dbMonitor = new DiskSpaceMonitor(this.backendConfiguration.getBackendId() + " backend index rebuild DB directory", backendDirectory, this.backendConfiguration.getDiskLowThreshold(), this.backendConfiguration.getDiskFullThreshold(), 5, TimeUnit.SECONDS, this);
        dbMonitor.initializeMonitorProvider(null);
        DirectoryServer.registerMonitorProvider(dbMonitor);
        try {
            this.rebuildManager.initialize();
            this.rebuildManager.printStartMessage();
            this.rebuildManager.rebuildIndexes();
            this.recursiveDelete(this.tempDir);
            this.rebuildManager.printStopMessage(startTime);
        }
        finally {
            DirectoryServer.deregisterMonitorProvider(tmpMonitor);
            DirectoryServer.deregisterMonitorProvider(dbMonitor);
            tmpMonitor.finalizeMonitorProvider();
            dbMonitor.finalizeMonitorProvider();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDIFImportResult processImport(RootContainer rootContainer) throws ConfigException, InitializationException, JebException, InterruptedException, ExecutionException {
        this.rootContainer = rootContainer;
        try {
            this.reader = new LDIFReader(this.importConfiguration, rootContainer, 8192);
        }
        catch (IOException ioe) {
            Message message = JebMessages.ERR_JEB_IMPORT_LDIF_READER_IO_ERROR.get();
            throw new InitializationException(message, (Throwable)ioe);
        }
        DiskSpaceMonitor tmpMonitor = new DiskSpaceMonitor(this.backendConfiguration.getBackendId() + " backend import tmp directory", this.tempDir, this.backendConfiguration.getDiskLowThreshold(), this.backendConfiguration.getDiskFullThreshold(), 5, TimeUnit.SECONDS, this);
        tmpMonitor.initializeMonitorProvider(null);
        DirectoryServer.registerMonitorProvider(tmpMonitor);
        File parentDirectory = StaticUtils.getFileForPath(this.backendConfiguration.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.backendConfiguration.getBackendId());
        DiskSpaceMonitor dbMonitor = new DiskSpaceMonitor(this.backendConfiguration.getBackendId() + " backend import DB directory", backendDirectory, this.backendConfiguration.getDiskLowThreshold(), this.backendConfiguration.getDiskFullThreshold(), 5, TimeUnit.SECONDS, this);
        dbMonitor.initializeMonitorProvider(null);
        DirectoryServer.registerMonitorProvider(dbMonitor);
        try {
            Message message = JebMessages.NOTE_JEB_IMPORT_STARTING.get(DirectoryServer.getVersionString(), DynamicConstants.BUILD_ID, DynamicConstants.REVISION_NUMBER);
            ErrorLogger.logError(message);
            message = JebMessages.NOTE_JEB_IMPORT_THREAD_COUNT.get(this.threadCount);
            ErrorLogger.logError(message);
            this.initializeSuffixes();
            this.setIndexesTrusted(false);
            long startTime = System.currentTimeMillis();
            this.phaseOne();
            this.isPhaseOneDone = true;
            long phaseOneFinishTime = System.currentTimeMillis();
            if (!this.skipDNValidation) {
                this.tmpEnv.shutdown();
            }
            if (this.isCanceled) {
                throw new InterruptedException("Import processing canceled.");
            }
            long phaseTwoTime = System.currentTimeMillis();
            this.phaseTwo();
            if (this.isCanceled) {
                throw new InterruptedException("Import processing canceled.");
            }
            long phaseTwoFinishTime = System.currentTimeMillis();
            this.setIndexesTrusted(true);
            this.switchContainers();
            this.recursiveDelete(this.tempDir);
            long finishTime = System.currentTimeMillis();
            long importTime = finishTime - startTime;
            float rate = 0.0f;
            message = JebMessages.NOTE_JEB_IMPORT_PHASE_STATS.get(importTime / 1000L, (phaseOneFinishTime - startTime) / 1000L, (phaseTwoFinishTime - phaseTwoTime) / 1000L);
            ErrorLogger.logError(message);
            if (importTime > 0L) {
                rate = 1000.0f * (float)this.reader.getEntriesRead() / (float)importTime;
            }
            message = JebMessages.NOTE_JEB_IMPORT_FINAL_STATUS.get(this.reader.getEntriesRead(), this.importCount.get(), this.reader.getEntriesIgnored(), this.reader.getEntriesRejected(), this.migratedCount, importTime / 1000L, Float.valueOf(rate));
            ErrorLogger.logError(message);
        }
        finally {
            this.reader.close();
            DirectoryServer.deregisterMonitorProvider(tmpMonitor);
            DirectoryServer.deregisterMonitorProvider(dbMonitor);
            tmpMonitor.finalizeMonitorProvider();
            dbMonitor.finalizeMonitorProvider();
        }
        return new LDIFImportResult(this.reader.getEntriesRead(), this.reader.getEntriesRejected(), this.reader.getEntriesIgnored());
    }

    private void recursiveDelete(File dir) {
        if (dir.listFiles() != null) {
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    this.recursiveDelete(f);
                }
                f.delete();
            }
        }
        dir.delete();
    }

    private void switchContainers() throws DatabaseException, JebException, InitializationException {
        for (Suffix suffix : this.dnSuffixMap.values()) {
            DN baseDN = suffix.getBaseDN();
            EntryContainer entryContainer = suffix.getSrcEntryContainer();
            if (entryContainer == null) continue;
            EntryContainer needRegisterContainer = this.rootContainer.unregisterEntryContainer(baseDN);
            needRegisterContainer.lock();
            needRegisterContainer.close();
            needRegisterContainer.delete();
            needRegisterContainer.unlock();
            EntryContainer newEC = suffix.getEntryContainer();
            newEC.lock();
            newEC.setDatabasePrefix(baseDN.toNormalizedString());
            newEC.unlock();
            this.rootContainer.registerEntryContainer(baseDN, newEC);
        }
    }

    private void setIndexesTrusted(boolean trusted) throws JebException {
        try {
            for (Suffix s : this.dnSuffixMap.values()) {
                s.setIndexesTrusted(trusted);
            }
        }
        catch (DatabaseException ex) {
            Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_TRUSTED_FAILED.get(ex.getMessage());
            throw new JebException(message);
        }
    }

    private void phaseOne() throws InterruptedException, ExecutionException {
        int i;
        this.initializeIndexBuffers();
        FirstPhaseProgressTask progressTask = new FirstPhaseProgressTask();
        ScheduledThreadPoolExecutor timerService = new ScheduledThreadPoolExecutor(1);
        timerService.scheduleAtFixedRate(progressTask, 10000L, 10000L, TimeUnit.MILLISECONDS);
        this.scratchFileWriterService = Executors.newFixedThreadPool(2 * this.indexCount);
        this.bufferSortService = Executors.newFixedThreadPool(this.threadCount);
        ExecutorService execService = Executors.newFixedThreadPool(this.threadCount);
        ArrayList<ImportTask> tasks = new ArrayList<ImportTask>(this.threadCount);
        tasks.add(new MigrateExistingTask());
        List results = execService.invokeAll(tasks);
        for (Future future : results) {
            if (future.isDone()) continue;
            future.get();
        }
        tasks.clear();
        results.clear();
        if (this.importConfiguration.appendToExistingData() && this.importConfiguration.replaceExistingEntries()) {
            for (i = 0; i < this.threadCount; ++i) {
                tasks.add(new AppendReplaceTask());
            }
        } else {
            for (i = 0; i < this.threadCount; ++i) {
                tasks.add(new ImportTask());
            }
        }
        results = execService.invokeAll(tasks);
        for (Future future : results) {
            if (future.isDone()) continue;
            future.get();
        }
        tasks.clear();
        results.clear();
        tasks.add(new MigrateExcludedTask());
        results = execService.invokeAll(tasks);
        for (Future future : results) {
            if (future.isDone()) continue;
            future.get();
        }
        this.stopScratchFileWriters();
        for (Future<Object> future : this.scratchFileWriterFutures) {
            if (future.isDone()) continue;
            future.get();
        }
        timerService.shutdown();
        timerService.awaitTermination(30L, TimeUnit.SECONDS);
        execService.shutdown();
        execService.awaitTermination(30L, TimeUnit.SECONDS);
        this.bufferSortService.shutdown();
        this.bufferSortService.awaitTermination(30L, TimeUnit.SECONDS);
        this.scratchFileWriterService.shutdown();
        this.scratchFileWriterService.awaitTermination(30L, TimeUnit.SECONDS);
        this.scratchFileWriterList.clear();
        this.scratchFileWriterFutures.clear();
        this.indexKeyQueMap.clear();
        this.freeBufferQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void phaseTwo() throws InterruptedException, ExecutionException {
        SecondPhaseProgressTask progress2Task = new SecondPhaseProgressTask(this.reader.getEntriesRead());
        ScheduledThreadPoolExecutor timerService = new ScheduledThreadPoolExecutor(1);
        timerService.scheduleAtFixedRate(progress2Task, 10000L, 10000L, TimeUnit.MILLISECONDS);
        try {
            this.processIndexFiles();
        }
        finally {
            timerService.shutdown();
            timerService.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private void processIndexFiles() throws InterruptedException, ExecutionException {
        int readAheadSize;
        int buffers;
        int dbThreads;
        block8: {
            if (this.bufferCount.get() == 0) {
                return;
            }
            dbThreads = Runtime.getRuntime().availableProcessors();
            if (dbThreads < 4) {
                dbThreads = 4;
            }
            long usableMemory = this.availableMemory - this.dbCacheSize;
            while (true) {
                ArrayList<IndexManager> totList = new ArrayList<IndexManager>(this.DNIndexMgrList);
                totList.addAll(this.indexMgrList);
                Collections.sort(totList, Collections.reverseOrder());
                buffers = 0;
                int limit = Math.min(dbThreads, totList.size());
                for (int i = 0; i < limit; ++i) {
                    buffers += ((IndexManager)totList.get(i)).numberOfBuffers;
                }
                readAheadSize = (int)(usableMemory / (long)buffers);
                if (readAheadSize > this.bufferSize) {
                    readAheadSize = this.bufferSize;
                    break block8;
                }
                if (readAheadSize > 2048) break block8;
                if (dbThreads <= 1) break;
                --dbThreads;
            }
            readAheadSize = 2048;
            buffers = (int)(usableMemory / (long)readAheadSize);
            Message message = JebMessages.WARN_IMPORT_LDIF_LACK_MEM_PHASE_TWO.get(usableMemory);
            ErrorLogger.logError(message);
        }
        dbThreads = Math.max(2, dbThreads);
        Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_PHASE_TWO_MEM_REPORT.get(this.availableMemory, readAheadSize, buffers);
        ErrorLogger.logError(message);
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        ExecutorService dbService = Executors.newFixedThreadPool(dbThreads);
        Semaphore permits = new Semaphore(buffers);
        for (IndexManager indexManager : this.DNIndexMgrList) {
            futures.add(dbService.submit(new IndexDBWriteTask(indexManager, permits, buffers, readAheadSize)));
        }
        for (IndexManager indexManager : this.indexMgrList) {
            futures.add(dbService.submit(new IndexDBWriteTask(indexManager, permits, buffers, readAheadSize)));
        }
        for (Future future : futures) {
            if (future.isDone()) continue;
            future.get();
        }
        dbService.shutdown();
    }

    private void stopScratchFileWriters() {
        IndexOutputBuffer indexBuffer = new IndexOutputBuffer(0);
        for (ScratchFileWriterTask task : this.scratchFileWriterList) {
            task.queue.add(indexBuffer);
        }
    }

    @Override
    public void diskLowThresholdReached(DiskSpaceMonitor monitor) {
        this.diskFullThresholdReached(monitor);
    }

    @Override
    public void diskFullThresholdReached(DiskSpaceMonitor monitor) {
        this.isCanceled = true;
        Message msg = !this.isPhaseOneDone ? JebMessages.ERR_IMPORT_LDIF_LACK_DISK_PHASE_ONE.get(monitor.getDirectory().getPath(), monitor.getFreeSpace(), monitor.getLowThreshold()) : JebMessages.ERR_IMPORT_LDIF_LACK_DISK_PHASE_TWO.get(monitor.getDirectory().getPath(), monitor.getFreeSpace(), monitor.getLowThreshold());
        ErrorLogger.logError(msg);
    }

    @Override
    public void diskSpaceRestored(DiskSpaceMonitor monitor) {
    }

    static {
        indexComparator = new IndexOutputBuffer.IndexComparator();
        dnType = DirectoryServer.getAttributeType("dn");
        if (dnType == null) {
            dnType = DirectoryServer.getDefaultAttributeType("dn");
        }
    }

    public final class TmpEnv
    implements DNCache {
        private String envPath;
        private Environment environment;
        private static final String DB_NAME = "dn_cache";
        private Database dnCache;
        private static final long FNV_INIT = -3750763034362895579L;
        private static final long FNV_PRIME = 1099511628211L;

        public TmpEnv(File envPath) throws DatabaseException {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setConfigParam("je.env.runCleaner", "true");
            envConfig.setReadOnly(false);
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(false);
            envConfig.setConfigParam("je.env.isLocking", "true");
            envConfig.setConfigParam("je.env.runCheckpointer", "false");
            envConfig.setConfigParam("je.evictor.lruOnly", "false");
            envConfig.setConfigParam("je.evictor.nodesPerScan", "128");
            envConfig.setConfigParam("je.maxMemory", Long.toString(Importer.this.tmpEnvCacheSize));
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(false);
            dbConfig.setTemporary(true);
            this.environment = new Environment(envPath, envConfig);
            this.dnCache = this.environment.openDatabase(null, DB_NAME, dbConfig);
            this.envPath = envPath.getPath();
        }

        private byte[] hashCode(byte[] b) {
            long hash = -3750763034362895579L;
            for (byte aB : b) {
                hash ^= (long)aB;
                hash *= 1099511628211L;
            }
            return JebFormat.entryIDToDatabase(hash);
        }

        public void shutdown() throws JebException {
            this.dnCache.close();
            this.environment.close();
            EnvManager.removeFiles(this.envPath);
        }

        public boolean insert(DN dn, DatabaseEntry val, DatabaseEntry key) throws JebException {
            byte[] dnBytes = StaticUtils.getBytes(dn.toNormalizedString());
            int len = PackedInteger.getWriteIntLength((int)dnBytes.length);
            byte[] dataBytes = new byte[dnBytes.length + len];
            int pos = PackedInteger.writeInt((byte[])dataBytes, (int)0, (int)dnBytes.length);
            System.arraycopy(dnBytes, 0, dataBytes, pos, dnBytes.length);
            val.setData(dataBytes);
            key.setData(this.hashCode(dnBytes));
            return this.insert(key, val, dnBytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean insert(DatabaseEntry key, DatabaseEntry val, byte[] dnBytes) throws JebException {
            boolean inserted = true;
            Cursor cursor = null;
            try {
                cursor = this.dnCache.openCursor(null, CursorConfig.DEFAULT);
                OperationStatus status = cursor.putNoOverwrite(key, val);
                if (status == OperationStatus.KEYEXIST) {
                    DatabaseEntry dns = new DatabaseEntry();
                    inserted = false;
                    status = cursor.getSearchKey(key, dns, LockMode.RMW);
                    if (status == OperationStatus.NOTFOUND) {
                        Message message = Message.raw(Category.JEB, Severity.SEVERE_ERROR, "Search DN cache failed.", new Object[0]);
                        throw new JebException(message);
                    }
                    if (!this.isDNMatched(dns, dnBytes)) {
                        this.addDN(dns, cursor, dnBytes);
                        inserted = true;
                    }
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return inserted;
        }

        private void addDN(DatabaseEntry val, Cursor cursor, byte[] dnBytes) throws JebException {
            byte[] bytes = val.getData();
            int pLen = PackedInteger.getWriteIntLength((int)dnBytes.length);
            int totLen = bytes.length + (pLen + dnBytes.length);
            byte[] newRec = new byte[totLen];
            System.arraycopy(bytes, 0, newRec, 0, bytes.length);
            int pos = bytes.length;
            pos = PackedInteger.writeInt((byte[])newRec, (int)pos, (int)dnBytes.length);
            System.arraycopy(dnBytes, 0, newRec, pos, dnBytes.length);
            DatabaseEntry newVal = new DatabaseEntry(newRec);
            OperationStatus status = cursor.putCurrent(newVal);
            if (status != OperationStatus.SUCCESS) {
                Message message = Message.raw(Category.JEB, Severity.SEVERE_ERROR, "Add of DN to DN cache failed.", new Object[0]);
                throw new JebException(message);
            }
        }

        private boolean isDNMatched(DatabaseEntry dns, byte[] dnBytes) {
            int len;
            int pLen;
            byte[] bytes = dns.getData();
            for (int pos = 0; pos < dns.getData().length; pos += pLen + len) {
                pLen = PackedInteger.getReadIntLength((byte[])bytes, (int)pos);
                if (indexComparator.compare(bytes, pos + pLen, len = PackedInteger.readInt((byte[])bytes, (int)pos), dnBytes, dnBytes.length) != 0) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(DN dn) {
            boolean dnExists = false;
            Cursor cursor = null;
            DatabaseEntry key = new DatabaseEntry();
            byte[] dnBytes = StaticUtils.getBytes(dn.toNormalizedString());
            key.setData(this.hashCode(dnBytes));
            try {
                cursor = this.dnCache.openCursor(null, CursorConfig.DEFAULT);
                DatabaseEntry dns = new DatabaseEntry();
                OperationStatus status = cursor.getSearchKey(key, dns, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS) {
                    dnExists = this.isDNMatched(dns, dnBytes);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return dnExists;
        }

        public EnvironmentStats getEnvironmentStats(StatsConfig statsConfig) throws DatabaseException {
            return this.environment.getStats(statsConfig);
        }
    }

    public static interface DNCache {
        public boolean contains(DN var1) throws DatabaseException;
    }

    public class IndexKey {
        private final AttributeType attributeType;
        private final ImportIndexType indexType;
        private final int entryLimit;

        IndexKey(AttributeType attributeType, ImportIndexType indexType, int entryLimit) {
            this.attributeType = attributeType;
            this.indexType = indexType;
            this.entryLimit = entryLimit;
        }

        public boolean equals(Object obj) {
            IndexKey oKey;
            return obj instanceof IndexKey && this.attributeType.equals((oKey = (IndexKey)obj).getAttributeType()) && this.indexType.equals((Object)oKey.getIndexType());
        }

        public int hashCode() {
            return this.attributeType.hashCode() + this.indexType.hashCode();
        }

        public AttributeType getAttributeType() {
            return this.attributeType;
        }

        public ImportIndexType getIndexType() {
            return this.indexType;
        }

        public String getName() {
            return this.attributeType.getPrimaryName() + "." + StaticUtils.toLowerCase(this.indexType.name());
        }

        public int getEntryLimit() {
            return this.entryLimit;
        }
    }

    public static enum ImportIndexType {
        DN,
        EQUALITY,
        PRESENCE,
        SUBSTRING,
        ORDERING,
        APPROXIMATE,
        EX_SUBSTRING,
        EX_SHARED,
        VLV;

    }

    public class EntryInformation {
        private EntryID entryID;
        private Suffix suffix;

        public Suffix getSuffix() {
            return this.suffix;
        }

        public void setSuffix(Suffix suffix) {
            this.suffix = suffix;
        }

        public void setEntryID(EntryID entryID) {
            this.entryID = entryID;
        }

        public EntryID getEntryID() {
            return this.entryID;
        }
    }

    private class SecondPhaseProgressTask
    extends TimerTask {
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats previousStats;
        private boolean evicting = false;
        private long latestCount;

        public SecondPhaseProgressTask(long latestCount) {
            this.latestCount = latestCount;
            try {
                this.previousStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            long deltaCount = this.latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            try {
                Runtime runTime = Runtime.getRuntime();
                long freeMemory = runTime.freeMemory() / 0x100000L;
                EnvironmentStats environmentStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = environmentStats.getNCacheMiss() - this.previousStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                Message message = JebMessages.NOTE_JEB_IMPORT_CACHE_AND_MEMORY_REPORT.get(freeMemory, Float.valueOf(cacheMissRate));
                ErrorLogger.logError(message);
                long evictPasses = environmentStats.getNEvictPasses();
                long evictNodes = environmentStats.getNNodesExplicitlyEvicted();
                long evictBinsStrip = environmentStats.getNBINsStripped();
                long cleanerRuns = environmentStats.getNCleanerRuns();
                long cleanerDeletions = environmentStats.getNCleanerDeletions();
                long cleanerEntriesRead = environmentStats.getNCleanerEntriesRead();
                long cleanerINCleaned = environmentStats.getNINsCleaned();
                long checkPoints = environmentStats.getNCheckpoints();
                if (evictPasses != 0L) {
                    if (!this.evicting) {
                        this.evicting = true;
                    }
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED_STATS.get(evictPasses, evictNodes, evictBinsStrip);
                    ErrorLogger.logError(message);
                }
                if (cleanerRuns != 0L) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_CLEANER_STATS.get(cleanerRuns, cleanerDeletions, cleanerEntriesRead, cleanerINCleaned);
                    ErrorLogger.logError(message);
                }
                if (checkPoints > 1L) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_CHECKPOINTS.get(checkPoints);
                    ErrorLogger.logError(message);
                }
                this.previousStats = environmentStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousCount = this.latestCount;
            this.previousTime = latestTime;
            for (IndexManager indexMgrDN : Importer.this.DNIndexMgrList) {
                indexMgrDN.printStats(deltaTime);
            }
            for (IndexManager indexMgr : Importer.this.indexMgrList) {
                indexMgr.printStats(deltaTime);
            }
        }
    }

    private final class FirstPhaseProgressTask
    extends TimerTask {
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats previousStats;
        private boolean evicting = false;
        private long evictionEntryCount = 0L;

        public FirstPhaseProgressTask() {
            try {
                this.previousStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            long latestCount = Importer.this.reader.getEntriesRead() + 0L;
            long deltaCount = latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            long entriesRead = Importer.this.reader.getEntriesRead();
            long entriesIgnored = Importer.this.reader.getEntriesIgnored();
            long entriesRejected = Importer.this.reader.getEntriesRejected();
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            Message message = JebMessages.NOTE_JEB_IMPORT_PROGRESS_REPORT.get(entriesRead, entriesIgnored, entriesRejected, 0, Float.valueOf(rate));
            ErrorLogger.logError(message);
            try {
                Runtime runTime = Runtime.getRuntime();
                long freeMemory = runTime.freeMemory() / 0x100000L;
                EnvironmentStats environmentStats = Importer.this.skipDNValidation ? Importer.this.rootContainer.getEnvironmentStats(new StatsConfig()) : Importer.this.tmpEnv.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = environmentStats.getNCacheMiss() - this.previousStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                message = JebMessages.NOTE_JEB_IMPORT_CACHE_AND_MEMORY_REPORT.get(freeMemory, Float.valueOf(cacheMissRate));
                ErrorLogger.logError(message);
                long evictPasses = environmentStats.getNEvictPasses();
                long evictNodes = environmentStats.getNNodesExplicitlyEvicted();
                long evictBinsStrip = environmentStats.getNBINsStripped();
                long cleanerRuns = environmentStats.getNCleanerRuns();
                long cleanerDeletions = environmentStats.getNCleanerDeletions();
                long cleanerEntriesRead = environmentStats.getNCleanerEntriesRead();
                long cleanerINCleaned = environmentStats.getNINsCleaned();
                long checkPoints = environmentStats.getNCheckpoints();
                if (evictPasses != 0L) {
                    if (!this.evicting) {
                        this.evicting = true;
                        this.evictionEntryCount = Importer.this.reader.getEntriesRead();
                        message = JebMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED.get(this.evictionEntryCount);
                        ErrorLogger.logError(message);
                    }
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED_STATS.get(evictPasses, evictNodes, evictBinsStrip);
                    ErrorLogger.logError(message);
                }
                if (cleanerRuns != 0L) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_CLEANER_STATS.get(cleanerRuns, cleanerDeletions, cleanerEntriesRead, cleanerINCleaned);
                    ErrorLogger.logError(message);
                }
                if (checkPoints > 1L) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_CHECKPOINTS.get(checkPoints);
                    ErrorLogger.logError(message);
                }
                this.previousStats = environmentStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousCount = latestCount;
            this.previousTime = latestTime;
        }
    }

    private class RebuildFirstPhaseProgressTask
    extends TimerTask {
        private long previousProcessed = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats prevEnvStats;

        public RebuildFirstPhaseProgressTask() throws DatabaseException {
            this.prevEnvStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
        }

        @Override
        public void run() {
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            long entriesProcessed = Importer.this.rebuildManager.getEntriesProcess();
            long deltaCount = entriesProcessed - this.previousProcessed;
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            float completed = 0.0f;
            if (Importer.this.rebuildManager.getTotEntries() > 0L) {
                completed = 100.0f * (float)entriesProcessed / (float)Importer.this.rebuildManager.getTotEntries();
            }
            Message message = JebMessages.NOTE_JEB_REBUILD_PROGRESS_REPORT.get(Float.valueOf(completed), entriesProcessed, Importer.this.rebuildManager.getTotEntries(), Float.valueOf(rate));
            ErrorLogger.logError(message);
            try {
                Runtime runtime = Runtime.getRuntime();
                long freeMemory = runtime.freeMemory() / 0x100000L;
                EnvironmentStats envStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = envStats.getNCacheMiss() - this.prevEnvStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                message = JebMessages.NOTE_JEB_REBUILD_CACHE_AND_MEMORY_REPORT.get(freeMemory, Float.valueOf(cacheMissRate));
                ErrorLogger.logError(message);
                this.prevEnvStats = envStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousProcessed = entriesProcessed;
            this.previousTime = latestTime;
        }
    }

    private class RebuildIndexManager
    extends ImportTask
    implements DiskSpaceMonitorHandler {
        private final RebuildConfig rebuildConfig;
        private final LocalDBBackendCfg cfg;
        private final Map<IndexKey, Index> indexMap;
        private final Map<IndexKey, Collection<Index>> extensibleIndexMap;
        private final List<VLVIndex> vlvIndexes;
        private DN2ID dn2id;
        private DN2URI dn2uri;
        private long totalEntries;
        private final AtomicLong entriesProcessed;
        private Suffix suffix;
        private EntryContainer entryContainer;

        public RebuildIndexManager(RebuildConfig rebuildConfig, LocalDBBackendCfg cfg) {
            this.indexMap = new LinkedHashMap<IndexKey, Index>();
            this.extensibleIndexMap = new LinkedHashMap<IndexKey, Collection<Index>>();
            this.vlvIndexes = new LinkedList<VLVIndex>();
            this.dn2id = null;
            this.dn2uri = null;
            this.totalEntries = 0L;
            this.entriesProcessed = new AtomicLong(0L);
            this.suffix = null;
            this.rebuildConfig = rebuildConfig;
            this.cfg = cfg;
        }

        public void initialize() throws ConfigException, InitializationException {
            this.entryContainer = Importer.this.rootContainer.getEntryContainer(this.rebuildConfig.getBaseDN());
            this.suffix = Suffix.createSuffixContext(this.entryContainer, null, null, null);
            if (this.suffix == null) {
                Message msg = JebMessages.ERR_JEB_REBUILD_SUFFIX_ERROR.get(this.rebuildConfig.getBaseDN().toString());
                throw new InitializationException(msg);
            }
        }

        public void printStartMessage() throws DatabaseException {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> rebuildList = this.rebuildConfig.getRebuildList();
            for (String index : rebuildList) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(index);
            }
            this.totalEntries = this.suffix.getID2Entry().getRecordCount();
            Message message = null;
            switch (this.rebuildConfig.getRebuildMode()) {
                case ALL: {
                    message = JebMessages.NOTE_JEB_REBUILD_ALL_START.get(this.totalEntries);
                    break;
                }
                case DEGRADED: {
                    message = JebMessages.NOTE_JEB_REBUILD_DEGRADED_START.get(this.totalEntries);
                    break;
                }
                default: {
                    if (this.rebuildConfig.isClearDegradedState()) break;
                    message = JebMessages.NOTE_JEB_REBUILD_START.get(sb.toString(), this.totalEntries);
                }
            }
            if (message != null) {
                ErrorLogger.logError(message);
            }
        }

        public void printStopMessage(long startTime) {
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            float rate = 0.0f;
            if (totalTime > 0L) {
                rate = 1000.0f * (float)this.entriesProcessed.get() / (float)totalTime;
            }
            if (!this.rebuildConfig.isClearDegradedState()) {
                Message message = JebMessages.NOTE_JEB_REBUILD_FINAL_STATUS.get(this.entriesProcessed.get(), totalTime / 1000L, Float.valueOf(rate));
                ErrorLogger.logError(message);
            }
        }

        @Override
        public Void call() throws Exception {
            ID2Entry id2entry = this.entryContainer.getID2Entry();
            DiskOrderedCursor cursor = id2entry.openCursor(DiskOrderedCursorConfig.DEFAULT);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            try {
                while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                    if (Importer.this.isCanceled) {
                        Void void_ = null;
                        return void_;
                    }
                    EntryID entryID = new EntryID(key);
                    Entry entry = ID2Entry.entryFromDatabase(ByteString.wrap(data.getData()), this.entryContainer.getRootContainer().getCompressedSchema());
                    this.processEntry(entry, entryID);
                    this.entriesProcessed.getAndIncrement();
                }
                this.flushIndexBuffers();
                cursor.close();
            }
            catch (Exception e) {
                Message message = JebMessages.ERR_JEB_IMPORT_LDIF_REBUILD_INDEX_TASK_ERR.get(e.getMessage());
                ErrorLogger.logError(message);
                Importer.this.isCanceled = true;
                throw e;
            }
            finally {
                cursor.close();
            }
            return null;
        }

        public void rebuildIndexes() throws DatabaseException, InterruptedException, ExecutionException, JebException {
            this.setIndexesListsToBeRebuilt();
            if (!this.rebuildConfig.isClearDegradedState()) {
                this.setRebuildListIndexesTrusted(false);
                this.clearIndexes(true);
                this.phaseOne();
                if (Importer.this.isCanceled) {
                    throw new InterruptedException("Rebuild Index canceled.");
                }
                this.phaseTwo();
            } else {
                Message message = JebMessages.NOTE_JEB_REBUILD_CLEARDEGRADEDSTATE_FINAL_STATUS.get(this.rebuildConfig.getRebuildList().toString());
                ErrorLogger.logError(message);
            }
            this.setRebuildListIndexesTrusted(true);
        }

        private void setIndexesListsToBeRebuilt() throws JebException {
            RebuildConfig.RebuildMode mode = this.rebuildConfig.getRebuildMode();
            switch (mode) {
                case ALL: {
                    this.rebuildIndexMap(false);
                }
                case DEGRADED: {
                    if (mode == RebuildConfig.RebuildMode.ALL || !this.entryContainer.getID2Children().isTrusted() || !this.entryContainer.getID2Subtree().isTrusted()) {
                        this.dn2id = this.entryContainer.getDN2ID();
                    }
                    if (mode == RebuildConfig.RebuildMode.ALL || this.entryContainer.getDN2URI() == null) {
                        this.dn2uri = this.entryContainer.getDN2URI();
                    }
                    if (mode == RebuildConfig.RebuildMode.DEGRADED || this.entryContainer.getAttributeIndexes().isEmpty()) {
                        this.rebuildIndexMap(true);
                    }
                    if (mode != RebuildConfig.RebuildMode.ALL && !this.vlvIndexes.isEmpty()) break;
                    this.vlvIndexes.addAll(new LinkedList<VLVIndex>(this.entryContainer.getVLVIndexes()));
                    break;
                }
                case USER_DEFINED: {
                    this.rebuildIndexMap(false);
                    break;
                }
            }
        }

        private void rebuildIndexMap(boolean onlyDegraded) {
            ArrayList<String> rebuildList = this.rebuildConfig.getRebuildList();
            for (Map.Entry<AttributeType, AttributeIndex> mapEntry : this.suffix.getAttrIndexMap().entrySet()) {
                AttributeType attributeType = mapEntry.getKey();
                AttributeIndex attributeIndex = mapEntry.getValue();
                if (this.rebuildConfig.getRebuildMode() == RebuildConfig.RebuildMode.ALL || this.rebuildConfig.getRebuildMode() == RebuildConfig.RebuildMode.DEGRADED) {
                    this.rebuildAttributeIndexes(attributeIndex, attributeType, onlyDegraded);
                    continue;
                }
                if (rebuildList.isEmpty()) continue;
                for (String index : rebuildList) {
                    if (!attributeType.getNameOrOID().toLowerCase().equals(index.toLowerCase())) continue;
                    this.rebuildAttributeIndexes(attributeIndex, attributeType, onlyDegraded);
                }
            }
        }

        private void rebuildAttributeIndexes(AttributeIndex attrIndex, AttributeType attrType, boolean onlyDegraded) throws DatabaseException {
            Map<String, Collection<Index>> extensibleMap;
            if (attrIndex.getSubstringIndex() != null) {
                this.fillIndexMap(attrType, attrIndex.getSubstringIndex(), ImportIndexType.SUBSTRING, onlyDegraded);
            }
            if (attrIndex.getOrderingIndex() != null) {
                this.fillIndexMap(attrType, attrIndex.getOrderingIndex(), ImportIndexType.ORDERING, onlyDegraded);
            }
            if (attrIndex.getEqualityIndex() != null) {
                this.fillIndexMap(attrType, attrIndex.getEqualityIndex(), ImportIndexType.EQUALITY, onlyDegraded);
            }
            if (attrIndex.getPresenceIndex() != null) {
                this.fillIndexMap(attrType, attrIndex.getPresenceIndex(), ImportIndexType.PRESENCE, onlyDegraded);
            }
            if (attrIndex.getApproximateIndex() != null) {
                this.fillIndexMap(attrType, attrIndex.getApproximateIndex(), ImportIndexType.APPROXIMATE, onlyDegraded);
            }
            if (!(extensibleMap = attrIndex.getExtensibleIndexes()).isEmpty()) {
                Collection<Index> sharedIndexes;
                Collection<Index> subIndexes = attrIndex.getExtensibleIndexes().get("substring");
                if (subIndexes != null && !subIndexes.isEmpty()) {
                    LinkedList<Index> mutableCopy = new LinkedList<Index>(subIndexes);
                    Iterator i = mutableCopy.iterator();
                    while (i.hasNext()) {
                        Index subIndex = (Index)i.next();
                        if (!onlyDegraded || !subIndex.isTrusted()) {
                            if ((!this.rebuildConfig.isClearDegradedState() || subIndex.getRecordCount() != 0L) && this.rebuildConfig.isClearDegradedState()) continue;
                            int id = System.identityHashCode(subIndex);
                            Importer.this.idContainerMap.putIfAbsent(id, subIndex);
                            continue;
                        }
                        i.remove();
                    }
                    if (!mutableCopy.isEmpty()) {
                        this.extensibleIndexMap.put(new IndexKey(attrType, ImportIndexType.EX_SUBSTRING, 0), mutableCopy);
                    }
                }
                if ((sharedIndexes = attrIndex.getExtensibleIndexes().get("shared")) != null && !sharedIndexes.isEmpty()) {
                    LinkedList<Index> mutableCopy = new LinkedList<Index>(sharedIndexes);
                    Iterator i = mutableCopy.iterator();
                    while (i.hasNext()) {
                        Index sharedIndex = (Index)i.next();
                        if (!onlyDegraded || !sharedIndex.isTrusted()) {
                            if ((!this.rebuildConfig.isClearDegradedState() || sharedIndex.getRecordCount() != 0L) && this.rebuildConfig.isClearDegradedState()) continue;
                            int id = System.identityHashCode(sharedIndex);
                            Importer.this.idContainerMap.putIfAbsent(id, sharedIndex);
                            continue;
                        }
                        i.remove();
                    }
                    if (!mutableCopy.isEmpty()) {
                        this.extensibleIndexMap.put(new IndexKey(attrType, ImportIndexType.EX_SHARED, 0), mutableCopy);
                    }
                }
            }
        }

        private void fillIndexMap(AttributeType attrType, Index partialAttrIndex, ImportIndexType importIndexType, boolean onlyDegraded) {
            if (!(onlyDegraded && partialAttrIndex.isTrusted() || (!this.rebuildConfig.isClearDegradedState() || partialAttrIndex.getRecordCount() != 0L) && this.rebuildConfig.isClearDegradedState())) {
                int id = System.identityHashCode(partialAttrIndex);
                Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                IndexKey indexKey = new IndexKey(attrType, importIndexType, partialAttrIndex.getIndexEntryLimit());
                this.indexMap.put(indexKey, partialAttrIndex);
            }
        }

        private void clearIndexes(boolean onlyDegraded) throws DatabaseException {
            if (!onlyDegraded) {
                this.entryContainer.clearDatabase(this.entryContainer.getDN2URI());
            }
            if (!(onlyDegraded && this.entryContainer.getID2Children().isTrusted() && this.entryContainer.getID2Subtree().isTrusted())) {
                this.entryContainer.clearDatabase(this.entryContainer.getDN2ID());
                this.entryContainer.clearDatabase(this.entryContainer.getID2Children());
                this.entryContainer.clearDatabase(this.entryContainer.getID2Subtree());
            }
            if (!this.indexMap.isEmpty()) {
                for (Map.Entry<IndexKey, Index> entry : this.indexMap.entrySet()) {
                    if (onlyDegraded && entry.getValue().isTrusted()) continue;
                    this.entryContainer.clearDatabase(entry.getValue());
                }
            }
            if (!this.extensibleIndexMap.isEmpty()) {
                for (Collection collection : this.extensibleIndexMap.values()) {
                    if (collection == null) continue;
                    for (Index subIndex : collection) {
                        this.entryContainer.clearDatabase(subIndex);
                    }
                }
            }
            for (VLVIndex vLVIndex : this.entryContainer.getVLVIndexes()) {
                if (onlyDegraded && vLVIndex.isTrusted()) continue;
                this.entryContainer.clearDatabase(vLVIndex);
            }
        }

        private void setRebuildListIndexesTrusted(boolean trusted) throws JebException {
            try {
                if (this.dn2id != null) {
                    EntryContainer ec = this.suffix.getEntryContainer();
                    ec.getID2Children().setTrusted(null, trusted);
                    ec.getID2Subtree().setTrusted(null, trusted);
                }
                if (!this.indexMap.isEmpty()) {
                    for (Map.Entry entry : this.indexMap.entrySet()) {
                        Index index = (Index)entry.getValue();
                        index.setTrusted(null, trusted);
                    }
                }
                if (!this.vlvIndexes.isEmpty()) {
                    for (VLVIndex vLVIndex : this.vlvIndexes) {
                        vLVIndex.setTrusted(null, trusted);
                    }
                }
                if (!this.extensibleIndexMap.isEmpty()) {
                    for (Collection collection : this.extensibleIndexMap.values()) {
                        if (collection == null) continue;
                        for (Index subIndex : collection) {
                            subIndex.setTrusted(null, trusted);
                        }
                    }
                }
            }
            catch (DatabaseException ex) {
                Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_TRUSTED_FAILED.get(ex.getMessage());
                throw new JebException(message);
            }
        }

        private void phaseOne() throws DatabaseException, InterruptedException, ExecutionException {
            Importer.this.initializeIndexBuffers();
            RebuildFirstPhaseProgressTask progressTask = new RebuildFirstPhaseProgressTask();
            Timer timer = new Timer();
            timer.scheduleAtFixedRate((TimerTask)progressTask, 10000L, 10000L);
            Importer.this.scratchFileWriterService = Executors.newFixedThreadPool(2 * Importer.this.indexCount);
            Importer.this.bufferSortService = Executors.newFixedThreadPool(Importer.this.threadCount);
            ExecutorService rebuildIndexService = Executors.newFixedThreadPool(Importer.this.threadCount);
            ArrayList<RebuildIndexManager> tasks = new ArrayList<RebuildIndexManager>(Importer.this.threadCount);
            for (int i = 0; i < Importer.this.threadCount; ++i) {
                tasks.add(this);
            }
            List results = rebuildIndexService.invokeAll(tasks);
            for (Future<Object> result : results) {
                if (result.isDone()) continue;
                result.get();
            }
            Importer.this.stopScratchFileWriters();
            for (Future<Object> result : Importer.this.scratchFileWriterFutures) {
                if (result.isDone()) continue;
                result.get();
            }
            rebuildIndexService.shutdown();
            rebuildIndexService.awaitTermination(30L, TimeUnit.SECONDS);
            Importer.this.bufferSortService.shutdown();
            Importer.this.bufferSortService.awaitTermination(30L, TimeUnit.SECONDS);
            Importer.this.scratchFileWriterService.shutdown();
            Importer.this.scratchFileWriterService.awaitTermination(30L, TimeUnit.SECONDS);
            timer.cancel();
            tasks.clear();
            results.clear();
            Importer.this.scratchFileWriterList.clear();
            Importer.this.scratchFileWriterFutures.clear();
            Importer.this.indexKeyQueMap.clear();
            Importer.this.freeBufferQueue.clear();
        }

        private void phaseTwo() throws InterruptedException, ExecutionException {
            SecondPhaseProgressTask progressTask = new SecondPhaseProgressTask(this.entriesProcessed.get());
            Timer timer2 = new Timer();
            timer2.scheduleAtFixedRate((TimerTask)progressTask, 10000L, 10000L);
            Importer.this.processIndexFiles();
            timer2.cancel();
        }

        private int getIndexCount() throws ConfigException, JebException, InitializationException {
            switch (this.rebuildConfig.getRebuildMode()) {
                case ALL: {
                    return Importer.this.getTotalIndexCount(this.cfg);
                }
                case DEGRADED: {
                    return Importer.this.getTotalIndexCount(this.cfg);
                }
            }
            return this.getRebuildListIndexCount(this.cfg);
        }

        private int getRebuildListIndexCount(LocalDBBackendCfg cfg) throws JebException, ConfigException, InitializationException {
            int indexCount = 0;
            ArrayList<String> rebuildList = this.rebuildConfig.getRebuildList();
            if (!rebuildList.isEmpty()) {
                for (String index : rebuildList) {
                    boolean found;
                    Message msg;
                    String lowerName = index.toLowerCase();
                    if (lowerName.equals("dn2id")) {
                        indexCount += 3;
                        continue;
                    }
                    if (lowerName.equals("dn2uri")) {
                        ++indexCount;
                        continue;
                    }
                    if (lowerName.startsWith("vlv.")) {
                        if (lowerName.length() < 5) {
                            msg = JebMessages.ERR_JEB_VLV_INDEX_NOT_CONFIGURED.get(lowerName);
                            throw new JebException(msg);
                        }
                        ++indexCount;
                        continue;
                    }
                    if (lowerName.equals("id2subtree") || lowerName.equals("id2children")) {
                        msg = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                        throw new InitializationException(msg);
                    }
                    String[] attrIndexParts = lowerName.split("\\.");
                    if (attrIndexParts.length <= 0 || attrIndexParts.length > 3) {
                        Message msg2 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                        throw new InitializationException(msg2);
                    }
                    AttributeType attrType = DirectoryServer.getAttributeType(attrIndexParts[0]);
                    if (attrType == null) {
                        Message msg3 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                        throw new InitializationException(msg3);
                    }
                    if (attrIndexParts.length != 1) {
                        if (attrIndexParts.length == 2) {
                            if (attrIndexParts[1].equals("presence")) {
                                ++indexCount;
                                continue;
                            }
                            if (attrIndexParts[1].equals("equality")) {
                                ++indexCount;
                                continue;
                            }
                            if (attrIndexParts[1].equals("substring")) {
                                ++indexCount;
                                continue;
                            }
                            if (attrIndexParts[1].equals("ordering")) {
                                ++indexCount;
                                continue;
                            }
                            if (attrIndexParts[1].equals("approximate")) {
                                ++indexCount;
                                continue;
                            }
                            Message msg4 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                            throw new InitializationException(msg4);
                        }
                        found = false;
                        String s = attrIndexParts[1] + "." + attrIndexParts[2];
                        for (String idx : cfg.listLocalDBIndexes()) {
                            LocalDBIndexCfg indexCfg = cfg.getLocalDBIndex(idx);
                            if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.EXTENSIBLE)) {
                                SortedSet<String> extensibleRules = indexCfg.getIndexExtensibleMatchingRule();
                                for (String exRule : extensibleRules) {
                                    if (!exRule.equalsIgnoreCase(s)) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (found) break;
                        }
                        if (!found) {
                            Message msg5 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                            throw new InitializationException(msg5);
                        }
                        ++indexCount;
                        continue;
                    }
                    found = false;
                    for (String idx : cfg.listLocalDBIndexes()) {
                        if (!idx.equalsIgnoreCase(index)) continue;
                        found = true;
                        LocalDBIndexCfg indexCfg = cfg.getLocalDBIndex(idx);
                        if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.EQUALITY)) {
                            ++indexCount;
                        }
                        if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.ORDERING)) {
                            ++indexCount;
                        }
                        if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.PRESENCE)) {
                            ++indexCount;
                        }
                        if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.SUBSTRING)) {
                            ++indexCount;
                        }
                        if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.APPROXIMATE)) {
                            ++indexCount;
                        }
                        if (!indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.EXTENSIBLE)) continue;
                        SortedSet<String> extensibleRules = indexCfg.getIndexExtensibleMatchingRule();
                        boolean shared = false;
                        for (String exRule : extensibleRules) {
                            if (exRule.endsWith(".sub")) {
                                ++indexCount;
                                continue;
                            }
                            if (shared) continue;
                            shared = true;
                            ++indexCount;
                        }
                    }
                    if (found) continue;
                    Message msg6 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                    throw new InitializationException(msg6);
                }
            }
            return indexCount;
        }

        private void processEntry(Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException, InterruptedException {
            if (this.dn2id != null) {
                this.processDN2ID(this.suffix, entry.getDN(), entryID);
            }
            if (this.dn2uri != null) {
                this.processDN2URI(this.suffix, null, entry);
            }
            this.processIndexes(entry, entryID);
            this.processExtensibleIndexes(entry, entryID);
            this.processVLVIndexes(entry, entryID);
        }

        private void processVLVIndexes(Entry entry, EntryID entryID) throws DatabaseException, JebException, DirectoryException {
            for (VLVIndex vlvIdx : this.suffix.getEntryContainer().getVLVIndexes()) {
                Transaction transaction = null;
                vlvIdx.addEntry(transaction, entryID, entry);
            }
        }

        private void processExtensibleIndexes(Entry entry, EntryID entryID) throws InterruptedException {
            for (Map.Entry<IndexKey, Collection<Index>> mapEntry : this.extensibleIndexMap.entrySet()) {
                IndexKey key = mapEntry.getKey();
                AttributeType attrType = key.getAttributeType();
                if (!entry.hasAttribute(attrType)) continue;
                Collection<Index> indexes = mapEntry.getValue();
                for (Index index : indexes) {
                    this.processAttribute(index, entry, entryID, key);
                }
            }
        }

        private void processIndexes(Entry entry, EntryID entryID) throws DatabaseException, InterruptedException {
            for (Map.Entry<IndexKey, Index> mapEntry : this.indexMap.entrySet()) {
                IndexKey key = mapEntry.getKey();
                AttributeType attrType = key.getAttributeType();
                if (!entry.hasAttribute(attrType)) continue;
                ImportIndexType indexType = key.getIndexType();
                Index index = mapEntry.getValue();
                if (indexType == ImportIndexType.SUBSTRING) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attrType, ImportIndexType.SUBSTRING, index.getIndexEntryLimit()));
                    continue;
                }
                this.processAttribute(index, entry, entryID, new IndexKey(attrType, indexType, index.getIndexEntryLimit()));
            }
        }

        public long getEntriesProcess() {
            return this.entriesProcessed.get();
        }

        public long getTotEntries() {
            return this.totalEntries;
        }

        @Override
        public void diskLowThresholdReached(DiskSpaceMonitor monitor) {
            this.diskFullThresholdReached(monitor);
        }

        @Override
        public void diskFullThresholdReached(DiskSpaceMonitor monitor) {
            Importer.this.isCanceled = true;
            Message msg = JebMessages.ERR_REBUILD_INDEX_LACK_DISK.get(monitor.getDirectory().getPath(), monitor.getFreeSpace(), monitor.getLowThreshold());
            ErrorLogger.logError(msg);
        }

        @Override
        public void diskSpaceRestored(DiskSpaceMonitor monitor) {
        }
    }

    final class IndexManager
    implements Comparable<IndexManager> {
        private final File bufferFile;
        private final String bufferFileName;
        private final File bufferIndexFile;
        private final String bufferIndexFileName;
        private long bufferFileSize;
        private long totalDNS;
        private final boolean isDN;
        private final int limit;
        private int numberOfBuffers = 0;
        private volatile IndexDBWriteTask writer = null;

        private IndexManager(String fileName, boolean isDN, int limit) {
            this.bufferFileName = fileName;
            this.bufferIndexFileName = fileName + ".index";
            this.bufferFile = new File(Importer.this.tempDir, this.bufferFileName);
            this.bufferIndexFile = new File(Importer.this.tempDir, this.bufferIndexFileName);
            this.isDN = isDN;
            this.limit = limit > 0 ? limit : Integer.MAX_VALUE;
        }

        private void setIndexDBWriteTask(IndexDBWriteTask writer) {
            this.writer = writer;
        }

        private File getBufferFile() {
            return this.bufferFile;
        }

        private long getBufferFileSize() {
            return this.bufferFileSize;
        }

        private File getBufferIndexFile() {
            return this.bufferIndexFile;
        }

        private void setBufferInfo(int numberOfBuffers, long bufferFileSize) {
            this.numberOfBuffers = numberOfBuffers;
            this.bufferFileSize = bufferFileSize;
        }

        void addBytesRead(int bytesRead) {
            if (this.writer != null) {
                this.writer.addBytesRead(bytesRead);
            }
        }

        private void addTotDNCount(int delta) {
            this.totalDNS += (long)delta;
        }

        private long getDNCount() {
            return this.totalDNS;
        }

        private boolean isDN2ID() {
            return this.isDN;
        }

        private void printStats(long deltaTime) {
            if (this.writer != null) {
                this.writer.printStats(deltaTime);
            }
        }

        String getBufferFileName() {
            return this.bufferFileName;
        }

        private int getLimit() {
            return this.limit;
        }

        @Override
        public int compareTo(IndexManager mgr) {
            return this.numberOfBuffers - mgr.numberOfBuffers;
        }

        private int getNumberOfBuffers() {
            return this.numberOfBuffers;
        }
    }

    private final class SortTask
    implements Callable<Void> {
        private final IndexOutputBuffer indexBuffer;

        public SortTask(IndexOutputBuffer indexBuffer) {
            this.indexBuffer = indexBuffer;
        }

        @Override
        public Void call() throws Exception {
            if (Importer.this.importConfiguration != null && Importer.this.importConfiguration.isCancelled() || Importer.this.isCanceled) {
                Importer.this.isCanceled = true;
                return null;
            }
            this.indexBuffer.sort();
            if (Importer.this.indexKeyQueMap.containsKey(this.indexBuffer.getIndexKey())) {
                BlockingQueue q = (BlockingQueue)Importer.this.indexKeyQueMap.get(this.indexBuffer.getIndexKey());
                q.add(this.indexBuffer);
            } else {
                this.createIndexWriterTask(this.indexBuffer.getIndexKey());
                BlockingQueue q = (BlockingQueue)Importer.this.indexKeyQueMap.get(this.indexBuffer.getIndexKey());
                q.add(this.indexBuffer);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createIndexWriterTask(IndexKey indexKey) throws FileNotFoundException {
            boolean isDN = false;
            Object object = Importer.this.synObj;
            synchronized (object) {
                if (Importer.this.indexKeyQueMap.containsKey(indexKey)) {
                    return;
                }
                if (indexKey.getIndexType().equals((Object)ImportIndexType.DN)) {
                    isDN = true;
                }
                IndexManager indexMgr = new IndexManager(indexKey.getName(), isDN, indexKey.getEntryLimit());
                if (isDN) {
                    Importer.this.DNIndexMgrList.add(indexMgr);
                } else {
                    Importer.this.indexMgrList.add(indexMgr);
                }
                ArrayBlockingQueue<IndexOutputBuffer> newQue = new ArrayBlockingQueue<IndexOutputBuffer>(Importer.this.phaseOneBufferCount);
                ScratchFileWriterTask indexWriter = new ScratchFileWriterTask(newQue, indexMgr);
                Importer.this.scratchFileWriterList.add(indexWriter);
                Importer.this.scratchFileWriterFutures.add(Importer.this.scratchFileWriterService.submit(indexWriter));
                Importer.this.indexKeyQueMap.put(indexKey, newQue);
            }
        }
    }

    private final class ScratchFileWriterTask
    implements Callable<Void> {
        private final int DRAIN_TO = 3;
        private final IndexManager indexMgr;
        private final BlockingQueue<IndexOutputBuffer> queue;
        private final ByteArrayOutputStream insertByteStream = new ByteArrayOutputStream(2 * Importer.access$1900(Importer.this));
        private final ByteArrayOutputStream deleteByteStream = new ByteArrayOutputStream(2 * Importer.access$1900(Importer.this));
        private final DataOutputStream bufferStream;
        private final DataOutputStream bufferIndexStream;
        private final byte[] tmpArray = new byte[8];
        private int insertKeyCount = 0;
        private int deleteKeyCount = 0;
        private int bufferCount = 0;
        private final SortedSet<IndexOutputBuffer> indexSortedSet;
        private boolean poisonSeen = false;

        public ScratchFileWriterTask(BlockingQueue<IndexOutputBuffer> queue, IndexManager indexMgr) throws FileNotFoundException {
            this.queue = queue;
            this.indexMgr = indexMgr;
            this.bufferStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexMgr.getBufferFile()), 8192));
            this.bufferIndexStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexMgr.getBufferIndexFile()), 8192));
            this.indexSortedSet = new TreeSet<IndexOutputBuffer>();
        }

        @Override
        public Void call() throws IOException, InterruptedException {
            long offset = 0L;
            LinkedList<IndexOutputBuffer> l = new LinkedList<IndexOutputBuffer>();
            try {
                do {
                    long bufferLen;
                    IndexOutputBuffer indexBuffer = this.queue.take();
                    long beginOffset = offset;
                    if (!this.queue.isEmpty()) {
                        this.queue.drainTo(l, 3);
                        l.add(indexBuffer);
                        bufferLen = this.writeIndexBuffers(l);
                        for (IndexOutputBuffer id : l) {
                            if (id.isDiscard()) continue;
                            id.reset();
                            Importer.this.freeBufferQueue.add(id);
                        }
                        l.clear();
                    } else {
                        if (indexBuffer.isPoison()) {
                            break;
                        }
                        bufferLen = this.writeIndexBuffer(indexBuffer);
                        if (!indexBuffer.isDiscard()) {
                            indexBuffer.reset();
                            Importer.this.freeBufferQueue.add(indexBuffer);
                        }
                    }
                    this.bufferIndexStream.writeLong(beginOffset);
                    this.bufferIndexStream.writeLong(offset += bufferLen);
                    ++this.bufferCount;
                    Importer.this.bufferCount.incrementAndGet();
                } while (!this.poisonSeen);
            }
            catch (IOException e) {
                Message message = JebMessages.ERR_JEB_IMPORT_LDIF_INDEX_FILEWRITER_ERR.get(this.indexMgr.getBufferFile().getAbsolutePath(), e.getMessage());
                ErrorLogger.logError(message);
                Importer.this.isCanceled = true;
                throw e;
            }
            finally {
                this.bufferStream.close();
                this.bufferIndexStream.close();
                this.indexMgr.setBufferInfo(this.bufferCount, this.indexMgr.getBufferFile().length());
            }
            return null;
        }

        private long writeIndexBuffer(IndexOutputBuffer indexBuffer) throws IOException {
            int numberKeys = indexBuffer.getNumberKeys();
            indexBuffer.setPosition(-1);
            long bufferLen = 0L;
            this.insertByteStream.reset();
            this.insertKeyCount = 0;
            this.deleteByteStream.reset();
            this.deleteKeyCount = 0;
            for (int i = 0; i < numberKeys; ++i) {
                if (indexBuffer.getPosition() == -1) {
                    indexBuffer.setPosition(i);
                    if (indexBuffer.isInsert(i)) {
                        indexBuffer.writeID(this.insertByteStream, i);
                        ++this.insertKeyCount;
                        continue;
                    }
                    indexBuffer.writeID(this.deleteByteStream, i);
                    ++this.deleteKeyCount;
                    continue;
                }
                if (!indexBuffer.compare(i)) {
                    bufferLen += (long)this.writeRecord(indexBuffer);
                    indexBuffer.setPosition(i);
                    this.insertByteStream.reset();
                    this.insertKeyCount = 0;
                    this.deleteByteStream.reset();
                    this.deleteKeyCount = 0;
                }
                if (indexBuffer.isInsert(i)) {
                    if (this.insertKeyCount++ > this.indexMgr.getLimit()) continue;
                    indexBuffer.writeID(this.insertByteStream, i);
                    continue;
                }
                indexBuffer.writeID(this.deleteByteStream, i);
                ++this.deleteKeyCount;
            }
            if (indexBuffer.getPosition() != -1) {
                bufferLen += (long)this.writeRecord(indexBuffer);
            }
            return bufferLen;
        }

        private long writeIndexBuffers(List<IndexOutputBuffer> buffers) throws IOException {
            long id = 0L;
            long bufferLen = 0L;
            this.insertByteStream.reset();
            this.insertKeyCount = 0;
            this.deleteByteStream.reset();
            this.deleteKeyCount = 0;
            for (IndexOutputBuffer b : buffers) {
                if (b.isPoison()) {
                    this.poisonSeen = true;
                    continue;
                }
                b.setPosition(0);
                b.setID(id++);
                this.indexSortedSet.add(b);
            }
            byte[] saveKey = null;
            int saveIndexID = 0;
            while (!this.indexSortedSet.isEmpty()) {
                IndexOutputBuffer b = this.indexSortedSet.first();
                this.indexSortedSet.remove(b);
                if (saveKey == null) {
                    saveKey = b.getKey();
                    saveIndexID = b.getIndexID();
                    if (b.isInsert(b.getPosition())) {
                        b.writeID(this.insertByteStream, b.getPosition());
                        ++this.insertKeyCount;
                    } else {
                        b.writeID(this.deleteByteStream, b.getPosition());
                        ++this.deleteKeyCount;
                    }
                } else if (!b.compare(saveKey, saveIndexID)) {
                    bufferLen += (long)this.writeRecord(saveKey, saveIndexID);
                    this.insertByteStream.reset();
                    this.deleteByteStream.reset();
                    this.insertKeyCount = 0;
                    this.deleteKeyCount = 0;
                    saveKey = b.getKey();
                    saveIndexID = b.getIndexID();
                    if (b.isInsert(b.getPosition())) {
                        b.writeID(this.insertByteStream, b.getPosition());
                        ++this.insertKeyCount;
                    } else {
                        b.writeID(this.deleteByteStream, b.getPosition());
                        ++this.deleteKeyCount;
                    }
                } else if (b.isInsert(b.getPosition())) {
                    if (this.insertKeyCount++ <= this.indexMgr.getLimit()) {
                        b.writeID(this.insertByteStream, b.getPosition());
                    }
                } else {
                    b.writeID(this.deleteByteStream, b.getPosition());
                    ++this.deleteKeyCount;
                }
                if (!b.hasMoreData()) continue;
                b.getNextRecord();
                this.indexSortedSet.add(b);
            }
            if (saveKey != null) {
                bufferLen += (long)this.writeRecord(saveKey, saveIndexID);
            }
            return bufferLen;
        }

        private int writeByteStreams() throws IOException {
            if (this.insertKeyCount > this.indexMgr.getLimit()) {
                this.insertKeyCount = 1;
                this.insertByteStream.reset();
                PackedInteger.writeInt((byte[])this.tmpArray, (int)0, (int)-1);
                this.insertByteStream.write(this.tmpArray, 0, 1);
            }
            int insertSize = PackedInteger.getWriteIntLength((int)this.insertKeyCount);
            PackedInteger.writeInt((byte[])this.tmpArray, (int)0, (int)this.insertKeyCount);
            this.bufferStream.write(this.tmpArray, 0, insertSize);
            if (this.insertByteStream.size() > 0) {
                this.insertByteStream.writeTo(this.bufferStream);
            }
            int deleteSize = PackedInteger.getWriteIntLength((int)this.deleteKeyCount);
            PackedInteger.writeInt((byte[])this.tmpArray, (int)0, (int)this.deleteKeyCount);
            this.bufferStream.write(this.tmpArray, 0, deleteSize);
            if (this.deleteByteStream.size() > 0) {
                this.deleteByteStream.writeTo(this.bufferStream);
            }
            return insertSize + deleteSize;
        }

        private int writeHeader(int indexID, int keySize) throws IOException {
            this.bufferStream.writeInt(indexID);
            int packedSize = PackedInteger.getWriteIntLength((int)keySize);
            PackedInteger.writeInt((byte[])this.tmpArray, (int)0, (int)keySize);
            this.bufferStream.write(this.tmpArray, 0, packedSize);
            return packedSize;
        }

        private int writeRecord(IndexOutputBuffer b) throws IOException {
            int keySize = b.getKeySize();
            int packedSize = this.writeHeader(b.getIndexID(), keySize);
            b.writeKey(this.bufferStream);
            return (packedSize += this.writeByteStreams()) + keySize + this.insertByteStream.size() + this.deleteByteStream.size() + 4;
        }

        private int writeRecord(byte[] k, int indexID) throws IOException {
            int packedSize = this.writeHeader(indexID, k.length);
            this.bufferStream.write(k);
            return (packedSize += this.writeByteStreams()) + k.length + this.insertByteStream.size() + this.deleteByteStream.size() + 4;
        }
    }

    private final class IndexDBWriteTask
    implements Callable<Void> {
        private final IndexManager indexMgr;
        private final DatabaseEntry dbKey;
        private final DatabaseEntry dbValue;
        private final int cacheSize;
        private final Map<Integer, DNState> dnStateMap = new HashMap<Integer, DNState>();
        private final Map<Integer, Index> indexMap = new HashMap<Integer, Index>();
        private final Semaphore permits;
        private final int maxPermits;
        private final AtomicLong bytesRead = new AtomicLong();
        private long lastBytesRead = 0L;
        private final AtomicInteger keyCount = new AtomicInteger();
        private RandomAccessFile bufferFile = null;
        private DataInputStream bufferIndexFile = null;
        private int remainingBuffers;
        private volatile int totalBatches;
        private AtomicInteger batchNumber = new AtomicInteger();
        private int nextBufferID;
        private int ownedPermits;
        private volatile boolean isRunning = false;

        public IndexDBWriteTask(IndexManager indexMgr, Semaphore permits, int maxPermits, int cacheSize) {
            this.indexMgr = indexMgr;
            this.permits = permits;
            this.maxPermits = maxPermits;
            this.cacheSize = cacheSize;
            this.dbKey = new DatabaseEntry();
            this.dbValue = new DatabaseEntry();
        }

        public void beginWriteTask() throws IOException {
            this.bufferFile = new RandomAccessFile(this.indexMgr.getBufferFile(), "r");
            this.bufferIndexFile = new DataInputStream(new BufferedInputStream(new FileInputStream(this.indexMgr.getBufferIndexFile())));
            this.remainingBuffers = this.indexMgr.getNumberOfBuffers();
            this.totalBatches = this.remainingBuffers / this.maxPermits + 1;
            this.batchNumber.set(0);
            this.nextBufferID = 0;
            this.ownedPermits = 0;
            Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_INDEX_STARTED.get(this.indexMgr.getBufferFileName(), this.remainingBuffers, this.totalBatches);
            ErrorLogger.logError(message);
            this.indexMgr.setIndexDBWriteTask(this);
            this.isRunning = true;
        }

        public NavigableSet<IndexInputBuffer> getNextBufferBatch() throws Exception {
            int permitRequest;
            if (this.ownedPermits > 0) {
                this.permits.release(this.ownedPermits);
                this.ownedPermits = 0;
            }
            if ((permitRequest = Math.min(this.remainingBuffers, this.maxPermits)) == 0) {
                return null;
            }
            this.permits.acquire(permitRequest);
            this.ownedPermits = permitRequest;
            this.remainingBuffers -= permitRequest;
            this.batchNumber.incrementAndGet();
            TreeSet<IndexInputBuffer> buffers = new TreeSet<IndexInputBuffer>();
            for (int i = 0; i < permitRequest; ++i) {
                long bufferBegin = this.bufferIndexFile.readLong();
                long bufferEnd = this.bufferIndexFile.readLong();
                IndexInputBuffer b = new IndexInputBuffer(this.indexMgr, this.bufferFile.getChannel(), bufferBegin, bufferEnd, this.nextBufferID++, this.cacheSize);
                buffers.add(b);
            }
            return buffers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endWriteTask() {
            this.isRunning = false;
            if (this.ownedPermits > 0) {
                this.permits.release(this.ownedPermits);
                this.ownedPermits = 0;
            }
            try {
                if (this.indexMgr.isDN2ID()) {
                    for (DNState dnState : this.dnStateMap.values()) {
                        dnState.flush();
                    }
                    if (!Importer.this.isCanceled) {
                        Message msg = JebMessages.NOTE_JEB_IMPORT_LDIF_DN_CLOSE.get(this.indexMgr.getDNCount());
                        ErrorLogger.logError(msg);
                    }
                } else {
                    for (Index index : this.indexMap.values()) {
                        index.closeCursor();
                    }
                    if (!Importer.this.isCanceled) {
                        Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_INDEX_CLOSE.get(this.indexMgr.getBufferFileName());
                        ErrorLogger.logError(message);
                    }
                }
            }
            finally {
                if (this.bufferFile != null) {
                    try {
                        this.bufferFile.close();
                    }
                    catch (IOException ignored) {}
                }
                if (this.bufferIndexFile != null) {
                    try {
                        this.bufferIndexFile.close();
                    }
                    catch (IOException iOException) {}
                }
                this.indexMgr.getBufferFile().delete();
                this.indexMgr.getBufferIndexFile().delete();
            }
        }

        public void printStats(long deltaTime) {
            if (this.isRunning) {
                long bufferFileSize = this.indexMgr.getBufferFileSize();
                long tmpBytesRead = this.bytesRead.get();
                int currentBatch = this.batchNumber.get();
                long bytesReadInterval = tmpBytesRead - this.lastBytesRead;
                int bytesReadPercent = Math.round(100.0f * (float)tmpBytesRead / (float)bufferFileSize);
                long kiloBytesRate = bytesReadInterval / deltaTime;
                long kiloBytesRemaining = (bufferFileSize - tmpBytesRead) / 1024L;
                Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_PHASE_TWO_REPORT.get(this.indexMgr.getBufferFileName(), bytesReadPercent, kiloBytesRemaining, kiloBytesRate, currentBatch, this.totalBatches);
                ErrorLogger.logError(message);
                this.lastBytesRead = tmpBytesRead;
            }
        }

        @Override
        public Void call() throws Exception, DirectoryException {
            ByteBuffer key = null;
            ImportIDSet insertIDSet = null;
            ImportIDSet deleteIDSet = null;
            Integer indexID = null;
            if (Importer.this.isCanceled) {
                return null;
            }
            try {
                NavigableSet<IndexInputBuffer> bufferSet;
                this.beginWriteTask();
                while ((bufferSet = this.getNextBufferBatch()) != null) {
                    if (Importer.this.isCanceled) {
                        Void void_ = null;
                        return void_;
                    }
                    while (!bufferSet.isEmpty()) {
                        boolean doCount;
                        int limit;
                        Index index;
                        IndexInputBuffer b = bufferSet.pollFirst();
                        if (key == null) {
                            indexID = b.getIndexID();
                            if (this.indexMgr.isDN2ID()) {
                                insertIDSet = new ImportIDSet(1, 1, false);
                                deleteIDSet = new ImportIDSet(1, 1, false);
                            } else {
                                index = (Index)Importer.this.idContainerMap.get(indexID);
                                limit = index.getIndexEntryLimit();
                                doCount = index.getMaintainCount();
                                insertIDSet = new ImportIDSet(1, limit, doCount);
                                deleteIDSet = new ImportIDSet(1, limit, doCount);
                            }
                            key = ByteBuffer.allocate(b.getKeyLen());
                            key.flip();
                            b.getKey(key);
                            b.mergeIDSet(insertIDSet);
                            b.mergeIDSet(deleteIDSet);
                            insertIDSet.setKey(key);
                            deleteIDSet.setKey(key);
                        } else if (b.compare(key, indexID) != 0) {
                            this.addToDB(insertIDSet, deleteIDSet, indexID);
                            this.keyCount.incrementAndGet();
                            indexID = b.getIndexID();
                            if (this.indexMgr.isDN2ID()) {
                                insertIDSet = new ImportIDSet(1, 1, false);
                                deleteIDSet = new ImportIDSet(1, 1, false);
                            } else {
                                index = (Index)Importer.this.idContainerMap.get(indexID);
                                limit = index.getIndexEntryLimit();
                                doCount = index.getMaintainCount();
                                insertIDSet = new ImportIDSet(1, limit, doCount);
                                deleteIDSet = new ImportIDSet(1, limit, doCount);
                            }
                            key.clear();
                            if (b.getKeyLen() > key.capacity()) {
                                key = ByteBuffer.allocate(b.getKeyLen());
                            }
                            key.flip();
                            b.getKey(key);
                            b.mergeIDSet(insertIDSet);
                            b.mergeIDSet(deleteIDSet);
                            insertIDSet.setKey(key);
                            deleteIDSet.setKey(key);
                        } else {
                            b.mergeIDSet(insertIDSet);
                            b.mergeIDSet(deleteIDSet);
                        }
                        if (!b.hasMoreData()) continue;
                        b.getNextRecord();
                        bufferSet.add(b);
                    }
                    if (key == null) continue;
                    this.addToDB(insertIDSet, deleteIDSet, indexID);
                }
            }
            catch (Exception e) {
                Message message = JebMessages.ERR_JEB_IMPORT_LDIF_INDEX_WRITE_DB_ERR.get(this.indexMgr.getBufferFileName(), e.getMessage());
                ErrorLogger.logError(message);
                throw e;
            }
            finally {
                this.endWriteTask();
            }
            return null;
        }

        private void addToDB(ImportIDSet insertSet, ImportIDSet deleteSet, int indexID) throws DirectoryException {
            if (!this.indexMgr.isDN2ID()) {
                Index index;
                if (deleteSet.size() > 0 || !deleteSet.isDefined()) {
                    this.dbKey.setData(deleteSet.getKey().array(), 0, deleteSet.getKey().limit());
                    index = (Index)Importer.this.idContainerMap.get(indexID);
                    index.delete(this.dbKey, deleteSet, this.dbValue);
                    if (!this.indexMap.containsKey(indexID)) {
                        this.indexMap.put(indexID, index);
                    }
                }
                if (insertSet.size() > 0 || !insertSet.isDefined()) {
                    this.dbKey.setData(insertSet.getKey().array(), 0, insertSet.getKey().limit());
                    index = (Index)Importer.this.idContainerMap.get(indexID);
                    index.insert(this.dbKey, insertSet, this.dbValue);
                    if (!this.indexMap.containsKey(indexID)) {
                        this.indexMap.put(indexID, index);
                    }
                }
            } else {
                this.addDN2ID(insertSet, indexID);
            }
        }

        private void addDN2ID(ImportIDSet record, Integer indexID) throws DirectoryException {
            DNState dnState;
            if (!this.dnStateMap.containsKey(indexID)) {
                dnState = new DNState((EntryContainer)Importer.this.idECMap.get(indexID));
                this.dnStateMap.put(indexID, dnState);
            } else {
                dnState = this.dnStateMap.get(indexID);
            }
            if (!dnState.checkParent(record)) {
                return;
            }
            dnState.writeToDB();
        }

        private void addBytesRead(int bytesRead) {
            this.bytesRead.addAndGet(bytesRead);
        }

        class DNState {
            private static final int DN_STATE_CACHE_SIZE = 65536;
            private ByteBuffer parentDN;
            private ByteBuffer lastDN;
            private EntryID parentID;
            private EntryID lastID;
            private EntryID entryID;
            private final DatabaseEntry dnKey;
            private final DatabaseEntry dnValue;
            private final TreeMap<ByteBuffer, EntryID> parentIDMap;
            private final EntryContainer entryContainer;
            private final Map<byte[], ImportIDSet> id2childTree;
            private final Map<byte[], ImportIDSet> id2subtreeTree;
            private final int childLimit;
            private final int subTreeLimit;
            private final boolean childDoCount;
            private final boolean subTreeDoCount;

            DNState(EntryContainer entryContainer) {
                this.entryContainer = entryContainer;
                this.parentIDMap = new TreeMap();
                Comparator<byte[]> childComparator = entryContainer.getID2Children().getComparator();
                this.id2childTree = new TreeMap<byte[], ImportIDSet>(childComparator);
                this.childLimit = entryContainer.getID2Children().getIndexEntryLimit();
                this.childDoCount = entryContainer.getID2Children().getMaintainCount();
                Comparator<byte[]> subComparator = entryContainer.getID2Subtree().getComparator();
                this.subTreeLimit = entryContainer.getID2Subtree().getIndexEntryLimit();
                this.subTreeDoCount = entryContainer.getID2Subtree().getMaintainCount();
                this.id2subtreeTree = new TreeMap<byte[], ImportIDSet>(subComparator);
                this.dnKey = new DatabaseEntry();
                this.dnValue = new DatabaseEntry();
                this.lastDN = ByteBuffer.allocate(128);
            }

            private ByteBuffer getParent(ByteBuffer buffer) {
                int parentIndex = JebFormat.findDNKeyParent(buffer.array(), 0, buffer.limit());
                if (parentIndex < 0) {
                    return null;
                }
                ByteBuffer parent = buffer.duplicate();
                parent.limit(parentIndex);
                return parent;
            }

            private ByteBuffer deepCopy(ByteBuffer srcBuffer, ByteBuffer destBuffer) {
                if (destBuffer == null || destBuffer.clear().remaining() < srcBuffer.limit()) {
                    byte[] bytes = new byte[srcBuffer.limit()];
                    System.arraycopy(srcBuffer.array(), 0, bytes, 0, srcBuffer.limit());
                    return ByteBuffer.wrap(bytes);
                }
                destBuffer.put(srcBuffer);
                destBuffer.flip();
                return destBuffer;
            }

            /*
             * Enabled aggressive block sorting
             */
            private boolean checkParent(ImportIDSet record) throws DatabaseException {
                this.dnKey.setData(record.getKey().array(), 0, record.getKey().limit());
                byte[] v = record.toDatabase();
                long v1 = JebFormat.entryIDFromDatabase(v);
                this.dnValue.setData(v);
                this.entryID = new EntryID(v1);
                this.parentDN = this.getParent(record.getKey());
                if (Importer.this.importConfiguration != null && Importer.this.importConfiguration.appendToExistingData()) {
                    if (this.parentDN == null) return true;
                    DatabaseEntry key = new DatabaseEntry(this.parentDN.array(), 0, this.parentDN.limit());
                    DatabaseEntry value = new DatabaseEntry();
                    OperationStatus status = this.entryContainer.getDN2ID().read(null, key, value, LockMode.DEFAULT);
                    if (status == OperationStatus.SUCCESS) {
                        this.parentID = new EntryID(value);
                        return true;
                    }
                    this.parentID = null;
                    return false;
                }
                if (this.parentIDMap.isEmpty()) {
                    this.parentIDMap.put(this.deepCopy(record.getKey(), null), this.entryID);
                    return true;
                }
                if (this.lastDN != null && this.lastDN.equals(this.parentDN)) {
                    this.parentIDMap.put(this.deepCopy(this.lastDN, null), this.lastID);
                    this.parentID = this.lastID;
                    this.lastDN = this.deepCopy(record.getKey(), this.lastDN);
                    this.lastID = this.entryID;
                    return true;
                }
                if (this.parentIDMap.lastKey().equals(this.parentDN)) {
                    this.parentID = this.parentIDMap.get(this.parentDN);
                    this.lastDN = this.deepCopy(record.getKey(), this.lastDN);
                    this.lastID = this.entryID;
                    return true;
                }
                if (!this.parentIDMap.containsKey(this.parentDN)) {
                    this.parentID = null;
                    return false;
                }
                EntryID newParentID = this.parentIDMap.get(this.parentDN);
                ByteBuffer key = this.parentIDMap.lastKey();
                while (true) {
                    if (this.parentDN.equals(key)) {
                        this.parentIDMap.put(this.deepCopy(record.getKey(), null), this.entryID);
                        this.parentID = newParentID;
                        this.lastDN = this.deepCopy(record.getKey(), this.lastDN);
                        this.lastID = this.entryID;
                        return true;
                    }
                    this.parentIDMap.remove(key);
                    key = this.parentIDMap.lastKey();
                }
            }

            private void id2child(EntryID childID) throws DirectoryException {
                if (this.parentID != null) {
                    ImportIDSet idSet;
                    if (!this.id2childTree.containsKey(this.parentID.getDatabaseEntry().getData())) {
                        idSet = new ImportIDSet(1, this.childLimit, this.childDoCount);
                        this.id2childTree.put(this.parentID.getDatabaseEntry().getData(), idSet);
                    } else {
                        idSet = this.id2childTree.get(this.parentID.getDatabaseEntry().getData());
                    }
                    idSet.addEntryID(childID);
                    if (this.id2childTree.size() > 65536) {
                        this.flushMapToDB(this.id2childTree, this.entryContainer.getID2Children(), true);
                    }
                } else {
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, JebMessages.ERR_PARENT_ENTRY_IS_MISSING.get());
                }
            }

            private EntryID getParentID(ByteBuffer dn) throws DatabaseException {
                EntryID nodeID;
                if (Importer.this.importConfiguration != null && Importer.this.importConfiguration.appendToExistingData()) {
                    DatabaseEntry key = new DatabaseEntry(dn.array(), 0, dn.limit());
                    DatabaseEntry value = new DatabaseEntry();
                    OperationStatus status = this.entryContainer.getDN2ID().read(null, key, value, LockMode.DEFAULT);
                    nodeID = status == OperationStatus.SUCCESS ? new EntryID(value) : null;
                } else {
                    nodeID = this.parentIDMap.get(dn);
                }
                return nodeID;
            }

            private void id2SubTree(EntryID childID) throws DirectoryException {
                if (this.parentID != null) {
                    EntryID nodeID;
                    ImportIDSet idSet;
                    if (!this.id2subtreeTree.containsKey(this.parentID.getDatabaseEntry().getData())) {
                        idSet = new ImportIDSet(1, this.subTreeLimit, this.subTreeDoCount);
                        this.id2subtreeTree.put(this.parentID.getDatabaseEntry().getData(), idSet);
                    } else {
                        idSet = this.id2subtreeTree.get(this.parentID.getDatabaseEntry().getData());
                    }
                    idSet.addEntryID(childID);
                    ByteBuffer dn = this.getParent(this.parentDN);
                    while (dn != null && (nodeID = this.getParentID(dn)) != null) {
                        if (!this.id2subtreeTree.containsKey(nodeID.getDatabaseEntry().getData())) {
                            idSet = new ImportIDSet(1, this.subTreeLimit, this.subTreeDoCount);
                            this.id2subtreeTree.put(nodeID.getDatabaseEntry().getData(), idSet);
                        } else {
                            idSet = this.id2subtreeTree.get(nodeID.getDatabaseEntry().getData());
                        }
                        idSet.addEntryID(childID);
                        dn = this.getParent(dn);
                    }
                    if (this.id2subtreeTree.size() > 65536) {
                        this.flushMapToDB(this.id2subtreeTree, this.entryContainer.getID2Subtree(), true);
                    }
                } else {
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, JebMessages.ERR_PARENT_ENTRY_IS_MISSING.get());
                }
            }

            public void writeToDB() throws DirectoryException {
                this.entryContainer.getDN2ID().put(null, this.dnKey, this.dnValue);
                IndexDBWriteTask.this.indexMgr.addTotDNCount(1);
                if (this.parentDN != null) {
                    this.id2child(this.entryID);
                    this.id2SubTree(this.entryID);
                }
            }

            private void flushMapToDB(Map<byte[], ImportIDSet> map, Index index, boolean clearMap) {
                for (Map.Entry<byte[], ImportIDSet> e : map.entrySet()) {
                    byte[] key = e.getKey();
                    ImportIDSet idSet = e.getValue();
                    this.dnKey.setData(key);
                    index.insert(this.dnKey, idSet, this.dnValue);
                }
                index.closeCursor();
                if (clearMap) {
                    map.clear();
                }
            }

            public void flush() {
                this.flushMapToDB(this.id2childTree, this.entryContainer.getID2Children(), false);
                this.flushMapToDB(this.id2subtreeTree, this.entryContainer.getID2Subtree(), false);
            }
        }
    }

    private class ImportTask
    implements Callable<Void> {
        private final Map<IndexKey, IndexOutputBuffer> indexBufferMap = new HashMap<IndexKey, IndexOutputBuffer>();
        private final Set<byte[]> insertKeySet = new HashSet<byte[]>();
        private final EntryInformation entryInfo = new EntryInformation();
        private DatabaseEntry keyEntry = new DatabaseEntry();
        private DatabaseEntry valEntry = new DatabaseEntry();

        private ImportTask() {
        }

        @Override
        public Void call() throws Exception {
            try {
                while (true) {
                    if (Importer.this.importConfiguration.isCancelled() || Importer.this.isCanceled) {
                        IndexOutputBuffer indexBuffer = new IndexOutputBuffer(0);
                        Importer.this.freeBufferQueue.add(indexBuffer);
                        return null;
                    }
                    Entry entry = Importer.this.reader.readEntry(Importer.this.dnSuffixMap, this.entryInfo);
                    if (entry == null) break;
                    EntryID entryID = this.entryInfo.getEntryID();
                    Suffix suffix = this.entryInfo.getSuffix();
                    this.processEntry(entry, entryID, suffix);
                }
                this.flushIndexBuffers();
            }
            catch (Exception e) {
                Message message = JebMessages.ERR_JEB_IMPORT_LDIF_IMPORT_TASK_ERR.get(e.getMessage());
                ErrorLogger.logError(message);
                Importer.this.isCanceled = true;
                throw e;
            }
            return null;
        }

        void processEntry(Entry entry, EntryID entryID, Suffix suffix) throws DatabaseException, DirectoryException, JebException, InterruptedException {
            DN entryDN = entry.getDN();
            if (!Importer.this.skipDNValidation && !this.dnSanityCheck(entryDN, entry, suffix)) {
                suffix.removePending(entryDN);
                return;
            }
            suffix.removePending(entryDN);
            this.processDN2ID(suffix, entryDN, entryID);
            this.processDN2URI(suffix, null, entry);
            this.processIndexes(suffix, entry, entryID);
            suffix.getID2Entry().put(null, entryID, entry);
            Importer.this.importCount.getAndIncrement();
        }

        boolean dnSanityCheck(DN entryDN, Entry entry, Suffix suffix) throws JebException, InterruptedException {
            DN parentDN = suffix.getEntryContainer().getParentWithinBase(entryDN);
            if (parentDN != null && !suffix.isParentProcessed(parentDN, Importer.this.tmpEnv, Importer.this.clearedBackend)) {
                Message message = JebMessages.ERR_JEB_IMPORT_PARENT_NOT_FOUND.get(parentDN.toString());
                Importer.this.reader.rejectEntry(entry, message);
                return false;
            }
            if (!Importer.this.clearedBackend) {
                EntryID id = suffix.getDN2ID().get(null, entryDN, LockMode.DEFAULT);
                if (id != null || !Importer.this.tmpEnv.insert(entryDN, this.keyEntry, this.valEntry)) {
                    Message message = JebMessages.WARN_JEB_IMPORT_ENTRY_EXISTS.get();
                    Importer.this.reader.rejectEntry(entry, message);
                    return false;
                }
            } else if (!Importer.this.tmpEnv.insert(entryDN, this.keyEntry, this.valEntry)) {
                Message message = JebMessages.WARN_JEB_IMPORT_ENTRY_EXISTS.get();
                Importer.this.reader.rejectEntry(entry, message);
                return false;
            }
            return true;
        }

        void processIndexes(Suffix suffix, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException, InterruptedException {
            for (Map.Entry<AttributeType, AttributeIndex> mapEntry : suffix.getAttrIndexMap().entrySet()) {
                AttributeType attributeType = mapEntry.getKey();
                if (!entry.hasAttribute(attributeType)) continue;
                this.fillIndexKey(suffix, mapEntry, entry, attributeType, entryID);
            }
        }

        void fillIndexKey(Suffix suffix, Map.Entry<AttributeType, AttributeIndex> mapEntry, Entry entry, AttributeType attributeType, EntryID entryID) throws DatabaseException, InterruptedException, DirectoryException, JebException {
            AttributeIndex attributeIndex = mapEntry.getValue();
            Index index = attributeIndex.getEqualityIndex();
            if (index != null) {
                this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.EQUALITY, index.getIndexEntryLimit()));
            }
            if ((index = attributeIndex.getPresenceIndex()) != null) {
                this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.PRESENCE, index.getIndexEntryLimit()));
            }
            if ((index = attributeIndex.getSubstringIndex()) != null) {
                this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.SUBSTRING, index.getIndexEntryLimit()));
            }
            if ((index = attributeIndex.getOrderingIndex()) != null) {
                this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.ORDERING, index.getIndexEntryLimit()));
            }
            if ((index = attributeIndex.getApproximateIndex()) != null) {
                this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.APPROXIMATE, index.getIndexEntryLimit()));
            }
            for (VLVIndex vlvIdx : suffix.getEntryContainer().getVLVIndexes()) {
                Transaction transaction = null;
                vlvIdx.addEntry(transaction, entryID, entry);
            }
            Map<String, Collection<Index>> extensibleMap = attributeIndex.getExtensibleIndexes();
            if (!extensibleMap.isEmpty()) {
                Collection<Index> sharedIndexes;
                Collection<Index> subIndexes = attributeIndex.getExtensibleIndexes().get("substring");
                if (subIndexes != null) {
                    for (Index subIndex : subIndexes) {
                        this.processAttribute(subIndex, entry, entryID, new IndexKey(attributeType, ImportIndexType.EX_SUBSTRING, subIndex.getIndexEntryLimit()));
                    }
                }
                if ((sharedIndexes = attributeIndex.getExtensibleIndexes().get("shared")) != null) {
                    for (Index sharedIndex : sharedIndexes) {
                        this.processAttribute(sharedIndex, entry, entryID, new IndexKey(attributeType, ImportIndexType.EX_SHARED, sharedIndex.getIndexEntryLimit()));
                    }
                }
            }
        }

        void processAttribute(Index index, Entry entry, EntryID entryID, IndexKey indexKey) throws DatabaseException, InterruptedException {
            this.insertKeySet.clear();
            index.indexer.indexEntry(entry, this.insertKeySet);
            for (byte[] key : this.insertKeySet) {
                this.processKey(index, key, entryID, indexComparator, indexKey, true);
            }
        }

        void flushIndexBuffers() throws InterruptedException, ExecutionException {
            Set<Map.Entry<IndexKey, IndexOutputBuffer>> set = this.indexBufferMap.entrySet();
            Iterator<Map.Entry<IndexKey, IndexOutputBuffer>> setIterator = set.iterator();
            while (setIterator.hasNext()) {
                Map.Entry<IndexKey, IndexOutputBuffer> e = setIterator.next();
                IndexKey indexKey = e.getKey();
                IndexOutputBuffer indexBuffer = e.getValue();
                setIterator.remove();
                indexBuffer.setComparator(indexComparator);
                indexBuffer.setIndexKey(indexKey);
                indexBuffer.setDiscard();
                Future<Void> future = Importer.this.bufferSortService.submit(new SortTask(indexBuffer));
                future.get();
            }
        }

        int processKey(DatabaseContainer container, byte[] key, EntryID entryID, IndexOutputBuffer.ComparatorBuffer<byte[]> comparator, IndexKey indexKey, boolean insert) throws InterruptedException {
            int sizeNeeded = IndexOutputBuffer.getRequiredSize(key.length, entryID.longValue());
            IndexOutputBuffer indexBuffer = this.indexBufferMap.get(indexKey);
            if (indexBuffer == null) {
                indexBuffer = this.getNewIndexBuffer(sizeNeeded);
                this.indexBufferMap.put(indexKey, indexBuffer);
            } else if (!indexBuffer.isSpaceAvailable(key, entryID.longValue())) {
                indexBuffer.setComparator(comparator);
                indexBuffer.setIndexKey(indexKey);
                Importer.this.bufferSortService.submit(new SortTask(indexBuffer));
                indexBuffer = this.getNewIndexBuffer(sizeNeeded);
                this.indexBufferMap.put(indexKey, indexBuffer);
            }
            int id = System.identityHashCode(container);
            indexBuffer.add(key, entryID, id, insert);
            return id;
        }

        IndexOutputBuffer getNewIndexBuffer(int size) throws InterruptedException {
            IndexOutputBuffer indexBuffer;
            if (size > Importer.this.bufferSize) {
                indexBuffer = new IndexOutputBuffer(size);
                indexBuffer.setDiscard();
            } else {
                indexBuffer = (IndexOutputBuffer)Importer.this.freeBufferQueue.take();
                if (indexBuffer == null) {
                    Message message = Message.raw(Category.JEB, Severity.SEVERE_ERROR, "Index buffer processing error.", new Object[0]);
                    throw new InterruptedException(message.toString());
                }
            }
            if (indexBuffer.isPoison()) {
                Message message = Message.raw(Category.JEB, Severity.SEVERE_ERROR, "Cancel processing received.", new Object[0]);
                throw new InterruptedException(message.toString());
            }
            return indexBuffer;
        }

        void processDN2ID(Suffix suffix, DN dn, EntryID entryID) throws InterruptedException {
            DN2ID dn2id = suffix.getDN2ID();
            byte[] dnBytes = JebFormat.dnToDNKey(dn, suffix.getBaseDN().getNumComponents());
            int id = this.processKey(dn2id, dnBytes, entryID, indexComparator, new IndexKey(dnType, ImportIndexType.DN, 1), true);
            Importer.this.idECMap.putIfAbsent(id, suffix.getEntryContainer());
        }

        void processDN2URI(Suffix suffix, Entry oldEntry, Entry newEntry) throws DatabaseException {
            DN2URI dn2uri = suffix.getDN2URI();
            if (oldEntry != null) {
                dn2uri.replaceEntry(null, oldEntry, newEntry);
            } else {
                dn2uri.addEntry(null, newEntry);
            }
        }
    }

    private class AppendReplaceTask
    extends ImportTask {
        private final Set<byte[]> insertKeySet = new HashSet<byte[]>();
        private final Set<byte[]> deleteKeySet = new HashSet<byte[]>();
        private final EntryInformation entryInfo = new EntryInformation();
        private Entry oldEntry;
        private EntryID entryID;

        private AppendReplaceTask() {
        }

        @Override
        public Void call() throws Exception {
            try {
                while (true) {
                    if (Importer.this.importConfiguration.isCancelled() || Importer.this.isCanceled) {
                        IndexOutputBuffer indexBuffer = new IndexOutputBuffer(0);
                        Importer.this.freeBufferQueue.add(indexBuffer);
                        return null;
                    }
                    this.oldEntry = null;
                    Entry entry = Importer.this.reader.readEntry(Importer.this.dnSuffixMap, this.entryInfo);
                    if (entry == null) break;
                    this.entryID = this.entryInfo.getEntryID();
                    Suffix suffix = this.entryInfo.getSuffix();
                    this.processEntry(entry, suffix);
                }
                this.flushIndexBuffers();
            }
            catch (Exception e) {
                Message message = JebMessages.ERR_JEB_IMPORT_LDIF_APPEND_REPLACE_TASK_ERR.get(e.getMessage());
                ErrorLogger.logError(message);
                Importer.this.isCanceled = true;
                throw e;
            }
            return null;
        }

        void processEntry(Entry entry, Suffix suffix) throws DatabaseException, DirectoryException, JebException, InterruptedException {
            DN entryDN = entry.getDN();
            DN2ID dn2id = suffix.getDN2ID();
            EntryID oldID = dn2id.get(null, entryDN, LockMode.DEFAULT);
            if (oldID != null) {
                this.oldEntry = suffix.getID2Entry().get(null, oldID, LockMode.DEFAULT);
            }
            if (this.oldEntry == null) {
                if (!Importer.this.skipDNValidation && !this.dnSanityCheck(entryDN, entry, suffix)) {
                    suffix.removePending(entryDN);
                    return;
                }
                suffix.removePending(entryDN);
                this.processDN2ID(suffix, entryDN, this.entryID);
            } else {
                suffix.removePending(entryDN);
                this.entryID = oldID;
            }
            this.processDN2URI(suffix, this.oldEntry, entry);
            suffix.getID2Entry().put(null, this.entryID, entry);
            if (this.oldEntry == null) {
                this.processIndexes(suffix, entry, this.entryID);
            } else {
                this.processAllIndexes(suffix, entry, this.entryID);
            }
            Importer.this.importCount.getAndIncrement();
        }

        void processAllIndexes(Suffix suffix, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException, InterruptedException {
            for (Map.Entry<AttributeType, AttributeIndex> mapEntry : suffix.getAttrIndexMap().entrySet()) {
                AttributeType attributeType = mapEntry.getKey();
                this.fillIndexKey(suffix, mapEntry, entry, attributeType, entryID);
            }
        }

        @Override
        void processAttribute(Index index, Entry entry, EntryID entryID, IndexKey indexKey) throws DatabaseException, InterruptedException {
            if (this.oldEntry != null) {
                this.deleteKeySet.clear();
                index.indexer.indexEntry(this.oldEntry, this.deleteKeySet);
                for (byte[] delKey : this.deleteKeySet) {
                    this.processKey(index, delKey, entryID, indexComparator, indexKey, false);
                }
            }
            this.insertKeySet.clear();
            index.indexer.indexEntry(entry, this.insertKeySet);
            for (byte[] key : this.insertKeySet) {
                this.processKey(index, key, entryID, indexComparator, indexKey, true);
            }
        }
    }

    private final class MigrateExistingTask
    extends ImportTask {
        private MigrateExistingTask() {
        }

        @Override
        public Void call() throws Exception {
            for (Suffix suffix : Importer.this.dnSuffixMap.values()) {
                ArrayList<byte[]> includeBranches = new ArrayList<byte[]>(suffix.getIncludeBranches().size());
                for (DN includeBranch : suffix.getIncludeBranches()) {
                    if (!includeBranch.isDescendantOf(suffix.getBaseDN())) continue;
                    includeBranches.add(JebFormat.dnToDNKey(includeBranch, suffix.getBaseDN().getNumComponents()));
                }
                EntryContainer entryContainer = suffix.getSrcEntryContainer();
                if (entryContainer == null || suffix.getIncludeBranches().isEmpty()) continue;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                LockMode lockMode = LockMode.DEFAULT;
                Message message = JebMessages.NOTE_JEB_IMPORT_MIGRATION_START.get("existing", String.valueOf(suffix.getBaseDN()));
                ErrorLogger.logError(message);
                Cursor cursor = entryContainer.getDN2ID().openCursor(null, null);
                try {
                    OperationStatus status = cursor.getFirst(key, data, lockMode);
                    while (status == OperationStatus.SUCCESS && !Importer.this.importConfiguration.isCancelled() && !Importer.this.isCanceled) {
                        boolean found = false;
                        for (byte[] includeBranch : includeBranches) {
                            if (!Arrays.equals(includeBranch, key.getData())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            EntryID id = new EntryID(data);
                            Entry entry = entryContainer.getID2Entry().get(null, id, LockMode.DEFAULT);
                            this.processEntry(entry, Importer.this.rootContainer.getNextEntryID(), suffix);
                            Importer.this.migratedCount++;
                            status = cursor.getNext(key, data, lockMode);
                            continue;
                        }
                        byte[] begin = Arrays.copyOf(key.getData(), key.getSize() + 1);
                        begin[begin.length - 1] = 1;
                        key.setData(begin);
                        status = cursor.getSearchKeyRange(key, data, lockMode);
                    }
                    this.flushIndexBuffers();
                }
                catch (Exception e) {
                    message = JebMessages.ERR_JEB_IMPORT_LDIF_MIGRATE_EXISTING_TASK_ERR.get(e.getMessage());
                    ErrorLogger.logError(message);
                    Importer.this.isCanceled = true;
                    throw e;
                }
                finally {
                    cursor.close();
                }
            }
            return null;
        }
    }

    private final class MigrateExcludedTask
    extends ImportTask {
        private MigrateExcludedTask() {
        }

        @Override
        public Void call() throws Exception {
            for (Suffix suffix : Importer.this.dnSuffixMap.values()) {
                EntryContainer entryContainer = suffix.getSrcEntryContainer();
                if (entryContainer == null || suffix.getExcludeBranches().isEmpty()) continue;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                LockMode lockMode = LockMode.DEFAULT;
                Message message = JebMessages.NOTE_JEB_IMPORT_MIGRATION_START.get("excluded", String.valueOf(suffix.getBaseDN()));
                ErrorLogger.logError(message);
                Cursor cursor = entryContainer.getDN2ID().openCursor(null, CursorConfig.READ_COMMITTED);
                Comparator<byte[]> comparator = entryContainer.getDN2ID().getComparator();
                try {
                    for (DN excludedDN : suffix.getExcludeBranches()) {
                        byte[] bytes = JebFormat.dnToDNKey(excludedDN, suffix.getBaseDN().getNumComponents());
                        key.setData(bytes);
                        OperationStatus status = cursor.getSearchKeyRange(key, data, lockMode);
                        if (status != OperationStatus.SUCCESS || !Arrays.equals(key.getData(), bytes)) continue;
                        byte[] end = Arrays.copyOf(bytes, bytes.length + 1);
                        end[end.length - 1] = 1;
                        while (status == OperationStatus.SUCCESS && comparator.compare(key.getData(), end) < 0 && !Importer.this.importConfiguration.isCancelled() && !Importer.this.isCanceled) {
                            EntryID id = new EntryID(data);
                            Entry entry = entryContainer.getID2Entry().get(null, id, LockMode.DEFAULT);
                            this.processEntry(entry, Importer.this.rootContainer.getNextEntryID(), suffix);
                            Importer.this.migratedCount++;
                            status = cursor.getNext(key, data, lockMode);
                        }
                    }
                    this.flushIndexBuffers();
                }
                catch (Exception e) {
                    message = JebMessages.ERR_JEB_IMPORT_LDIF_MIGRATE_EXCLUDED_TASK_ERR.get(e.getMessage());
                    ErrorLogger.logError(message);
                    Importer.this.isCanceled = true;
                    throw e;
                }
                finally {
                    cursor.close();
                }
            }
            return null;
        }
    }
}

