/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import org.opends.server.types.DN;

public class RebuildConfig {
    private DN baseDN;
    private ArrayList<String> rebuildList;
    private RebuildMode rebuildMode = RebuildMode.USER_DEFINED;
    private String tmpDirectory;
    private boolean isClearDegradedState;

    public RebuildConfig() {
        this.rebuildList = new ArrayList();
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(DN baseDN) {
        this.baseDN = baseDN;
    }

    public ArrayList<String> getRebuildList() {
        return this.rebuildList;
    }

    public void addRebuildIndex(String index) {
        String[] newIndexParts = index.split("\\.");
        for (String s : new ArrayList<String>(this.rebuildList)) {
            String[] existingIndexParts = s.split("\\.");
            if (!existingIndexParts[0].equalsIgnoreCase(newIndexParts[0])) continue;
            if (newIndexParts.length == 1 && existingIndexParts.length == 1) {
                return;
            }
            if (newIndexParts.length > 1 && existingIndexParts.length == 1) {
                return;
            }
            if (newIndexParts.length == 1 && existingIndexParts.length > 1) {
                this.rebuildList.remove(s);
                continue;
            }
            if (!newIndexParts[1].equalsIgnoreCase(existingIndexParts[1])) continue;
            return;
        }
        this.rebuildList.add(index);
    }

    public String checkConflicts(RebuildConfig config) {
        if (this.baseDN.equals(config.baseDN)) {
            for (String thisIndex : this.rebuildList) {
                for (String thatIndex : config.rebuildList) {
                    String[] newIndexParts;
                    String[] existingIndexParts = thisIndex.split("\\.");
                    if (!existingIndexParts[0].equalsIgnoreCase((newIndexParts = thatIndex.split("\\."))[0])) continue;
                    if (newIndexParts.length == 1 && existingIndexParts.length == 1) {
                        return thatIndex;
                    }
                    if (newIndexParts.length > 1 && existingIndexParts.length == 1) {
                        return thatIndex;
                    }
                    if (newIndexParts.length == 1 && existingIndexParts.length > 1) {
                        return thatIndex;
                    }
                    if (!newIndexParts[1].equalsIgnoreCase(existingIndexParts[1])) continue;
                    return thatIndex;
                }
            }
        }
        return null;
    }

    public boolean includesSystemIndex() {
        for (String index : this.rebuildList) {
            if (index.equalsIgnoreCase("dn2id")) {
                return true;
            }
            if (!index.equalsIgnoreCase("dn2uri")) continue;
            return true;
        }
        return false;
    }

    public void setTmpDirectory(String path) {
        this.tmpDirectory = path;
    }

    public String getTmpDirectory() {
        return this.tmpDirectory;
    }

    public void setRebuildMode(RebuildMode mode) {
        this.rebuildMode = mode;
    }

    public RebuildMode getRebuildMode() {
        return this.rebuildMode;
    }

    public boolean isClearDegradedState() {
        return this.isClearDegradedState;
    }

    public void isClearDegradedState(boolean isClearDegradedState) {
        this.isClearDegradedState = isClearDegradedState;
    }

    public static enum RebuildMode {
        ALL,
        DEGRADED,
        USER_DEFINED;

    }
}

