/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import org.opends.server.backends.jeb.JECompressedSchema;
import org.opends.server.types.EntryEncodeConfig;
import org.opends.server.util.Validator;

public class DataConfig {
    private boolean compressed = false;
    private EntryEncodeConfig encodeConfig = new EntryEncodeConfig();

    public DataConfig(boolean compressed, boolean compactEncoding, JECompressedSchema compressedSchema) {
        this.compressed = compressed;
        if (compressedSchema == null) {
            Validator.ensureTrue(!compactEncoding);
            this.encodeConfig = new EntryEncodeConfig(false, compactEncoding, false);
        } else {
            this.encodeConfig = new EntryEncodeConfig(false, compactEncoding, compactEncoding, compressedSchema);
        }
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public boolean isCompactEncoding() {
        return this.encodeConfig.compressAttributeDescriptions();
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public void setCompactEncoding(boolean compactEncoding, JECompressedSchema compressedSchema) {
        if (compressedSchema == null) {
            Validator.ensureTrue(!compactEncoding);
            this.encodeConfig = new EntryEncodeConfig(false, compactEncoding, compactEncoding);
        } else {
            this.encodeConfig = new EntryEncodeConfig(false, compactEncoding, compactEncoding, compressedSchema);
        }
    }

    public EntryEncodeConfig getEntryEncodeConfig() {
        return this.encodeConfig;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataConfig(compressed=");
        builder.append(this.compressed);
        builder.append(", ");
        this.encodeConfig.toString(builder);
        builder.append(")");
        return builder.toString();
    }
}

