/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.KeywordBindRule;

public class SSF
implements KeywordBindRule {
    private EnumBindRuleType type = null;
    private static final int MAX_KEY_BITS = 1024;
    private int ssf;

    private SSF(int ssf, EnumBindRuleType type) {
        this.ssf = ssf;
        this.type = type;
    }

    static SSF decode(String expr, EnumBindRuleType type) throws AciException {
        int valueAsInt = 0;
        try {
            valueAsInt = Integer.parseInt(expr);
        }
        catch (NumberFormatException nfe) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_SSF_FORMAT.get(expr, nfe.getMessage());
            throw new AciException(message);
        }
        if (valueAsInt <= 0 || valueAsInt > 1024) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_SSF_RANGE.get(expr);
            throw new AciException(message);
        }
        return new SSF(valueAsInt, type);
    }

    @Override
    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        int currentSSF = evalCtx.getCurrentSSF();
        switch (this.type) {
            case EQUAL_BINDRULE_TYPE: 
            case NOT_EQUAL_BINDRULE_TYPE: {
                if (currentSSF != this.ssf) break;
                matched = EnumEvalResult.TRUE;
                break;
            }
            case LESS_OR_EQUAL_BINDRULE_TYPE: {
                if (currentSSF > this.ssf) break;
                matched = EnumEvalResult.TRUE;
                break;
            }
            case LESS_BINDRULE_TYPE: {
                if (currentSSF >= this.ssf) break;
                matched = EnumEvalResult.TRUE;
                break;
            }
            case GREATER_OR_EQUAL_BINDRULE_TYPE: {
                if (currentSSF < this.ssf) break;
                matched = EnumEvalResult.TRUE;
                break;
            }
            case GREATER_BINDRULE_TYPE: {
                if (currentSSF <= this.ssf) break;
                matched = EnumEvalResult.TRUE;
            }
        }
        return matched.getRet(this.type, false);
    }
}

