/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

public enum EnumRight {
    READ("read"),
    WRITE("write"),
    ADD("add"),
    DELETE("delete"),
    SEARCH("search"),
    COMPARE("compare"),
    SELFWRITE("selfwrite"),
    PROXY("proxy"),
    IMPORT("import"),
    EXPORT("export"),
    ALL("all"),
    DELWRITE("delwrite"),
    ADDWRITE("addwrite");

    private final String right;

    private EnumRight(String right) {
        this.right = right;
    }

    public boolean isRight(String right) {
        return right.equalsIgnoreCase(this.right);
    }

    public static EnumRight decode(String right) {
        if (right != null) {
            for (EnumRight t : EnumRight.values()) {
                if (!t.isRight(right)) continue;
                return t;
            }
        }
        return null;
    }

    public static int getMask(EnumRight right) {
        int mask = 0;
        switch (right) {
            case READ: {
                mask = 4;
                break;
            }
            case WRITE: {
                mask = 8;
                break;
            }
            case ADD: {
                mask = 32;
                break;
            }
            case DELETE: {
                mask = 16;
                break;
            }
            case SEARCH: {
                mask = 2;
                break;
            }
            case COMPARE: {
                mask = 1;
                break;
            }
            case ALL: {
                mask = 127;
                break;
            }
            case EXPORT: {
                mask = 512;
                break;
            }
            case IMPORT: {
                mask = 256;
                break;
            }
            case PROXY: {
                mask = 128;
                break;
            }
            case SELFWRITE: {
                mask = 64;
            }
        }
        return mask;
    }
}

