/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.api.Backend;
import org.opends.server.api.DITCacheMap;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AciHandler;
import org.opends.server.authorization.dseecompat.AciTargets;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.RDN;

public class AciList {
    private volatile DITCacheMap<List<Aci>> aciList = new DITCacheMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private DN configDN;

    public AciList(DN configDN) {
        this.configDN = configDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Aci> getCandidateAcis(DN baseDN) {
        LinkedList<Aci> candidates = new LinkedList<Aci>();
        if (baseDN == null) {
            return candidates;
        }
        this.lock.readLock().lock();
        try {
            DN entryDN = baseDN;
            while (baseDN != null) {
                List<Aci> acis = this.aciList.get(baseDN);
                if (acis != null) {
                    if (baseDN.isNullDN()) {
                        for (Aci aci : acis) {
                            boolean ret;
                            AciTargets targets = aci.getTargets();
                            if (targets == null || !(ret = AciTargets.isTargetApplicable(aci, targets, entryDN))) continue;
                            candidates.add(aci);
                        }
                    } else {
                        candidates.addAll(acis);
                    }
                }
                if (baseDN.isNullDN()) {
                    break;
                }
                DN parentDN = baseDN.getParent();
                if (parentDN == null) {
                    baseDN = DN.nullDN();
                    continue;
                }
                baseDN = parentDN;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return candidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAci(List<? extends Entry> entries, LinkedList<Message> failedACIMsgs) {
        int validAcis = 0;
        this.lock.writeLock().lock();
        try {
            for (Entry entry : entries) {
                DN dn = entry.getDN();
                List<Attribute> attributeList = entry.getOperationalAttribute(AciHandler.aciType);
                validAcis += AciList.addAciAttributeList(this.aciList, dn, this.configDN, attributeList, failedACIMsgs);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return validAcis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAci(DN dn, SortedSet<Aci> acis) {
        this.lock.writeLock().lock();
        try {
            this.aciList.put(dn, (List<Aci>)new LinkedList<Aci>(acis));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAci(Entry entry, boolean hasAci, boolean hasGlobalAci, LinkedList<Message> failedACIMsgs) {
        int validAcis = 0;
        this.lock.writeLock().lock();
        try {
            List<Attribute> attributeList;
            if (hasGlobalAci && entry.getDN().equals(this.configDN)) {
                attributeList = entry.getAttribute(AciHandler.globalAciType);
                validAcis = AciList.addAciAttributeList(this.aciList, DN.nullDN(), this.configDN, attributeList, failedACIMsgs);
            }
            if (hasAci) {
                attributeList = entry.getAttribute(AciHandler.aciType);
                validAcis += AciList.addAciAttributeList(this.aciList, entry.getDN(), this.configDN, attributeList, failedACIMsgs);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return validAcis;
    }

    private static int addAciAttributeList(DITCacheMap<List<Aci>> aciList, DN dn, DN configDN, List<Attribute> attributeList, LinkedList<Message> failedACIMsgs) {
        if (attributeList == null) {
            return 0;
        }
        int validAcis = 0;
        ArrayList<Aci> acis = new ArrayList<Aci>();
        for (Attribute attribute : attributeList) {
            for (AttributeValue value : attribute) {
                try {
                    Aci aci = Aci.decode(value.getValue(), dn);
                    acis.add(aci);
                    ++validAcis;
                }
                catch (AciException ex) {
                    DN msgDN = dn;
                    if (dn == DN.nullDN()) {
                        msgDN = configDN;
                    }
                    Message message = AccessControlMessages.WARN_ACI_ADD_LIST_FAILED_DECODE.get(value.getValue().toString(), String.valueOf(msgDN), ex.getMessage());
                    failedACIMsgs.add(message);
                }
            }
        }
        AciList.addAci(aciList, dn, acis);
        return validAcis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modAciOldNewEntry(Entry oldEntry, Entry newEntry, boolean hasAci, boolean hasGlobalAci) {
        this.lock.writeLock().lock();
        try {
            List<Attribute> attributeList;
            LinkedList<Message> failedACIMsgs = new LinkedList<Message>();
            if (hasAci) {
                this.aciList.remove(oldEntry.getDN());
                attributeList = newEntry.getOperationalAttribute(AciHandler.aciType);
                AciList.addAciAttributeList(this.aciList, newEntry.getDN(), this.configDN, attributeList, failedACIMsgs);
            }
            if (hasGlobalAci && oldEntry.getDN().equals(this.configDN)) {
                this.aciList.remove(DN.nullDN());
                attributeList = newEntry.getAttribute(AciHandler.globalAciType);
                AciList.addAciAttributeList(this.aciList, DN.nullDN(), this.configDN, attributeList, failedACIMsgs);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static void addAci(DITCacheMap<List<Aci>> aciList, DN dn, List<Aci> acis) {
        if (aciList.containsKey(dn)) {
            List<Aci> tmpAci = aciList.get(dn);
            tmpAci.addAll(acis);
        } else {
            aciList.put(dn, acis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAci(Entry entry, boolean hasAci, boolean hasGlobalAci) {
        DN entryDN = entry.getDN();
        this.lock.writeLock().lock();
        try {
            if (hasGlobalAci && entryDN.equals(this.configDN) && this.aciList.remove(DN.nullDN()) == null) {
                boolean bl = false;
                return bl;
            }
            if (hasAci && this.aciList.remove(entryDN) == null) {
                boolean bl = false;
                return bl;
            }
            if (!hasGlobalAci && !hasAci) {
                boolean bl = this.aciList.removeSubtree(entryDN, null);
                return bl;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAci(Backend backend) {
        this.lock.writeLock().lock();
        try {
            Iterator<Map.Entry<DN, List<Aci>>> iterator = this.aciList.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DN, List<Aci>> mapEntry = iterator.next();
                if (!backend.handlesEntry(mapEntry.getKey())) continue;
                iterator.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameAci(DN oldDN, DN newDN) {
        int oldRDNCount = oldDN.getNumComponents();
        int newRDNCount = newDN.getNumComponents();
        this.lock.writeLock().lock();
        try {
            HashMap tempAciList = new HashMap();
            Iterator<Map.Entry<DN, List<Aci>>> iterator = this.aciList.entrySet().iterator();
            while (iterator.hasNext()) {
                int i;
                Map.Entry<DN, List<Aci>> hashEntry = iterator.next();
                if (!hashEntry.getKey().isDescendantOf(oldDN)) continue;
                int keyRDNCount = hashEntry.getKey().getNumComponents();
                int keepRDNCount = keyRDNCount - oldRDNCount;
                RDN[] newRDNs = new RDN[keepRDNCount + newRDNCount];
                for (i = 0; i < keepRDNCount; ++i) {
                    newRDNs[i] = hashEntry.getKey().getRDN(i);
                }
                i = keepRDNCount;
                for (int j = 0; j < newRDNCount; ++j) {
                    newRDNs[i] = newDN.getRDN(j);
                    ++i;
                }
                DN relocateDN = new DN(newRDNs);
                LinkedList<Aci> acis = new LinkedList<Aci>();
                for (Aci aci : hashEntry.getValue()) {
                    try {
                        Aci newAci = Aci.decode(ByteString.valueOf(aci.toString()), relocateDN);
                        acis.add(newAci);
                    }
                    catch (AciException ex) {
                        Message message = AccessControlMessages.WARN_ACI_ADD_LIST_FAILED_DECODE.get(aci.toString(), String.valueOf(relocateDN), ex.getMessage());
                        ErrorLogger.logError(message);
                    }
                }
                tempAciList.put(relocateDN, acis);
                iterator.remove();
            }
            this.aciList.putAll(tempAciList);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

