/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.WorkQueueCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=true)
public abstract class WorkQueue<T extends WorkQueueCfg> {
    public abstract void initializeWorkQueue(T var1) throws ConfigException, InitializationException;

    public abstract void finalizeWorkQueue(Message var1);

    public abstract void submitOperation(Operation var1) throws DirectoryException;

    public abstract boolean trySubmitOperation(Operation var1) throws DirectoryException;

    public abstract boolean isIdle();

    public abstract int getNumWorkerThreads();

    protected int computeNumWorkerThreads(Integer configuredNumWorkerThreads) {
        if (configuredNumWorkerThreads != null) {
            return configuredNumWorkerThreads;
        }
        int cpus = Runtime.getRuntime().availableProcessors();
        int value = Math.max(24, cpus * 2);
        Message message = CoreMessages.INFO_ERGONOMIC_SIZING_OF_WORKER_THREAD_POOL.get(value);
        ErrorLogger.logError(message);
        return value;
    }

    public boolean waitUntilIdle(long timeLimit) {
        long stopWaitingTime = timeLimit <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeLimit;
        while (System.currentTimeMillis() < stopWaitingTime) {
            if (this.isIdle()) {
                return true;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ie) {}
        }
        return false;
    }
}

