/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.ExtendedOperationHandlerCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class ExtendedOperationHandler<T extends ExtendedOperationHandlerCfg> {
    private Set<String> supportedControlOIDs = new HashSet<String>(0);
    private Set<String> supportedFeatureOIDs = new HashSet<String>(0);

    public abstract void initializeExtendedOperationHandler(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(ExtendedOperationHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public void finalizeExtendedOperationHandler() {
    }

    public abstract void processExtendedOperation(ExtendedOperation var1);

    public Set<String> getSupportedControls() {
        return this.supportedControlOIDs;
    }

    public final boolean supportsControl(String controlOID) {
        return this.getSupportedControls().contains(controlOID);
    }

    public Set<String> getSupportedFeatures() {
        return this.supportedFeatureOIDs;
    }

    public final boolean supportsFeature(String featureOID) {
        return this.getSupportedFeatures().contains(featureOID);
    }

    protected void registerControlsAndFeatures() {
        Set<String> featureOIDs;
        Set<String> controlOIDs = this.getSupportedControls();
        if (controlOIDs != null) {
            for (String oid : controlOIDs) {
                DirectoryServer.registerSupportedControl(oid);
            }
        }
        if ((featureOIDs = this.getSupportedFeatures()) != null) {
            for (String oid : featureOIDs) {
                DirectoryServer.registerSupportedFeature(oid);
            }
        }
    }

    protected void deregisterControlsAndFeatures() {
        Set<String> featureOIDs;
        Set<String> controlOIDs = this.getSupportedControls();
        if (controlOIDs != null) {
            for (String oid : controlOIDs) {
                DirectoryServer.deregisterSupportedControl(oid);
            }
        }
        if ((featureOIDs = this.getSupportedFeatures()) != null) {
            for (String oid : featureOIDs) {
                DirectoryServer.deregisterSupportedFeature(oid);
            }
        }
    }

    public String getExtendedOperationName() {
        return null;
    }
}

