/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.AlertGenerator;
import org.opends.server.backends.task.Task;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=true, mayInvoke=true)
public class DirectoryThread
extends Thread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final DirectoryThreadGroup DIRECTORY_THREAD_GROUP = new DirectoryThreadGroup();
    private StackTraceElement[] creationStackTrace;
    private Task task;
    private Thread parentThread;

    public DirectoryThread(Runnable target, String threadName) {
        super(DIRECTORY_THREAD_GROUP, target, threadName);
        this.init();
    }

    protected DirectoryThread(String threadName) {
        super((ThreadGroup)DIRECTORY_THREAD_GROUP, threadName);
        this.init();
    }

    private void init() {
        this.parentThread = DirectoryThread.currentThread();
        this.creationStackTrace = this.parentThread.getStackTrace();
        this.task = this.parentThread instanceof DirectoryThread ? ((DirectoryThread)this.parentThread).task : null;
        if (DirectoryServer.getEnvironmentConfig().forceDaemonThreads()) {
            this.setDaemon(true);
        }
    }

    public StackTraceElement[] getCreationStackTrace() {
        return this.creationStackTrace;
    }

    public Thread getParentThread() {
        return this.parentThread;
    }

    public Task getAssociatedTask() {
        return this.task;
    }

    public void setAssociatedTask(Task task) {
        this.task = task;
    }

    public Map<String, String> getDebugProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("parentThread", this.parentThread.getName() + "(" + this.parentThread.getId() + ")");
        properties.put("isDaemon", String.valueOf(this.isDaemon()));
        return properties;
    }

    private static class DirectoryThreadGroup
    extends ThreadGroup
    implements AlertGenerator {
        private final LinkedHashMap<String, String> alerts = new LinkedHashMap();

        private DirectoryThreadGroup() {
            super("Directory Server Thread Group");
            this.alerts.put("org.opends.server.UncaughtException", "This alert type will be used if a Directory Server thread has encountered an uncaught exception that caused that thread to terminate abnormally.  The impact that this problem has on the server depends on which thread was impacted and the nature of the exception.");
        }

        @Override
        public DN getComponentEntryDN() {
            return DN.NULL_DN;
        }

        @Override
        public String getClassName() {
            return "org.opends.server.api.DirectoryThread";
        }

        @Override
        public LinkedHashMap<String, String> getAlerts() {
            return this.alerts;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_UNCAUGHT_THREAD_EXCEPTION.get(t.getName(), StaticUtils.stackTraceToString(e));
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.UncaughtException", message);
        }
    }

    public static final class Factory
    implements ThreadFactory {
        private final String threadNamePrefix;
        private final AtomicInteger nextID = new AtomicInteger();

        public Factory(String threadNamePrefix) {
            if (threadNamePrefix == null) {
                throw new NullPointerException("Null thread name prefix");
            }
            this.threadNamePrefix = threadNamePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new DirectoryThread(r, this.threadNamePrefix + " " + this.nextID.getAndIncrement());
        }
    }
}

