/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class AttributeSyntax<T extends AttributeSyntaxCfg> {
    public abstract void initializeSyntax(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(AttributeSyntaxCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public void finalizeSyntax() {
    }

    public abstract String getSyntaxName();

    public abstract String getOID();

    public abstract String getDescription();

    public abstract EqualityMatchingRule getEqualityMatchingRule();

    public abstract OrderingMatchingRule getOrderingMatchingRule();

    public abstract SubstringMatchingRule getSubstringMatchingRule();

    public abstract ApproximateMatchingRule getApproximateMatchingRule();

    public abstract boolean valueIsAcceptable(ByteSequence var1, MessageBuilder var2);

    public abstract boolean isBinary();

    public abstract boolean isHumanReadable();

    public final int hashCode() {
        int hashCode = 0;
        String oidString = this.getOID();
        int oidLength = oidString.length();
        for (int i = 0; i < oidLength; ++i) {
            hashCode += oidString.charAt(i);
        }
        return hashCode;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeSyntax)) {
            return false;
        }
        return this.getOID().equals(((AttributeSyntax)o).getOID());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public final void toString(StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.getOID());
        String description = this.getDescription();
        if (description == null || description.length() == 0) {
            buffer.append(" )");
        } else {
            buffer.append(" DESC '");
            buffer.append(description);
            buffer.append("' )");
        }
    }
}

