/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.GenericConstraint;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.condition.Conditions;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.LDAPPassThroughAuthenticationPolicyCfgClient;
import org.opends.server.admin.std.client.PasswordStorageSchemeCfgClient;
import org.opends.server.admin.std.client.TrustManagerProviderCfgClient;
import org.opends.server.admin.std.meta.AuthenticationPolicyCfgDefn;
import org.opends.server.admin.std.server.AuthenticationPolicyCfg;
import org.opends.server.admin.std.server.LDAPPassThroughAuthenticationPolicyCfg;
import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.admin.std.server.TrustManagerProviderCfg;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;

public final class LDAPPassThroughAuthenticationPolicyCfgDefn
extends ManagedObjectDefinition<LDAPPassThroughAuthenticationPolicyCfgClient, LDAPPassThroughAuthenticationPolicyCfg> {
    private static final LDAPPassThroughAuthenticationPolicyCfgDefn INSTANCE = new LDAPPassThroughAuthenticationPolicyCfgDefn();
    private static final AggregationPropertyDefinition<PasswordStorageSchemeCfgClient, PasswordStorageSchemeCfg> PD_CACHED_PASSWORD_STORAGE_SCHEME;
    private static final DurationPropertyDefinition PD_CACHED_PASSWORD_TTL;
    private static final DurationPropertyDefinition PD_CONNECTION_TIMEOUT;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final AttributeTypePropertyDefinition PD_MAPPED_ATTRIBUTE;
    private static final DNPropertyDefinition PD_MAPPED_SEARCH_BASE_DN;
    private static final DNPropertyDefinition PD_MAPPED_SEARCH_BIND_DN;
    private static final StringPropertyDefinition PD_MAPPED_SEARCH_BIND_PASSWORD;
    private static final StringPropertyDefinition PD_MAPPED_SEARCH_BIND_PASSWORD_ENVIRONMENT_VARIABLE;
    private static final StringPropertyDefinition PD_MAPPED_SEARCH_BIND_PASSWORD_FILE;
    private static final StringPropertyDefinition PD_MAPPED_SEARCH_BIND_PASSWORD_PROPERTY;
    private static final EnumPropertyDefinition<MappingPolicy> PD_MAPPING_POLICY;
    private static final StringPropertyDefinition PD_PRIMARY_REMOTE_LDAP_SERVER;
    private static final StringPropertyDefinition PD_SECONDARY_REMOTE_LDAP_SERVER;
    private static final StringPropertyDefinition PD_SSL_CIPHER_SUITE;
    private static final StringPropertyDefinition PD_SSL_PROTOCOL;
    private static final AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> PD_TRUST_MANAGER_PROVIDER;
    private static final BooleanPropertyDefinition PD_USE_PASSWORD_CACHING;
    private static final BooleanPropertyDefinition PD_USE_SSL;
    private static final BooleanPropertyDefinition PD_USE_TCP_KEEP_ALIVE;
    private static final BooleanPropertyDefinition PD_USE_TCP_NO_DELAY;

    public static LDAPPassThroughAuthenticationPolicyCfgDefn getInstance() {
        return INSTANCE;
    }

    private LDAPPassThroughAuthenticationPolicyCfgDefn() {
        super("ldap-pass-through-authentication-policy", AuthenticationPolicyCfgDefn.getInstance());
    }

    @Override
    public LDAPPassThroughAuthenticationPolicyCfgClient createClientConfiguration(ManagedObject<? extends LDAPPassThroughAuthenticationPolicyCfgClient> impl) {
        return new LDAPPassThroughAuthenticationPolicyCfgClientImpl(impl);
    }

    @Override
    public LDAPPassThroughAuthenticationPolicyCfg createServerConfiguration(ServerManagedObject<? extends LDAPPassThroughAuthenticationPolicyCfg> impl) {
        return new LDAPPassThroughAuthenticationPolicyCfgServerImpl(impl);
    }

    @Override
    public Class<LDAPPassThroughAuthenticationPolicyCfg> getServerConfigurationClass() {
        return LDAPPassThroughAuthenticationPolicyCfg.class;
    }

    public AggregationPropertyDefinition<PasswordStorageSchemeCfgClient, PasswordStorageSchemeCfg> getCachedPasswordStorageSchemePropertyDefinition() {
        return PD_CACHED_PASSWORD_STORAGE_SCHEME;
    }

    public DurationPropertyDefinition getCachedPasswordTTLPropertyDefinition() {
        return PD_CACHED_PASSWORD_TTL;
    }

    public DurationPropertyDefinition getConnectionTimeoutPropertyDefinition() {
        return PD_CONNECTION_TIMEOUT;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public AttributeTypePropertyDefinition getMappedAttributePropertyDefinition() {
        return PD_MAPPED_ATTRIBUTE;
    }

    public DNPropertyDefinition getMappedSearchBaseDNPropertyDefinition() {
        return PD_MAPPED_SEARCH_BASE_DN;
    }

    public DNPropertyDefinition getMappedSearchBindDNPropertyDefinition() {
        return PD_MAPPED_SEARCH_BIND_DN;
    }

    public StringPropertyDefinition getMappedSearchBindPasswordPropertyDefinition() {
        return PD_MAPPED_SEARCH_BIND_PASSWORD;
    }

    public StringPropertyDefinition getMappedSearchBindPasswordEnvironmentVariablePropertyDefinition() {
        return PD_MAPPED_SEARCH_BIND_PASSWORD_ENVIRONMENT_VARIABLE;
    }

    public StringPropertyDefinition getMappedSearchBindPasswordFilePropertyDefinition() {
        return PD_MAPPED_SEARCH_BIND_PASSWORD_FILE;
    }

    public StringPropertyDefinition getMappedSearchBindPasswordPropertyPropertyDefinition() {
        return PD_MAPPED_SEARCH_BIND_PASSWORD_PROPERTY;
    }

    public EnumPropertyDefinition<MappingPolicy> getMappingPolicyPropertyDefinition() {
        return PD_MAPPING_POLICY;
    }

    public StringPropertyDefinition getPrimaryRemoteLDAPServerPropertyDefinition() {
        return PD_PRIMARY_REMOTE_LDAP_SERVER;
    }

    public StringPropertyDefinition getSecondaryRemoteLDAPServerPropertyDefinition() {
        return PD_SECONDARY_REMOTE_LDAP_SERVER;
    }

    public StringPropertyDefinition getSSLCipherSuitePropertyDefinition() {
        return PD_SSL_CIPHER_SUITE;
    }

    public StringPropertyDefinition getSSLProtocolPropertyDefinition() {
        return PD_SSL_PROTOCOL;
    }

    public AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> getTrustManagerProviderPropertyDefinition() {
        return PD_TRUST_MANAGER_PROVIDER;
    }

    public BooleanPropertyDefinition getUsePasswordCachingPropertyDefinition() {
        return PD_USE_PASSWORD_CACHING;
    }

    public BooleanPropertyDefinition getUseSSLPropertyDefinition() {
        return PD_USE_SSL;
    }

    public BooleanPropertyDefinition getUseTCPKeepAlivePropertyDefinition() {
        return PD_USE_TCP_KEEP_ALIVE;
    }

    public BooleanPropertyDefinition getUseTCPNoDelayPropertyDefinition() {
        return PD_USE_TCP_NO_DELAY;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "cached-password-storage-scheme");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "cached-password-storage-scheme"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("password-storage-scheme");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_CACHED_PASSWORD_STORAGE_SCHEME = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CACHED_PASSWORD_STORAGE_SCHEME);
        INSTANCE.registerConstraint(PD_CACHED_PASSWORD_STORAGE_SCHEME.getSourceConstraint());
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "cached-password-ttl");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "cached-password-ttl"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("8 hours");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        PD_CACHED_PASSWORD_TTL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CACHED_PASSWORD_TTL);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "connection-timeout");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "connection-timeout"));
        provider = new DefinedDefaultBehaviorProvider("3 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_CONNECTION_TIMEOUT = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONNECTION_TIMEOUT);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.LDAPPassThroughAuthenticationPolicyFactory");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.AuthenticationPolicyFactory");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "mapped-attribute");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "mapped-attribute"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_MAPPED_ATTRIBUTE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAPPED_ATTRIBUTE);
        builder = DNPropertyDefinition.createBuilder(INSTANCE, "mapped-search-base-dn");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "mapped-search-base-dn"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_MAPPED_SEARCH_BASE_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAPPED_SEARCH_BASE_DN);
        builder = DNPropertyDefinition.createBuilder(INSTANCE, "mapped-search-bind-dn");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "mapped-search-bind-dn"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "mapped-search-bind-dn"));
        PD_MAPPED_SEARCH_BIND_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAPPED_SEARCH_BIND_DN);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "mapped-search-bind-password");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "mapped-search-bind-password"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_MAPPED_SEARCH_BIND_PASSWORD = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAPPED_SEARCH_BIND_PASSWORD);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "mapped-search-bind-password-environment-variable");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "mapped-search-bind-password-environment-variable"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_MAPPED_SEARCH_BIND_PASSWORD_ENVIRONMENT_VARIABLE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAPPED_SEARCH_BIND_PASSWORD_ENVIRONMENT_VARIABLE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "mapped-search-bind-password-file");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "mapped-search-bind-password-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_MAPPED_SEARCH_BIND_PASSWORD_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAPPED_SEARCH_BIND_PASSWORD_FILE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "mapped-search-bind-password-property");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "mapped-search-bind-password-property"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_MAPPED_SEARCH_BIND_PASSWORD_PROPERTY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAPPED_SEARCH_BIND_PASSWORD_PROPERTY);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "mapping-policy");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "mapping-policy"));
        provider = new DefinedDefaultBehaviorProvider("unmapped");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(MappingPolicy.class);
        PD_MAPPING_POLICY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAPPING_POLICY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "primary-remote-ldap-server");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "primary-remote-ldap-server"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^.+:[0-9]+$", "HOST:PORT");
        PD_PRIMARY_REMOTE_LDAP_SERVER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PRIMARY_REMOTE_LDAP_SERVER);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "secondary-remote-ldap-server");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "secondary-remote-ldap-server"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "secondary-remote-ldap-server"));
        ((StringPropertyDefinition.Builder)builder).setPattern("^.+:[0-9]+$", "HOST:PORT");
        PD_SECONDARY_REMOTE_LDAP_SERVER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SECONDARY_REMOTE_LDAP_SERVER);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cipher-suite");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-cipher-suite"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cipher-suite"));
        PD_SSL_CIPHER_SUITE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CIPHER_SUITE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-protocol");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-protocol"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-protocol"));
        PD_SSL_PROTOCOL = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_PROTOCOL);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "trust-manager-provider");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "trust-manager-provider"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "trust-manager-provider"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("trust-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.and(Conditions.contains("use-ssl", "true")));
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_TRUST_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_TRUST_MANAGER_PROVIDER.getSourceConstraint());
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-password-caching");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "use-password-caching"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_PASSWORD_CACHING = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_PASSWORD_CACHING);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-ssl");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "use-ssl"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_SSL = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_SSL);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-tcp-keep-alive");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "use-tcp-keep-alive"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_TCP_KEEP_ALIVE = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_TCP_KEEP_ALIVE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-tcp-no-delay");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "use-tcp-no-delay"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_TCP_NO_DELAY = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_TCP_NO_DELAY);
        INSTANCE.registerTag(Tag.valueOf("user-management"));
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 1, Conditions.implies(Conditions.or(Conditions.contains("mapping-policy", "mapped-bind"), Conditions.contains("mapping-policy", "mapped-search")), Conditions.isPresent("mapped-attribute"))));
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 2, Conditions.implies(Conditions.contains("mapping-policy", "mapped-search"), Conditions.isPresent("mapped-search-base-dn"))));
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 3, Conditions.implies(Conditions.and(Conditions.contains("mapping-policy", "mapped-search"), Conditions.isPresent("mapped-search-bind-dn")), Conditions.or(Conditions.isPresent("mapped-search-bind-password"), Conditions.isPresent("mapped-search-bind-password-property"), Conditions.isPresent("mapped-search-bind-password-environment-variable"), Conditions.isPresent("mapped-search-bind-password-file")))));
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 4, Conditions.implies(Conditions.contains("use-password-caching", "true"), Conditions.isPresent("cached-password-storage-scheme"))));
    }

    private static class LDAPPassThroughAuthenticationPolicyCfgServerImpl
    implements LDAPPassThroughAuthenticationPolicyCfg {
        private ServerManagedObject<? extends LDAPPassThroughAuthenticationPolicyCfg> impl;
        private final String pCachedPasswordStorageScheme;
        private final long pCachedPasswordTTL;
        private final long pConnectionTimeout;
        private final String pJavaClass;
        private final SortedSet<AttributeType> pMappedAttribute;
        private final SortedSet<DN> pMappedSearchBaseDN;
        private final DN pMappedSearchBindDN;
        private final String pMappedSearchBindPassword;
        private final String pMappedSearchBindPasswordEnvironmentVariable;
        private final String pMappedSearchBindPasswordFile;
        private final String pMappedSearchBindPasswordProperty;
        private final MappingPolicy pMappingPolicy;
        private final SortedSet<String> pPrimaryRemoteLDAPServer;
        private final SortedSet<String> pSecondaryRemoteLDAPServer;
        private final SortedSet<String> pSSLCipherSuite;
        private final SortedSet<String> pSSLProtocol;
        private final String pTrustManagerProvider;
        private final boolean pUsePasswordCaching;
        private final boolean pUseSSL;
        private final boolean pUseTCPKeepAlive;
        private final boolean pUseTCPNoDelay;

        private LDAPPassThroughAuthenticationPolicyCfgServerImpl(ServerManagedObject<? extends LDAPPassThroughAuthenticationPolicyCfg> impl) {
            this.impl = impl;
            this.pCachedPasswordStorageScheme = impl.getPropertyValue(INSTANCE.getCachedPasswordStorageSchemePropertyDefinition());
            this.pCachedPasswordTTL = impl.getPropertyValue(INSTANCE.getCachedPasswordTTLPropertyDefinition());
            this.pConnectionTimeout = impl.getPropertyValue(INSTANCE.getConnectionTimeoutPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pMappedAttribute = impl.getPropertyValues((PropertyDefinition)INSTANCE.getMappedAttributePropertyDefinition());
            this.pMappedSearchBaseDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getMappedSearchBaseDNPropertyDefinition());
            this.pMappedSearchBindDN = impl.getPropertyValue(INSTANCE.getMappedSearchBindDNPropertyDefinition());
            this.pMappedSearchBindPassword = impl.getPropertyValue(INSTANCE.getMappedSearchBindPasswordPropertyDefinition());
            this.pMappedSearchBindPasswordEnvironmentVariable = impl.getPropertyValue(INSTANCE.getMappedSearchBindPasswordEnvironmentVariablePropertyDefinition());
            this.pMappedSearchBindPasswordFile = impl.getPropertyValue(INSTANCE.getMappedSearchBindPasswordFilePropertyDefinition());
            this.pMappedSearchBindPasswordProperty = impl.getPropertyValue(INSTANCE.getMappedSearchBindPasswordPropertyPropertyDefinition());
            this.pMappingPolicy = impl.getPropertyValue(INSTANCE.getMappingPolicyPropertyDefinition());
            this.pPrimaryRemoteLDAPServer = impl.getPropertyValues((PropertyDefinition)INSTANCE.getPrimaryRemoteLDAPServerPropertyDefinition());
            this.pSecondaryRemoteLDAPServer = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSecondaryRemoteLDAPServerPropertyDefinition());
            this.pSSLCipherSuite = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCipherSuitePropertyDefinition());
            this.pSSLProtocol = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLProtocolPropertyDefinition());
            this.pTrustManagerProvider = impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
            this.pUsePasswordCaching = impl.getPropertyValue(INSTANCE.getUsePasswordCachingPropertyDefinition());
            this.pUseSSL = impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
            this.pUseTCPKeepAlive = impl.getPropertyValue(INSTANCE.getUseTCPKeepAlivePropertyDefinition());
            this.pUseTCPNoDelay = impl.getPropertyValue(INSTANCE.getUseTCPNoDelayPropertyDefinition());
        }

        @Override
        public void addLDAPPassThroughChangeListener(ConfigurationChangeListener<LDAPPassThroughAuthenticationPolicyCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeLDAPPassThroughChangeListener(ConfigurationChangeListener<LDAPPassThroughAuthenticationPolicyCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<AuthenticationPolicyCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<AuthenticationPolicyCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getCachedPasswordStorageScheme() {
            return this.pCachedPasswordStorageScheme;
        }

        @Override
        public DN getCachedPasswordStorageSchemeDN() {
            String value = this.getCachedPasswordStorageScheme();
            if (value == null) {
                return null;
            }
            return INSTANCE.getCachedPasswordStorageSchemePropertyDefinition().getChildDN(value);
        }

        @Override
        public long getCachedPasswordTTL() {
            return this.pCachedPasswordTTL;
        }

        @Override
        public long getConnectionTimeout() {
            return this.pConnectionTimeout;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<AttributeType> getMappedAttribute() {
            return this.pMappedAttribute;
        }

        @Override
        public SortedSet<DN> getMappedSearchBaseDN() {
            return this.pMappedSearchBaseDN;
        }

        @Override
        public DN getMappedSearchBindDN() {
            return this.pMappedSearchBindDN;
        }

        @Override
        public String getMappedSearchBindPassword() {
            return this.pMappedSearchBindPassword;
        }

        @Override
        public String getMappedSearchBindPasswordEnvironmentVariable() {
            return this.pMappedSearchBindPasswordEnvironmentVariable;
        }

        @Override
        public String getMappedSearchBindPasswordFile() {
            return this.pMappedSearchBindPasswordFile;
        }

        @Override
        public String getMappedSearchBindPasswordProperty() {
            return this.pMappedSearchBindPasswordProperty;
        }

        @Override
        public MappingPolicy getMappingPolicy() {
            return this.pMappingPolicy;
        }

        @Override
        public SortedSet<String> getPrimaryRemoteLDAPServer() {
            return this.pPrimaryRemoteLDAPServer;
        }

        @Override
        public SortedSet<String> getSecondaryRemoteLDAPServer() {
            return this.pSecondaryRemoteLDAPServer;
        }

        @Override
        public SortedSet<String> getSSLCipherSuite() {
            return this.pSSLCipherSuite;
        }

        @Override
        public SortedSet<String> getSSLProtocol() {
            return this.pSSLProtocol;
        }

        @Override
        public String getTrustManagerProvider() {
            return this.pTrustManagerProvider;
        }

        @Override
        public DN getTrustManagerProviderDN() {
            String value = this.getTrustManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getTrustManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public boolean isUsePasswordCaching() {
            return this.pUsePasswordCaching;
        }

        @Override
        public boolean isUseSSL() {
            return this.pUseSSL;
        }

        @Override
        public boolean isUseTCPKeepAlive() {
            return this.pUseTCPKeepAlive;
        }

        @Override
        public boolean isUseTCPNoDelay() {
            return this.pUseTCPNoDelay;
        }

        @Override
        public Class<? extends LDAPPassThroughAuthenticationPolicyCfg> configurationClass() {
            return LDAPPassThroughAuthenticationPolicyCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class LDAPPassThroughAuthenticationPolicyCfgClientImpl
    implements LDAPPassThroughAuthenticationPolicyCfgClient {
        private ManagedObject<? extends LDAPPassThroughAuthenticationPolicyCfgClient> impl;

        private LDAPPassThroughAuthenticationPolicyCfgClientImpl(ManagedObject<? extends LDAPPassThroughAuthenticationPolicyCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getCachedPasswordStorageScheme() {
            return this.impl.getPropertyValue(INSTANCE.getCachedPasswordStorageSchemePropertyDefinition());
        }

        @Override
        public void setCachedPasswordStorageScheme(String value) {
            this.impl.setPropertyValue(INSTANCE.getCachedPasswordStorageSchemePropertyDefinition(), value);
        }

        @Override
        public long getCachedPasswordTTL() {
            return this.impl.getPropertyValue(INSTANCE.getCachedPasswordTTLPropertyDefinition());
        }

        @Override
        public void setCachedPasswordTTL(Long value) {
            this.impl.setPropertyValue(INSTANCE.getCachedPasswordTTLPropertyDefinition(), value);
        }

        @Override
        public long getConnectionTimeout() {
            return this.impl.getPropertyValue(INSTANCE.getConnectionTimeoutPropertyDefinition());
        }

        @Override
        public void setConnectionTimeout(Long value) {
            this.impl.setPropertyValue(INSTANCE.getConnectionTimeoutPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<AttributeType> getMappedAttribute() {
            return this.impl.getPropertyValues(INSTANCE.getMappedAttributePropertyDefinition());
        }

        @Override
        public void setMappedAttribute(Collection<AttributeType> values) {
            this.impl.setPropertyValues(INSTANCE.getMappedAttributePropertyDefinition(), values);
        }

        @Override
        public SortedSet<DN> getMappedSearchBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getMappedSearchBaseDNPropertyDefinition());
        }

        @Override
        public void setMappedSearchBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getMappedSearchBaseDNPropertyDefinition(), values);
        }

        @Override
        public DN getMappedSearchBindDN() {
            return this.impl.getPropertyValue(INSTANCE.getMappedSearchBindDNPropertyDefinition());
        }

        @Override
        public void setMappedSearchBindDN(DN value) {
            this.impl.setPropertyValue(INSTANCE.getMappedSearchBindDNPropertyDefinition(), value);
        }

        @Override
        public String getMappedSearchBindPassword() {
            return this.impl.getPropertyValue(INSTANCE.getMappedSearchBindPasswordPropertyDefinition());
        }

        @Override
        public void setMappedSearchBindPassword(String value) {
            this.impl.setPropertyValue(INSTANCE.getMappedSearchBindPasswordPropertyDefinition(), value);
        }

        @Override
        public String getMappedSearchBindPasswordEnvironmentVariable() {
            return this.impl.getPropertyValue(INSTANCE.getMappedSearchBindPasswordEnvironmentVariablePropertyDefinition());
        }

        @Override
        public void setMappedSearchBindPasswordEnvironmentVariable(String value) {
            this.impl.setPropertyValue(INSTANCE.getMappedSearchBindPasswordEnvironmentVariablePropertyDefinition(), value);
        }

        @Override
        public String getMappedSearchBindPasswordFile() {
            return this.impl.getPropertyValue(INSTANCE.getMappedSearchBindPasswordFilePropertyDefinition());
        }

        @Override
        public void setMappedSearchBindPasswordFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getMappedSearchBindPasswordFilePropertyDefinition(), value);
        }

        @Override
        public String getMappedSearchBindPasswordProperty() {
            return this.impl.getPropertyValue(INSTANCE.getMappedSearchBindPasswordPropertyPropertyDefinition());
        }

        @Override
        public void setMappedSearchBindPasswordProperty(String value) {
            this.impl.setPropertyValue(INSTANCE.getMappedSearchBindPasswordPropertyPropertyDefinition(), value);
        }

        @Override
        public MappingPolicy getMappingPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getMappingPolicyPropertyDefinition());
        }

        @Override
        public void setMappingPolicy(MappingPolicy value) {
            this.impl.setPropertyValue(INSTANCE.getMappingPolicyPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getPrimaryRemoteLDAPServer() {
            return this.impl.getPropertyValues(INSTANCE.getPrimaryRemoteLDAPServerPropertyDefinition());
        }

        @Override
        public void setPrimaryRemoteLDAPServer(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getPrimaryRemoteLDAPServerPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getSecondaryRemoteLDAPServer() {
            return this.impl.getPropertyValues(INSTANCE.getSecondaryRemoteLDAPServerPropertyDefinition());
        }

        @Override
        public void setSecondaryRemoteLDAPServer(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSecondaryRemoteLDAPServerPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getSSLCipherSuite() {
            return this.impl.getPropertyValues(INSTANCE.getSSLCipherSuitePropertyDefinition());
        }

        @Override
        public void setSSLCipherSuite(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCipherSuitePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getSSLProtocol() {
            return this.impl.getPropertyValues(INSTANCE.getSSLProtocolPropertyDefinition());
        }

        @Override
        public void setSSLProtocol(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLProtocolPropertyDefinition(), values);
        }

        @Override
        public String getTrustManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void setTrustManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition(), value);
        }

        @Override
        public boolean isUsePasswordCaching() {
            return this.impl.getPropertyValue(INSTANCE.getUsePasswordCachingPropertyDefinition());
        }

        @Override
        public void setUsePasswordCaching(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUsePasswordCachingPropertyDefinition(), value);
        }

        @Override
        public boolean isUseSSL() {
            return this.impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
        }

        @Override
        public void setUseSSL(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseSSLPropertyDefinition(), value);
        }

        @Override
        public boolean isUseTCPKeepAlive() {
            return this.impl.getPropertyValue(INSTANCE.getUseTCPKeepAlivePropertyDefinition());
        }

        @Override
        public void setUseTCPKeepAlive(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseTCPKeepAlivePropertyDefinition(), value);
        }

        @Override
        public boolean isUseTCPNoDelay() {
            return this.impl.getPropertyValue(INSTANCE.getUseTCPNoDelayPropertyDefinition());
        }

        @Override
        public void setUseTCPNoDelay(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseTCPNoDelayPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends LDAPPassThroughAuthenticationPolicyCfgClient, ? extends LDAPPassThroughAuthenticationPolicyCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    public static enum MappingPolicy {
        MAPPED_BIND("mapped-bind"),
        MAPPED_SEARCH("mapped-search"),
        UNMAPPED("unmapped");

        private final String name;

        private MappingPolicy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

