/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.GenericConstraint;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.condition.Conditions;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.FileBasedKeyManagerProviderCfgClient;
import org.opends.server.admin.std.meta.KeyManagerProviderCfgDefn;
import org.opends.server.admin.std.server.FileBasedKeyManagerProviderCfg;
import org.opends.server.admin.std.server.KeyManagerProviderCfg;
import org.opends.server.types.DN;

public final class FileBasedKeyManagerProviderCfgDefn
extends ManagedObjectDefinition<FileBasedKeyManagerProviderCfgClient, FileBasedKeyManagerProviderCfg> {
    private static final FileBasedKeyManagerProviderCfgDefn INSTANCE = new FileBasedKeyManagerProviderCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_KEY_STORE_FILE;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN_FILE;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN_PROPERTY;
    private static final StringPropertyDefinition PD_KEY_STORE_TYPE;

    public static FileBasedKeyManagerProviderCfgDefn getInstance() {
        return INSTANCE;
    }

    private FileBasedKeyManagerProviderCfgDefn() {
        super("file-based-key-manager-provider", KeyManagerProviderCfgDefn.getInstance());
    }

    @Override
    public FileBasedKeyManagerProviderCfgClient createClientConfiguration(ManagedObject<? extends FileBasedKeyManagerProviderCfgClient> impl) {
        return new FileBasedKeyManagerProviderCfgClientImpl(impl);
    }

    @Override
    public FileBasedKeyManagerProviderCfg createServerConfiguration(ServerManagedObject<? extends FileBasedKeyManagerProviderCfg> impl) {
        return new FileBasedKeyManagerProviderCfgServerImpl(impl);
    }

    @Override
    public Class<FileBasedKeyManagerProviderCfg> getServerConfigurationClass() {
        return FileBasedKeyManagerProviderCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return KeyManagerProviderCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getKeyStoreFilePropertyDefinition() {
        return PD_KEY_STORE_FILE;
    }

    public StringPropertyDefinition getKeyStorePinPropertyDefinition() {
        return PD_KEY_STORE_PIN;
    }

    public StringPropertyDefinition getKeyStorePinEnvironmentVariablePropertyDefinition() {
        return PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE;
    }

    public StringPropertyDefinition getKeyStorePinFilePropertyDefinition() {
        return PD_KEY_STORE_PIN_FILE;
    }

    public StringPropertyDefinition getKeyStorePinPropertyPropertyDefinition() {
        return PD_KEY_STORE_PIN_PROPERTY;
    }

    public StringPropertyDefinition getKeyStoreTypePropertyDefinition() {
        return PD_KEY_STORE_TYPE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.FileBasedKeyManagerProvider");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.KeyManagerProvider");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-file");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "FILE");
        PD_KEY_STORE_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_FILE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_KEY_STORE_PIN = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin-environment-variable");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin-environment-variable"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin-file");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "FILE");
        PD_KEY_STORE_PIN_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN_FILE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin-property");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin-property"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_KEY_STORE_PIN_PROPERTY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN_PROPERTY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-type");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-type"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_KEY_STORE_TYPE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_TYPE);
        INSTANCE.registerTag(Tag.valueOf("security"));
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 1, Conditions.implies(Conditions.contains("enabled", "true"), Conditions.or(Conditions.isPresent("key-store-pin-property"), Conditions.isPresent("key-store-pin-environment-variable"), Conditions.isPresent("key-store-pin-file"), Conditions.isPresent("key-store-pin")))));
    }

    private static class FileBasedKeyManagerProviderCfgServerImpl
    implements FileBasedKeyManagerProviderCfg {
        private ServerManagedObject<? extends FileBasedKeyManagerProviderCfg> impl;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final String pKeyStoreFile;
        private final String pKeyStorePin;
        private final String pKeyStorePinEnvironmentVariable;
        private final String pKeyStorePinFile;
        private final String pKeyStorePinProperty;
        private final String pKeyStoreType;

        private FileBasedKeyManagerProviderCfgServerImpl(ServerManagedObject<? extends FileBasedKeyManagerProviderCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pKeyStoreFile = impl.getPropertyValue(INSTANCE.getKeyStoreFilePropertyDefinition());
            this.pKeyStorePin = impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyDefinition());
            this.pKeyStorePinEnvironmentVariable = impl.getPropertyValue(INSTANCE.getKeyStorePinEnvironmentVariablePropertyDefinition());
            this.pKeyStorePinFile = impl.getPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition());
            this.pKeyStorePinProperty = impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyPropertyDefinition());
            this.pKeyStoreType = impl.getPropertyValue(INSTANCE.getKeyStoreTypePropertyDefinition());
        }

        @Override
        public void addFileBasedChangeListener(ConfigurationChangeListener<FileBasedKeyManagerProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeFileBasedChangeListener(ConfigurationChangeListener<FileBasedKeyManagerProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<KeyManagerProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<KeyManagerProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getKeyStoreFile() {
            return this.pKeyStoreFile;
        }

        @Override
        public String getKeyStorePin() {
            return this.pKeyStorePin;
        }

        @Override
        public String getKeyStorePinEnvironmentVariable() {
            return this.pKeyStorePinEnvironmentVariable;
        }

        @Override
        public String getKeyStorePinFile() {
            return this.pKeyStorePinFile;
        }

        @Override
        public String getKeyStorePinProperty() {
            return this.pKeyStorePinProperty;
        }

        @Override
        public String getKeyStoreType() {
            return this.pKeyStoreType;
        }

        @Override
        public Class<? extends FileBasedKeyManagerProviderCfg> configurationClass() {
            return FileBasedKeyManagerProviderCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class FileBasedKeyManagerProviderCfgClientImpl
    implements FileBasedKeyManagerProviderCfgClient {
        private ManagedObject<? extends FileBasedKeyManagerProviderCfgClient> impl;

        private FileBasedKeyManagerProviderCfgClientImpl(ManagedObject<? extends FileBasedKeyManagerProviderCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getKeyStoreFile() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStoreFilePropertyDefinition());
        }

        @Override
        public void setKeyStoreFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStoreFilePropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePin() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyDefinition());
        }

        @Override
        public void setKeyStorePin(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinPropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePinEnvironmentVariable() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinEnvironmentVariablePropertyDefinition());
        }

        @Override
        public void setKeyStorePinEnvironmentVariable(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinEnvironmentVariablePropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePinFile() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition());
        }

        @Override
        public void setKeyStorePinFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePinProperty() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyPropertyDefinition());
        }

        @Override
        public void setKeyStorePinProperty(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinPropertyPropertyDefinition(), value);
        }

        @Override
        public String getKeyStoreType() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStoreTypePropertyDefinition());
        }

        @Override
        public void setKeyStoreType(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStoreTypePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends FileBasedKeyManagerProviderCfgClient, ? extends FileBasedKeyManagerProviderCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

