/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.condition.Conditions;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.CertificateMapperCfgClient;
import org.opends.server.admin.std.client.ExternalSASLMechanismHandlerCfgClient;
import org.opends.server.admin.std.meta.SASLMechanismHandlerCfgDefn;
import org.opends.server.admin.std.server.CertificateMapperCfg;
import org.opends.server.admin.std.server.ExternalSASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;

public final class ExternalSASLMechanismHandlerCfgDefn
extends ManagedObjectDefinition<ExternalSASLMechanismHandlerCfgClient, ExternalSASLMechanismHandlerCfg> {
    private static final ExternalSASLMechanismHandlerCfgDefn INSTANCE = new ExternalSASLMechanismHandlerCfgDefn();
    private static final AttributeTypePropertyDefinition PD_CERTIFICATE_ATTRIBUTE;
    private static final AggregationPropertyDefinition<CertificateMapperCfgClient, CertificateMapperCfg> PD_CERTIFICATE_MAPPER;
    private static final EnumPropertyDefinition<CertificateValidationPolicy> PD_CERTIFICATE_VALIDATION_POLICY;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static ExternalSASLMechanismHandlerCfgDefn getInstance() {
        return INSTANCE;
    }

    private ExternalSASLMechanismHandlerCfgDefn() {
        super("external-sasl-mechanism-handler", SASLMechanismHandlerCfgDefn.getInstance());
    }

    @Override
    public ExternalSASLMechanismHandlerCfgClient createClientConfiguration(ManagedObject<? extends ExternalSASLMechanismHandlerCfgClient> impl) {
        return new ExternalSASLMechanismHandlerCfgClientImpl(impl);
    }

    @Override
    public ExternalSASLMechanismHandlerCfg createServerConfiguration(ServerManagedObject<? extends ExternalSASLMechanismHandlerCfg> impl) {
        return new ExternalSASLMechanismHandlerCfgServerImpl(impl);
    }

    @Override
    public Class<ExternalSASLMechanismHandlerCfg> getServerConfigurationClass() {
        return ExternalSASLMechanismHandlerCfg.class;
    }

    public AttributeTypePropertyDefinition getCertificateAttributePropertyDefinition() {
        return PD_CERTIFICATE_ATTRIBUTE;
    }

    public AggregationPropertyDefinition<CertificateMapperCfgClient, CertificateMapperCfg> getCertificateMapperPropertyDefinition() {
        return PD_CERTIFICATE_MAPPER;
    }

    public EnumPropertyDefinition<CertificateValidationPolicy> getCertificateValidationPolicyPropertyDefinition() {
        return PD_CERTIFICATE_VALIDATION_POLICY;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return SASLMechanismHandlerCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "certificate-attribute");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "certificate-attribute"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("userCertificate");
        builder.setDefaultBehaviorProvider(provider);
        PD_CERTIFICATE_ATTRIBUTE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CERTIFICATE_ATTRIBUTE);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "certificate-mapper");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "certificate-mapper"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("certificate-mapper");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.contains("enabled", "true"));
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_CERTIFICATE_MAPPER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CERTIFICATE_MAPPER);
        INSTANCE.registerConstraint(PD_CERTIFICATE_MAPPER.getSourceConstraint());
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "certificate-validation-policy");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "certificate-validation-policy"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(CertificateValidationPolicy.class);
        PD_CERTIFICATE_VALIDATION_POLICY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CERTIFICATE_VALIDATION_POLICY);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.ExternalSASLMechanismHandler");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.SASLMechanismHandler");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("security"));
    }

    private static class ExternalSASLMechanismHandlerCfgServerImpl
    implements ExternalSASLMechanismHandlerCfg {
        private ServerManagedObject<? extends ExternalSASLMechanismHandlerCfg> impl;
        private final AttributeType pCertificateAttribute;
        private final String pCertificateMapper;
        private final CertificateValidationPolicy pCertificateValidationPolicy;
        private final boolean pEnabled;
        private final String pJavaClass;

        private ExternalSASLMechanismHandlerCfgServerImpl(ServerManagedObject<? extends ExternalSASLMechanismHandlerCfg> impl) {
            this.impl = impl;
            this.pCertificateAttribute = impl.getPropertyValue(INSTANCE.getCertificateAttributePropertyDefinition());
            this.pCertificateMapper = impl.getPropertyValue(INSTANCE.getCertificateMapperPropertyDefinition());
            this.pCertificateValidationPolicy = impl.getPropertyValue(INSTANCE.getCertificateValidationPolicyPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addExternalChangeListener(ConfigurationChangeListener<ExternalSASLMechanismHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeExternalChangeListener(ConfigurationChangeListener<ExternalSASLMechanismHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<SASLMechanismHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<SASLMechanismHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public AttributeType getCertificateAttribute() {
            return this.pCertificateAttribute;
        }

        @Override
        public String getCertificateMapper() {
            return this.pCertificateMapper;
        }

        @Override
        public DN getCertificateMapperDN() {
            String value = this.getCertificateMapper();
            if (value == null) {
                return null;
            }
            return INSTANCE.getCertificateMapperPropertyDefinition().getChildDN(value);
        }

        @Override
        public CertificateValidationPolicy getCertificateValidationPolicy() {
            return this.pCertificateValidationPolicy;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends ExternalSASLMechanismHandlerCfg> configurationClass() {
            return ExternalSASLMechanismHandlerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class ExternalSASLMechanismHandlerCfgClientImpl
    implements ExternalSASLMechanismHandlerCfgClient {
        private ManagedObject<? extends ExternalSASLMechanismHandlerCfgClient> impl;

        private ExternalSASLMechanismHandlerCfgClientImpl(ManagedObject<? extends ExternalSASLMechanismHandlerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public AttributeType getCertificateAttribute() {
            return this.impl.getPropertyValue(INSTANCE.getCertificateAttributePropertyDefinition());
        }

        @Override
        public void setCertificateAttribute(AttributeType value) {
            this.impl.setPropertyValue(INSTANCE.getCertificateAttributePropertyDefinition(), value);
        }

        @Override
        public String getCertificateMapper() {
            return this.impl.getPropertyValue(INSTANCE.getCertificateMapperPropertyDefinition());
        }

        @Override
        public void setCertificateMapper(String value) {
            this.impl.setPropertyValue(INSTANCE.getCertificateMapperPropertyDefinition(), value);
        }

        @Override
        public CertificateValidationPolicy getCertificateValidationPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getCertificateValidationPolicyPropertyDefinition());
        }

        @Override
        public void setCertificateValidationPolicy(CertificateValidationPolicy value) {
            this.impl.setPropertyValue(INSTANCE.getCertificateValidationPolicyPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ExternalSASLMechanismHandlerCfgClient, ? extends ExternalSASLMechanismHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    public static enum CertificateValidationPolicy {
        ALWAYS("always"),
        IFPRESENT("ifpresent"),
        NEVER("never");

        private final String name;

        private CertificateValidationPolicy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

