/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.Tag;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.CryptPasswordStorageSchemeCfgClient;
import org.opends.server.admin.std.meta.PasswordStorageSchemeCfgDefn;
import org.opends.server.admin.std.server.CryptPasswordStorageSchemeCfg;
import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.types.DN;

public final class CryptPasswordStorageSchemeCfgDefn
extends ManagedObjectDefinition<CryptPasswordStorageSchemeCfgClient, CryptPasswordStorageSchemeCfg> {
    private static final CryptPasswordStorageSchemeCfgDefn INSTANCE = new CryptPasswordStorageSchemeCfgDefn();
    private static final EnumPropertyDefinition<CryptPasswordStorageEncryptionAlgorithm> PD_CRYPT_PASSWORD_STORAGE_ENCRYPTION_ALGORITHM;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static CryptPasswordStorageSchemeCfgDefn getInstance() {
        return INSTANCE;
    }

    private CryptPasswordStorageSchemeCfgDefn() {
        super("crypt-password-storage-scheme", PasswordStorageSchemeCfgDefn.getInstance());
    }

    @Override
    public CryptPasswordStorageSchemeCfgClient createClientConfiguration(ManagedObject<? extends CryptPasswordStorageSchemeCfgClient> impl) {
        return new CryptPasswordStorageSchemeCfgClientImpl(impl);
    }

    @Override
    public CryptPasswordStorageSchemeCfg createServerConfiguration(ServerManagedObject<? extends CryptPasswordStorageSchemeCfg> impl) {
        return new CryptPasswordStorageSchemeCfgServerImpl(impl);
    }

    @Override
    public Class<CryptPasswordStorageSchemeCfg> getServerConfigurationClass() {
        return CryptPasswordStorageSchemeCfg.class;
    }

    public EnumPropertyDefinition<CryptPasswordStorageEncryptionAlgorithm> getCryptPasswordStorageEncryptionAlgorithmPropertyDefinition() {
        return PD_CRYPT_PASSWORD_STORAGE_ENCRYPTION_ALGORITHM;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PasswordStorageSchemeCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = EnumPropertyDefinition.createBuilder(INSTANCE, "crypt-password-storage-encryption-algorithm");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "crypt-password-storage-encryption-algorithm"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("unix");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(CryptPasswordStorageEncryptionAlgorithm.class);
        PD_CRYPT_PASSWORD_STORAGE_ENCRYPTION_ALGORITHM = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CRYPT_PASSWORD_STORAGE_ENCRYPTION_ALGORITHM);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.CryptPasswordStorageScheme");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.PasswordStorageScheme");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("user-management"));
    }

    private static class CryptPasswordStorageSchemeCfgServerImpl
    implements CryptPasswordStorageSchemeCfg {
        private ServerManagedObject<? extends CryptPasswordStorageSchemeCfg> impl;
        private final CryptPasswordStorageEncryptionAlgorithm pCryptPasswordStorageEncryptionAlgorithm;
        private final boolean pEnabled;
        private final String pJavaClass;

        private CryptPasswordStorageSchemeCfgServerImpl(ServerManagedObject<? extends CryptPasswordStorageSchemeCfg> impl) {
            this.impl = impl;
            this.pCryptPasswordStorageEncryptionAlgorithm = impl.getPropertyValue(INSTANCE.getCryptPasswordStorageEncryptionAlgorithmPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addCryptChangeListener(ConfigurationChangeListener<CryptPasswordStorageSchemeCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeCryptChangeListener(ConfigurationChangeListener<CryptPasswordStorageSchemeCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<PasswordStorageSchemeCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<PasswordStorageSchemeCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public CryptPasswordStorageEncryptionAlgorithm getCryptPasswordStorageEncryptionAlgorithm() {
            return this.pCryptPasswordStorageEncryptionAlgorithm;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends CryptPasswordStorageSchemeCfg> configurationClass() {
            return CryptPasswordStorageSchemeCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class CryptPasswordStorageSchemeCfgClientImpl
    implements CryptPasswordStorageSchemeCfgClient {
        private ManagedObject<? extends CryptPasswordStorageSchemeCfgClient> impl;

        private CryptPasswordStorageSchemeCfgClientImpl(ManagedObject<? extends CryptPasswordStorageSchemeCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public CryptPasswordStorageEncryptionAlgorithm getCryptPasswordStorageEncryptionAlgorithm() {
            return this.impl.getPropertyValue(INSTANCE.getCryptPasswordStorageEncryptionAlgorithmPropertyDefinition());
        }

        @Override
        public void setCryptPasswordStorageEncryptionAlgorithm(CryptPasswordStorageEncryptionAlgorithm value) {
            this.impl.setPropertyValue(INSTANCE.getCryptPasswordStorageEncryptionAlgorithmPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends CryptPasswordStorageSchemeCfgClient, ? extends CryptPasswordStorageSchemeCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    public static enum CryptPasswordStorageEncryptionAlgorithm {
        MD5("md5"),
        SHA256("sha256"),
        SHA512("sha512"),
        UNIX("unix");

        private final String name;

        private CryptPasswordStorageEncryptionAlgorithm(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

