/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.condition;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.condition.Condition;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.config.ConfigException;
import org.opends.server.util.Validator;

public final class IsPresentCondition
implements Condition {
    private final String propertyName;
    private PropertyDefinition<?> pd;

    public IsPresentCondition(String propertyName) {
        Validator.ensureNotNull(propertyName);
        this.propertyName = propertyName;
    }

    @Override
    public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws AuthorizationException, CommunicationException {
        SortedSet<?> values = managedObject.getPropertyValues(this.pd);
        return !values.isEmpty();
    }

    @Override
    public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
        Collection values = managedObject.getPropertyValues((PropertyDefinition)this.pd);
        return !values.isEmpty();
    }

    @Override
    public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        this.pd = d.getPropertyDefinition(this.propertyName);
    }
}

