/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.EnumSet;
import java.util.Locale;
import java.util.MissingResourceException;
import org.opends.messages.Message;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.ManagedObjectDefinitionI18NResource;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.util.Validator;

public final class IntegerPropertyDefinition
extends PropertyDefinition<Integer> {
    private static final String UNLIMITED = "unlimited";
    private final int lowerLimit;
    private final Integer upperLimit;
    private final boolean allowUnlimited;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private IntegerPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Integer> defaultBehavior, int lowerLimit, Integer upperLimit, boolean allowUnlimited) {
        super(d, Integer.class, propertyName, options, adminAction, defaultBehavior);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.allowUnlimited = allowUnlimited;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public Integer getUpperLimit() {
        return this.upperLimit;
    }

    public Message getUnitSynopsis() {
        return this.getUnitSynopsis(Locale.getDefault());
    }

    public Message getUnitSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.getName() + ".syntax.integer.unit-synopsis";
        try {
            return resource.getMessage(this.getManagedObjectDefinition(), property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public boolean isAllowUnlimited() {
        return this.allowUnlimited;
    }

    @Override
    public void validateValue(Integer value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
        if (!this.allowUnlimited && value < this.lowerLimit) {
            throw new IllegalPropertyValueException(this, value);
        }
        if (value >= 0 && value < this.lowerLimit) {
            throw new IllegalPropertyValueException(this, value);
        }
        if (this.upperLimit != null && value > this.upperLimit) {
            throw new IllegalPropertyValueException(this, value);
        }
    }

    @Override
    public String encodeValue(Integer value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
        if (this.allowUnlimited && value < 0) {
            return UNLIMITED;
        }
        return value.toString();
    }

    @Override
    public Integer decodeValue(String value) throws IllegalPropertyValueStringException {
        Integer i;
        Validator.ensureNotNull(value);
        if (this.allowUnlimited && value.trim().equalsIgnoreCase(UNLIMITED)) {
            return -1;
        }
        try {
            i = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
        try {
            this.validateValue(i);
        }
        catch (IllegalPropertyValueException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
        return i;
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitInteger(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, Integer value, P p) {
        return v.visitInteger(this, value, p);
    }

    @Override
    public void toString(StringBuilder builder) {
        super.toString(builder);
        builder.append(" lowerLimit=");
        builder.append(this.lowerLimit);
        if (this.upperLimit != null) {
            builder.append(" upperLimit=");
            builder.append(this.upperLimit);
        }
        builder.append(" allowUnlimited=");
        builder.append(this.allowUnlimited);
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }

    public static class Builder
    extends PropertyDefinition.AbstractBuilder<Integer, IntegerPropertyDefinition> {
        private int lowerLimit = 0;
        private Integer upperLimit = null;
        private boolean allowUnlimited = false;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void setLowerLimit(int lowerLimit) throws IllegalArgumentException {
            if (lowerLimit < 0) {
                throw new IllegalArgumentException("Negative lower limit");
            }
            if (this.upperLimit != null && lowerLimit > this.upperLimit) {
                throw new IllegalArgumentException("Lower limit greater than upper limit");
            }
            this.lowerLimit = lowerLimit;
        }

        public final void setUpperLimit(Integer upperLimit) {
            if (upperLimit != null) {
                if (upperLimit < 0) {
                    throw new IllegalArgumentException("Negative lower limit");
                }
                if (this.lowerLimit > upperLimit) {
                    throw new IllegalArgumentException("Lower limit greater than upper limit");
                }
            }
            this.upperLimit = upperLimit;
        }

        public final void setAllowUnlimited(boolean allowUnlimited) {
            this.allowUnlimited = allowUnlimited;
        }

        @Override
        protected IntegerPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Integer> defaultBehavior) {
            return new IntegerPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.lowerLimit, this.upperLimit, this.allowUnlimited);
        }
    }
}

