/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.util.Validator;

public final class IPAddressPropertyDefinition
extends PropertyDefinition<InetAddress> {
    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private IPAddressPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<InetAddress> defaultBehavior) {
        super(d, InetAddress.class, propertyName, options, adminAction, defaultBehavior);
    }

    @Override
    public void validateValue(InetAddress value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
    }

    @Override
    public InetAddress decodeValue(String value) throws IllegalPropertyValueStringException {
        Validator.ensureNotNull(value);
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
    }

    @Override
    public String encodeValue(InetAddress value) throws IllegalPropertyValueException {
        String s = value.toString();
        int i = s.indexOf(47);
        if (i > 0) {
            return s.substring(0, i);
        }
        return value.getHostAddress();
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitIPAddress(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, InetAddress value, P p) {
        return v.visitIPAddress(this, value, p);
    }

    @Override
    public int compare(InetAddress o1, InetAddress o2) {
        return o1.getHostAddress().compareTo(o2.getHostAddress());
    }

    public static class Builder
    extends PropertyDefinition.AbstractBuilder<InetAddress, IPAddressPropertyDefinition> {
        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        @Override
        protected IPAddressPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<InetAddress> defaultBehavior) {
            return new IPAddressPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior);
        }
    }
}

