/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.Locale;
import java.util.MissingResourceException;
import org.opends.messages.Message;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectDefinitionI18NResource;

public final class AdministratorAction {
    private final AbstractManagedObjectDefinition<?, ?> definition;
    private final String propertyName;
    private final Type type;

    public AdministratorAction(Type type, AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        this.type = type;
        this.definition = d;
        this.propertyName = propertyName;
    }

    public final Message getSynopsis() {
        return this.getSynopsis(Locale.getDefault());
    }

    public final Message getSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.propertyName + ".requires-admin-action.synopsis";
        try {
            return resource.getMessage(this.definition, property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final Type getType() {
        return this.type;
    }

    public static enum Type {
        COMPONENT_RESTART("component-restart"),
        NONE("none"),
        OTHER("other"),
        SERVER_RESTART("server-restart");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

