/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import javax.swing.SwingUtilities;
import org.opends.quicksetup.util.BackgroundTask;

class BackgroundTaskThread<T>
extends Thread {
    private final BackgroundTask<T> backgroundTask;

    public BackgroundTaskThread(BackgroundTask<T> backgroundTask) {
        this.backgroundTask = backgroundTask;
    }

    @Override
    public void run() {
        try {
            final T returnValue = this.backgroundTask.processBackgroundTask();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BackgroundTaskThread.this.backgroundTask.backgroundTaskCompleted(returnValue, null);
                }
            });
        }
        catch (Throwable t) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BackgroundTaskThread.this.backgroundTask.backgroundTaskCompleted(null, t);
                }
            });
        }
    }
}

