/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.webstart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.LicenseFile;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.installer.InstallProgressStep;
import org.opends.quicksetup.installer.Installer;
import org.opends.quicksetup.util.FileManager;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.Utils;
import org.opends.quicksetup.util.ZipExtractor;

public class WebStartInstaller
extends Installer {
    private final HashMap<InstallProgressStep, Integer> hmRatio = new HashMap();
    private final HashMap<InstallProgressStep, Message> hmSummary = new HashMap();
    private static final Logger LOG = Logger.getLogger(WebStartInstaller.class.getName());

    public WebStartInstaller() {
        this.initLoader();
        this.setCurrentProgressStep(InstallProgressStep.NOT_STARTED);
    }

    @Override
    public void run() {
        this.initMaps();
        PrintStream origErr = System.err;
        PrintStream origOut = System.out;
        boolean downloadedBits = false;
        try {
            System.setErr(this.getApplicationErrorStream());
            System.setOut(this.getApplicationOutputStream());
            this.setCurrentProgressStep(InstallProgressStep.DOWNLOADING);
            this.notifyListenersOfLog();
            this.notifyListeners(this.getLineBreak());
            this.checkAbort();
            InputStream in = this.getZipInputStream(this.getRatio(InstallProgressStep.EXTRACTING));
            this.setCurrentProgressStep(InstallProgressStep.EXTRACTING);
            if (this.isVerbose()) {
                this.notifyListeners(this.getTaskSeparator());
            }
            this.checkAbort();
            this.createParentDirectoryIfRequired();
            this.extractZipFiles(in, this.getRatio(InstallProgressStep.EXTRACTING), this.getRatio(InstallProgressStep.CONFIGURING_SERVER));
            downloadedBits = true;
            try {
                in.close();
            }
            catch (Throwable t) {
                LOG.log(Level.INFO, "Error closing zip input stream: " + t, t);
            }
            this.checkAbort();
            this.setCurrentProgressStep(InstallProgressStep.CONFIGURING_SERVER);
            if (this.isVerbose()) {
                this.notifyListeners(this.getTaskSeparator());
            }
            this.configureServer();
            this.checkAbort();
            LicenseFile.createFileLicenseApproved();
            this.createData();
            this.checkAbort();
            if (Utils.isWindows() && this.getUserData().getEnableWindowsService()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.ENABLING_WINDOWS_SERVICE);
                this.enableWindowsService();
                this.checkAbort();
            }
            if (this.mustStart()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.STARTING_SERVER);
                Application.PointAdder pointAdder = new Application.PointAdder();
                if (!this.isVerbose()) {
                    this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_STARTING_NON_VERBOSE.get()));
                    pointAdder.start();
                }
                try {
                    new ServerController(this).startServer(!this.isStartVerbose());
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                finally {
                    if (!this.isVerbose()) {
                        pointAdder.stop();
                    }
                }
                if (!this.isVerbose()) {
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                } else {
                    this.notifyListeners(this.getLineBreak());
                }
                this.checkAbort();
            }
            if (this.mustCreateAds()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.CONFIGURING_ADS);
                this.updateADS();
                this.checkAbort();
            }
            if (this.mustConfigureReplication()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.CONFIGURING_REPLICATION);
                this.createReplicatedBackendsIfRequired();
                this.configureReplication();
                this.checkAbort();
            }
            if (this.mustInitializeSuffixes()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.INITIALIZE_REPLICATED_SUFFIXES);
                this.initializeSuffixes();
                this.checkAbort();
            }
            if (this.mustStop()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.STOPPING_SERVER);
                if (!this.isVerbose()) {
                    this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_STOPPING_NON_VERBOSE.get()));
                }
                new ServerController(this).stopServer(!this.isVerbose());
                if (!this.isVerbose()) {
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                }
            }
            this.checkAbort();
            this.updateSummaryWithServerState(this.hmSummary, false);
            this.setCurrentProgressStep(InstallProgressStep.FINISHED_SUCCESSFULLY);
            this.notifyListeners(null);
        }
        catch (ApplicationException ex) {
            if (ReturnCode.CANCELED.equals(ex.getType())) {
                this.uninstall(downloadedBits);
                this.setCurrentProgressStep(InstallProgressStep.FINISHED_CANCELED);
                this.notifyListeners(null);
            }
            Installation installation = this.getInstallation();
            if (installation.getStatus().isServerRunning()) {
                try {
                    if (!this.isVerbose()) {
                        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_STOPPING_NON_VERBOSE.get()));
                    }
                    new ServerController(installation).stopServer(!this.isVerbose());
                    if (!this.isVerbose()) {
                        this.notifyListeners(this.getFormattedDoneWithLineBreak());
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.INFO, "error stopping server", t);
                }
            }
            this.notifyListeners(this.getLineBreak());
            this.updateSummaryWithServerState(this.hmSummary, false);
            this.setCurrentProgressStep(InstallProgressStep.FINISHED_WITH_ERROR);
            Message html = this.getFormattedError(ex, true);
            this.notifyListeners(html);
            LOG.log(Level.SEVERE, "Error installing.", ex);
            this.notifyListeners(this.getLineBreak());
            this.notifyListenersOfLogAfterError();
        }
        catch (Throwable t) {
            Installation installation = this.getInstallation();
            if (installation.getStatus().isServerRunning()) {
                try {
                    new ServerController(installation).stopServer(true);
                }
                catch (Throwable t2) {
                    LOG.log(Level.INFO, "error stopping server", t2);
                }
            }
            this.notifyListeners(this.getLineBreak());
            this.updateSummaryWithServerState(this.hmSummary, false);
            this.setCurrentProgressStep(InstallProgressStep.FINISHED_WITH_ERROR);
            ApplicationException ex = new ApplicationException(ReturnCode.BUG, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t), t);
            Message msg = this.getFormattedError(ex, true);
            this.notifyListeners(msg);
            LOG.log(Level.SEVERE, "Error installing.", t);
            this.notifyListeners(this.getLineBreak());
            this.notifyListenersOfLogAfterError();
        }
        System.setErr(origErr);
        System.setOut(origOut);
    }

    @Override
    public Integer getRatio(ProgressStep status) {
        return this.hmRatio.get(status);
    }

    @Override
    public Message getSummary(ProgressStep status) {
        Message summary = InstallProgressStep.DOWNLOADING.equals(status) ? this.loader.getSummary() : this.hmSummary.get(status);
        return summary;
    }

    private void initMaps() {
        this.initSummaryMap(this.hmSummary, false);
        HashMap<InstallProgressStep, Integer> hmTime = new HashMap<InstallProgressStep, Integer>();
        hmTime.put(InstallProgressStep.DOWNLOADING, 15);
        hmTime.put(InstallProgressStep.EXTRACTING, 15);
        hmTime.put(InstallProgressStep.CONFIGURING_SERVER, 5);
        hmTime.put(InstallProgressStep.CREATING_BASE_ENTRY, 10);
        hmTime.put(InstallProgressStep.IMPORTING_LDIF, 20);
        hmTime.put(InstallProgressStep.IMPORTING_AUTOMATICALLY_GENERATED, 20);
        hmTime.put(InstallProgressStep.CONFIGURING_REPLICATION, 10);
        hmTime.put(InstallProgressStep.ENABLING_WINDOWS_SERVICE, 5);
        hmTime.put(InstallProgressStep.STARTING_SERVER, 10);
        hmTime.put(InstallProgressStep.STOPPING_SERVER, 5);
        hmTime.put(InstallProgressStep.CONFIGURING_ADS, 5);
        hmTime.put(InstallProgressStep.INITIALIZE_REPLICATED_SUFFIXES, 25);
        int totalTime = 0;
        ArrayList<InstallProgressStep> steps = new ArrayList<InstallProgressStep>();
        totalTime += ((Integer)hmTime.get(InstallProgressStep.DOWNLOADING)).intValue();
        steps.add(InstallProgressStep.DOWNLOADING);
        totalTime += ((Integer)hmTime.get(InstallProgressStep.EXTRACTING)).intValue();
        steps.add(InstallProgressStep.EXTRACTING);
        totalTime += ((Integer)hmTime.get(InstallProgressStep.CONFIGURING_SERVER)).intValue();
        steps.add(InstallProgressStep.CONFIGURING_SERVER);
        if (this.createNotReplicatedSuffix()) {
            switch (this.getUserData().getNewSuffixOptions().getType()) {
                case CREATE_BASE_ENTRY: {
                    steps.add(InstallProgressStep.CREATING_BASE_ENTRY);
                    totalTime += ((Integer)hmTime.get(InstallProgressStep.CREATING_BASE_ENTRY)).intValue();
                    break;
                }
                case IMPORT_FROM_LDIF_FILE: {
                    steps.add(InstallProgressStep.IMPORTING_LDIF);
                    totalTime += ((Integer)hmTime.get(InstallProgressStep.IMPORTING_LDIF)).intValue();
                    break;
                }
                case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                    steps.add(InstallProgressStep.IMPORTING_AUTOMATICALLY_GENERATED);
                    totalTime += ((Integer)hmTime.get(InstallProgressStep.IMPORTING_AUTOMATICALLY_GENERATED)).intValue();
                }
            }
        }
        if (Utils.isWindows() && this.getUserData().getEnableWindowsService()) {
            totalTime += ((Integer)hmTime.get(InstallProgressStep.ENABLING_WINDOWS_SERVICE)).intValue();
            steps.add(InstallProgressStep.ENABLING_WINDOWS_SERVICE);
        }
        if (this.mustStart()) {
            totalTime += ((Integer)hmTime.get(InstallProgressStep.STARTING_SERVER)).intValue();
            steps.add(InstallProgressStep.STARTING_SERVER);
        }
        if (this.mustCreateAds()) {
            totalTime += ((Integer)hmTime.get(InstallProgressStep.CONFIGURING_ADS)).intValue();
            steps.add(InstallProgressStep.CONFIGURING_ADS);
        }
        if (this.mustConfigureReplication()) {
            steps.add(InstallProgressStep.CONFIGURING_REPLICATION);
            totalTime += ((Integer)hmTime.get(InstallProgressStep.CONFIGURING_REPLICATION)).intValue();
        }
        if (this.mustInitializeSuffixes()) {
            totalTime += ((Integer)hmTime.get(InstallProgressStep.INITIALIZE_REPLICATED_SUFFIXES)).intValue();
            steps.add(InstallProgressStep.INITIALIZE_REPLICATED_SUFFIXES);
        }
        if (this.mustStop()) {
            totalTime += ((Integer)hmTime.get(InstallProgressStep.STOPPING_SERVER)).intValue();
            steps.add(InstallProgressStep.STOPPING_SERVER);
        }
        int cumulatedTime = 0;
        for (InstallProgressStep s : steps) {
            Integer statusTime = (Integer)hmTime.get(s);
            this.hmRatio.put(s, 100 * cumulatedTime / totalTime);
            if (statusTime == null) continue;
            cumulatedTime += statusTime.intValue();
        }
        this.hmRatio.put(InstallProgressStep.FINISHED_SUCCESSFULLY, 100);
        this.hmRatio.put(InstallProgressStep.FINISHED_CANCELED, 100);
        this.hmRatio.put(InstallProgressStep.FINISHED_WITH_ERROR, 100);
    }

    private InputStream getZipInputStream(Integer maxRatio) throws ApplicationException {
        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_DOWNLOADING.get()));
        this.waitForLoader(maxRatio);
        String zipName = this.getZipFileName();
        InputStream in = Installer.class.getClassLoader().getResourceAsStream(zipName);
        if (in == null) {
            throw new ApplicationException(ReturnCode.DOWNLOAD_ERROR, QuickSetupMessages.INFO_ERROR_ZIPINPUTSTREAMNULL.get(zipName), null);
        }
        this.notifyListeners(this.getFormattedDoneWithLineBreak());
        return in;
    }

    private void createParentDirectoryIfRequired() throws ApplicationException {
        String serverLocation = this.getUserData().getServerLocation();
        if (!Utils.parentDirectoryExists(serverLocation)) {
            File f = new File(serverLocation);
            String parent = f.getParent();
            try {
                if (!Utils.createDirectory(parent)) {
                    throw new ApplicationException(ReturnCode.FILE_SYSTEM_ACCESS_ERROR, QuickSetupMessages.INFO_ERROR_COULD_NOT_CREATE_PARENT_DIR.get(parent), null);
                }
            }
            catch (IOException ioe) {
                throw new ApplicationException(ReturnCode.FILE_SYSTEM_ACCESS_ERROR, QuickSetupMessages.INFO_ERROR_COULD_NOT_CREATE_PARENT_DIR.get(parent), ioe);
            }
        }
    }

    private void extractZipFiles(InputStream is, int minRatio, int maxRatio) throws ApplicationException {
        ZipExtractor extractor = new ZipExtractor(is, minRatio, maxRatio, Utils.getNumberZipEntries(), this.getZipFileName(), this);
        extractor.extract(this.getUserData().getServerLocation());
    }

    private String getZipFileName() {
        return System.getProperty("org.opends.quicksetup.zipfilename");
    }

    private void uninstall(boolean downloadedBits) {
        if (downloadedBits) {
            this.notifyListeners(this.getTaskSeparator());
            if (!this.isVerbose()) {
                this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CANCELING.get()));
            } else {
                this.notifyListeners(this.getFormattedProgressWithLineBreak(QuickSetupMessages.INFO_SUMMARY_CANCELING.get()));
            }
            Installation installation = this.getInstallation();
            FileManager fm = new FileManager(this);
            if (installation.getStatus().isServerRunning()) {
                try {
                    new ServerController(installation).stopServer(true);
                }
                catch (ApplicationException e) {
                    LOG.log(Level.INFO, "error stopping server", e);
                }
            }
            this.uninstallServices();
            try {
                fm.deleteRecursively(installation.getRootDirectory(), null, FileManager.DeletionPolicy.DELETE_ON_EXIT_IF_UNSUCCESSFUL);
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "error deleting files", e);
            }
        } else {
            if (!this.isVerbose()) {
                this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CANCELING.get()));
            } else {
                this.notifyListeners(this.getFormattedProgressWithLineBreak(QuickSetupMessages.INFO_SUMMARY_CANCELING.get()));
            }
            File serverRoot = new File(this.getUserData().getServerLocation());
            if (serverRoot.exists()) {
                FileManager fm = new FileManager(this);
                try {
                    fm.deleteRecursively(serverRoot, null, FileManager.DeletionPolicy.DELETE_ON_EXIT_IF_UNSUCCESSFUL);
                }
                catch (ApplicationException e) {
                    LOG.log(Level.INFO, "error deleting files", e);
                }
            }
        }
        if (!this.isVerbose()) {
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
        }
    }

    @Override
    public String getInstallationPath() {
        return this.getUserData().getServerLocation();
    }

    @Override
    public String getInstancePath() {
        return this.getUserData().getServerLocation();
    }
}

