/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.JavaArguments;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.installer.DataReplicationOptions;
import org.opends.quicksetup.installer.NewSuffixOptions;
import org.opends.quicksetup.installer.SuffixesToReplicateOptions;
import org.opends.quicksetup.installer.ui.JavaArgumentsDialog;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.HtmlProgressMessageFormatter;

public class RuntimeOptionsPanel
extends QuickSetupStepPanel {
    private static final long serialVersionUID = -8303034619200476754L;
    private JButton bServer;
    private JButton bImport;
    private JLabel lServer;
    private JLabel lImport;
    private JEditorPane warning;
    private Component lastFocusComponent;
    private JavaArguments serverJavaArgs;
    private JavaArguments importJavaArgs;
    private JavaArguments defaultServerJavaArgs;
    private JavaArguments defaultImportJavaArgs;
    private static final long WARNING_THRESOLD_FOR_IMPORT = 0xC800000L;
    private static final int WARNING_THRESOLD_AUTOMATICALLY_GENERATED_IMPORT = 100000;
    private static final int WARNING_THRESOLD_REPLICATED_ENTRIES = 100000;

    public RuntimeOptionsPanel(GuiApplication application) {
        super(application);
        this.createComponents();
        this.addFocusListeners();
    }

    @Override
    protected Component createInputPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 4;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.top = 10;
        gbc.insets.bottom = 10;
        gbc.weightx = 1.0;
        panel.add((Component)this.warning, gbc);
        this.warning.setVisible(false);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets.bottom = 0;
        JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_SERVER_RUNTIME_ARGS_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        gbc.insets.top = Math.abs(this.bServer.getPreferredSize().height - l.getPreferredSize().height) / 2;
        panel.add((Component)l, gbc);
        ++gbc.gridx;
        gbc.insets.left = 10;
        gbc.weightx = 0.5;
        panel.add((Component)this.lServer, gbc);
        ++gbc.gridx;
        gbc.insets.top = 0;
        gbc.weightx = 0.0;
        panel.add((Component)this.bServer, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        panel.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_IMPORT_RUNTIME_ARGS_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        int importInsetsTop = Math.abs(this.bImport.getPreferredSize().height - l.getPreferredSize().height) / 2;
        gbc.insets.top = importInsetsTop + 5;
        panel.add((Component)l, gbc);
        ++gbc.gridx;
        gbc.insets.left = 10;
        gbc.weightx = 0.5;
        panel.add((Component)this.lImport, gbc);
        ++gbc.gridx;
        gbc.insets.top = 5;
        gbc.weightx = 0.0;
        panel.add((Component)this.bImport, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        panel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        ++gbc.gridy;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel.add(Box.createVerticalGlue(), gbc);
        return panel;
    }

    @Override
    protected Message getInstructions() {
        return QuickSetupMessages.INFO_JAVA_RUNTIME_OPTIONS_PANEL_INSTRUCTIONS.get();
    }

    @Override
    protected Message getTitle() {
        return QuickSetupMessages.INFO_JAVA_RUNTIME_OPTIONS_PANEL_TITLE.get();
    }

    @Override
    public Object getFieldValue(FieldName fieldName) {
        JavaArguments value = null;
        if (fieldName == FieldName.SERVER_JAVA_ARGUMENTS) {
            value = this.serverJavaArgs;
        } else if (fieldName == FieldName.IMPORT_JAVA_ARGUMENTS) {
            value = this.importJavaArgs;
        }
        return value;
    }

    @Override
    public void beginDisplay(UserData uData) {
        if (this.defaultServerJavaArgs == null) {
            this.defaultServerJavaArgs = uData.getDefaultJavaArguments(UserData.SERVER_SCRIPT_NAME);
        }
        if (this.defaultImportJavaArgs == null) {
            this.defaultImportJavaArgs = uData.getDefaultJavaArguments(UserData.IMPORT_SCRIPT_NAME);
        }
        boolean updatePanel = false;
        if (this.serverJavaArgs == null) {
            this.serverJavaArgs = uData.getJavaArguments(UserData.SERVER_SCRIPT_NAME);
            updatePanel = true;
        }
        if (this.importJavaArgs == null) {
            this.importJavaArgs = uData.getJavaArguments(UserData.IMPORT_SCRIPT_NAME);
            updatePanel = true;
        }
        if (updatePanel) {
            this.lServer.setText(JavaArguments.getMessageForJLabel(this.serverJavaArgs, this.defaultServerJavaArgs, UIFactory.SECONDARY_FIELD_VALID_FONT).toString());
            this.lImport.setText(JavaArguments.getMessageForJLabel(this.importJavaArgs, this.defaultImportJavaArgs, UIFactory.SECONDARY_FIELD_VALID_FONT).toString());
        }
        this.updateWarningMessage(uData);
    }

    @Override
    public void endDisplay() {
        if (this.lastFocusComponent != null) {
            this.lastFocusComponent.requestFocusInWindow();
        }
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    private void addFocusListeners() {
        FocusListener l = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                RuntimeOptionsPanel.this.lastFocusComponent = e.getComponent();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        this.bServer.addFocusListener(l);
        this.bImport.addFocusListener(l);
        this.lastFocusComponent = this.bServer;
    }

    private void changeServerClicked() {
        JavaArgumentsDialog dlg = new JavaArgumentsDialog(this.getFrame(), this.serverJavaArgs, QuickSetupMessages.INFO_SERVER_JAVA_ARGUMENTS_TITLE.get(), QuickSetupMessages.INFO_SERVER_JAVA_ARGUMENTS_MSG.get());
        dlg.pack();
        dlg.setModal(true);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            this.serverJavaArgs = dlg.getJavaArguments();
            this.lServer.setText(JavaArguments.getMessageForJLabel(this.serverJavaArgs, this.defaultServerJavaArgs, UIFactory.SECONDARY_FIELD_VALID_FONT).toString());
        }
    }

    private void changeImportClicked() {
        JavaArgumentsDialog dlg = new JavaArgumentsDialog(this.getFrame(), this.importJavaArgs, QuickSetupMessages.INFO_IMPORT_JAVA_ARGUMENTS_TITLE.get(), QuickSetupMessages.INFO_IMPORT_JAVA_ARGUMENTS_MSG.get());
        dlg.pack();
        dlg.setModal(true);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            this.importJavaArgs = dlg.getJavaArguments();
            this.lImport.setText(JavaArguments.getMessageForJLabel(this.importJavaArgs, this.defaultImportJavaArgs, UIFactory.SECONDARY_FIELD_VALID_FONT).toString());
        }
    }

    private void createComponents() {
        this.warning = UIFactory.makeHtmlPane(Message.EMPTY, UIFactory.INSTRUCTIONS_FONT);
        this.warning.setOpaque(false);
        this.lServer = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, Message.EMPTY, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.bServer = UIFactory.makeJButton(QuickSetupMessages.INFO_JAVA_RUNTIME_CHANGE_LABEL.get(), QuickSetupMessages.INFO_JAVA_RUNTIME_CHANGE_SERVER_TOOLTIP.get());
        this.bServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RuntimeOptionsPanel.this.changeServerClicked();
            }
        });
        this.lImport = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, Message.EMPTY, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.bImport = UIFactory.makeJButton(QuickSetupMessages.INFO_JAVA_RUNTIME_CHANGE_LABEL.get(), QuickSetupMessages.INFO_JAVA_RUNTIME_CHANGE_IMPORT_TOOLTIP.get());
        this.bImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RuntimeOptionsPanel.this.changeImportClicked();
            }
        });
    }

    private JFrame getFrame() {
        Component mainWindow = this.getMainWindow();
        JFrame frame = null;
        if (mainWindow instanceof JFrame) {
            frame = (JFrame)mainWindow;
        }
        return frame;
    }

    private void updateWarningMessage(UserData uData) {
        boolean createSuffix;
        Message msg = null;
        DataReplicationOptions repl = uData.getReplicationOptions();
        SuffixesToReplicateOptions suf = uData.getSuffixesToReplicateOptions();
        boolean bl = createSuffix = repl.getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY || repl.getType() == DataReplicationOptions.Type.STANDALONE || suf.getType() == SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY;
        if (createSuffix) {
            NewSuffixOptions options = uData.getNewSuffixOptions();
            switch (options.getType()) {
                case IMPORT_FROM_LDIF_FILE: {
                    File ldifFile = new File(options.getLDIFPaths().getFirst());
                    if (ldifFile.length() <= 0xC800000L) break;
                    msg = QuickSetupMessages.INFO_IMPORT_FILE_WARNING_UPDATE_RUNTIME_ARGS.get();
                    break;
                }
                case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                    if (options.getNumberEntries() <= 100000) break;
                    msg = QuickSetupMessages.INFO_AUTOMATICALLY_GENERATED_DATA_WARNING_UPDATE_RUNTIME_ARGS.get();
                }
            }
        } else if (repl.getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY) {
            int maxReplicatedEntries = 0;
            Set<SuffixDescriptor> suffixes = suf.getSuffixes();
            for (SuffixDescriptor suffix : suffixes) {
                int suffixEntries = 0;
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    suffixEntries = Math.max(suffixEntries, replica.getEntries());
                }
                maxReplicatedEntries += suffixEntries;
            }
            if (maxReplicatedEntries > 100000) {
                msg = QuickSetupMessages.INFO_REPLICATED_ENTRIES_WARNING_UPDATE_RUNTIME_ARGS.get();
            }
        }
        if (msg != null) {
            HtmlProgressMessageFormatter formatter = new HtmlProgressMessageFormatter();
            StringBuilder buf = new StringBuilder();
            String space = formatter.getSpace().toString();
            String lBreak = formatter.getLineBreak().toString();
            String title = UIFactory.applyFontToHtml(QuickSetupMessages.INFO_GENERAL_WARNING.get().toString(), UIFactory.TITLE_FONT);
            String details = UIFactory.applyFontToHtml(msg.toString(), UIFactory.SECONDARY_FIELD_VALID_FONT);
            buf.append(UIFactory.getIconHtml(UIFactory.IconType.WARNING_LARGE)).append(space).append(space).append(title).append(lBreak).append(lBreak).append(details);
            String s = "<form>" + UIFactory.applyErrorBackgroundToHtml(buf.toString()) + "</form>";
            this.warning.setText(s);
            this.warning.setVisible(true);
        } else {
            this.warning.setText("");
            this.warning.setVisible(false);
        }
    }
}

