/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVSortOrder;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.messages.AdminToolMessages;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.admin.std.server.AdministrationConnectorCfg;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.BackupBackendCfg;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.CryptoManagerCfg;
import org.opends.server.admin.std.server.HTTPConnectionHandlerCfg;
import org.opends.server.admin.std.server.JMXConnectionHandlerCfg;
import org.opends.server.admin.std.server.LDAPConnectionHandlerCfg;
import org.opends.server.admin.std.server.LDIFBackendCfg;
import org.opends.server.admin.std.server.LDIFConnectionHandlerCfg;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.admin.std.server.MemoryBackendCfg;
import org.opends.server.admin.std.server.MonitorBackendCfg;
import org.opends.server.admin.std.server.ReplicationDomainCfg;
import org.opends.server.admin.std.server.ReplicationServerCfg;
import org.opends.server.admin.std.server.ReplicationSynchronizationProviderCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.RootDNCfg;
import org.opends.server.admin.std.server.RootDNUserCfg;
import org.opends.server.admin.std.server.SNMPConnectionHandlerCfg;
import org.opends.server.admin.std.server.TaskBackendCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;

public class ConfigFromFile
extends ConfigReader {
    private static final Logger LOG = Logger.getLogger(ConfigFromFile.class.getName());

    /*
     * Could not resolve type clashes
     */
    public void readConfiguration() {
        ArrayList<OpenDsException> ex = new ArrayList<OpenDsException>();
        HashSet<ConnectionHandlerDescriptor> ls = new HashSet<ConnectionHandlerDescriptor>();
        HashSet<BackendDescriptor> bs = new HashSet<BackendDescriptor>();
        HashSet<DN> as = new HashSet<DN>();
        try {
            DirectoryServer.getInstance().initializeConfiguration();
            if (this.mustReadSchema()) {
                try {
                    this.readSchema();
                    if (this.getSchema() != null) {
                        DirectoryServer.setSchema(this.getSchema());
                    }
                }
                catch (OpenDsException oe) {
                    ex.add(oe);
                }
            }
            RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
            try {
                AdministrationConnectorCfg adminConnector = root.getAdministrationConnector();
                this.adminConnector = this.getConnectionHandler(adminConnector);
            }
            catch (ConfigException ce) {
                ex.add(ce);
            }
            for (String connHandler : root.listConnectionHandlers()) {
                try {
                    ConnectionHandlerCfg connectionHandler = root.getConnectionHandler(connHandler);
                    ls.add(this.getConnectionHandler(connectionHandler, connHandler));
                }
                catch (OpenDsException oe) {
                    ex.add(oe);
                }
            }
            this.isSchemaEnabled = root.getGlobalConfiguration().isCheckSchema();
            for (String backendName : root.listBackends()) {
                try {
                    BackendDescriptor.Type type;
                    BackendCfg backend = root.getBackend(backendName);
                    HashSet<BaseDNDescriptor> baseDNs = new HashSet<BaseDNDescriptor>();
                    for (DN dn : backend.getBaseDN()) {
                        BaseDNDescriptor baseDN = new BaseDNDescriptor(BaseDNDescriptor.Type.NOT_REPLICATED, dn, null, -1, -1L, -1);
                        baseDNs.add(baseDN);
                    }
                    HashSet<IndexDescriptor> indexes = new HashSet<IndexDescriptor>();
                    HashSet<VLVIndexDescriptor> vlvIndexes = new HashSet<VLVIndexDescriptor>();
                    if (backend instanceof LocalDBBackendCfg) {
                        Configuration index;
                        type = BackendDescriptor.Type.LOCAL_DB;
                        LocalDBBackendCfg db = (LocalDBBackendCfg)backend;
                        try {
                            for (String indexName : db.listLocalDBIndexes()) {
                                index = db.getLocalDBIndex(indexName);
                                indexes.add(new IndexDescriptor(index.getAttribute().getNameOrOID(), index.getAttribute(), null, index.getIndexType(), index.getIndexEntryLimit()));
                            }
                        }
                        catch (OpenDsException oe) {
                            ex.add(oe);
                        }
                        indexes.add(new IndexDescriptor("dn2id", null, null, new TreeSet<LocalDBIndexCfgDefn.IndexType>(), -1));
                        indexes.add(new IndexDescriptor("id2children", null, null, new TreeSet<LocalDBIndexCfgDefn.IndexType>(), -1));
                        indexes.add(new IndexDescriptor("id2subtree", null, null, new TreeSet<LocalDBIndexCfgDefn.IndexType>(), -1));
                        try {
                            for (String vlvIndexName : db.listLocalDBVLVIndexes()) {
                                index = db.getLocalDBVLVIndex(vlvIndexName);
                                String s = index.getSortOrder();
                                List<VLVSortOrder> sortOrder = this.getVLVSortOrder(s);
                                vlvIndexes.add(new VLVIndexDescriptor(index.getName(), null, index.getBaseDN(), index.getScope(), index.getFilter(), sortOrder, index.getMaxBlockSize()));
                            }
                        }
                        catch (OpenDsException oe) {
                            ex.add(oe);
                        }
                    } else {
                        type = backend instanceof LDIFBackendCfg ? BackendDescriptor.Type.LDIF : (backend instanceof MemoryBackendCfg ? BackendDescriptor.Type.MEMORY : (backend instanceof BackupBackendCfg ? BackendDescriptor.Type.BACKUP : (backend instanceof MonitorBackendCfg ? BackendDescriptor.Type.MONITOR : (backend instanceof TaskBackendCfg ? BackendDescriptor.Type.TASK : BackendDescriptor.Type.OTHER))));
                    }
                    BackendDescriptor desc = new BackendDescriptor(backend.getBackendId(), baseDNs, indexes, vlvIndexes, -1, backend.isEnabled(), type);
                    for (AbstractIndexDescriptor index : indexes) {
                        index.setBackend(desc);
                    }
                    for (AbstractIndexDescriptor index : vlvIndexes) {
                        index.setBackend(desc);
                    }
                    bs.add(desc);
                }
                catch (OpenDsException oe) {
                    ex.add(oe);
                }
            }
            boolean isReplicationSecure = false;
            try {
                CryptoManagerCfg cryptoManager = root.getCryptoManager();
                isReplicationSecure = cryptoManager.isSSLEncryption();
            }
            catch (OpenDsException oe) {
                ex.add(oe);
            }
            this.replicationPort = -1;
            ReplicationSynchronizationProviderCfg sync = null;
            try {
                sync = (ReplicationSynchronizationProviderCfg)root.getSynchronizationProvider("Multimaster Synchronization");
            }
            catch (OpenDsException oe) {
                // empty catch block
            }
            if (sync != null) {
                try {
                    String[] domains;
                    ReplicationServerCfg replicationServer;
                    if (sync.isEnabled() && sync.hasReplicationServer() && (replicationServer = sync.getReplicationServer()) != null) {
                        this.replicationPort = replicationServer.getReplicationPort();
                        ConnectionHandlerDescriptor.Protocol protocol = isReplicationSecure ? ConnectionHandlerDescriptor.Protocol.REPLICATION_SECURE : ConnectionHandlerDescriptor.Protocol.REPLICATION;
                        Set<CustomSearchResult> emptySet = Collections.emptySet();
                        ConnectionHandlerDescriptor connHandler = new ConnectionHandlerDescriptor(new HashSet<InetAddress>(), this.replicationPort, protocol, ConnectionHandlerDescriptor.State.ENABLED, "Multimaster Synchronization", emptySet);
                        ls.add(connHandler);
                    }
                    if ((domains = sync.listReplicationDomains()) != null) {
                        for (String domain2 : domains) {
                            ReplicationDomainCfg domain = sync.getReplicationDomain(domain2);
                            DN dn = domain.getBaseDN();
                            for (BackendDescriptor backend : bs) {
                                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                                    if (!baseDN.getDn().equals(dn)) continue;
                                    baseDN.setType(sync.isEnabled() ? BaseDNDescriptor.Type.REPLICATED : BaseDNDescriptor.Type.DISABLED);
                                    baseDN.setReplicaID(domain.getServerId());
                                }
                            }
                        }
                    }
                }
                catch (OpenDsException oe) {
                    ex.add(oe);
                }
            }
            try {
                RootDNCfg rootDN = root.getRootDN();
                String[] rootUsers = rootDN.listRootDNUsers();
                as.clear();
                if (rootUsers != null) {
                    for (String rootUser2 : rootUsers) {
                        RootDNUserCfg rootUser = rootDN.getRootDNUser(rootUser2);
                        as.addAll(rootUser.getAlternateBindDN());
                    }
                }
            }
            catch (OpenDsException oe) {
                ex.add(oe);
            }
        }
        catch (OpenDsException oe) {
            ex.add(oe);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error reading configuration: " + t, t);
            OfflineUpdateException oue = new OfflineUpdateException(AdminToolMessages.ERR_READING_CONFIG_LDAP.get(t.getMessage().toString()), t);
            ex.add(oue);
        }
        if (ex.size() > 0 && environmentSettingException != null) {
            ex.add(0, environmentSettingException);
        }
        for (OpenDsException oe : ex) {
            LOG.log(Level.WARNING, "Error reading configuration: " + oe, oe);
        }
        this.exceptions = Collections.unmodifiableList(ex);
        this.administrativeUsers = Collections.unmodifiableSet(as);
        this.listeners = Collections.unmodifiableSet(ls);
        this.backends = Collections.unmodifiableSet(bs);
    }

    private ConnectionHandlerDescriptor getConnectionHandler(ConnectionHandlerCfg connHandler, String name) throws OpenDsException {
        int port;
        ConnectionHandlerDescriptor.Protocol protocol;
        ConnectionHandlerDescriptor.State state;
        TreeSet<InetAddress> addresses = new TreeSet<InetAddress>(this.getInetAddressComparator());
        ConnectionHandlerDescriptor.State state2 = state = connHandler.isEnabled() ? ConnectionHandlerDescriptor.State.ENABLED : ConnectionHandlerDescriptor.State.DISABLED;
        if (connHandler instanceof LDAPConnectionHandlerCfg) {
            LDAPConnectionHandlerCfg ldap = (LDAPConnectionHandlerCfg)connHandler;
            protocol = ldap.isUseSSL() ? ConnectionHandlerDescriptor.Protocol.LDAPS : (ldap.isAllowStartTLS() ? ConnectionHandlerDescriptor.Protocol.LDAP_STARTTLS : ConnectionHandlerDescriptor.Protocol.LDAP);
            this.addAll(addresses, ldap.getListenAddress());
            port = ldap.getListenPort();
        } else if (connHandler instanceof HTTPConnectionHandlerCfg) {
            HTTPConnectionHandlerCfg http = (HTTPConnectionHandlerCfg)connHandler;
            protocol = http.isUseSSL() ? ConnectionHandlerDescriptor.Protocol.HTTPS : ConnectionHandlerDescriptor.Protocol.HTTP;
            this.addAll(addresses, http.getListenAddress());
            port = http.getListenPort();
        } else if (connHandler instanceof JMXConnectionHandlerCfg) {
            JMXConnectionHandlerCfg jmx = (JMXConnectionHandlerCfg)connHandler;
            protocol = jmx.isUseSSL() ? ConnectionHandlerDescriptor.Protocol.JMXS : ConnectionHandlerDescriptor.Protocol.JMX;
            this.addAll(addresses, jmx.getListenAddress());
            port = jmx.getListenPort();
        } else if (connHandler instanceof LDIFConnectionHandlerCfg) {
            protocol = ConnectionHandlerDescriptor.Protocol.LDIF;
            port = -1;
        } else if (connHandler instanceof SNMPConnectionHandlerCfg) {
            protocol = ConnectionHandlerDescriptor.Protocol.SNMP;
            SNMPConnectionHandlerCfg snmp = (SNMPConnectionHandlerCfg)connHandler;
            this.addAll(addresses, snmp.getListenAddress());
            port = snmp.getListenPort();
        } else {
            protocol = ConnectionHandlerDescriptor.Protocol.OTHER;
            port = -1;
        }
        Set<CustomSearchResult> emptySet = Collections.emptySet();
        return new ConnectionHandlerDescriptor(addresses, port, protocol, state, name, emptySet);
    }

    private <T> void addAll(Collection<T> target, Collection<T> source) {
        if (source != null) {
            target.addAll(source);
        }
    }

    private ConnectionHandlerDescriptor getConnectionHandler(AdministrationConnectorCfg adminConnector) throws OpenDsException {
        TreeSet<InetAddress> addresses = new TreeSet<InetAddress>(this.getInetAddressComparator());
        ConnectionHandlerDescriptor.Protocol protocol = ConnectionHandlerDescriptor.Protocol.ADMINISTRATION_CONNECTOR;
        ConnectionHandlerDescriptor.State state = ConnectionHandlerDescriptor.State.ENABLED;
        this.addAll(addresses, adminConnector.getListenAddress());
        int port = adminConnector.getListenPort();
        Set<CustomSearchResult> emptySet = Collections.emptySet();
        return new ConnectionHandlerDescriptor(addresses, port, protocol, state, AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_ADMINISTRATION.get().toString(), emptySet);
    }
}

