/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.quicksetup.ui.UIFactory;

public class FilterTextField
extends JTextField {
    private static final long serialVersionUID = -2083433734204435457L;
    private boolean displayClearIcon;
    private ImageIcon clearIcon = Utilities.createImageIcon("org/opends/guitools/controlpanel/images/clear-filter.png");
    private ImageIcon clearIconPressed = Utilities.createImageIcon("org/opends/guitools/controlpanel/images/clear-filter-down.png");
    private ImageIcon refreshIcon = UIFactory.getImageIcon(UIFactory.IconType.WAIT_TINY);
    private boolean mousePressed;
    private boolean displayRefreshIcon;
    public static long DEFAULT_REFRESH_ICON_TIME = 750L;
    private LinkedHashSet<ActionListener> listeners = new LinkedHashSet();
    private boolean constructorBorderSet = false;
    private static int id = 1;

    public FilterTextField() {
        super(15);
        Border border = this.getBorder();
        if (border != null) {
            this.setBorder(BorderFactory.createCompoundBorder(border, new IconBorder()));
        } else {
            this.setBorder(new IconBorder());
        }
        this.constructorBorderSet = true;
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                boolean displayIcon;
                boolean bl = displayIcon = FilterTextField.this.getText().length() > 0;
                if (FilterTextField.this.displayClearIcon != displayIcon) {
                    FilterTextField.this.displayClearIcon = displayIcon;
                    FilterTextField.this.repaint();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                boolean p = FilterTextField.this.getClearIconRectangle().contains(ev.getPoint());
                if (p != FilterTextField.this.mousePressed) {
                    FilterTextField.this.mousePressed = p;
                    FilterTextField.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (FilterTextField.this.mousePressed && FilterTextField.this.getClearIconRectangle().contains(ev.getPoint())) {
                    FilterTextField.this.setText("");
                    FilterTextField.this.notifyListeners();
                }
                FilterTextField.this.mousePressed = false;
            }
        });
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setBorder(Border border) {
        if (this.constructorBorderSet && border != null) {
            border = BorderFactory.createCompoundBorder(border, new IconBorder());
        }
        super.setBorder(border);
    }

    public void displayRefreshIcon(boolean display) {
        if (display != this.displayRefreshIcon) {
            this.displayRefreshIcon = display;
            this.repaint();
        }
    }

    public boolean isRefreshIconDisplayed() {
        return this.displayRefreshIcon;
    }

    public void displayRefreshIcon(final long time) {
        this.displayRefreshIcon = true;
        this.repaint();
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(time);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FilterTextField.this.displayRefreshIcon = false;
                            FilterTextField.this.repaint();
                        }
                    });
                    catch (Throwable throwable2) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable2;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        t.start();
    }

    private void notifyListeners() {
        ActionEvent ev = new ActionEvent(this, id, "CLEAR_FILTER");
        ++id;
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(ev);
        }
    }

    private Rectangle getClearIconRectangle() {
        ImageIcon icon = this.getClearIcon();
        int margin = this.getMargin(this, icon);
        return new Rectangle(this.getWidth() - margin - icon.getIconWidth(), margin, icon.getIconWidth(), icon.getIconHeight());
    }

    private int getMargin(Component c, ImageIcon icon) {
        int margin = (c.getHeight() - icon.getIconHeight()) / 2;
        return margin;
    }

    private ImageIcon getClearIcon() {
        ImageIcon icon = this.mousePressed ? this.clearIconPressed : this.clearIcon;
        return icon;
    }

    private class IconBorder
    implements Border {
        private IconBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            ImageIcon icon = FilterTextField.this.getClearIcon();
            int rightInsets = 0;
            if (FilterTextField.this.displayClearIcon) {
                rightInsets += icon.getIconWidth() + FilterTextField.this.getMargin(c, icon);
            }
            if (FilterTextField.this.displayRefreshIcon) {
                rightInsets += FilterTextField.this.refreshIcon.getIconWidth() + FilterTextField.this.getMargin(c, FilterTextField.this.refreshIcon);
            }
            return new Insets(0, 0, 0, rightInsets);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (FilterTextField.this.displayClearIcon || FilterTextField.this.displayRefreshIcon) {
                Graphics2D g2d = (Graphics2D)g.create();
                int leftSpaceOfClearIcon = 0;
                if (FilterTextField.this.displayClearIcon) {
                    ImageIcon icon = FilterTextField.this.getClearIcon();
                    int margin = (height - icon.getIconHeight()) / 2;
                    icon.paintIcon(c, g2d, x + width - margin - icon.getIconWidth(), y + margin);
                    leftSpaceOfClearIcon = margin + icon.getIconWidth();
                }
                if (FilterTextField.this.displayRefreshIcon) {
                    int margin = (height - FilterTextField.this.refreshIcon.getIconHeight()) / 2;
                    FilterTextField.this.refreshIcon.paintIcon(c, g2d, x + width - margin - FilterTextField.this.refreshIcon.getIconWidth() - leftSpaceOfClearIcon, y + margin);
                }
                g2d.dispose();
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

