/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opends.guitools.controlpanel.datamodel.Category;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.border.SelectedCategoryBorder;
import org.opends.guitools.controlpanel.util.Utilities;

class CategoryButton
extends JCheckBox {
    private static final long serialVersionUID = 6191857253411571940L;
    private Border buttonSelectedBorder;
    private Border buttonUnselectedBorder;
    private static final Color backgroundColor = ColorAndFontConstants.greyBackground;

    public CategoryButton(Category category) {
        this.setText(category.getName().toString());
        this.setHorizontalTextPosition(11);
        this.setHorizontalAlignment(10);
        this.setFocusPainted(true);
        this.setRolloverEnabled(false);
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        this.setBorderPainted(true);
        this.setSelectedIcon(Utilities.createImageIcon("org/opends/guitools/controlpanel/images/downarrow.png"));
        this.setIcon(Utilities.createImageIcon("org/opends/guitools/controlpanel/images/rightarrow.png"));
        this.setRolloverIcon(this.getIcon());
        this.setRolloverSelectedIcon(this.getSelectedIcon());
        this.setPressedIcon(this.getSelectedIcon());
        this.buttonSelectedBorder = new SelectedCategoryBorder();
        this.buttonUnselectedBorder = new EmptyBorder(5, 5, 5, 5);
        this.setBorder(this.isSelected() ? this.buttonSelectedBorder : this.buttonUnselectedBorder);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CategoryButton.this.setBorder(CategoryButton.this.isSelected() ? CategoryButton.this.buttonSelectedBorder : CategoryButton.this.buttonUnselectedBorder);
            }
        });
        this.setBackground(backgroundColor);
        this.setForeground(ColorAndFontConstants.categoryForeground);
        this.setFont(ColorAndFontConstants.categoryFont);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(this.isSelected() ? this.buttonSelectedBorder : this.buttonUnselectedBorder);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.setBackground(backgroundColor);
        g.setColor(backgroundColor);
        g.setFont(ColorAndFontConstants.categoryFont);
        Dimension size = this.getSize();
        g.fillRect(0, 0, size.width, size.height);
        this.setBorder(this.isSelected() ? this.buttonSelectedBorder : this.buttonUnselectedBorder);
        super.paintComponent(g);
    }
}

