/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.datamodel.BinaryValue;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.ObjectClassValue;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.LDAPEntryChangedEvent;
import org.opends.guitools.controlpanel.event.LDAPEntryChangedListener;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.RDN;
import org.opends.server.types.Schema;
import org.opends.server.util.Base64;

public abstract class ViewEntryPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -1908757626234678L;
    protected SortedSet<String> schemaReadOnlyAttributes = new TreeSet<String>();
    protected SortedSet<String> schemaReadOnlyAttributesLowerCase = new TreeSet<String>();
    protected SortedSet<String> editableOperationalAttrNames = new TreeSet<String>();
    private JLabel title = Utilities.createDefaultLabel();
    private Set<LDAPEntryChangedListener> listeners = new LinkedHashSet<LDAPEntryChangedListener>();
    protected boolean ignoreEntryChangeEvents;
    protected static boolean displayOnlyWithAttrs = true;

    @Override
    public void okClicked() {
    }

    public abstract Entry getEntry() throws OpenDsException;

    public abstract void update(CustomSearchResult var1, boolean var2, TreePath var3);

    protected void addTitlePanel(Container c, GridBagConstraints gbc) {
        c.add((Component)this.title, gbc);
    }

    protected boolean checkSchema() {
        return this.getInfo().getServerDescriptor().isSchemaEnabled();
    }

    public void addLDAPEntryChangedListener(LDAPEntryChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeLDAPEntryChangedListener(LDAPEntryChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean requiresBorder() {
        return true;
    }

    protected abstract String getDisplayedDN();

    protected void notifyListeners() {
        if (this.ignoreEntryChangeEvents) {
            return;
        }
        Entry entry = null;
        String dn = this.getDisplayedDN();
        if (dn != null && !dn.equals(this.title.getText())) {
            this.title.setText(dn);
        }
        LDAPEntryChangedEvent ev = new LDAPEntryChangedEvent(this, entry);
        for (LDAPEntryChangedListener listener : this.listeners) {
            listener.entryChanged(ev);
        }
    }

    protected void updateTitle(CustomSearchResult sr, TreePath path) {
        BasicNode node;
        String dn = sr.getDN();
        if (dn != null && dn.length() > 0) {
            this.title.setText(sr.getDN());
        } else if (path != null) {
            node = (BasicNode)path.getLastPathComponent();
            this.title.setText(node.getDisplayName());
        }
        if (path != null) {
            node = (BasicNode)path.getLastPathComponent();
            this.title.setIcon(node.getIcon());
        } else {
            this.title.setIcon(null);
        }
        List<Object> ocs = sr.getAttributeValues("objectclass");
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        if (!ocs.isEmpty() && schema != null) {
            ObjectClassValue ocDesc = this.getObjectClassDescriptor(ocs, schema);
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (ocDesc.getStructural() != null) {
                sb.append(AdminToolMessages.INFO_CTRL_OBJECTCLASS_DESCRIPTOR.get(ocDesc.getStructural()));
            }
            if (ocDesc.getAuxiliary().size() > 0) {
                if (sb.length() > 0) {
                    sb.append("<br>");
                }
                sb.append(AdminToolMessages.INFO_CTRL_AUXILIARY_OBJECTCLASS_DESCRIPTOR.get(Utilities.getStringFromCollection(ocDesc.getAuxiliary(), ", ")));
            }
            this.title.setToolTipText(sb.toString());
        } else {
            this.title.setToolTipText(null);
        }
    }

    protected ObjectClassValue getObjectClassDescriptor(List<Object> ocValues, Schema schema) {
        CommonSchemaElements structuralObjectClass = null;
        TreeSet<String> auxiliaryClasses = new TreeSet<String>();
        for (Object o : ocValues) {
            ObjectClass objectClass = schema.getObjectClass(((String)o).toLowerCase());
            if (objectClass == null) continue;
            if (objectClass.getObjectClassType() == ObjectClassType.STRUCTURAL) {
                if (structuralObjectClass == null) {
                    structuralObjectClass = objectClass;
                    continue;
                }
                if (!objectClass.isDescendantOf((ObjectClass)structuralObjectClass)) continue;
                structuralObjectClass = objectClass;
                continue;
            }
            String name = objectClass.getNameOrOID();
            if (name.equals("top")) continue;
            auxiliaryClasses.add(objectClass.getNameOrOID());
        }
        String structural = structuralObjectClass != null ? structuralObjectClass.getNameOrOID() : null;
        return new ObjectClassValue(structural, auxiliaryClasses);
    }

    protected void addValuesInRDN(Entry entry) {
        RDN rdn = entry.getDN().getRDN();
        for (int i = 0; i < rdn.getNumValues(); ++i) {
            String attrName = rdn.getAttributeName(i);
            AttributeValue value = rdn.getAttributeValue(i);
            List<Attribute> attrs = entry.getAttribute(attrName.toLowerCase());
            boolean done = false;
            if (attrs != null) {
                for (Attribute attr : attrs) {
                    if (!attr.getNameWithOptions().equals(attrName)) continue;
                    ArrayList<AttributeValue> newValues = new ArrayList<AttributeValue>();
                    Iterator<AttributeValue> it = attr.iterator();
                    while (it.hasNext()) {
                        newValues.add(it.next());
                    }
                    newValues.add(value);
                    entry.addAttribute(attr, newValues);
                    done = true;
                    break;
                }
            }
            if (done) continue;
            Attribute attr = Attributes.create(rdn.getAttributeType(i), value);
            ArrayList<AttributeValue> newValues = new ArrayList<AttributeValue>();
            newValues.add(value);
            entry.addAttribute(attr, newValues);
        }
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_EDIT_LDAP_ENTRY_TITLE.get();
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        Schema schema = ev.getNewDescriptor().getSchema();
        if (schema != null && this.schemaReadOnlyAttributes.isEmpty()) {
            this.schemaReadOnlyAttributes.clear();
            this.schemaReadOnlyAttributesLowerCase.clear();
            for (AttributeType attr : schema.getAttributeTypes().values()) {
                if (attr.isNoUserModification()) {
                    String attrName = attr.getNameOrOID();
                    this.schemaReadOnlyAttributes.add(attrName);
                    this.schemaReadOnlyAttributesLowerCase.add(attrName.toLowerCase());
                    continue;
                }
                if (!attr.isOperational()) continue;
                this.editableOperationalAttrNames.add(attr.getNameOrOID());
            }
        }
    }

    protected void appendLDIFLines(StringBuilder sb, String attrName, List<Object> values) {
        for (Object value : values) {
            this.appendLDIFLine(sb, attrName, value);
        }
    }

    protected void appendLDIFLine(StringBuilder sb, String attrName, Object value) {
        if (value instanceof ObjectClassValue) {
            ObjectClassValue ocValue = (ObjectClassValue)value;
            if (ocValue.getStructural() != null) {
                ObjectClass oc;
                sb.append("\n");
                sb.append(attrName + ": " + ocValue.getStructural());
                Schema schema = this.getInfo().getServerDescriptor().getSchema();
                if (schema != null && (oc = schema.getObjectClass(ocValue.getStructural().toLowerCase())) != null) {
                    Set<String> names = this.getObjectClassSuperiorValues(oc);
                    for (String name : names) {
                        sb.append("\n");
                        sb.append(attrName + ": " + name);
                    }
                }
            }
            for (String v : ocValue.getAuxiliary()) {
                sb.append("\n");
                sb.append(attrName + ": " + v);
            }
        } else if (value instanceof byte[]) {
            if (((byte[])value).length > 0) {
                sb.append("\n");
                sb.append(attrName + ":: " + Base64.encode((byte[])value));
            }
        } else if (value instanceof BinaryValue) {
            sb.append("\n");
            sb.append(attrName + ":: " + ((BinaryValue)value).getBase64());
        } else if (String.valueOf(value).trim().length() > 0) {
            sb.append("\n");
            sb.append(attrName + ": " + value);
        }
    }

    protected boolean isBinary(String attrName) {
        boolean isBinary = false;
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        isBinary = Utilities.hasBinarySyntax(attrName, schema);
        return isBinary;
    }

    protected boolean isPassword(String attrName) {
        boolean isPassword = false;
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        isPassword = Utilities.hasPasswordSyntax(attrName, schema);
        return isPassword;
    }

    protected boolean hasCertificateSyntax(String attrName, Schema schema) {
        AttributeSyntax<?> syntax;
        AttributeType attr;
        boolean isCertificate = false;
        if (schema != null && (attr = schema.getAttributeType(Utilities.getAttributeNameWithoutOptions(attrName).toLowerCase())) != null && (syntax = attr.getSyntax()) != null) {
            isCertificate = syntax.getOID().equals("1.3.6.1.4.1.1466.115.121.1.8");
        }
        return isCertificate;
    }

    protected abstract List<Object> getValues(String var1);

    protected void setValues(CustomSearchResult sr, String attrName) {
        List<Object> values = this.getValues(attrName);
        ArrayList<Object> valuesToSet = new ArrayList<Object>();
        for (Object value : values) {
            if (value instanceof ObjectClassValue) {
                ObjectClassValue ocValue = (ObjectClassValue)value;
                if (ocValue.getStructural() != null) {
                    valuesToSet.add(ocValue.getStructural());
                }
                valuesToSet.addAll(ocValue.getAuxiliary());
                continue;
            }
            if (value instanceof byte[]) {
                valuesToSet.add(value);
                continue;
            }
            if (value instanceof BinaryValue) {
                try {
                    valuesToSet.add(((BinaryValue)value).getBytes());
                    continue;
                }
                catch (ParseException pe) {
                    throw new RuntimeException("Unexpected error: " + pe, pe);
                }
            }
            if (String.valueOf(value).trim().length() <= 0) continue;
            valuesToSet.add(String.valueOf(value));
        }
        if (valuesToSet.size() > 0) {
            sr.set(attrName, valuesToSet);
        }
    }

    public static boolean isEditable(String attrName, Schema schema) {
        AttributeType attrType;
        boolean isEditable = false;
        attrName = Utilities.getAttributeNameWithoutOptions(attrName);
        if (schema != null && (attrType = schema.getAttributeType(attrName.toLowerCase())) != null) {
            isEditable = !attrType.isNoUserModification();
        }
        return isEditable;
    }

    protected CustomSearchResult filterSearchResult(CustomSearchResult sr) {
        CustomSearchResult filteredSr;
        List<Object> values = sr.getAttributeValues("ds-sync-hist");
        if (values != null) {
            ArrayList<Object> newValues = new ArrayList<Object>();
            for (Object v : values) {
                newValues.add(this.filterStringValue(String.valueOf(v)));
            }
            if (newValues.equals(values)) {
                filteredSr = sr;
            } else {
                filteredSr = sr.duplicate();
                filteredSr.set("ds-sync-hist", newValues);
            }
        } else {
            filteredSr = sr;
        }
        return filteredSr;
    }

    private String filterStringValue(String value) {
        String filteredValue;
        int index = value.indexOf(":");
        if (index != -1) {
            String replTag;
            int index2;
            String modifiedAttr = value.substring(0, index).trim();
            filteredValue = this.isBinary(modifiedAttr = Utilities.getAttributeNameWithoutOptions(modifiedAttr)) ? ((index2 = value.indexOf(replTag = "repl:", index)) != -1 ? value.substring(0, index2 + replTag.length()) + AdminToolMessages.INFO_CTRL_PANEL_DS_SYNC_HIST_BINARY_VALUE.get() : value.substring(0, index + 1) + AdminToolMessages.INFO_CTRL_PANEL_DS_SYNC_HIST_BINARY_VALUE.get()) : value;
        } else {
            filteredValue = value;
        }
        return filteredValue;
    }

    protected Set<String> getObjectClassSuperiorValues(ObjectClass oc) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        Set<ObjectClass> parents = oc.getSuperiorClasses();
        if (parents != null && !parents.isEmpty()) {
            for (ObjectClass parent : parents) {
                names.add(parent.getNameOrOID());
                names.addAll(this.getObjectClassSuperiorValues(parent));
            }
        }
        return names;
    }
}

