/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.MonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.ScheduleType;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigChangeListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedListener;
import org.opends.guitools.controlpanel.task.RebuildIndexTask;
import org.opends.guitools.controlpanel.task.RestartServerTask;
import org.opends.guitools.controlpanel.task.StartServerTask;
import org.opends.guitools.controlpanel.task.StopServerTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ControlCenterMainPane;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.GenericFrame;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.components.AddRemovePanel;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.LowerCaseComparator;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.MessageDescriptor;
import org.opends.quicksetup.ui.CustomHTMLEditorKit;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.OpenDsException;

public abstract class StatusGenericPanel
extends JPanel
implements ConfigChangeListener {
    private static final long serialVersionUID = -9123358652232556732L;
    public static final String COMBO_SEPARATOR = "----------";
    protected static final Message NOT_APPLICABLE = AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get();
    private Message AUTHENTICATE = AdminToolMessages.INFO_AUTHENTICATE_BUTTON_LABEL.get();
    private Message START = AdminToolMessages.INFO_START_BUTTON_LABEL.get();
    private ControlPanelInfo info;
    private boolean enableClose = true;
    private boolean enableCancel = true;
    private boolean enableOK = true;
    private boolean disposeOnClose = false;
    private JPanel cardPanel;
    private JPanel mainPanel;
    private JEditorPane message;
    private CardLayout cardLayout;
    private static final String MAIN_PANEL = "mainPanel";
    private static final String MESSAGE_PANEL = "messagePanel";
    private static final Logger LOG = Logger.getLogger(StatusGenericPanel.class.getName());
    protected JEditorPane errorPane;
    protected String lastDisplayedError = null;
    private ArrayList<ConfigurationElementCreatedListener> confListeners = new ArrayList();
    private boolean sizeSet = false;
    private boolean focusSet = false;
    private static DateFormat taskDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public abstract Message getTitle();

    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.OK_CANCEL;
    }

    public abstract Component getPreferredFocusComponent();

    public boolean requiresBorder() {
        return true;
    }

    public JMenuBar getMenuBar() {
        return null;
    }

    public boolean callConfigurationChangedInBackground() {
        return false;
    }

    public void toBeDisplayed(boolean visible) {
    }

    public boolean requiresScroll() {
        return true;
    }

    protected StatusGenericPanel() {
        super(new GridBagLayout());
        this.setBackground(ColorAndFontConstants.background);
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setOpaque(false);
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setOpaque(false);
        this.message = Utilities.makeHtmlPane("", ColorAndFontConstants.progressFont);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        super.add((Component)this.cardPanel, gbc);
        this.cardPanel.add((Component)this.mainPanel, MAIN_PANEL);
        JPanel messagePanel = new JPanel(new GridBagLayout());
        messagePanel.setOpaque(false);
        gbc.fill = 0;
        gbc.anchor = 10;
        messagePanel.add((Component)this.message, gbc);
        this.cardPanel.add((Component)messagePanel, MESSAGE_PANEL);
        this.cardLayout.show(this.cardPanel, MAIN_PANEL);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.mainPanel.add(comp, constraints);
    }

    protected void addBottomGlue(GridBagConstraints gbc) {
        GridBagConstraints gbc2 = (GridBagConstraints)gbc.clone();
        gbc2.insets = new Insets(0, 0, 0, 0);
        ++gbc2.gridy;
        gbc2.gridwidth = 0;
        gbc2.weighty = 1.0;
        gbc2.fill = 3;
        this.add(Box.createVerticalGlue(), gbc2);
        ++gbc.gridy;
    }

    protected JLabel createRequiredLabel() {
        JLabel requiredLabel = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_INDICATES_REQUIRED_FIELD_LABEL.get());
        requiredLabel.setIcon(Utilities.createImageIcon("org/opends/guitools/controlpanel/images/required.gif"));
        return requiredLabel;
    }

    protected void addErrorPane(GridBagConstraints baseGbc) {
        this.addErrorPane(this, baseGbc);
    }

    protected void addErrorPane(Container p, GridBagConstraints baseGbc) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = baseGbc.gridx;
        gbc.gridy = baseGbc.gridy;
        gbc.gridwidth = baseGbc.gridwidth;
        gbc.gridheight = baseGbc.gridheight;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = this.requiresBorder() ? new Insets(0, 0, 10, 0) : new Insets(20, 20, 0, 20);
        this.createErrorPane();
        p.add((Component)this.errorPane, gbc);
    }

    protected void createErrorPane() {
        this.errorPane = Utilities.makeHtmlPane("", ColorAndFontConstants.progressFont);
        this.errorPane.setOpaque(false);
        this.errorPane.setEditable(false);
        this.errorPane.setVisible(false);
        CustomHTMLEditorKit htmlEditor = new CustomHTMLEditorKit();
        htmlEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (StatusGenericPanel.this.AUTHENTICATE.toString().equals(ev.getActionCommand())) {
                    StatusGenericPanel.this.authenticate();
                } else if (StatusGenericPanel.this.START.toString().equals(ev.getActionCommand())) {
                    StatusGenericPanel.this.startServer();
                }
            }
        });
        this.errorPane.setEditorKit(htmlEditor);
    }

    protected void add(JLabel[] labels, Component[] comps, JLabel[] inlineHelp, Container panel, GridBagConstraints gbc) {
        int i = 0;
        for (Component comp : comps) {
            gbc.insets.left = 0;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            if (labels[i] != null) {
                panel.add((Component)labels[i], gbc);
            }
            gbc.insets.left = 10;
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            panel.add(comp, gbc);
            if (inlineHelp[i] != null) {
                gbc.insets.top = 3;
                ++gbc.gridy;
                panel.add((Component)inlineHelp[i], gbc);
            }
            gbc.insets.top = 10;
            ++gbc.gridy;
            ++i;
        }
    }

    protected void setEnabledOK(boolean enable) {
        Window w = Utilities.getParentDialog(this);
        if (w instanceof GenericDialog) {
            ((GenericDialog)w).setEnabledOK(enable);
        } else if (w instanceof GenericFrame) {
            ((GenericFrame)w).setEnabledOK(enable);
        }
        this.enableOK = enable;
    }

    protected void setEnabledCancel(boolean enable) {
        Window w = Utilities.getParentDialog(this);
        if (w instanceof GenericDialog) {
            ((GenericDialog)w).setEnabledCancel(enable);
        } else if (w instanceof GenericFrame) {
            ((GenericFrame)w).setEnabledCancel(enable);
        }
        this.enableCancel = enable;
    }

    protected void setPrimaryInvalid(JComponent comp) {
        comp.setFont(ColorAndFontConstants.primaryInvalidFont);
        comp.setForeground(ColorAndFontConstants.invalidFontColor);
    }

    protected void setPrimaryValid(JComponent comp) {
        comp.setForeground(ColorAndFontConstants.validFontColor);
        comp.setFont(ColorAndFontConstants.primaryFont);
    }

    protected void setSecondaryInvalid(JComponent comp) {
        comp.setForeground(ColorAndFontConstants.invalidFontColor);
        comp.setFont(ColorAndFontConstants.invalidFont);
    }

    protected void setSecondaryValid(JComponent comp) {
        comp.setForeground(ColorAndFontConstants.validFontColor);
        comp.setFont(ColorAndFontConstants.defaultFont);
    }

    protected void packParentDialog() {
        Window dlg = Utilities.getParentDialog(this);
        if (dlg != null) {
            this.invalidate();
            dlg.invalidate();
            dlg.pack();
            if (!SwingUtilities.isEventDispatchThread()) {
                Thread.dumpStack();
            }
        }
    }

    public abstract void okClicked();

    public void addConfigurationElementCreatedListener(ConfigurationElementCreatedListener listener) {
        this.getConfigurationElementCreatedListeners().add(listener);
    }

    public void removeConfigurationElementCreatedListener(ConfigurationElementCreatedListener listener) {
        this.getConfigurationElementCreatedListeners().remove(listener);
    }

    protected void notifyConfigurationElementCreated(Object configObject) {
        for (ConfigurationElementCreatedListener listener : this.getConfigurationElementCreatedListeners()) {
            listener.elementCreated(new ConfigurationElementCreatedEvent(this, configObject));
        }
    }

    protected List<ConfigurationElementCreatedListener> getConfigurationElementCreatedListeners() {
        return this.confListeners;
    }

    public void cancelClicked() {
        Utilities.getParentDialog(this).setVisible(false);
        if (this.isDisposeOnClose()) {
            Utilities.getParentDialog(this).dispose();
        }
    }

    public boolean isDisposeOnClose() {
        return this.disposeOnClose;
    }

    public void setDisposeOnClose(boolean disposeOnClose) {
        this.disposeOnClose = disposeOnClose;
    }

    public void closeClicked() {
        Utilities.getParentDialog(this).setVisible(false);
        if (this.isDisposeOnClose()) {
            Utilities.getParentDialog(this).dispose();
        }
    }

    protected void displayErrorDialog(Collection<Message> errors) {
        Utilities.displayErrorDialog(Utilities.getParentDialog(this), errors);
    }

    protected boolean displayConfirmationDialog(Message title, Message msg) {
        return Utilities.displayConfirmationDialog(Utilities.getParentDialog(this), title, msg);
    }

    protected void rebuildIndexIfNecessary(AbstractIndexDescriptor index, ProgressDialog progressDialog) {
        boolean rebuildIndexes;
        progressDialog.setTaskIsOver(false);
        String backendName = index.getBackend().getBackendID();
        if (!this.isServerRunning()) {
            rebuildIndexes = Utilities.displayConfirmationDialog(progressDialog, AdminToolMessages.INFO_CTRL_PANEL_INDEX_REBUILD_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_INDEX_REBUILD_REQUIRED_OFFLINE_DETAILS.get(index.getName(), backendName));
        } else if (this.isLocal()) {
            rebuildIndexes = Utilities.displayConfirmationDialog(progressDialog, AdminToolMessages.INFO_CTRL_PANEL_INDEX_REBUILD_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_INDEX_REBUILD_REQUIRED_ONLINE_DETAILS.get(index.getName(), backendName, backendName));
        } else {
            Utilities.displayWarningDialog(progressDialog, AdminToolMessages.INFO_CTRL_PANEL_INDEX_REBUILD_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_INDEX_REBUILD_REQUIRED_REMOTE_DETAILS.get(index.getName(), backendName));
            rebuildIndexes = false;
        }
        if (rebuildIndexes) {
            TreeSet<AbstractIndexDescriptor> indexes = new TreeSet<AbstractIndexDescriptor>();
            indexes.add(index);
            TreeSet<String> baseDNs = new TreeSet<String>();
            for (BaseDNDescriptor b : index.getBackend().getBaseDns()) {
                String baseDN = Utilities.unescapeUtf8(b.getDn().toString());
                baseDNs.add(baseDN);
            }
            RebuildIndexTask newTask = new RebuildIndexTask(this.getInfo(), progressDialog, baseDNs, indexes);
            ArrayList<Message> errors = new ArrayList<Message>();
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.size() == 0) {
                progressDialog.appendProgressHtml("<br><br>");
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_REBUILDING_INDEXES_SUMMARY.get(backendName), AdminToolMessages.INFO_CTRL_PANEL_REBUILDING_INDEXES_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_REBUILDING_INDEXES_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_REBUILDING_INDEXES_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_REBUILDING_INDEXES_ERROR_DETAILS, progressDialog, false);
                if (progressDialog.isModal()) {
                    progressDialog.toFront();
                }
                progressDialog.setVisible(true);
                if (!progressDialog.isModal()) {
                    progressDialog.toFront();
                }
            }
            if (errors.size() > 0) {
                this.displayErrorDialog(errors);
            }
        } else {
            progressDialog.setTaskIsOver(true);
            if (progressDialog.isVisible()) {
                progressDialog.toFront();
            }
        }
    }

    protected String getAuthenticateHTML() {
        return "<INPUT type=\"submit\" value=\"" + this.AUTHENTICATE + "\"></INPUT>";
    }

    protected String getStartServerHTML() {
        return "<INPUT type=\"submit\" value=\"" + this.START + "\"></INPUT>";
    }

    protected void updateErrorPaneAndOKButtonIfAuthRequired(ServerDescriptor desc, Message details) {
        if (this.authenticationRequired(desc)) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(details);
            mb.append("<br><br>" + this.getAuthenticateHTML());
            Message title = AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_SUMMARY.get();
            this.updateErrorPane(this.errorPane, title, ColorAndFontConstants.errorTitleFont, mb.toMessage(), ColorAndFontConstants.defaultFont);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusGenericPanel.this.errorPane.setVisible(true);
                    StatusGenericPanel.this.packParentDialog();
                    StatusGenericPanel.this.setEnabledOK(false);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusGenericPanel.this.errorPane.setVisible(false);
                    StatusGenericPanel.this.checkOKButtonEnable();
                }
            });
        }
    }

    protected boolean authenticationRequired(ServerDescriptor desc) {
        ServerDescriptor.ServerStatus status = desc.getStatus();
        boolean returnValue = status == ServerDescriptor.ServerStatus.STARTED && !desc.isAuthenticated() || status == ServerDescriptor.ServerStatus.NOT_CONNECTED_TO_REMOTE;
        return returnValue;
    }

    protected void updateErrorPaneIfAuthRequired(ServerDescriptor desc, Message details) {
        if (this.authenticationRequired(desc)) {
            Message title = AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_SUMMARY.get();
            MessageBuilder mb = new MessageBuilder();
            mb.append(details);
            mb.append("<br><br>" + this.getAuthenticateHTML());
            this.updateErrorPane(this.errorPane, title, ColorAndFontConstants.errorTitleFont, mb.toMessage(), ColorAndFontConstants.defaultFont);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusGenericPanel.this.errorPane.setVisible(true);
                    StatusGenericPanel.this.packParentDialog();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusGenericPanel.this.errorPane.setVisible(false);
                }
            });
        }
    }

    protected void updateErrorPaneIfServerRunningAndAuthRequired(ServerDescriptor desc, Message detailsServerNotRunning, Message authRequired) {
        ServerDescriptor.ServerStatus status = desc.getStatus();
        if (status != ServerDescriptor.ServerStatus.STARTED && status != ServerDescriptor.ServerStatus.NOT_CONNECTED_TO_REMOTE) {
            Message title = AdminToolMessages.INFO_CTRL_PANEL_SERVER_NOT_RUNNING_SUMMARY.get();
            MessageBuilder mb = new MessageBuilder();
            mb.append(detailsServerNotRunning);
            mb.append("<br><br>" + this.getStartServerHTML());
            this.updateErrorPane(this.errorPane, title, ColorAndFontConstants.errorTitleFont, mb.toMessage(), ColorAndFontConstants.defaultFont);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusGenericPanel.this.errorPane.setVisible(true);
                    StatusGenericPanel.this.packParentDialog();
                }
            });
        } else if (this.authenticationRequired(desc)) {
            Message title = AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_SUMMARY.get();
            MessageBuilder mb = new MessageBuilder();
            mb.append(authRequired);
            mb.append("<br><br>" + this.getAuthenticateHTML());
            this.updateErrorPane(this.errorPane, title, ColorAndFontConstants.errorTitleFont, mb.toMessage(), ColorAndFontConstants.defaultFont);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusGenericPanel.this.errorPane.setVisible(true);
                    StatusGenericPanel.this.packParentDialog();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusGenericPanel.this.errorPane.setVisible(false);
                }
            });
        }
    }

    protected void checkOKButtonEnable() {
        this.setEnabledOK(!this.errorPane.isVisible());
    }

    protected boolean isCategory(Object o) {
        boolean isCategory = false;
        if (o instanceof CategorizedComboBoxElement) {
            CategorizedComboBoxElement desc = (CategorizedComboBoxElement)o;
            isCategory = desc.getType() == CategorizedComboBoxElement.Type.CATEGORY;
        }
        return isCategory;
    }

    public ControlPanelInfo getInfo() {
        return this.info;
    }

    public void setInfo(ControlPanelInfo info) {
        if (!info.equals(this.info)) {
            if (this.info != null) {
                this.info.removeConfigChangeListener(this);
            }
            this.info = info;
            this.info.addConfigChangeListener(this);
            if (SwingUtilities.isEventDispatchThread() && this.callConfigurationChangedInBackground()) {
                final Color savedBackground = this.getBackground();
                this.setBackground(ColorAndFontConstants.background);
                if (!this.sizeSet) {
                    this.setPreferredSize(this.mainPanel.getPreferredSize());
                    this.sizeSet = true;
                }
                BackgroundTask<Void> worker = new BackgroundTask<Void>(){

                    @Override
                    public Void processBackgroundTask() throws Throwable {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        StatusGenericPanel.this.configurationChanged(new ConfigurationChangeEvent(StatusGenericPanel.this.info, StatusGenericPanel.this.info.getServerDescriptor()));
                        return null;
                    }

                    @Override
                    public void backgroundTaskCompleted(Void returnValue, Throwable t) {
                        StatusGenericPanel.this.setBackground(savedBackground);
                        StatusGenericPanel.this.displayMainPanel();
                        if (!StatusGenericPanel.this.focusSet) {
                            StatusGenericPanel.this.focusSet = true;
                            Component comp = StatusGenericPanel.this.getPreferredFocusComponent();
                            if (comp != null) {
                                comp.requestFocusInWindow();
                            }
                        }
                    }
                };
                this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_LOADING_PANEL_SUMMARY.get());
                worker.startBackgroundTask();
            } else if (info.getServerDescriptor() != null) {
                this.configurationChanged(new ConfigurationChangeEvent(this.info, this.info.getServerDescriptor()));
            }
        }
    }

    protected void displayMainPanel() {
        this.cardLayout.show(this.cardPanel, MAIN_PANEL);
    }

    protected boolean isMainPanelVisible() {
        return this.mainPanel.isVisible();
    }

    protected void displayMessage(Message msg) {
        this.message.setText(Utilities.applyFont(msg.toString(), ColorAndFontConstants.defaultFont));
        this.cardLayout.show(this.cardPanel, MESSAGE_PANEL);
        this.message.requestFocusInWindow();
    }

    protected void displayErrorMessage(Message title, Message msg) {
        this.updateErrorPane(this.message, title, ColorAndFontConstants.errorTitleFont, msg, ColorAndFontConstants.defaultFont);
        this.cardLayout.show(this.cardPanel, MESSAGE_PANEL);
        this.message.requestFocusInWindow();
    }

    protected boolean isMessageVisible() {
        return this.message.isVisible();
    }

    protected void updateErrorPane(JEditorPane pane, Message title, Font titleFont, Message details, Font detailsFont) {
        this.updatePane(pane, title, titleFont, details, detailsFont, PanelType.ERROR);
    }

    protected void updateWarningPane(JEditorPane pane, Message title, Font titleFont, Message details, Font detailsFont) {
        this.updatePane(pane, title, titleFont, details, detailsFont, PanelType.WARNING);
    }

    protected void updateConfirmationPane(JEditorPane pane, Message title, Font titleFont, Message details, Font detailsFont) {
        this.updatePane(pane, title, titleFont, details, detailsFont, PanelType.CONFIRMATION);
    }

    private void updatePane(final JEditorPane pane, Message title, Font titleFont, Message details, Font detailsFont, PanelType type) {
        Window window;
        String text;
        switch (type) {
            case ERROR: {
                text = Utilities.getFormattedError(title, titleFont, details, detailsFont);
                break;
            }
            case CONFIRMATION: {
                text = Utilities.getFormattedConfirmation(title, titleFont, details, detailsFont);
                break;
            }
            case WARNING: {
                text = Utilities.getFormattedWarning(title, titleFont, details, detailsFont);
                break;
            }
            default: {
                text = Utilities.getFormattedSuccess(title, titleFont, details, detailsFont);
            }
        }
        if (!text.equals(this.lastDisplayedError)) {
            String wrappedText;
            Message wrappedTitle = Utilities.wrapHTML(title, 80);
            Message wrappedDetails = Utilities.wrapHTML(details, 90);
            JEditorPane wrappedPane = Utilities.makeHtmlPane(null, pane.getFont());
            switch (type) {
                case ERROR: {
                    wrappedText = Utilities.getFormattedError(wrappedTitle, titleFont, wrappedDetails, detailsFont);
                    break;
                }
                default: {
                    wrappedText = Utilities.getFormattedSuccess(wrappedTitle, titleFont, wrappedDetails, detailsFont);
                }
            }
            wrappedPane.setText(wrappedText);
            Dimension d = wrappedPane.getPreferredSize();
            pane.setText(text);
            pane.setPreferredSize(d);
            this.lastDisplayedError = text;
        }
        if ((window = Utilities.getParentDialog(this)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pane.invalidate();
                    window.validate();
                }
            });
        }
    }

    protected void updateSimpleBackendComboBoxModel(final JComboBox combo, final JLabel lNoBackendsFound, ServerDescriptor desc) {
        final TreeSet<String> newElements = new TreeSet<String>(new LowerCaseComparator());
        for (BackendDescriptor backend : desc.getBackends()) {
            if (backend.isConfigBackend()) continue;
            newElements.add(backend.getBackendID());
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
        this.updateComboBoxModel(newElements, model);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                combo.setVisible(newElements.size() > 0);
                lNoBackendsFound.setVisible(newElements.size() == 0);
            }
        });
    }

    protected boolean displayBackend(BackendDescriptor backend) {
        return !backend.isConfigBackend();
    }

    protected void updateBaseDNComboBoxModel(DefaultComboBoxModel model, ServerDescriptor desc) {
        LinkedHashSet<CategorizedComboBoxElement> newElements = new LinkedHashSet<CategorizedComboBoxElement>();
        TreeSet<String> backendIDs = new TreeSet<String>(new LowerCaseComparator());
        HashMap<String, TreeSet<String>> hmBaseDNs = new HashMap<String, TreeSet<String>>();
        for (BackendDescriptor backend : desc.getBackends()) {
            if (!this.displayBackend(backend)) continue;
            String backendID = backend.getBackendID();
            backendIDs.add(backendID);
            TreeSet<String> baseDNs = new TreeSet<String>(new LowerCaseComparator());
            for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                try {
                    baseDNs.add(Utilities.unescapeUtf8(baseDN.getDn().toString()));
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unexpected error: " + t, t);
                }
            }
            hmBaseDNs.put(backendID, baseDNs);
        }
        for (String backendID : backendIDs) {
            newElements.add(new CategorizedComboBoxElement(backendID, CategorizedComboBoxElement.Type.CATEGORY));
            SortedSet baseDNs = (SortedSet)hmBaseDNs.get(backendID);
            for (String baseDN : baseDNs) {
                newElements.add(new CategorizedComboBoxElement(baseDN, CategorizedComboBoxElement.Type.REGULAR));
            }
        }
        this.updateComboBoxModel(newElements, model);
    }

    protected void updateComboBoxModel(Collection<?> newElements, DefaultComboBoxModel model) {
        this.updateComboBoxModel(newElements, model, null);
    }

    protected void updateComboBoxModel(final Collection<?> newElements, final DefaultComboBoxModel model, final Comparator<Object> comparator) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Utilities.updateComboBoxModel(newElements, model, comparator);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndexMap(ServerDescriptor desc, HashMap<String, SortedSet<AbstractIndexDescriptor>> hmIndexes) {
        HashMap<String, SortedSet<AbstractIndexDescriptor>> hashMap = hmIndexes;
        synchronized (hashMap) {
            HashSet<String> dns = new HashSet<String>();
            for (BackendDescriptor backend : desc.getBackends()) {
                if (backend.getType() != BackendDescriptor.Type.LOCAL_DB) continue;
                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                    String dn;
                    try {
                        dn = Utilities.unescapeUtf8(baseDN.getDn().toString());
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Unexpected error: " + t, t);
                    }
                    dns.add(dn);
                    TreeSet<AbstractIndexDescriptor> indexes = new TreeSet<AbstractIndexDescriptor>();
                    indexes.addAll(backend.getIndexes());
                    indexes.addAll(backend.getVLVIndexes());
                    SortedSet<AbstractIndexDescriptor> currentIndexes = hmIndexes.get(dn);
                    if (currentIndexes != null) {
                        if (currentIndexes.equals(indexes)) continue;
                        hmIndexes.put(dn, indexes);
                        continue;
                    }
                    hmIndexes.put(dn, indexes);
                }
            }
            for (String dn : new HashSet<String>(hmIndexes.keySet())) {
                if (dns.contains(dn)) continue;
                hmIndexes.remove(dn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void comboBoxSelected(HashMap<String, SortedSet<AbstractIndexDescriptor>> hmIndexes, CategorizedComboBoxElement selectedItem, AddRemovePanel<AbstractIndexDescriptor> addRemove) {
        HashMap<String, SortedSet<AbstractIndexDescriptor>> hashMap = hmIndexes;
        synchronized (hashMap) {
            SortedSet<AbstractIndexDescriptor> indexes;
            String selectedDn = null;
            if (selectedItem != null) {
                selectedDn = (String)selectedItem.getValue();
            }
            if (selectedDn != null && (indexes = hmIndexes.get(selectedDn)) != null) {
                boolean availableChanged = false;
                boolean selectedChanged = false;
                SortedSet<AbstractIndexDescriptor> availableIndexes = addRemove.getAvailableListModel().getData();
                SortedSet<AbstractIndexDescriptor> selectedIndexes = addRemove.getSelectedListModel().getData();
                availableChanged = availableIndexes.retainAll(indexes);
                selectedChanged = selectedIndexes.retainAll(indexes);
                for (AbstractIndexDescriptor index : indexes) {
                    if (availableIndexes.contains(index) || selectedIndexes.contains(index)) continue;
                    availableIndexes.add(index);
                    availableChanged = true;
                }
                if (availableChanged) {
                    addRemove.getAvailableListModel().clear();
                    addRemove.getAvailableListModel().addAll(availableIndexes);
                    addRemove.getAvailableListModel().fireContentsChanged(addRemove.getAvailableListModel(), 0, addRemove.getAvailableListModel().getSize());
                }
                if (selectedChanged) {
                    addRemove.getSelectedListModel().clear();
                    addRemove.getSelectedListModel().addAll(selectedIndexes);
                    addRemove.getSelectedListModel().fireContentsChanged(addRemove.getSelectedListModel(), 0, addRemove.getSelectedListModel().getSize());
                }
            }
        }
    }

    public boolean isEnableCancel() {
        return this.enableCancel;
    }

    public boolean isEnableClose() {
        return this.enableClose;
    }

    public boolean isEnableOK() {
        return this.enableOK;
    }

    protected boolean isServerRunning() {
        return this.getInfo().getServerDescriptor().getStatus() == ServerDescriptor.ServerStatus.STARTED;
    }

    protected boolean isLocal() {
        return this.getInfo().getServerDescriptor().isLocal();
    }

    protected void launchOperation(Task task, Message initialSummary, Message successSummary, Message successDetail, Message errorSummary, Message errorDetail, MessageDescriptor.Arg1<Number> errorDetailCode, ProgressDialog dialog) {
        this.launchOperation(task, initialSummary, successSummary, successDetail, errorSummary, errorDetail, errorDetailCode, dialog, true);
    }

    protected void launchOperation(Task task, Message initialSummary, Message successSummary, Message successDetail, Message errorSummary, Message errorDetail, MessageDescriptor.Arg1<Number> errorDetailCode, ProgressDialog dialog, boolean resetLogs) {
        StatusGenericPanel.launchOperation(task, initialSummary, successSummary, successDetail, errorSummary, errorDetail, errorDetailCode, dialog, resetLogs, this.getInfo());
    }

    public static void launchOperation(final Task task, Message initialSummary, final Message successSummary, final Message successDetail, final Message errorSummary, final Message errorDetail, final MessageDescriptor.Arg1<Number> errorDetailCode, final ProgressDialog dialog, boolean resetLogs, final ControlPanelInfo info) {
        String cmdLine;
        dialog.setTaskIsOver(false);
        dialog.getProgressBar().setIndeterminate(true);
        dialog.addPrintStreamListeners(task.getOutPrintStream(), task.getErrorPrintStream());
        if (resetLogs) {
            dialog.resetProgressLogs();
        }
        if ((cmdLine = task.getCommandLineToDisplay()) != null) {
            dialog.appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_COMMAND_LINE.get() + "<br><b>" + cmdLine + "</b><br><br>", ColorAndFontConstants.progressFont));
        }
        dialog.setEnabledClose(false);
        dialog.setSummary(Message.raw(Utilities.applyFont(initialSummary.toString(), ColorAndFontConstants.defaultFont), new Object[0]));
        dialog.getProgressBar().setVisible(true);
        BackgroundTask<Task> worker = new BackgroundTask<Task>(){

            @Override
            public Task processBackgroundTask() throws Throwable {
                task.runTask();
                if (task.regenerateDescriptor()) {
                    info.regenerateDescriptor();
                }
                return task;
            }

            @Override
            public void backgroundTaskCompleted(Task returnValue, Throwable t) {
                String summaryMsg;
                if (task.getState() == Task.State.FINISHED_SUCCESSFULLY) {
                    summaryMsg = Utilities.getFormattedSuccess(successSummary, ColorAndFontConstants.errorTitleFont, successDetail, ColorAndFontConstants.defaultFont);
                } else {
                    if (t == null) {
                        t = task.getLastException();
                    }
                    if (t != null) {
                        LOG.log(Level.WARNING, "Error occurred running task: " + t, t);
                        if (task.getReturnCode() != null && errorDetailCode != null) {
                            String sThrowable = t instanceof OpenDsException ? ((OpenDsException)t).getMessageObject().toString() : (t.getMessage() != null ? t.getMessage() : t.toString());
                            MessageBuilder mb = new MessageBuilder();
                            mb.append(errorDetailCode.get(task.getReturnCode()));
                            mb.append("  " + AdminToolMessages.INFO_CTRL_PANEL_DETAILS_THROWABLE.get(sThrowable));
                            summaryMsg = Utilities.getFormattedError(errorSummary, ColorAndFontConstants.errorTitleFont, mb.toMessage(), ColorAndFontConstants.defaultFont);
                        } else if (errorDetail != null) {
                            MessageBuilder mb = new MessageBuilder();
                            mb.append(errorDetail);
                            mb.append("  " + AdminToolMessages.INFO_CTRL_PANEL_DETAILS_THROWABLE.get(t.toString()));
                            summaryMsg = Utilities.getFormattedError(errorSummary, ColorAndFontConstants.errorTitleFont, mb.toMessage(), ColorAndFontConstants.defaultFont);
                        } else {
                            summaryMsg = null;
                        }
                    } else {
                        summaryMsg = task.getReturnCode() != null && errorDetailCode != null ? Utilities.getFormattedError(errorSummary, ColorAndFontConstants.errorTitleFont, errorDetailCode.get(task.getReturnCode()), ColorAndFontConstants.defaultFont) : (errorDetail != null ? Utilities.getFormattedError(errorSummary, ColorAndFontConstants.errorTitleFont, errorDetail, ColorAndFontConstants.defaultFont) : null);
                    }
                }
                if (summaryMsg != null) {
                    dialog.setSummary(Message.raw(summaryMsg, new Object[0]));
                }
                dialog.setEnabledClose(true);
                dialog.getProgressBar().setVisible(false);
                if (task.getState() == Task.State.FINISHED_SUCCESSFULLY) {
                    dialog.setTaskIsOver(true);
                }
                task.postOperation();
            }
        };
        info.registerTask(task);
        worker.startBackgroundTask();
    }

    protected void checkIntValue(Collection<Message> errors, String stringValue, int minValue, int maxValue, Message errMsg) {
        try {
            int n = Integer.parseInt(stringValue);
            if (n > maxValue || n < minValue) {
                throw new RuntimeException("Invalid value");
            }
        }
        catch (Throwable t) {
            errors.add(errMsg);
        }
    }

    protected void startServer() {
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        ProgressDialog progressDialog = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_START_SERVER_PROGRESS_DLG_TITLE.get(), this.getInfo());
        StartServerTask newTask = new StartServerTask(this.getInfo(), progressDialog);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        if (errors.size() == 0) {
            this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_STARTING_SERVER_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_STARTING_SERVER_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_STARTING_SERVER_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_STARTING_SERVER_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_STARTING_SERVER_ERROR_DETAILS, progressDialog);
            progressDialog.setVisible(true);
        } else {
            this.displayErrorDialog(errors);
        }
    }

    protected void stopServer() {
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        ProgressDialog progressDialog = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_STOP_SERVER_PROGRESS_DLG_TITLE.get(), this.getInfo());
        StopServerTask newTask = new StopServerTask(this.getInfo(), progressDialog);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        boolean confirmed = true;
        if (errors.size() == 0) {
            confirmed = this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRM_STOP_SERVER_DETAILS.get());
        }
        if (errors.size() == 0 && confirmed) {
            this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_STOPPING_SERVER_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_STOPPING_SERVER_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_STOPPING_SERVER_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_STOPPING_SERVER_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_STOPPING_SERVER_ERROR_DETAILS, progressDialog);
            progressDialog.setVisible(true);
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    protected void restartServer() {
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        ProgressDialog progressDialog = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_RESTART_SERVER_PROGRESS_DLG_TITLE.get(), this.getInfo());
        RestartServerTask newTask = new RestartServerTask(this.getInfo(), progressDialog);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        boolean confirmed = true;
        if (errors.size() == 0) {
            confirmed = this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRM_RESTART_SERVER_DETAILS.get());
        }
        if (errors.size() == 0 && confirmed) {
            this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_STOPPING_SERVER_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_RESTARTING_SERVER_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_RESTARTING_SERVER_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_RESTARTING_SERVER_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_RESTARTING_SERVER_ERROR_DETAILS, progressDialog);
            progressDialog.setVisible(true);
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    protected void authenticate() {
        if (!this.getLoginDialog().isVisible()) {
            this.getLoginDialog().setVisible(true);
        }
        this.getLoginDialog().toFront();
    }

    protected GenericDialog getLoginDialog() {
        if (this.isLocal()) {
            GenericDialog loginDialog = ControlCenterMainPane.getLocalServerLoginDialog(this.getInfo());
            Utilities.centerGoldenMean(loginDialog, Utilities.getFrame(this));
            loginDialog.setModal(true);
            return loginDialog;
        }
        GenericDialog localOrRemoteDialog = ControlCenterMainPane.getLocalOrRemoteDialog(this.getInfo());
        Utilities.centerGoldenMean(localOrRemoteDialog, Utilities.getFrame(this));
        localOrRemoteDialog.setModal(true);
        return localOrRemoteDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean entryExists(String dn) {
        boolean entryExists = false;
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(0);
            ctls.setReturningAttributes(new String[]{"1.1"});
            String filter = "(|(objectClass=*)(objectClass=ldapsubentry))";
            NamingEnumeration<SearchResult> result = this.getInfo().getDirContext().search(Utilities.getJNDIName(dn), filter, ctls);
            try {
                while (result.hasMore()) {
                    SearchResult sr = result.next();
                    entryExists = sr != null;
                }
            }
            finally {
                result.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return entryExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasObjectClass(String dn, String objectClass) {
        boolean hasObjectClass = false;
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(0);
            ctls.setReturningAttributes(new String[]{"objectclass"});
            String filter = "(|(objectClass=*)(objectClass=ldapsubentry))";
            NamingEnumeration<SearchResult> result = this.getInfo().getDirContext().search(Utilities.getJNDIName(dn), filter, ctls);
            try {
                block5: while (result.hasMore()) {
                    SearchResult sr = result.next();
                    Set<String> values = ConnectionUtils.getValues(sr, "objectclass");
                    if (values == null) continue;
                    for (String s : values) {
                        if (!s.equalsIgnoreCase(objectClass)) continue;
                        hasObjectClass = true;
                        continue block5;
                    }
                }
            }
            finally {
                result.close();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return hasObjectClass;
    }

    protected Border getRightPanelBorder() {
        return ColorAndFontConstants.textAreaBorder;
    }

    public static String getMonitoringValue(MonitoringAttributes attr, CustomSearchResult monitoringEntry) {
        return Utilities.getMonitoringValue(attr, monitoringEntry);
    }

    protected void updateMonitoringInfo(List<MonitoringAttributes> monitoringAttrs, List<JLabel> monitoringLabels, CustomSearchResult monitoringEntry) {
        for (int i = 0; i < monitoringAttrs.size(); ++i) {
            String value = StatusGenericPanel.getMonitoringValue(monitoringAttrs.get(i), monitoringEntry);
            JLabel l = monitoringLabels.get(i);
            l.setText(value);
        }
    }

    protected Object getFirstMonitoringValue(CustomSearchResult sr, String attrName) {
        return Utilities.getFirstMonitoringValue(sr, attrName);
    }

    protected static Message getLabel(MonitoringAttributes attr) {
        return AdminToolMessages.INFO_CTRL_PANEL_OPERATION_NAME_AS_LABEL.get(attr.getMessage().toString());
    }

    protected List<String> getScheduleArgs(ScheduleType schedule) {
        ArrayList<String> args = new ArrayList<String>(2);
        switch (schedule.getType()) {
            case LAUNCH_LATER: {
                args.add("--start");
                args.add(this.getStartTimeForTask(schedule.getLaunchLaterDate()));
                break;
            }
            case LAUNCH_PERIODICALLY: {
                args.add("--recurringTask");
                args.add(schedule.getCronValue());
            }
        }
        return args;
    }

    protected void addScheduleErrors(ScheduleType schedule, Collection<Message> errors, JLabel label) {
        if (!this.isServerRunning()) {
            ScheduleType.Type type = schedule.getType();
            if (type == ScheduleType.Type.LAUNCH_LATER) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_LAUNCH_LATER_REQUIRES_SERVER_RUNNING.get());
                this.setPrimaryInvalid(label);
            } else if (type == ScheduleType.Type.LAUNCH_PERIODICALLY) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_LAUNCH_SCHEDULE_REQUIRES_SERVER_RUNNING.get());
                this.setPrimaryInvalid(label);
            }
        }
    }

    private String getStartTimeForTask(Date date) {
        return taskDateFormat.format(date);
    }

    protected void checkCompatibleSuperiors(Set<ObjectClass> objectClassSuperiors, ObjectClassType objectClassType, List<Message> errors) {
        TreeSet<String> notCompatibleClasses = new TreeSet<String>(new LowerCaseComparator());
        for (ObjectClass oc : objectClassSuperiors) {
            if (oc.getObjectClassType() == ObjectClassType.ABSTRACT || oc.getObjectClassType() == objectClassType) continue;
            notCompatibleClasses.add(oc.getNameOrOID());
        }
        if (!notCompatibleClasses.isEmpty()) {
            String arg = Utilities.getStringFromCollection(notCompatibleClasses, ", ");
            if (objectClassType == ObjectClassType.STRUCTURAL) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INCOMPATIBLE_SUPERIORS_WITH_STRUCTURAL.get(arg));
            } else if (objectClassType == ObjectClassType.AUXILIARY) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INCOMPATIBLE_SUPERIORS_WITH_AUXILIARY.get(arg));
            } else if (objectClassType == ObjectClassType.ABSTRACT) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INCOMPATIBLE_SUPERIORS_WITH_ABSTRACT.get(arg));
            }
        }
    }

    protected static enum PanelType {
        ERROR,
        CONFIRMATION,
        INFORMATION,
        WARNING;

    }

    protected class IgnoreItemListener
    implements ItemListener {
        private Object selectedItem;
        private JComboBox combo;

        public IgnoreItemListener(JComboBox combo) {
            this.combo = combo;
            this.selectedItem = combo.getSelectedItem();
            if (StatusGenericPanel.this.isCategory(this.selectedItem)) {
                this.selectedItem = null;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            Object o = this.combo.getSelectedItem();
            if (StatusGenericPanel.this.isCategory(o)) {
                if (this.selectedItem == null) {
                    for (int i = 0; i < this.combo.getModel().getSize(); ++i) {
                        Object item = this.combo.getModel().getElementAt(i);
                        if (!(item instanceof CategorizedComboBoxElement) || StatusGenericPanel.this.isCategory(item)) continue;
                        this.selectedItem = item;
                        break;
                    }
                }
                if (this.selectedItem != null) {
                    this.combo.setSelectedItem(this.selectedItem);
                }
            } else if (StatusGenericPanel.COMBO_SEPARATOR.equals(o)) {
                this.combo.setSelectedItem(this.selectedItem);
            } else {
                this.selectedItem = o;
            }
        }
    }
}

