/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.datamodel.BinaryValue;
import org.opends.guitools.controlpanel.datamodel.CheckEntrySyntaxException;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.ObjectClassValue;
import org.opends.guitools.controlpanel.event.ScrollPaneBorderListener;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.ui.BinaryAttributeEditorPanel;
import org.opends.guitools.controlpanel.ui.BinaryValuePanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.LDAPEntrySelectionPanel;
import org.opends.guitools.controlpanel.ui.ObjectClassEditorPanel;
import org.opends.guitools.controlpanel.ui.ViewEntryPanel;
import org.opends.guitools.controlpanel.ui.components.BinaryCellPanel;
import org.opends.guitools.controlpanel.ui.components.ObjectClassCellPanel;
import org.opends.guitools.controlpanel.ui.nodes.BrowserNodeInfo;
import org.opends.guitools.controlpanel.ui.nodes.DndBrowserNodes;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.RDN;
import org.opends.server.types.Schema;
import org.opends.server.util.Base64;
import org.opends.server.util.LDIFReader;

public class SimplifiedViewEntryPanel
extends ViewEntryPanel {
    private static final long serialVersionUID = 2775960608128921072L;
    private JPanel attributesPanel;
    private ScrollPaneBorderListener scrollListener;
    private GenericDialog binaryDlg;
    private BinaryValuePanel binaryPanel;
    private GenericDialog editBinaryDlg;
    private BinaryAttributeEditorPanel editBinaryPanel;
    private GenericDialog editOcDlg;
    private ObjectClassEditorPanel editOcPanel;
    private JLabel requiredLabel;
    private JCheckBox showOnlyAttrsWithValues;
    private DropTargetListener dropTargetListener;
    private GenericDialog browseEntriesDlg;
    private LDAPEntrySelectionPanel browseEntriesPanel;
    private Map<String, List<String>> lastUserPasswords = new HashMap<String, List<String>>();
    private CustomSearchResult searchResult;
    private boolean isReadOnly;
    private TreePath treePath;
    private JScrollPane scrollAttributes;
    private LinkedHashMap<String, List<EditorComponent>> hmEditors = new LinkedHashMap();
    private Set<String> requiredAttrs = new HashSet<String>();
    private Map<String, JComponent> hmLabels = new HashMap<String, JComponent>();
    private Map<String, String> hmDisplayedNames = new HashMap<String, String>();
    private Map<String, JComponent> hmComponents = new HashMap<String, JComponent>();
    private final String CONFIRM_PASSWORD = "confirm password";
    static Map<String, Message> hmFriendlyAttrNames = new HashMap<String, Message>();
    static Map<String, String> hmNameAttrNames = new HashMap<String, String>();
    static Map<String, String[]> hmOrdereredAttrNames = new HashMap<String, String[]>();
    private Message NAME = AdminToolMessages.INFO_CTRL_PANEL_NAME_LABEL.get();

    public SimplifiedViewEntryPanel() {
        this.createLayout();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return null;
    }

    @Override
    public boolean requiresBorder() {
        return false;
    }

    private void createLayout() {
        this.dropTargetListener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent e) {
            }

            @Override
            public void dragExit(DropTargetEvent e) {
            }

            @Override
            public void dragOver(DropTargetDragEvent e) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent e) {
            }

            @Override
            public void drop(DropTargetDropEvent e) {
                try {
                    Transferable tr = e.getTransferable();
                    if (!tr.isDataFlavorSupported(DndBrowserNodes.INFO_FLAVOR)) {
                        e.rejectDrop();
                    }
                    DndBrowserNodes nodes = (DndBrowserNodes)tr.getTransferData(DndBrowserNodes.INFO_FLAVOR);
                    Component comp = e.getDropTargetContext().getComponent();
                    if (comp instanceof JTextArea) {
                        JTextArea ta = (JTextArea)comp;
                        StringBuilder sb = new StringBuilder();
                        sb.append(ta.getText());
                        for (BrowserNodeInfo node : nodes.getNodes()) {
                            if (sb.length() > 0) {
                                sb.append("\n");
                            }
                            sb.append(node.getNode().getDN());
                        }
                        ta.setText(sb.toString());
                        ta.setCaretPosition(sb.length());
                    } else if (comp instanceof JTextField) {
                        JTextField tf = (JTextField)comp;
                        if (nodes.getNodes().length > 0) {
                            String dn = nodes.getNodes()[0].getNode().getDN();
                            tf.setText(dn);
                            tf.setCaretPosition(dn.length());
                        }
                    }
                    e.acceptDrop(3);
                    e.getDropTargetContext().dropComplete(true);
                }
                catch (IOException io) {
                    e.rejectDrop();
                }
                catch (UnsupportedFlavorException ufe) {
                    e.rejectDrop();
                }
            }
        };
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 10, 0, 10);
        this.addTitlePanel(this, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.gridwidth = 1;
        this.showOnlyAttrsWithValues = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_SHOW_ATTRS_WITH_VALUES_LABEL.get());
        this.showOnlyAttrsWithValues.setSelected(displayOnlyWithAttrs);
        this.showOnlyAttrsWithValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SimplifiedViewEntryPanel.this.updateAttributeVisibility(!SimplifiedViewEntryPanel.this.showOnlyAttrsWithValues.isSelected());
                ViewEntryPanel.displayOnlyWithAttrs = SimplifiedViewEntryPanel.this.showOnlyAttrsWithValues.isSelected();
            }
        });
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        this.add((Component)this.showOnlyAttrsWithValues, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        gbc.fill = 0;
        this.requiredLabel = this.createRequiredLabel();
        this.add((Component)this.requiredLabel, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add(Box.createVerticalStrut(10), gbc);
        this.showOnlyAttrsWithValues.setFont(this.requiredLabel.getFont());
        this.attributesPanel = new JPanel(new GridBagLayout());
        this.attributesPanel.setOpaque(false);
        this.attributesPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        ++gbc.gridy;
        gbc.fill = 1;
        this.scrollAttributes = Utilities.createBorderLessScrollBar(this.attributesPanel);
        this.scrollListener = ScrollPaneBorderListener.createBottomAndTopBorderListener(this.scrollAttributes);
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.scrollAttributes, gbc);
    }

    @Override
    public void update(CustomSearchResult sr, boolean isReadOnly, TreePath path) {
        boolean sameEntry = false;
        if (sr != null) {
            sr = this.filterSearchResult(sr);
        }
        if (this.searchResult != null && sr != null) {
            sameEntry = this.searchResult.getDN().equals(sr.getDN());
        }
        final Point p = sameEntry ? this.scrollAttributes.getViewport().getViewPosition() : new Point(0, 0);
        this.searchResult = sr;
        this.isReadOnly = isReadOnly;
        this.treePath = path;
        this.updateTitle(sr, path);
        this.requiredLabel.setVisible(!isReadOnly);
        this.showOnlyAttrsWithValues.setVisible(!isReadOnly);
        this.attributesPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        this.lastUserPasswords.clear();
        this.hmEditors.clear();
        this.hmLabels.clear();
        this.hmDisplayedNames.clear();
        this.hmComponents.clear();
        this.requiredAttrs.clear();
        Collection<String> sortedAttributes = this.getSortedAttributes(sr, isReadOnly);
        if (isReadOnly) {
            for (String attr : sortedAttributes) {
                JLabel label = this.getLabelForAttribute(attr, sr);
                List<Object> values = sr.getAttributeValues(attr);
                JComponent comp = this.getReadOnlyComponent(attr, values);
                gbc.weightx = 0.0;
                if (values.size() > 1) {
                    gbc.anchor = 18;
                } else {
                    Object v;
                    gbc.anchor = 17;
                    if (values.size() == 1 && (v = values.get(0)) instanceof String && ((String)v).indexOf("\n") != -1) {
                        gbc.anchor = 18;
                    }
                }
                gbc.insets.left = 0;
                gbc.gridwidth = -1;
                this.attributesPanel.add((Component)label, gbc);
                gbc.insets.left = 10;
                gbc.weightx = 1.0;
                gbc.gridwidth = 0;
                this.attributesPanel.add((Component)comp, gbc);
                gbc.insets.top = 10;
            }
        } else {
            for (String attr : sortedAttributes) {
                List<Object> values;
                JLabel label = this.getLabelForAttribute(attr, sr);
                if (this.isRequired(attr, sr)) {
                    Utilities.setRequiredIcon(label);
                    this.requiredAttrs.add(attr.toLowerCase());
                }
                if ((values = sr.getAttributeValues(attr)).isEmpty()) {
                    values = new ArrayList<Object>(1);
                    if (this.isBinary(attr)) {
                        values.add(new byte[0]);
                    } else {
                        values.add("");
                    }
                }
                if (this.isPassword(attr)) {
                    ArrayList<String> pwds = new ArrayList<String>();
                    for (Object o : values) {
                        pwds.add(this.getPasswordStringValue(o));
                    }
                    this.lastUserPasswords.put(attr.toLowerCase(), pwds);
                }
                JComponent comp = this.getReadWriteComponent(attr, values);
                gbc.weightx = 0.0;
                if (attr.equalsIgnoreCase("objectclass")) {
                    int nOcs = 0;
                    for (Object o : values) {
                        if ("top".equals(o)) continue;
                        ++nOcs;
                    }
                    gbc.anchor = nOcs > 1 ? 18 : 17;
                } else {
                    gbc.anchor = this.isSingleValue(attr) ? 17 : (values.size() <= 1 && (this.hasBinaryValue(values) || this.isBinary(attr)) ? 17 : 18);
                }
                gbc.insets.left = 0;
                gbc.gridwidth = -1;
                this.attributesPanel.add((Component)label, gbc);
                gbc.insets.left = 10;
                gbc.weightx = 1.0;
                gbc.gridwidth = 0;
                this.attributesPanel.add((Component)comp, gbc);
                gbc.insets.top = 10;
                this.hmLabels.put(attr.toLowerCase(), label);
                this.hmComponents.put(attr.toLowerCase(), comp);
                if (!this.isPassword(attr)) continue;
                label = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_PASSWORD_CONFIRM_LABEL.get());
                String key = this.getConfirmPasswordKey(attr);
                comp = this.getReadWriteComponent(key, values);
                this.hmLabels.put(key, label);
                this.hmComponents.put(key, comp);
                gbc.weightx = 0.0;
                gbc.anchor = this.isSingleValue(attr) ? 17 : 18;
                gbc.insets.left = 0;
                gbc.gridwidth = -1;
                this.attributesPanel.add((Component)label, gbc);
                gbc.insets.left = 10;
                gbc.weightx = 1.0;
                gbc.gridwidth = 0;
                this.attributesPanel.add((Component)comp, gbc);
                gbc.insets.top = 10;
            }
        }
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.attributesPanel.add(Box.createVerticalGlue(), gbc);
        this.scrollListener.updateBorder();
        if (this.showOnlyAttrsWithValues.isSelected()) {
            this.updateAttributeVisibility(false);
        } else if (this.isVisible()) {
            this.repaint();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (p != null && SimplifiedViewEntryPanel.this.scrollAttributes.getViewport().contains(p)) {
                    SimplifiedViewEntryPanel.this.scrollAttributes.getViewport().setViewPosition(p);
                }
                SimplifiedViewEntryPanel.this.ignoreEntryChangeEvents = false;
            }
        });
    }

    private JLabel getLabelForAttribute(String attrName, CustomSearchResult sr) {
        boolean isNameAttribute;
        String subType;
        String basicAttrName;
        MessageBuilder l = new MessageBuilder();
        int index = attrName.indexOf(";");
        if (index == -1) {
            basicAttrName = attrName;
            subType = null;
        } else {
            basicAttrName = attrName.substring(0, index);
            subType = attrName.substring(index + 1);
        }
        if (subType != null && subType.equalsIgnoreCase("binary")) {
            subType = "binary";
        }
        if (isNameAttribute = this.isAttrName(basicAttrName, sr)) {
            if (subType != null) {
                l.append(this.NAME + " (" + subType + ")");
            } else {
                l.append(this.NAME);
            }
        } else {
            Message friendly = hmFriendlyAttrNames.get(basicAttrName.toLowerCase());
            if (friendly == null) {
                l.append(attrName);
            } else {
                l.append(friendly);
                if (subType != null) {
                    l.append(" (" + subType + ")");
                }
            }
        }
        this.hmDisplayedNames.put(attrName.toLowerCase(), l.toString());
        l.append(":");
        return Utilities.createPrimaryLabel(l.toMessage());
    }

    private Collection<String> getSortedAttributes(CustomSearchResult sr, boolean isReadOnly) {
        LinkedHashSet<String> attrNames = new LinkedHashSet<String>();
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        ArrayList<String> entryAttrs = new ArrayList<String>();
        entryAttrs.addAll(sr.getAttributeNames());
        ArrayList<String> attrsWithNoOptions = new ArrayList<String>();
        for (String attr : entryAttrs) {
            attrsWithNoOptions.add(Utilities.getAttributeNameWithoutOptions(attr).toLowerCase());
        }
        List<Object> values = sr.getAttributeValues("objectclass");
        for (Object o : values) {
            String ocName = (String)o;
            String[] attrs = hmOrdereredAttrNames.get(ocName.toLowerCase());
            if (attrs == null) continue;
            for (String attr : attrs) {
                int index = attrsWithNoOptions.indexOf(attr.toLowerCase());
                if (index != -1) {
                    attrNames.add(entryAttrs.get(index));
                    continue;
                }
                attrNames.add(attr);
            }
        }
        boolean isRootEntry = sr.getDN().equals("");
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        if (isRootEntry) {
            String[] attrsNotToAdd = new String[]{"entryuuid", "hassubordinates", "numsubordinates", "subschemasubentry", "entrydn", "hassubordinates"};
            for (String attr : sr.getAttributeNames()) {
                String addedAttr;
                boolean found = false;
                Iterator i$ = attrNames.iterator();
                while (i$.hasNext() && !(found = (addedAttr = (String)i$.next()).equalsIgnoreCase(attr))) {
                }
                if (!found) {
                    String notToAddAttr;
                    String[] arr$ = attrsNotToAdd;
                    int len$ = arr$.length;
                    for (int i$2 = 0; i$2 < len$ && !(found = (notToAddAttr = arr$[i$2]).equalsIgnoreCase(attr)); ++i$2) {
                    }
                }
                if (found) continue;
                attrNames.add(attr);
            }
        } else {
            TreeSet<String> requiredAttributes = new TreeSet<String>();
            TreeSet<String> allowedAttributes = new TreeSet<String>();
            if (schema != null) {
                List<Object> ocs = sr.getAttributeValues("objectclass");
                for (Object o : ocs) {
                    String oc = (String)o;
                    ObjectClass objectClass = schema.getObjectClass(oc.toLowerCase());
                    if (objectClass == null) continue;
                    for (AttributeType attr : objectClass.getRequiredAttributeChain()) {
                        requiredAttributes.add(attr.getNameOrOID());
                    }
                    for (AttributeType attr : objectClass.getOptionalAttributeChain()) {
                        allowedAttributes.add(attr.getNameOrOID());
                    }
                }
            }
            this.updateAttributes(attributes, requiredAttributes, entryAttrs, attrsWithNoOptions, true);
            this.updateAttributes(attributes, requiredAttributes, entryAttrs, attrsWithNoOptions, false);
            this.updateAttributes(attributes, allowedAttributes, entryAttrs, attrsWithNoOptions, true);
            this.updateAttributes(attributes, allowedAttributes, entryAttrs, attrsWithNoOptions, false);
            for (String attr : entryAttrs) {
                attributes.add(attr);
            }
            attributes.add("aci");
            if (isReadOnly) {
                attributes.retainAll(entryAttrs);
            }
            for (String attr : attributes) {
                String addedAttr;
                boolean add = SimplifiedViewEntryPanel.isEditable(attr, schema);
                if (!add) continue;
                boolean found = false;
                Iterator i$ = attrNames.iterator();
                while (i$.hasNext() && !(found = (addedAttr = (String)i$.next()).equalsIgnoreCase(attr))) {
                }
                if (found) continue;
                attrNames.add(attr);
            }
        }
        return attrNames;
    }

    private void updateAttributes(Collection<String> attributes, Set<String> newAttributes, ArrayList<String> entryAttrs, ArrayList<String> attrsWithNoOptions, boolean addIfFriendlyName) {
        for (String attr : newAttributes) {
            String attrLc = attr.toLowerCase();
            boolean hasFriendlyName = hmFriendlyAttrNames.get(attrLc) != null;
            if (hasFriendlyName != addIfFriendlyName) continue;
            int index = attrsWithNoOptions.indexOf(attrLc);
            if (index != -1) {
                attributes.add(entryAttrs.get(index));
                continue;
            }
            if (!this.hasCertificateSyntax(attr, this.getInfo().getServerDescriptor().getSchema())) {
                attributes.add(attr);
                continue;
            }
            attributes.add(attr + ";binary");
        }
    }

    private JComponent getReadOnlyComponent(final String attrName, List<Object> values) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        boolean isBinary = this.hasBinaryValue(values);
        for (Object o : values) {
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            if (attrName.equalsIgnoreCase("objectclass")) {
                ObjectClassCellPanel ocPanel = new ObjectClassCellPanel();
                Schema schema = this.getInfo().getServerDescriptor().getSchema();
                if (schema != null) {
                    ObjectClassValue ocDescriptor = this.getObjectClassDescriptor(values, schema);
                    ocPanel.setValue(ocDescriptor);
                }
                ocPanel.setEditButtonVisible(false);
                panel.add((Component)ocPanel, gbc);
                break;
            }
            if (Utilities.mustObfuscate(attrName, this.getInfo().getServerDescriptor().getSchema())) {
                panel.add((Component)Utilities.createDefaultLabel(Message.raw("********", new Object[0])), gbc);
                continue;
            }
            if (!isBinary) {
                JComponent toAdd;
                JTextArea ta;
                TreeSet<String> sValues = new TreeSet<String>();
                for (Object value : values) {
                    sValues.add(String.valueOf(value));
                }
                if (values.size() > 15) {
                    ta = Utilities.createNonEditableTextArea(Message.raw(Utilities.getStringFromCollection(sValues, "\n"), new Object[0]), 15, 20);
                    toAdd = Utilities.createScrollPane(ta);
                } else {
                    ta = Utilities.createNonEditableTextArea(Message.raw(Utilities.getStringFromCollection(sValues, "\n"), new Object[0]), values.size(), 20);
                    toAdd = ta;
                }
                panel.add((Component)toAdd, gbc);
                break;
            }
            BinaryCellPanel pane = new BinaryCellPanel();
            pane.setEditButtonText(AdminToolMessages.INFO_CTRL_PANEL_VIEW_BUTTON_LABEL.get());
            final byte[] binaryValue = (byte[])o;
            Schema schema = this.getInfo().getServerDescriptor().getSchema();
            boolean isImage = Utilities.hasImageSyntax(attrName, schema);
            pane.setValue(binaryValue, isImage);
            pane.addEditActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (SimplifiedViewEntryPanel.this.binaryDlg == null) {
                        SimplifiedViewEntryPanel.this.binaryPanel = new BinaryValuePanel();
                        SimplifiedViewEntryPanel.this.binaryPanel.setInfo(SimplifiedViewEntryPanel.this.getInfo());
                        SimplifiedViewEntryPanel.this.binaryDlg = new GenericDialog(Utilities.getFrame(SimplifiedViewEntryPanel.this), SimplifiedViewEntryPanel.this.binaryPanel);
                        SimplifiedViewEntryPanel.this.binaryDlg.setModal(true);
                        Utilities.centerGoldenMean(SimplifiedViewEntryPanel.this.binaryDlg, Utilities.getParentDialog(SimplifiedViewEntryPanel.this));
                    }
                    SimplifiedViewEntryPanel.this.binaryPanel.setValue(attrName, binaryValue);
                    SimplifiedViewEntryPanel.this.binaryDlg.setVisible(true);
                }
            });
            panel.add((Component)pane, gbc);
        }
        return panel;
    }

    private JComponent getReadWriteComponent(final String attrName, List<Object> values) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        ArrayList<EditorComponent> components = new ArrayList<EditorComponent>();
        this.hmEditors.put(attrName.toLowerCase(), components);
        boolean isBinary = this.hasBinaryValue(values);
        for (Object o : values) {
            Schema schema;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            if (attrName.equalsIgnoreCase("objectclass")) {
                ObjectClassValue ocDescriptor;
                final ObjectClassCellPanel ocCellPanel = new ObjectClassCellPanel();
                schema = this.getInfo().getServerDescriptor().getSchema();
                if (schema != null) {
                    ocDescriptor = this.getObjectClassDescriptor(values, schema);
                    ocCellPanel.setValue(ocDescriptor);
                } else {
                    ocDescriptor = null;
                }
                ocCellPanel.addEditActionListener(new ActionListener(){
                    private ObjectClassValue newValue;

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (SimplifiedViewEntryPanel.this.editOcDlg == null) {
                            SimplifiedViewEntryPanel.this.editOcPanel = new ObjectClassEditorPanel();
                            SimplifiedViewEntryPanel.this.editOcPanel.setInfo(SimplifiedViewEntryPanel.this.getInfo());
                            SimplifiedViewEntryPanel.this.editOcDlg = new GenericDialog(null, SimplifiedViewEntryPanel.this.editOcPanel);
                            SimplifiedViewEntryPanel.this.editOcDlg.setModal(true);
                            Utilities.centerGoldenMean(SimplifiedViewEntryPanel.this.editOcDlg, Utilities.getParentDialog(SimplifiedViewEntryPanel.this));
                        }
                        if (this.newValue == null && ocDescriptor != null) {
                            SimplifiedViewEntryPanel.this.editOcPanel.setValue(ocDescriptor);
                        } else {
                            SimplifiedViewEntryPanel.this.editOcPanel.setValue(this.newValue);
                        }
                        SimplifiedViewEntryPanel.this.editOcDlg.setVisible(true);
                        if (SimplifiedViewEntryPanel.this.editOcPanel.valueChanged()) {
                            this.newValue = SimplifiedViewEntryPanel.this.editOcPanel.getObjectClassValue();
                            ocCellPanel.setValue(this.newValue);
                            SimplifiedViewEntryPanel.this.updatePanel(this.newValue);
                        }
                    }
                });
                panel = ocCellPanel;
                components.add(new EditorComponent(ocCellPanel));
                break;
            }
            if (this.isPassword(attrName) || this.isConfirmPassword(attrName)) {
                JPasswordField pf;
                if (o.equals("")) {
                    pf = Utilities.createPasswordField();
                } else {
                    pf = Utilities.createPasswordField();
                    pf.setText(this.getPasswordStringValue(o));
                }
                panel.add((Component)pf, gbc);
                components.add(new EditorComponent(pf));
            } else {
                if (!isBinary) {
                    JComponent toAdd;
                    JTextArea ta;
                    if (this.isSingleValue(attrName)) {
                        final JTextField tf = Utilities.createMediumTextField();
                        tf.setText(String.valueOf(o));
                        if (this.mustAddBrowseButton(attrName)) {
                            gbc.gridx = 0;
                            panel.add((Component)tf, gbc);
                            gbc.insets.left = 5;
                            gbc.weightx = 0.0;
                            ++gbc.gridx;
                            gbc.anchor = 11;
                            JButton browse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
                            browse.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent ev) {
                                    SimplifiedViewEntryPanel.this.addBrowseClicked(attrName, tf);
                                }
                            });
                            panel.add((Component)browse, gbc);
                            new DropTarget(tf, this.dropTargetListener);
                        } else {
                            gbc.gridx = 0;
                            panel.add((Component)tf, gbc);
                        }
                        components.add(new EditorComponent(tf));
                        break;
                    }
                    TreeSet<String> sValues = new TreeSet<String>();
                    for (Object value : values) {
                        sValues.add(String.valueOf(value));
                    }
                    if (values.size() > 15) {
                        ta = Utilities.createTextArea(Message.raw(Utilities.getStringFromCollection(sValues, "\n"), new Object[0]), 15, 20);
                        toAdd = Utilities.createScrollPane(ta);
                    } else {
                        ta = Utilities.createTextAreaWithBorder(Message.raw(Utilities.getStringFromCollection(sValues, "\n"), new Object[0]), values.size(), 20);
                        toAdd = ta;
                    }
                    if (this.mustAddBrowseButton(attrName)) {
                        panel.add((Component)toAdd, gbc);
                        gbc.insets.left = 5;
                        gbc.weightx = 0.0;
                        ++gbc.gridx;
                        gbc.anchor = 11;
                        JButton browse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
                        browse.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ev) {
                                SimplifiedViewEntryPanel.this.addBrowseClicked(attrName, ta);
                            }
                        });
                        if (attrName.equalsIgnoreCase("uniquemember")) {
                            browse.setText(AdminToolMessages.INFO_CTRL_PANEL_ADD_MEMBERS_BUTTON.get().toString());
                        }
                        panel.add((Component)browse, gbc);
                        new DropTarget(ta, this.dropTargetListener);
                    } else {
                        panel.add((Component)toAdd, gbc);
                    }
                    components.add(new EditorComponent(ta));
                    break;
                }
                final BinaryCellPanel pane = new BinaryCellPanel();
                schema = this.getInfo().getServerDescriptor().getSchema();
                final boolean isImage = Utilities.hasImageSyntax(attrName, schema);
                pane.setDisplayDelete(true);
                final byte[] binaryValue = (byte[])o;
                if (binaryValue.length > 0) {
                    pane.setValue(binaryValue, isImage);
                }
                pane.addEditActionListener(new ActionListener(){
                    private BinaryValue newValue;

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (SimplifiedViewEntryPanel.this.editBinaryDlg == null) {
                            SimplifiedViewEntryPanel.this.editBinaryPanel = new BinaryAttributeEditorPanel();
                            SimplifiedViewEntryPanel.this.editBinaryPanel.setInfo(SimplifiedViewEntryPanel.this.getInfo());
                            SimplifiedViewEntryPanel.this.editBinaryDlg = new GenericDialog(Utilities.getFrame(SimplifiedViewEntryPanel.this), SimplifiedViewEntryPanel.this.editBinaryPanel);
                            SimplifiedViewEntryPanel.this.editBinaryDlg.setModal(true);
                            Utilities.centerGoldenMean(SimplifiedViewEntryPanel.this.editBinaryDlg, Utilities.getParentDialog(SimplifiedViewEntryPanel.this));
                        }
                        if (this.newValue == null) {
                            if (binaryValue != null && binaryValue.length > 0) {
                                this.newValue = BinaryValue.createBase64(binaryValue);
                                SimplifiedViewEntryPanel.this.editBinaryPanel.setValue(attrName, this.newValue);
                            } else {
                                SimplifiedViewEntryPanel.this.editBinaryPanel.setValue(attrName, null);
                            }
                        } else {
                            SimplifiedViewEntryPanel.this.editBinaryPanel.setValue(attrName, this.newValue);
                        }
                        SimplifiedViewEntryPanel.this.editBinaryDlg.setVisible(true);
                        if (SimplifiedViewEntryPanel.this.editBinaryPanel.valueChanged()) {
                            this.newValue = SimplifiedViewEntryPanel.this.editBinaryPanel.getBinaryValue();
                            pane.setValue(this.newValue, isImage);
                            SimplifiedViewEntryPanel.this.notifyListeners();
                        }
                    }
                });
                pane.addDeleteActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        pane.setValue((byte[])null, false);
                        if (SimplifiedViewEntryPanel.this.editBinaryPanel != null) {
                            SimplifiedViewEntryPanel.this.editBinaryPanel.setValue(attrName, null);
                        }
                        SimplifiedViewEntryPanel.this.notifyListeners();
                    }
                });
                panel.add((Component)pane, gbc);
                components.add(new EditorComponent(pane));
            }
            ++gbc.gridy;
            gbc.insets.top = 10;
        }
        return panel;
    }

    private boolean isSingleValue(String attrName) {
        AttributeType attr;
        boolean isSingleValue = false;
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        if (schema != null && (attr = schema.getAttributeType(attrName.toLowerCase())) != null) {
            isSingleValue = attr.isSingleValue();
        }
        return isSingleValue;
    }

    private boolean isRequired(String attrName, CustomSearchResult sr) {
        AttributeType attr;
        boolean isRequired = false;
        attrName = Utilities.getAttributeNameWithoutOptions(attrName);
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        if (schema != null && (attr = schema.getAttributeType(attrName.toLowerCase())) != null) {
            List<Object> ocs = sr.getAttributeValues("objectclass");
            for (Object o : ocs) {
                String oc = (String)o;
                ObjectClass objectClass = schema.getObjectClass(oc.toLowerCase());
                if (objectClass == null || !objectClass.isRequired(attr)) continue;
                isRequired = true;
                break;
            }
        }
        return isRequired;
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    @Override
    public Entry getEntry() throws OpenDsException {
        Entry entry = null;
        ArrayList<Message> errors = new ArrayList<Message>();
        try {
            DN.decode(this.getDisplayedDN());
        }
        catch (Throwable t) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_DN_NOT_VALID.get());
        }
        for (String attrName : this.hmLabels.keySet()) {
            this.setPrimaryValid(this.hmLabels.get(attrName));
        }
        for (String attrName : this.lastUserPasswords.keySet()) {
            List<String> confirmPwds;
            List<String> pwds = this.getNewPasswords(attrName);
            if (pwds.equals(confirmPwds = this.getConfirmPasswords(attrName))) continue;
            this.setPrimaryInvalid(this.hmLabels.get(attrName));
            this.setPrimaryInvalid(this.hmLabels.get(this.getConfirmPasswordKey(attrName)));
            Message msg = AdminToolMessages.ERR_CTRL_PANEL_PASSWORD_DO_NOT_MATCH.get();
            if (errors.contains(msg)) continue;
            errors.add(msg);
        }
        for (String attrName : this.requiredAttrs) {
            if (this.hasValue(attrName)) continue;
            this.setPrimaryInvalid(this.hmLabels.get(attrName));
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_ATTRIBUTE_REQUIRED.get(this.hmDisplayedNames.get(attrName)));
        }
        if (errors.size() > 0) {
            throw new CheckEntrySyntaxException(errors);
        }
        LDIFImportConfig ldifImportConfig = null;
        try {
            String ldif = this.getLDIF();
            ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
            LDIFReader reader = new LDIFReader(ldifImportConfig);
            entry = reader.readEntry(this.checkSchema());
            this.addValuesInRDN(entry);
        }
        catch (IOException ioe) {
            throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_CHECKING_ENTRY.get(ioe.toString()), (Throwable)ioe);
        }
        finally {
            if (ldifImportConfig != null) {
                ldifImportConfig.close();
            }
        }
        return entry;
    }

    private List<String> getDisplayedStringValues(String attrName) {
        ArrayList<String> values = new ArrayList<String>();
        List<EditorComponent> comps = this.hmEditors.get(attrName.toLowerCase());
        if (comps != null) {
            for (EditorComponent comp : comps) {
                Object value = comp.getValue();
                if (value instanceof ObjectClassValue) {
                    ObjectClassValue ocValue = (ObjectClassValue)value;
                    if (ocValue.getStructural() != null) {
                        values.add(ocValue.getStructural());
                    }
                    values.addAll(ocValue.getAuxiliary());
                    continue;
                }
                if (value instanceof Collection) {
                    for (Object o : (Collection)value) {
                        values.add((String)o);
                    }
                    continue;
                }
                values.add(String.valueOf(comp.getValue()));
            }
        }
        return values;
    }

    private List<String> getNewPasswords(String attrName) {
        String attr = Utilities.getAttributeNameWithoutOptions(attrName).toLowerCase();
        return this.getDisplayedStringValues(attr);
    }

    private List<String> getConfirmPasswords(String attrName) {
        return this.getDisplayedStringValues(this.getConfirmPasswordKey(attrName));
    }

    private String getConfirmPasswordKey(String attrName) {
        return "confirm password" + Utilities.getAttributeNameWithoutOptions(attrName).toLowerCase();
    }

    private boolean isConfirmPassword(String key) {
        return key.startsWith("confirm password");
    }

    private String getLDIF() {
        StringBuilder sb = new StringBuilder();
        sb.append("dn: " + this.getDisplayedDN());
        for (String attrName : this.hmEditors.keySet()) {
            if (this.isConfirmPassword(attrName)) continue;
            if (this.isPassword(attrName)) {
                List<String> newPwds = this.getNewPasswords(attrName);
                if (newPwds.equals(this.lastUserPasswords.get(attrName.toLowerCase()))) {
                    List<Object> oldValues = this.searchResult.getAttributeValues(attrName);
                    if (oldValues.isEmpty()) continue;
                    this.appendLDIFLines(sb, attrName, oldValues);
                    continue;
                }
                this.appendLDIFLines(sb, attrName);
                continue;
            }
            if (this.schemaReadOnlyAttributesLowerCase.contains(attrName.toLowerCase())) continue;
            this.appendLDIFLines(sb, attrName);
        }
        for (String attrName : this.schemaReadOnlyAttributesLowerCase) {
            List<Object> values = this.searchResult.getAttributeValues(attrName);
            if (values.isEmpty()) continue;
            this.appendLDIFLines(sb, attrName, values);
        }
        return sb.toString();
    }

    private boolean isAttrName(String attrName, CustomSearchResult sr) {
        boolean isAttrName = false;
        List<Object> values = sr.getAttributeValues("objectclass");
        for (Object o : values) {
            String ocName = (String)o;
            String attr = hmNameAttrNames.get(ocName.toLowerCase());
            if (attr == null || !attr.equalsIgnoreCase(attrName)) continue;
            isAttrName = true;
            break;
        }
        return isAttrName;
    }

    private boolean hasBinaryValue(List<Object> values) {
        boolean isBinary = false;
        if (values.size() > 0) {
            isBinary = values.iterator().next() instanceof byte[];
        }
        return isBinary;
    }

    private boolean mustAddBrowseButton(String attrName) {
        String syntaxName;
        AttributeType attr;
        Schema schema;
        boolean mustAddBrowseButton;
        boolean bl = mustAddBrowseButton = attrName.equalsIgnoreCase("uniquemember") || attrName.equalsIgnoreCase("ds-target-group-dn");
        if (!mustAddBrowseButton && (schema = this.getInfo().getServerDescriptor().getSchema()) != null && (attr = schema.getAttributeType(attrName.toLowerCase())) != null && (syntaxName = attr.getSyntax().getSyntaxName()) != null) {
            mustAddBrowseButton = syntaxName.equalsIgnoreCase("DN");
        }
        return mustAddBrowseButton;
    }

    @Override
    protected List<Object> getValues(String attrName) {
        ArrayList<Object> values = new ArrayList<Object>();
        List<EditorComponent> comps = this.hmEditors.get(attrName);
        if (comps.size() > 0) {
            for (EditorComponent comp : comps) {
                if (!this.hasValue(comp)) continue;
                Object value = comp.getValue();
                if (value instanceof Collection) {
                    for (Object o : (Collection)value) {
                        values.add(o);
                    }
                    continue;
                }
                values.add(value);
            }
        }
        return values;
    }

    private void appendLDIFLines(StringBuilder sb, String attrName) {
        List<Object> values = this.getValues(attrName);
        if (values.size() > 0) {
            this.appendLDIFLines(sb, attrName, values);
        }
    }

    @Override
    protected String getDisplayedDN() {
        StringBuilder sb = new StringBuilder();
        try {
            DN oldDN = DN.decode(this.searchResult.getDN());
            if (oldDN.getNumComponents() > 0) {
                Schema schema;
                AttributeType attr;
                RDN rdn = oldDN.getRDN();
                ArrayList<AttributeType> attributeTypes = new ArrayList<AttributeType>();
                ArrayList<String> attributeNames = new ArrayList<String>();
                ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
                for (int i = 0; i < rdn.getNumValues(); ++i) {
                    String attrName = rdn.getAttributeName(i);
                    AttributeValue value = rdn.getAttributeValue(i);
                    String sValue = value.getValue().toString();
                    List<String> values = this.getDisplayedStringValues(attrName);
                    if (!values.contains(sValue)) {
                        if (values.size() <= 0) continue;
                        String firstNonEmpty = null;
                        for (String v : values) {
                            if ((v = v.trim()).length() <= 0) continue;
                            firstNonEmpty = v;
                            break;
                        }
                        if (firstNonEmpty == null) continue;
                        attr = rdn.getAttributeType(i);
                        attributeTypes.add(attr);
                        attributeNames.add(rdn.getAttributeName(i));
                        attributeValues.add(AttributeValues.create(attr, firstNonEmpty));
                        continue;
                    }
                    attributeTypes.add(rdn.getAttributeType(i));
                    attributeNames.add(rdn.getAttributeName(i));
                    attributeValues.add(value);
                }
                if (attributeTypes.size() == 0 && (schema = this.getInfo().getServerDescriptor().getSchema()) != null) {
                    for (String attrName : this.hmEditors.keySet()) {
                        Object o;
                        List<EditorComponent> comps;
                        if (this.isPassword(attrName) || this.isConfirmPassword(attrName) || (comps = this.hmEditors.get(attrName)).size() <= 0 || !((o = comps.iterator().next().getValue()) instanceof String)) continue;
                        String aName = Utilities.getAttributeNameWithoutOptions(attrName);
                        attr = schema.getAttributeType(aName.toLowerCase());
                        if (attr == null) break;
                        attributeTypes.add(attr);
                        attributeNames.add(attrName);
                        attributeValues.add(AttributeValues.create(attr, (String)o));
                        break;
                    }
                }
                DN parent = oldDN.getParent();
                if (attributeTypes.size() > 0) {
                    RDN newRDN = new RDN(attributeTypes, attributeNames, attributeValues);
                    DN newDN = parent == null ? new DN(new RDN[]{newRDN}) : parent.concat(newRDN);
                    sb.append(newDN.toString());
                } else if (parent != null) {
                    sb.append("," + parent.toString());
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Unexpected error: " + t, t);
        }
        return sb.toString();
    }

    private void addBrowseClicked(String attrName, JTextComponent textComponent) {
        LDAPEntrySelectionPanel.Filter filter;
        Message title;
        Message previousTitle = null;
        LDAPEntrySelectionPanel.Filter previousFilter = null;
        if (this.browseEntriesDlg == null) {
            this.browseEntriesPanel = new LDAPEntrySelectionPanel();
            this.browseEntriesPanel.setMultipleSelection(false);
            this.browseEntriesPanel.setInfo(this.getInfo());
            this.browseEntriesDlg = new GenericDialog(Utilities.getFrame(this), this.browseEntriesPanel);
            Utilities.centerGoldenMean(this.browseEntriesDlg, Utilities.getParentDialog(this));
            this.browseEntriesDlg.setModal(true);
        } else {
            previousTitle = this.browseEntriesPanel.getTitle();
            previousFilter = this.browseEntriesPanel.getFilter();
        }
        if (attrName.equalsIgnoreCase("uniquemember")) {
            title = AdminToolMessages.INFO_CTRL_PANEL_ADD_MEMBERS_LABEL.get();
            filter = LDAPEntrySelectionPanel.Filter.USERS;
        } else if (attrName.equalsIgnoreCase("ds-target-group-dn")) {
            title = AdminToolMessages.INFO_CTRL_PANEL_CHOOSE_REFERENCE_GROUP.get();
            filter = LDAPEntrySelectionPanel.Filter.DYNAMIC_GROUPS;
        } else {
            title = AdminToolMessages.INFO_CTRL_PANEL_CHOOSE_ENTRIES.get();
            filter = LDAPEntrySelectionPanel.Filter.DEFAULT;
        }
        if (!title.equals(previousTitle)) {
            this.browseEntriesPanel.setTitle(title);
        }
        if (!filter.equals((Object)previousFilter)) {
            this.browseEntriesPanel.setFilter(filter);
        }
        this.browseEntriesPanel.setMultipleSelection(!this.isSingleValue(attrName));
        this.browseEntriesDlg.setVisible(true);
        if (textComponent instanceof JTextArea) {
            String[] dns = this.browseEntriesPanel.getDNs();
            if (dns.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(textComponent.getText());
                for (String dn : dns) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(dn);
                }
                textComponent.setText(sb.toString());
                textComponent.setCaretPosition(sb.length());
            }
        } else {
            String[] dns = this.browseEntriesPanel.getDNs();
            if (dns.length > 0) {
                textComponent.setText(dns[0]);
            }
        }
    }

    private String getPasswordStringValue(Object o) {
        if (o instanceof byte[]) {
            return Base64.encode((byte[])o);
        }
        return String.valueOf(o);
    }

    private void updatePanel(ObjectClassValue newValue) {
        CustomSearchResult oldResult = this.searchResult;
        CustomSearchResult newResult = new CustomSearchResult(this.searchResult.getDN());
        for (String attrName : this.schemaReadOnlyAttributesLowerCase) {
            List<Object> values = this.searchResult.getAttributeValues(attrName);
            if (values.isEmpty()) continue;
            newResult.set(attrName, values);
        }
        this.ignoreEntryChangeEvents = true;
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        if (schema != null) {
            ArrayList<String> attributes = new ArrayList<String>();
            ArrayList<String> ocs = new ArrayList<String>();
            if (newValue.getStructural() != null) {
                ocs.add(newValue.getStructural().toLowerCase());
            }
            for (String oc : newValue.getAuxiliary()) {
                ocs.add(oc.toLowerCase());
            }
            for (String oc : ocs) {
                ObjectClass objectClass = schema.getObjectClass(oc);
                if (objectClass == null) continue;
                for (AttributeType attr : objectClass.getRequiredAttributeChain()) {
                    attributes.add(attr.getNameOrOID().toLowerCase());
                }
                for (AttributeType attr : objectClass.getOptionalAttributeChain()) {
                    attributes.add(attr.getNameOrOID().toLowerCase());
                }
            }
            for (String attrName : this.editableOperationalAttrNames) {
                attributes.add(attrName.toLowerCase());
            }
            for (String attrName : this.hmEditors.keySet()) {
                String attrNoOptions = Utilities.getAttributeNameWithoutOptions(attrName);
                if (!attributes.contains(attrNoOptions)) continue;
                if (this.isPassword(attrName)) {
                    List<String> newPwds = this.getNewPasswords(attrName);
                    if (newPwds.equals(this.lastUserPasswords.get(attrName))) {
                        List<Object> oldValues = this.searchResult.getAttributeValues(attrName);
                        newResult.set(attrName, oldValues);
                        continue;
                    }
                    this.setValues(newResult, attrName);
                    continue;
                }
                if (this.schemaReadOnlyAttributesLowerCase.contains(attrName.toLowerCase())) continue;
                this.setValues(newResult, attrName);
            }
        }
        this.update(newResult, this.isReadOnly, this.treePath);
        this.ignoreEntryChangeEvents = false;
        this.searchResult = oldResult;
        this.notifyListeners();
    }

    private void updateAttributeVisibility(boolean showAll) {
        for (String attrName : this.hmLabels.keySet()) {
            EditorComponent editor;
            Component label = this.hmLabels.get(attrName);
            Component comp = this.hmComponents.get(attrName);
            if (showAll || this.requiredAttrs.contains(attrName)) {
                label.setVisible(true);
                comp.setVisible(true);
                continue;
            }
            List<EditorComponent> editors = this.hmEditors.get(attrName);
            boolean hasValue = false;
            Iterator<EditorComponent> i$ = editors.iterator();
            while (i$.hasNext() && !(hasValue = this.hasValue(editor = i$.next()))) {
            }
            label.setVisible(hasValue);
            comp.setVisible(hasValue);
        }
        this.repaint();
    }

    private boolean hasValue(String attrName) {
        return this.getValues(attrName).size() > 0;
    }

    private boolean hasValue(EditorComponent editor) {
        boolean hasValue = false;
        Object value = editor.getValue();
        if (value != null) {
            hasValue = value instanceof byte[] ? ((byte[])value).length > 0 : (value instanceof String ? ((String)value).trim().length() > 0 : (value instanceof Collection ? ((Collection)value).size() > 0 : true));
        }
        return hasValue;
    }

    static {
        hmFriendlyAttrNames.put("objectclass", AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("cn", AdminToolMessages.INFO_CTRL_PANEL_CN_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("givenname", AdminToolMessages.INFO_CTRL_PANEL_GIVENNAME_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("sn", AdminToolMessages.INFO_CTRL_PANEL_SN_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("uid", AdminToolMessages.INFO_CTRL_PANEL_UID_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("employeenumber", AdminToolMessages.INFO_CTRL_PANEL_EMPLOYEENUMBER_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("userpassword", AdminToolMessages.INFO_CTRL_PANEL_USERPASSWORD_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("authpassword", AdminToolMessages.INFO_CTRL_PANEL_AUTHPASSWORD_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("mail", AdminToolMessages.INFO_CTRL_PANEL_MAIL_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("street", AdminToolMessages.INFO_CTRL_PANEL_STREET_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("l", AdminToolMessages.INFO_CTRL_PANEL_L_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("st", AdminToolMessages.INFO_CTRL_PANEL_ST_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("postalcode", AdminToolMessages.INFO_CTRL_PANEL_POSTALCODE_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("mobile", AdminToolMessages.INFO_CTRL_PANEL_MOBILE_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("homephone", AdminToolMessages.INFO_CTRL_PANEL_HOMEPHONE_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("telephonenumber", AdminToolMessages.INFO_CTRL_PANEL_TELEPHONENUMBER_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("pager", AdminToolMessages.INFO_CTRL_PANEL_PAGER_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("facsimiletelephonenumber", AdminToolMessages.INFO_CTRL_PANEL_FACSIMILETELEPHONENUMBER_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("description", AdminToolMessages.INFO_CTRL_PANEL_DESCRIPTION_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("postaladdress", AdminToolMessages.INFO_CTRL_PANEL_POSTALADDRESS_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("uniquemember", AdminToolMessages.INFO_CTRL_PANEL_UNIQUEMEMBER_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("memberurl", AdminToolMessages.INFO_CTRL_PANEL_MEMBERURL_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("c", AdminToolMessages.INFO_CTRL_PANEL_C_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("ds-target-group-dn", AdminToolMessages.INFO_CTRL_PANEL_DS_TARGET_GROUP_DN_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("usercertificate", AdminToolMessages.INFO_CTRL_PANEL_USERCERTIFICATE_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("jpegphoto", AdminToolMessages.INFO_CTRL_PANEL_JPEGPHOTO_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("supportedauthpasswordschemes", AdminToolMessages.INFO_CTRL_PANEL_SUPPORTEDPWDSCHEMES_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("supportedcontrol", AdminToolMessages.INFO_CTRL_PANEL_SUPPORTEDCONTROLS_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("supportedldapversion", AdminToolMessages.INFO_CTRL_PANEL_SUPPORTEDLDAPVERSIONS_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("supportedcontrol", AdminToolMessages.INFO_CTRL_PANEL_SUPPORTEDCONTROLS_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("supportedextension", AdminToolMessages.INFO_CTRL_PANEL_SUPPORTEDEXTENSIONS_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("supportedfeatures", AdminToolMessages.INFO_CTRL_PANEL_SUPPORTEDFEATURES_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("vendorname", AdminToolMessages.INFO_CTRL_PANEL_VENDORNAME_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("vendorversion", AdminToolMessages.INFO_CTRL_PANEL_VENDORVERSION_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("namingcontexts", AdminToolMessages.INFO_CTRL_PANEL_NAMINGCONTEXTS_FRIENDLY_NAME.get());
        hmFriendlyAttrNames.put("ds-private-naming-contexts", AdminToolMessages.INFO_CTRL_PANEL_PRIVATENAMINGCONTEXTS_FRIENDLY_NAME.get());
        hmNameAttrNames.put("organizationalunit", "ou");
        hmNameAttrNames.put("domain", "dc");
        hmNameAttrNames.put("organization", "o");
        hmNameAttrNames.put("groupofurls", "cn");
        hmNameAttrNames.put("groupofnames", "cn");
        hmOrdereredAttrNames.put("person", new String[]{"givenname", "sn", "cn", "uid", "userpassword", "mail", "telephonenumber", "facsimiletelephonenumber", "employeenumber", "street", "l", "st", "postalcode", "mobile", "homephone", "pager", "description", "postaladdress"});
        hmOrdereredAttrNames.put("groupofnames", new String[]{"cn", "description", "uniquemember", "ds-target-group-dn"});
        hmOrdereredAttrNames.put("groupofurls", new String[]{"cn", "description", "memberurl"});
        hmOrdereredAttrNames.put("organizationalunit", new String[]{"ou", "description", "postalAddress", "telephonenumber", "facsimiletelephonenumber"});
        hmOrdereredAttrNames.put("organization", new String[]{"o", "description"});
        hmOrdereredAttrNames.put("domain", new String[]{"dc", "description"});
    }

    class EditorComponent {
        private Component comp;

        public EditorComponent(JTextComponent tf) {
            this.comp = tf;
            tf.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent ev) {
                    SimplifiedViewEntryPanel.this.notifyListeners();
                }

                @Override
                public void changedUpdate(DocumentEvent ev) {
                    SimplifiedViewEntryPanel.this.notifyListeners();
                }

                @Override
                public void removeUpdate(DocumentEvent ev) {
                    SimplifiedViewEntryPanel.this.notifyListeners();
                }
            });
        }

        public EditorComponent(BinaryCellPanel binaryPanel) {
            this.comp = binaryPanel;
        }

        public EditorComponent(ObjectClassCellPanel ocPanel) {
            this.comp = ocPanel;
        }

        public Object getValue() {
            LinkedHashSet<String> returnValue;
            if (this.comp instanceof ObjectClassCellPanel) {
                ObjectClass oc;
                ObjectClassValue ocDesc = ((ObjectClassCellPanel)this.comp).getValue();
                LinkedHashSet<String> values = new LinkedHashSet<String>();
                String structural = ocDesc.getStructural();
                if (structural != null) {
                    values.add(structural);
                }
                values.addAll(ocDesc.getAuxiliary());
                Schema schema = SimplifiedViewEntryPanel.this.getInfo().getServerDescriptor().getSchema();
                if (schema != null && structural != null && (oc = schema.getObjectClass(structural.toLowerCase())) != null) {
                    values.addAll(SimplifiedViewEntryPanel.this.getObjectClassSuperiorValues(oc));
                }
                returnValue = values;
            } else if (this.comp instanceof JTextArea) {
                String[] lines;
                LinkedHashSet<String> values = new LinkedHashSet<String>();
                String value = ((JTextArea)this.comp).getText();
                for (String line : lines = value.split("\n")) {
                    if ((line = line.trim()).length() <= 0) continue;
                    values.add(line);
                }
                returnValue = values;
            } else if (this.comp instanceof JTextComponent) {
                returnValue = ((JTextComponent)this.comp).getText();
            } else {
                Object o = ((BinaryCellPanel)this.comp).getValue();
                if (o instanceof BinaryValue) {
                    try {
                        returnValue = (LinkedHashSet<String>)((BinaryValue)o).getBytes();
                    }
                    catch (ParseException pe) {
                        throw new RuntimeException("Unexpected error: " + pe);
                    }
                } else {
                    returnValue = o;
                }
            }
            return returnValue;
        }
    }
}

